/*********************************************************
 **
 ** FILE:    fileswindow.c
 **		functions for the file select window
 ** CREATED: 25 JUN 92  CB
 ** CHANGES: 26 APR 93  SF
 **          adapted for Parallaxis (graphical user
 **          interface) with friendly permission of
 **          the author.
 **
 *********************************************************/

#define F1 100000               /* dimensions for file buffer */
#define F2 10000
#define BSIZE 100000            /* max. length for one transmission */
#define DIM1 5000               /* buffer dimensions */
#define DIM2 80
#define WAT1 50                 /* dimensions for watch variables */
#define WAT2 30
#define FNAMELENGTH 150         /* Length of the fullname string */
#define OUTLENGTH 5000          /* Length for the string in the program output window */
#define WAT1 50                 /* Array dimensions for watch expressions */
#define WAT2 30
#define FONT_HT 12.6                /* Font offsets */
#define FONT_OFF (-20)

/* include own headers */

#include	"misc.h"
#include        "direc.h"

/* include standard- and headers for X11 and Athena Widgets */ 

#include	<sys/param.h>
#include	<stdio.h>
#include	<X11/Intrinsic.h>
#include	<X11/StringDefs.h>
#include	<X11/Shell.h>
#include	<X11/Xaw/Form.h>
#include	<X11/Xaw/Label.h>
#include	<X11/Xaw/Command.h>
#include	<X11/Xaw/Toggle.h>
#include	<X11/Xaw/AsciiText.h>
#include	<X11/Xaw/List.h>
#include	<X11/Xaw/Viewport.h>
#include	<X11/Xaw/MenuButton.h>
#include	<X11/Xaw/SimpleMenu.h>
#include	<X11/Xaw/SmeBSB.h>

/* extern */

extern Widget	toplevel,ctrlbutt,ctrlfile,listvp,listfile,ctrlstruc,message,mfile,intext,mpes,outtext,td1;
extern XtAppContext ApplicationContext;
extern Display *MyDisplay;
extern char fullname[];
extern char oldfilename[];
extern char *filebuf[];
extern int bpoint[];
extern char inbuf[];
extern int count;
extern int lines;
extern int atokens;
extern itoa();
extern AddBlanks();
extern char puffer[][DIM2];
extern char *outst;
extern BOOLEAN fileok;
extern char watches[][WAT2];
extern int wpoints;
extern WatchOut();
extern int dmode;
extern BOOLEAN dimmode, colormode;
extern BOOLEAN startmode;
extern char pecolor[][100], dims[][100], dims2[][100];
extern BOOLEAN topon;
extern int emode;
extern int pid;
extern char colorexp[];
extern long left,right;
extern char actproc[];
extern BOOLEAN debugon;

/* no, it's not extern */
extern  void FisCancel(), FisListSingleClick(), FisSetDirectory(), FisLoad(), FisMenuSelect(), FisFiReturn();

/* Widgets used by the file select window */

/* Level 0 */
Widget	FisPopup;	/* since a pop-up shell can only have one child */

/* Level 1 */
Widget	FisMain;

/* Level 2 */
Widget	FisPath, FisSeScList, FisFile;

/* Level 3 */
Widget	FisPaLabel, FisPaPath, FisSeList, FisFiLabel, FisFiName, FisFiCancel, FisFiLoad;

/* Level 4 */
Widget	FisPaMenu;

/* Level 5 */
Widget	FisPaEntry[DI_PATHDEPTH];


/* The DirContents struct that is managed by the FisWindow */
struct	DirContents	FisDirectory;

/** MenuDepth is the number of '/' characters that the last
 ** FisSetDirectory found in the path. It may be greater
 ** than DI_PATHDEPTH. It is used by FisMenuSelect. */
static int	MenuDepth;

/** Boolean FisIsOpen is an easy way to check whether the Fis window
 ** is currently open */
static int	_FisIsOpen;

int lastlines;

/***********************************************************
 ** FUNCTION: CreateFisWindow                             **
 ** PURPOSE:  Create the file select popup window         **
 ** INPUTS:   none                                        **
 ** RETURNS:  none - (global widgets are created)         **
 **********************************************************/

void CreateFisWindow()
     
{
  char	pathname[MAXPATHLEN];	/* for getcwd only */
  char	*getcwd();
  
  static XtActionsRec FisActions[] = {
    {"fisFiReturn", FisFiReturn}};
  
  /* register new actions */
  XtAppAddActions( ApplicationContext,
		  FisActions, XtNumber( FisActions ));
  
  /* Level 0 */
  FisPopup = XtVaCreatePopupShell(
				  "fisPopup",
				  transientShellWidgetClass,
				  toplevel,
				  NULL);
  
  /* Level 1 */
  FisMain = XtVaCreateManagedWidget(
				    "fisMain", formWidgetClass, FisPopup, NULL);
  
  /* Level 2 */
  FisPath = XtVaCreateManagedWidget(
				    "fisPath", formWidgetClass, FisMain, NULL);
  FisSeScList = XtVaCreateManagedWidget(
					"fisSeScList", viewportWidgetClass, FisMain,
					XtNallowVert, TRUE,
					NULL);
  FisFile = XtVaCreateManagedWidget(
				    "fisFile", formWidgetClass, FisMain, NULL);
  
  /* Level 3 */
  /* FisPath group */
  FisPaLabel = XtVaCreateManagedWidget(
				       "fisPaLabel", labelWidgetClass, FisPath, NULL);
  FisPaPath = XtVaCreateManagedWidget(
				      "fisPaPath", menuButtonWidgetClass, FisPath,
				      XtNmenuName, "fisPaMenu",
				      XtNresize, FALSE,
				      NULL);
  
  /* FisSeScList group */
  FisSeList = XtVaCreateManagedWidget(
				      "fisSeList", listWidgetClass, FisSeScList, NULL);
  XtAddCallback( FisSeList, XtNcallback, FisListSingleClick, 0 );
  /* for double click */
  XtOverrideTranslations( FisSeList,
			 XtParseTranslationTable(
						 "<Btn1Up>(2): fisFiReturn()\n<Btn1Down>,<Btn1Up>: Set() Notify()"));
  
  /* FisFile group */
  FisFiLabel = XtVaCreateManagedWidget(
				       "fisFiLabel", labelWidgetClass, FisFile, NULL);
  FisFiName = XtVaCreateManagedWidget( 
				      "fisFiName", asciiTextWidgetClass, FisFile,
				      XtNeditType, XawtextEdit, NULL);
  XtOverrideTranslations( FisFiName,
			 XtParseTranslationTable(
						 "<Key>Return: fisFiReturn()"));
  FisFiCancel = XtVaCreateManagedWidget( 
					"fisFiCancel", commandWidgetClass, FisFile, NULL);
  XtAddCallback( FisFiCancel, XtNcallback, FisCancel, 0);
  FisFiLoad = XtVaCreateManagedWidget( 
				      "fisFiLoad", commandWidgetClass, FisFile, NULL);
  XtAddCallback( FisFiLoad, XtNcallback, FisLoad, 0);
  

  /* Level 4 */
  FisPaMenu = XtVaCreatePopupShell(
				   "fisPaMenu", simpleMenuWidgetClass, FisPaPath, NULL);
  
  /* Level 5 */
  /* create DI_PATHDEPTH entries of FisPaEntry[] */
  {
    int	i;
    char	entryname[50];
    
    for( i=0; i<DI_PATHDEPTH; ++i )
      {
	sprintf(entryname, "fisPaEntry%d", i);
	
	FisPaEntry[i] = XtVaCreateWidget(
					 entryname, smeBSBObjectClass, FisPaMenu, NULL);
	XtAddCallback( FisPaEntry[i], XtNcallback, FisMenuSelect, i );
      }
  }
  
  
  /* Initialize the FisDirectory structure */
  if( getcwd(pathname, MAXPATHLEN+1) && SetPathname( &FisDirectory, pathname ) )
    /* OK */;
  else if( SetPathname( &FisDirectory, "/" ) )
    /* OK */;
  else {
#ifdef	DEBUG
    fprintf(stderr, "CreateFisWindow: couldn't set my path\n");
#endif
    exit(1);
  }
}

/****************************************
 ** FUNCTION: PopupFisWindow           **
 ** PURPOSE:  Callback function        **
 ** INPUTS:   Xt                       **
 ** RETURNS:  none                     **
 ***************************************/

void PopupFisWindow(w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
     
{
  Widget ctrl = (Widget) client_data;
  Dimension	width, height;
  Position	x, y;

  /* rescan the current directory */
  ScanDir( &FisDirectory );
  FisSetDirectory( &FisDirectory );
  
  /* move the popup */
  XtVaGetValues( ctrl,
		XtNwidth, &width,
		XtNheight, &height,
		NULL );
  
  XtTranslateCoords( ctrl,
		    (Position) width/2,
		    (Position) height/2,
		    &x, &y);
  
  XtVaSetValues( FisPopup,
		XtNx, x,
		XtNy, y,
		NULL);
  
  /* then pop it up */
  XtPopup( FisPopup, XtGrabExclusive );
  
  _FisIsOpen = TRUE;
}

/*************************************************************************
 ** FUNCTIONS: FisSetDirectory                                          **
 ** PURPOSE:   Set the widgets according to a DirContents struct        **
 ** INPUTS:    struct DirContents *DC                                   **
 ** RETURNS:   none                                                     **
 ************************************************************************/

void FisSetDirectory( DC )
     struct DirContents *DC;
     
{
  char	path[MAXPATHLEN];
  char	*start = DC->Pathname, *p, *q;
  int	i;
  static char *emptystring = " *empty*";
  
  for( MenuDepth=0, q = start+strlen(start)-1;
      q >= start; ++MenuDepth )
    {
      /* get last part of path */
      if( q == start )
	p = q-1;
      else
	for( --q, p=q; p>start && *p!='/'; --p );
      
      strncpy(path, p+1, q-p);
      path[q-p] = '\0';
      q=p;
      
      /** the first path part is also displayed in the
       ** FisPaPath widget */
      if( ! MenuDepth )
	XtVaSetValues( FisPaPath, XtNlabel, path, NULL );
      
      /* probably set a new menu pane */
      if( MenuDepth < DI_PATHDEPTH )
	{
	  XtVaSetValues(
			FisPaEntry[MenuDepth], XtNlabel, path, NULL );
	  XtManageChild(
			FisPaEntry[MenuDepth] );
	}
    }
  
  /* Unmanage all other menu panes */
  for( i=MenuDepth; i<DI_PATHDEPTH; ++i )
    XtUnmanageChild(FisPaEntry[i]);
  
  /** set the directory entry list */
  /** The viewport widget doesn't change the scrollbars
   ** if the list gets smaller or larger. So i unmanage the
   ** list, change it and manage it again -- this works fine
   ** although i doubt whether this is the right way to do it */
  XtUnmanageChild(FisSeList);
  
  /** Again, there is something special...
   ** the list widget can't cope with empty lists,
   ** so when a directory is empty, i simply display an empty
   ** string as the only filename in the list. */
  if( DC->NoOfEntries )
    XawListChange( FisSeList, DC->Name, DC->NoOfEntries, 0, False );
  else
    XawListChange( FisSeList, &emptystring, 1, 0, False );
  
  XtManageChild(FisSeList);
}

/*************************************************************************************************
 ** FUNCTION: FisCancel                                                                         **
 ** PURPOSE:  Callback function. Cancels file selection. Only place where XtPopdown is called   **
 ** INPUTS:   Xt                                                                                **
 ** RETURNS:  none                                                                              **
 ************************************************************************************************/

void FisCancel(w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
     
{
  XtPopdown( FisPopup );
  
  _FisIsOpen = FALSE;
}

/*************************************************************************************************
 ** FUNCTION: FisListSingleClick                                                                **
 ** PURPOSE:  Callback function.                                                                **
 **           If a filename was clicked, set the FisFiName widget to reflect the new            **
 **           filename. If a pathname was clicked, change current path                          **
 ** INPUTS:   Xt                                                                                **
 ** RETURNS:  none                                                                              **
 ************************************************************************************************/

void FisListSingleClick(w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
     
{
  XawListReturnStruct *listret = (XawListReturnStruct *)call_data;
  
  if( IsAFile( &FisDirectory, listret->list_index ) )
    {
      XtVaSetValues( FisFiName,
		    XtNstring, listret->string+1,
		    NULL );
      XawTextSetInsertionPoint( FisFiName,
			       (XawTextPosition)(strlen(listret->string)-1) );
    }
  else
    {
      /* a directory entry was selected */
      if( AddPathname( &FisDirectory, listret->string+1 ) )
	{
	  ScanDir( &FisDirectory );
	  FisSetDirectory( &FisDirectory );
	}
    }
}

/************************************************************
 ** FUNCTION: CheckParFile                                 **
 ** PURPOSE:  Checks whether the loaded file is a          **
 **           Parallaxis source file or not.               **
 ** INPUTS:   none                                         **
 ** RETURNS:  BOOLEAN, TRUE  - Parallaxis file             **
 **                    FALSE - perhaps no Parallaxis file  **
 ***********************************************************/

BOOLEAN CheckParFile(cs)
int cs;
{
  int i = 0;
  char tt[F2];
  while (i < 200)
    {
      if (filebuf[i] == NULL)
	return(FALSE);
      scopy(filebuf[i],tt,cs+1,cs+6);
      if (strcasecmp(tt,"system") == 0)
	return(TRUE);
      i++;
    }
  return(FALSE);
}

/*******************************************************
 ** FUNCTION: DrawListFile                            **
 ** PURPOSE:  Renews entries of the list widget       **
 ** INPUTS:   char *what[] - new string to be drawed  **
 **           int l        - number of strings        **
 ** RETURNS:  none                                    **
 ******************************************************/

void DrawListFile(l)
     int l;
{
  int lo = 2000;

  XtUnmanageChild(listfile);
  if (l < 2500)
    XtVaSetValues(listfile,
		  XtNverticalList,TRUE,
		  XtNnumberStrings,l,
		  XtNlongest, lo,
		  NULL);
  else
    XtVaSetValues(listfile,
		  XtNverticalList,TRUE,
		  XtNnumberStrings,l,
		  XtNdefaultColumns,2,
		  XtNlongest, lo*2,
		  NULL);
    
  XawListChange(listfile,filebuf,l,0,FALSE);
  XtManageChild(listfile);
}

/********************************************************
 ** FUNCTION: FisLoad                                  **
 ** PURPOSE:  Callback function. Load a Parallaxisfile **
 ** INPUTS:   Xt                                       **
 ** RETURNS:  none                                     **
 *******************************************************/

void FisLoad(w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
     
{
  char stu[150];
  String s;
  char cs[20],rz[100],*emeld;
  BOOLEAN LoadOK;
  FILE *fp,*fopen();
  int i = 0, j, k = 1, l, m, tok;
  char *rs,*is = "\0";
  int defco,te;
  BOOLEAN foco, ok = FALSE, compileerror = FALSE, fertig = FALSE, fertig1 = FALSE;
  BOOLEAN fertig2 = FALSE;
  BOOLEAN newfile = TRUE, ft = FALSE;
  char oneline[F2];
  char tss[100],ts1[10];

  /* get file name */

  if (emode != 1)
    {
      XtVaGetValues( FisFiName,
		    XtNstring, &s, NULL );
      
      /* try to load */
      strcpy(stu,"Filename: ");
      strcat(stu,FisDirectory.Pathname);
      strcpy(fullname,FisDirectory.Pathname);
      strcat(stu,s);
      strcat(fullname,s);
      if (strcmp(fullname,oldfilename) == 0)
	newfile = FALSE;
      else
	strcpy(oldfilename,fullname);
    }
  else
    newfile = FALSE;
  
  if ((fp = fopen(fullname,"r")) == NULL)
    {
      WriteText(message,"File does not exist or is protected");
      LoadOK = FALSE;
    }
  else
    {
      for (j = 0; j < lastlines; j++)
	if (!free(filebuf[j]))
	  fprintf(stderr,"WARNING --- Couldn't free FILEBUF[%d]-Buffer.\n",j);
	    
      do
	{
	  if ((fgets(oneline,F2,fp)) != NULL)
	    {
	      oneline[strlen(oneline)] = '\0';
	      filebuf[i] = (char *)calloc(strlen(oneline)+20,sizeof(char));
	      if (filebuf[i] == NULL)
		{	
		  fprintf(stderr,"Couldn't allocate required memory ! (FILEBUF)\n");
		  exit;
		}
	      strcpy(filebuf[i],oneline);
	      i++;
	    }
	  else
	    ft = TRUE;
	}
      while (!ft);

      fclose(fp);
      
      lines = i;
      lastlines = lines;

      for (j=0; j<lines; j++)
	{
	  itoa(k,cs);
	  AddBlanks(k,lines,cs);		
	  strcat(cs," ");
	  leftcat("  ",cs);
	  k++;
	  leftcat(cs,filebuf[j]);
	  filebuf[j][strlen(filebuf[j])-1] = '\0';
	}
      
      if (!CheckParFile(strlen(cs)))
	{
	  LoadOK = FALSE;
	  WriteText(message,"This file seems not to be a Parallaxis source file !");
	}
      else
	{
	  LoadOK = TRUE;
	  fileok = TRUE;
	  
	  if (pid > 0)
	    {
	      strcpy(tss,"kill -2 ");
	      itoa(pid,ts1);
	      strcat(tss,ts1);
	      system(tss);
	    }

	  strcat(stu," --- COMPILING --- ");
	  WriteText(message,stu);
	  WriteText(mfile,fullname);
	  
	  DrawListFile(lines);
	  
	  /* load file in PARZ */
	  
	  strcpy(rz,"LOAD ");
	  strcat(rz,fullname);
	  strcat(rz,"\n");
	  paprint(rz);
	  
	  emeld = (char *)calloc(2,sizeof(char));
	  strcpy(emeld,"\0");
	  fertig2 = FALSE;
	  clearbuffer();
	  while (!fertig2)
	    {
	      pascan1(inbuf,TRUE);
	      if (strcasecmp(puffer[atokens],"P>") == 0)
		fertig2 = TRUE;
	      emeld = (char *)realloc(emeld,strlen(emeld)+strlen(inbuf)+1);
	      strcat(emeld,inbuf);
	    }

	  clearbuffer();
	  tok = scanner(emeld);

	  for (m = 0; m <= tok; m++)
	    {
	      if (strcasecmp(puffer[m],"input-file") == 0)
		fertig1 = TRUE;
	      if ((strncasecmp(puffer[m],"[error",6) == 0) || (strncasecmp(puffer[m],"[runtime",8) == 0) ||
		  (strncasecmp(puffer[m],"[warning",8) == 0) || (strncasecmp(puffer[m],"[abort",6) == 0))
		compileerror = TRUE;
	      
	    }
	  
	  if (debugon)
	    fprintf(stderr,"EMELD(FISLOAD) = %s\n",emeld);
	  
	  ScanOut(1,1);
	  ScanOut(1,2);
	  if (newfile)
	    {
	      for (l = 0; l < WAT1; l++)
		strcpy(watches[l],"\0");
	  
	      for (l = 0; l < 10000; l++)
		{
		  strcpy(pecolor[l],"\0");
		  strcpy(dims[l],"\0");
		  strcpy(dims2[l],"\0");
		}
	  
	      dmode = 1;
	      dimmode = FALSE;
	      colormode = FALSE;
	      startmode = FALSE;
	      topon = FALSE;
	      wpoints = 0;
	      strcpy(colorexp,"\0");
	      left = -10;
	      right = 10;
	      strcpy(actproc,"\0");
	      XtVaSetValues(intext, XtNstring, is, NULL);
	      XtVaSetValues(td1, XtNstring, is, NULL);
	      XClearWindow(MyDisplay, XtWindow(ctrlstruc));
	    }

	  WriteText(mpes, "Processor topology");
	  for (l = 0; l < F1; l++)
	    bpoint[l] = 0;
	  
	  outst = (char *)calloc(1,sizeof(char));
	  strcpy(outst,"\0");
	  WriteOut(outst);
	  WatchOut();
	  clearbuffer();
	  strcpy(inbuf,"\0");
	  XawViewportSetCoordinates(listvp, (Position)0, (Position)0);
	  
	  if (!compileerror)
	    WriteText(message," --- READY --- ");
	  else
	    {
	      WriteText(message,"Compiler-Errors or -Warnings occured ---> Program simulation may now work incorrect !");
	      XtVaSetValues(outtext, XtNstring, emeld, NULL);
	    }
	}
    }    
  

  if (!free(emeld))
    fprintf(stderr,"Couldn't free EMELD-Buffer !!!\n");

  /* close file requester, if load succeded */
  if( LoadOK )
    FisCancel(w, client_data, call_data);
}

/************************************************************************************************
 ** FUNCTION: FisMenuSelect                                                                    **
 ** PURPOSE:  Callback function. Response to a user's menu selection and change the path       **
 ** INPUTS:   Xt                                                                               **
 ** RETURNS:  none                                                                             **
 ***********************************************************************************************/

void FisMenuSelect(w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
     
{
  int menunumber = (int)client_data;
  
  TruncPathname( &FisDirectory, MenuDepth-menunumber );
  ScanDir( &FisDirectory );
  FisSetDirectory( &FisDirectory );
}

/************************************************************************************************
 ** FUNCTION: FisFiReturn                                                                      **
 ** PURPOSE:  Action Proc. Load a file when the user pressed return or made a double click     **
 ** INPUTS:   none                                                                             **
 ** RETURNS:  none                                                                             **
 ***********************************************************************************************/

void FisFiReturn()
     
{
  Widget        garbage1;
  XtPointer	garbage2, garbage3;
  
  FisLoad(garbage1, garbage2, garbage3);
}

/*****************************************
 ** FUNCTION: FisIsOpen                 **
 ** PURPOSE:  return _FisIsOpen value   **
 ** INPUTS:   none                      **
 ** RETURNS:  int _FispIsOpen           **
 ****************************************/

int FisIsOpen()
{
  return( _FisIsOpen );
}

