/**********************************************************
 **                                                      **
 ** FILE:    misc.c                                      **
 **	         Collection of some useful routines      **
 ** CREATED: 08 MAY 92  Claus Brenner                    **
 ** CHANGES: 28 MAY 93  Stefan Frank                     **
 **          added "itoa, reverse, addblanks, leftcat    **
 **          AddBlanks, scopy"                           **
 **                                                      **
 *********************************************************/

#include	<stdio.h>
#include	<X11/Intrinsic.h>
#include	<X11/StringDefs.h>

/* extern */
extern	Display	*MyDisplay;

/***********************************************************************
 ** FUNCTION: ReadString                                              **
 ** PURPOSE:  Read a line from Input File, including '\n'             **
 **		(I'm sure I could have solved this using fscanf...)   **
 ** INPUTS:   File - file ptr                                         **
 **              S - char ptr to string                               **
 ** RETURNS:  none (fills in specified string)                        **
 **********************************************************************/

void ReadString( File, S )
     FILE *File;
     char *S;
     
{
  int i;
  
  while( (i = getc(File)) != '\n' )
    {
      if( i == EOF )
	break;
      else
	*S++ = (char)i;
    }
  
  *S = '\0';
}


/***************************************************************
 ** FUNCTION: AssembleFilename                                **
 ** PURPOSE:  Put together Path and Name for a full Filename  **
 ** INPUTS:   Pointers to Path, Name and Resulting string.    **
 ** RETURNS:  none (Result ist filled in)                     **
 **************************************************************/

void AssembleFilename( Path, Name, Result )
     char *Path, *Name, *Result;
     
{
  int	l;
  
  if( (l = strlen(Path)) )
    {
      strcpy(Result, Path);
      if( Path[l-1] != '/' )
	strcat(Result, "/");
      strcat(Result, Name);
    }
  else
    /* No Path given */
    strcpy(Result, Name);
}


/*********************************************************
 ** FUNCTION: FClose                                    **
 ** PURPOSE:  fclose, but only if stream is not stdin   **
 ** INPUTS:   stream to close                           **
 ** RETURNS:  none.                                     **
 ********************************************************/

void FClose( Stream )
     FILE *Stream;
     
{
  if( Stream != stdin )
    fclose( Stream );
}


/*************************************************************
 ** FUNCTION: ExposeWidget                                  **
 ** PURPOSE:  Refresh a widget's contents.                  **
 **		I'm not quite sure if the below method is   **
 **		correct, since the `serial' field is set    **
 **		to 0 (however, it works...)                 **
 ** INPUTS:   Widget - widget id of widget to be refreshed  **
 ** RETURNS:  none.                                         **
 ************************************************************/

void ExposeWidget( W )
     Widget W;
     
{
  XEvent event;
  XExposeEvent *e = &(event.xexpose);
  Dimension width, height;
  
  XtVaGetValues( W,
		XtNwidth, &width,
		XtNheight, &height,
		NULL );
  
  event.type = e->type = Expose;
  e->serial = e->x = e->y = e->count = 0;
  e->send_event = False;
  e->display = MyDisplay;
  e->window = XtWindow( W );
  e->width = (int) width;
  e->height = (int) height;
  
  XtDispatchEvent( &event );
  XFlush( MyDisplay );
}


/***************************************************************
 ** FUNCTION: OrderFloat                                      **
 ** PURPOSE:  Swap two float values if they are not in proper **
 **		(ascending) order.                            **
 ** INPUTS:   f1, f2 - ptrs to two float's                    **
 ** RETURNS:  none (swaps *f1, *f2)                           **
 **************************************************************/

void OrderFloat( f1, f2 )
     float *f1, *f2;
     
{
  float temp;
  
  if( *f1 <= *f2 ) return;
  
  temp = *f1;
  *f1  = *f2;
  *f2  = temp;
}

/***************************************************************
 ** FUNCTION: OrderInt                                        **
 ** PURPOSE:  Swap two int values if they are not in proper   **
 **		(ascending) order.                            **
 ** INPUTS:   f1, f2 - ptrs to two int's                      **
 ** RETURNS:  none (swaps *f1, *f2)                           **
 **************************************************************/

void OrderInt( f1, f2 )
     int *f1, *f2;
     
{
  int temp;
  
  temp = *f1;
  *f1  = *f2;
  *f2  = temp;
}

/**********************************************************
 ** FUNCTION: reverse                                    **
 ** PURPOSE:  Reverses String                            **
 ** INPUTS:   String s                                   **
 ** RETURNS:  none                                       ** 
 *********************************************************/

void reverse(s)
     char s[];
{
  int c,i,j;
  
  for (i = 0, j = strlen(s)-1; i < j; i++, j--)
    {
      c = s[i];
      s[i] = s[j];
      s[j] = c;
    }
}

/*********************************************************
 ** FUNCTION: itoa                                      **
 ** PURPOSE:  Converts integer value in string          **
 ** INPUTS:   Int n, String s                           **
 ** RETURNS:  none                                      **
 ********************************************************/

void itoa (n,s)
     char s[];
     int n;
{
  int i, sign;
  
  if ((sign = n) < 0)
    n = -n;
  i = 0;
  do
    {
      s[i++] = n % 10 + '0';
    } while ((n /= 10) > 0);
  if (sign < 0)
    s[i++] = '-';
  s[i] = '\0';
  reverse(s);
}

/***************************************************************
 ** FUNCTION: leftcat                                         **
 ** PURPOSE:  Concatenates constant string from the left side **
 ** INPUTS:   String s1, s2                                   **
 ** RETURNS:  none                                            **
 **************************************************************/

void leftcat(s1,s2)
     char s1[], s2[];
{
  char t[100000];
  strcpy(t,s1);
  strcat(t,s2);
  strcpy(s2,t);
}

/***************************************************************************
 ** FUNCTION: AddBlanks                                                   **
 ** PURPOSE:  Formats an int value and adds blanks from the left side     **
 ** INPUTS:   Int n, Int maxl, String st                                  **
 ** RETURNS:  none                                                        **
 **************************************************************************/

void AddBlanks (n, maxl, st)
     int n, maxl;
     char st[];
{
  int i;
  char s1[6],s2[6],t[6];
  itoa (n, s1);
  itoa (maxl, s2);
  
  t[0] = '\0';
  for (i = 0; i < (strlen(s2) - strlen(s1)); i++)
    strcat(t," ");
  strcat(t,st);
  strcpy(st,t);
}

/****************************************************
 ** FUNCTION: scopy                                **
 ** PURPOSE:  Copies a part of a string to another **
 ** INPUTS:   String s1,s2, Int n1,n2              **
 ** RETURNS:  none                                 **
 ***************************************************/

void scopy(s1,s2,n1,n2)
     char *s1, *s2;
     int n1,n2;
{
  int i;
  for (i = 1; i < n1; i++)
    *s1++;
  for (i = n1; i <= n2; i++)
    *s2++ = *s1++;
  *s2++ = '\0';
}

