/******************************************
 ** Routines for creating a pipe between **
 ** PGUI and PARZ                        **
 ** ------------------------------------ **
 ** Author: Stefan Frank                 **
 ** Last change: 23.08.93                **
 ** ------------------------------------ **
 ** 14.06.93                             **
 ** added a second pipe for handling     **
 ** stdout of the parz interpreter       **
 *****************************************/

#define READ 0                 /* Reading from a PIPE = 0 */
#define WRITE 1                /* Writing to a PIPE = 1   */
#define BSIZE 10000            /* max. string length for transmission */
#define DIM1 2000              /* buffer dimensions       */ 
#define DIM2 80

/* various includes for X,signals, pipes, etc. */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <dirent.h>
#include "misc.h"

int re1,re2,wr,z,i,j;           /* read- and write descriptors */
char puffer[DIM1][DIM2];        /* global buffer */
int ende = 0;                   /* control variable */
int p1[2],p2[2],p3[2];          /* pipe variables */
int pid,count=0,rval;           /* process id, strlen of read message, return value from system calls */
char inbuf[BSIZE];              /* global string with pipe contents */

extern int atokens;             /* number of tokens read */
extern Widget message;          /* message widget for output */

/**************************************************************
 ** FUNCTION: scanner                                        **
 ** PURPOSE:  collects tokens from inputstring               **
 **            uses global buffer: puffer[dim1][dim2]        **
 ** INPUTS:   char ss[] -- string                            **
 ** RETURNS:  none - (global buffer is filled in)            **
 *************************************************************/

int scanner(ss)
     char ss[];
{
  int i, j=0, s, d=0;
  s = strlen(ss);
  for (i=0; i<=s; i++)
    {
      switch (ss[i])
	{
	case 13:
	  break;
	case ' ':
	case '\n':
	  if (d > 0)
	    {
	      puffer[j][d+1]='\0';
	      j++;
	      d = 0;
	    }
	  break;
	default:
	  puffer[j][d++] = ss[i];
	  break;
	}
    }
  if (puffer[j][0] != '\0')
    return (j);
  else
    return (j-1);
}

/***************************************************
 ** FUNCTION: clearbuffer                         **
 ** PURPOSE:  clears global variable puffer       **
 ** INPUTS:   none                                **
 ** RETURNS:  none - (global puffer is changed)   **
 **************************************************/

void clearbuffer()
{
  int i,j;
  for (i=0; i < DIM1; i++)
    for (j = 0; j < DIM2; j++)
      puffer[i][j] = '\0';
}

/**********************************************
 ** FUNCTION: paprint                        **
 ** PURPOSE:  send string to parz-simulator  **
 ** INPUTS:   char s[] - string to be sent   **
 ** RETURNS:  none                           **
 *********************************************/

void paprint(s)
     char s[];
{ 
  int rval;   
  rval = write(wr,s,strlen(s));
}

/************************************************************
 ** FUNCTION: pascan1                                      **
 ** PURPOSE:  get string from parz-simulator using stderr  **
 ** INPUTS:   char s[] -- string to hold the message       **
 **           BOOLEAN bu -- global puffer should be filled **
 **                         or not                         **
 ** RETURNS:  none                                         **
 ***********************************************************/

void pascan1(s,bu)
     char s[];
     BOOLEAN bu;
{
  count = read(re1,s,BSIZE);
  if (count == -1)
    {
      strcpy(s,"\0");
      atokens = 0;
    }
  else
    {
      s[count] = '\0';
      if (bu)
	{
	  clearbuffer(); 
	  atokens = scanner(s);
	}
    }
}

/************************************************************
 ** FUNCTION: pascan2                                      **
 ** PURPOSE:  get string from parz-simulator using stdout  **
 ** INPUTS:   char s[] -- string to hold the message       **
 **           BOOLEAN bu -- global puffer should be filled **
 **                         or not                         **
 ** RETURNS:  none                                         **
 ***********************************************************/

void pascan2(s,bu)
     char s[];
     BOOLEAN bu;
{
  count = read(re2,s,BSIZE);
  if (count == -1)
    {
      strcpy(s,"\0");
      atokens = 0;
    }
  else
    {
      s[count] = '\0';
      if (bu)
	{
	  clearbuffer(); 
	  atokens = scanner(s);
	}
    }
}


/*******************************************************
 ** FUNCTION: CreatePipe                              **
 ** PURPOSE:  creates pipes between PGUI and PARZ     **
 ** INPUTS:   none                                    **
 ** RETURNS:  none                                    **
 ******************************************************/

void CreatePipe()
{
  int test1,test2;
  rval = pipe(p1);                    if (rval) fprintf(stderr,"couldn't create pipe1\n");
  rval = pipe(p2);                    if (rval) fprintf(stderr,"couldn't create pipe2\n");
  rval = pipe(p3);                    if (rval) fprintf(stderr,"couldn't create pipe3\n");
  if (pid = fork())
    {
      /* PARENT PROCESS */
      rval = close (p1[READ]);        if (rval) fprintf(stderr,"error on closing p1[READ]\n");
      rval = close (p2[WRITE]);       if (rval) fprintf(stderr,"error on closing p2[WRITE]\n");
      rval = close (p3[WRITE]);       if (rval) fprintf(stderr,"error on closing p3[WRITE]\n");
      wr  = p1[WRITE];
      re1 = p2[READ];
      re2 = p3[READ];
      
      /* setting the pipes to non blocking IO */
      test1 = fcntl(re1,F_SETFL,O_NDELAY);
      test2 = fcntl(re2,F_SETFL,O_NDELAY);
      
      if ((test1 == 0) && (test2 == 0))
	WriteText(message,"Pipe created ---- PARZ-Simulator connected");
      else
	WriteText(message,"ERROR occured on setting pipes to non blocking IO !");
    }
  else
    {
      /* CHILD PROCESS */
      rval = close(p1[WRITE]);        if (rval) fprintf(stderr,"error on closing p1[WRITE]\n");
      rval = close(p2[READ]);         if (rval) fprintf(stderr,"error on closing p2[READ]\n");
      rval = close(p3[READ]);         if (rval) fprintf(stderr,"error on closing p3[READ]\n");
      
      rval = close(0);                if (rval) fprintf(stderr,"error on closing STDIN\n");
      rval = dup(p1[READ]);           if (rval == -1) fprintf(stderr,"error on dup p1[READ]\n");
      rval = close(p1[READ]);         if (rval) fprintf(stderr,"error on closing p1[READ]\n");
      
      rval = close(1);                if (rval) fprintf(stderr,"error on closing STDOUT\n");
      rval = dup(p3[WRITE]);          if (rval == -1) fprintf(stderr,"error on duping p3[WRITE]\n");
      
      rval = close(2);                if (rval) fprintf(stderr,"error on closing STDERR\n");       
      rval = dup(p2[WRITE]);          if (rval == -1) fprintf(stderr,"error on dup p2[WRITE]\n");
      
      rval = close(p2[WRITE]);        if (rval) fprintf(stderr,"error on closing p2[WRITE]\n");
      rval = close(p3[WRITE]);        if (rval) fprintf(stderr,"error on closing p3[WRITE]\n");
      
      /* Start the PARZ interpreter */
      count = execlp("pz","pz","-lm0",(char *)0);
    }
}




















