/********************************************
** windows.c -- Creates all widgets and    **
**              colours                    **
**              --> called by main()       **
** --------------------------------------- **
** Last change: 26.10.93                   **
** --------------------------------------- **
** 18.08.93: Added a graphics context for  **
**           drawing the PE-structure      **
** 06.09.93: Added entries for colormap    **
********************************************/

/* Include Xt and Xaw */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>

extern Widget       toplevel,goodbye,load,ctrlmain,ctrlbutt,ctrlfile,ctrlpes,ctrlstruc,fout,fin,message;
extern Widget       edit,editor,go,step,over,gline,addwatch,delwatch,diaform,dialog,done,pshell,listvp,listfile;
extern Widget       outtext,intext,petext,mfile,minput,moutput,mwatches,mpes,helpbutton,helppopup,helpdone;
extern Widget       helpform,helptext,topol,stopex,clearbp,wpopup,wform,wdialog,wdone,glpopup,glform,gldialog,gldone;
extern Widget       tpopup,tform,td1,td2,td3,tlabel,tstart,tcircle,tgrid,tnothing;
extern XtAppContext ApplicationContext;
extern Display      *MyDisplay;
extern int          MyScreen;
extern GC           NormalGC;
extern Font         ft;
extern int          minc, maxc;
extern char         *Fallback_Resources[];

extern void         WDone(), GlDone(), DialogDone();
extern void         InReturn();
extern void         GotoLine();

static XtActionsRec CtrlActions[] = {
  {"wDone",      WDone      },
  {"glDone",     GlDone     },
  {"dialogDone", DialogDone },
  {"inReturn",   InReturn   }};


/********************************************************
 ** FUNCTION: GetRGB                                   **
 ** PURPOSE:  convert a given hue value to rgb values  **
 ** INPUTS:   Hue - Real value 0<=Hue<=720             **
 **	      RGB - int* to r, g, b results            **
 ** RETURNS:  RGB field is filled in                   **
 **		(RGB[0] = r, RGB[1] = g, RGB[2] = b)   **
 *******************************************************/

void GetRGB( Hue, RGB )
     float Hue;
     int RGB[];
	
{
  register int sector;
  register float v, r, g, b;
  
  sector  = (int)(Hue / 120.0);
  v       = (Hue - sector * 120.0) / 120.0; /* between 0 and 1 */
  
  switch( sector ) {
  case 0:	r = 1;   g = v;   b = 0;	break;
  case 1:	r = 1-v; g = 1;   b = 0;	break;
  case 2:	r = 0;   g = 1;   b = v;	break;
  case 3:	r = 0;   g = 1-v; b = 1;	break;
  case 4:	r = v;   g = 0;   b = 1;	break;
  case 5:	r = 1;   g = 0;   b = 1-v;	break;
  }
  
  RGB[0] = (int)(r * 255);
  RGB[1] = (int)(g * 255);
  RGB[2] = (int)(b * 255);
}


/*********************************************************
 ** FUNCTION: CreateAll                                 **
 ** PURPOSE:  Creates all of the desired widgets        **
 ** INPUTS:   int ac, char **av (for XtVaAppInitialize) **
 ** RETURNS:  none (global widgets are created)         **
 ********************************************************/

void CreateAll(ac,av)
     int ac;
     char **av;
{
  XtGCMask value_mask;
  XGCValues values;
  XColor color;
  int rgb[3];
  float r;

  /* Level 0 */
  
  toplevel = XtVaAppInitialize(&ApplicationContext,
			       "Pgui",
			       NULL,0,
			       &ac,av,
			       Fallback_Resources,
			       NULL);
  
  XtAppAddActions(ApplicationContext,
		  CtrlActions, XtNumber(CtrlActions));
  
  MyDisplay = XtDisplay( toplevel );
  MyScreen = DefaultScreen( MyDisplay );
  
  r = 0;
  minc = 256;
  maxc = 0;
  while (r < 600)
    {
      GetRGB(r, rgb);
      color.red = rgb[0] << 8;
      color.green = rgb[1] << 8;
      color.blue = rgb[2] << 8;
      r += 2.6;
      
      XAllocColor(MyDisplay, DefaultColormap(MyDisplay, MyScreen), &color);
      if (color.pixel < minc)
	minc = color.pixel;
      if (color.pixel > maxc)
	maxc = color.pixel;
    }

  if (maxc > 253)
    {
      fprintf(stderr,"WARNING - Can't create correct colormap !!!\n");
      maxc = 253;
    }
  
  if (maxc < 200)
    {
      fprintf(stderr,"WARNING - Can't create correct colormap !!!\n");
      maxc -= 2;
    }
  
  /* Level 1 */

  ctrlmain = XtVaCreateManagedWidget(
				     "ctrlmain",
				     formWidgetClass,
				     toplevel,
				     NULL
				     );
  
  /* Level 2 */
  
  ctrlbutt = XtVaCreateManagedWidget(
				     "ctrlbutt",
				     formWidgetClass,
				     ctrlmain,
				     NULL
				     );

  moutput = XtVaCreateManagedWidget(
				    "moutput",
				    labelWidgetClass,
				    ctrlmain,
				    NULL
				    );
  
  fout = XtVaCreateManagedWidget(
        	        	 "fout",
				 formWidgetClass,
			         ctrlmain,
			         NULL
				 );
  
  minput = XtVaCreateManagedWidget(
				   "minput",
				   labelWidgetClass,
				   ctrlmain,
				   NULL
				   );
  
  fin = XtVaCreateManagedWidget(
				"fin",
			        formWidgetClass,
				ctrlmain,
				NULL
				);
  
  mfile = XtVaCreateManagedWidget(
				  "mfile",
				  labelWidgetClass,
				  ctrlmain,
				  NULL
				  );
  
  ctrlfile = XtVaCreateManagedWidget(
				     "ctrlfile",
				     formWidgetClass,
				     ctrlmain,
				     NULL
				     );
  
  mpes = XtVaCreateManagedWidget(
				 "mpes",
				 labelWidgetClass,
				 ctrlmain,
				 NULL
				 );
  
  ctrlstruc = XtVaCreateManagedWidget(
				      "ctrlstruc",
				      formWidgetClass,
				      ctrlmain,
				      NULL
				      );
  
  value_mask = (GCForeground | GCBackground);
  values.foreground = BlackPixel(MyDisplay, MyScreen);
  values.background = WhitePixel(MyDisplay, MyScreen);
  NormalGC = XtGetGC( ctrlstruc, value_mask, &values);
  ft = XLoadFont(MyDisplay, "6x12");
  XSetFont(MyDisplay, NormalGC, ft);
  
  mwatches = XtVaCreateManagedWidget(
				     "mwatches",
				     labelWidgetClass,
				     ctrlmain,
				     NULL
				     );
  
  ctrlpes  = XtVaCreateManagedWidget(
				     "ctrlpes",
				     formWidgetClass,
				     ctrlmain,
				     NULL
				     );
  
  /* Level 3 */
  
  petext = XtVaCreateManagedWidget(
				   "petext",
				   asciiTextWidgetClass,
				   ctrlpes,
				   XtNeditType,
				   XawtextRead,
				   XtNscrollVertical,
				   TRUE,
				   XtNscrollHorizontal,
				   TRUE,
				   NULL
				   );
  
  outtext = XtVaCreateManagedWidget(
				    "outtext",
				    asciiTextWidgetClass,
				    fout,
				    XtNeditType,
				    XawtextRead,
				    XtNscrollVertical,
				    TRUE,
				    XtNscrollHorizontal,
				    TRUE,
				    NULL
				    );
  
  intext = XtVaCreateManagedWidget(
				   "intext",
				   asciiTextWidgetClass,
				   fin,
				   XtNeditType,
				   XawtextAppend,
				   XtNscrollVertical,
				   TRUE,
				   NULL
				   );
  
  XtOverrideTranslations( intext, XtParseTranslationTable("<Key>Return: inReturn()"));
  
  goodbye = XtVaCreateManagedWidget(
				    "goodbye",
				    commandWidgetClass,
				    ctrlbutt,
				    NULL
				    );
  
  load = XtVaCreateManagedWidget(
				 "load",
				 commandWidgetClass,
				 ctrlbutt,
				 NULL
				 );
  
  edit = XtVaCreateManagedWidget(
				 "edit",
				 commandWidgetClass,
				 ctrlbutt,
				 NULL
				 );
  
  editor = XtVaCreateManagedWidget(
				   "editor",
				   commandWidgetClass,
				   ctrlbutt,
				   NULL
				   );
  
  go = XtVaCreateManagedWidget(
			       "go",
			       commandWidgetClass,
			       ctrlbutt,
			       NULL
			       );
  
  step = XtVaCreateManagedWidget(
				 "step",
				 commandWidgetClass,
				 ctrlbutt,
				 NULL
				 );
  
  over = XtVaCreateManagedWidget(
				 "over",
				 commandWidgetClass,
				 ctrlbutt,
				 NULL
				 );
  
  gline = XtVaCreateManagedWidget(
				  "gline",
				  commandWidgetClass,
				  ctrlbutt,
				  NULL
				  );
  
  addwatch = XtVaCreateManagedWidget(
				     "addwatch",
				     commandWidgetClass,
				     ctrlbutt,
				     NULL
				     );
  
  delwatch = XtVaCreateManagedWidget(
				     "delwatch",
				     commandWidgetClass,
				     ctrlbutt,
				     NULL
				     );
  
  helpbutton = XtVaCreateManagedWidget(
				       "helpbutton",
				       commandWidgetClass,
				       ctrlbutt,
				       NULL
				       );

  topol = XtVaCreateManagedWidget(
				  "topol",
				  commandWidgetClass,
				  ctrlbutt,
				  NULL
				  );

  stopex = XtVaCreateManagedWidget(
				   "stopex",
				   commandWidgetClass,
				   ctrlbutt,
				   NULL
				   );

  clearbp = XtVaCreateManagedWidget(
				   "clearbp",
				   commandWidgetClass,
				   ctrlbutt,
				   NULL
				   );
  
  message = XtVaCreateManagedWidget(
				    "message",
				    labelWidgetClass,
				    ctrlmain,
				    NULL
				    );
  
  pshell = XtVaCreatePopupShell(
				"pshell",
				transientShellWidgetClass,
				toplevel,
				NULL);
  
  diaform = XtVaCreateManagedWidget(
				  "diaform",
				  formWidgetClass,
				  pshell,
				  NULL);

  dialog = XtVaCreateManagedWidget(
				   "dialog",
				   asciiTextWidgetClass,
				   diaform,
				   XtNeditType,
				   XawtextAppend,
				   NULL);
  
  done = XtVaCreateManagedWidget(
				 "done",
				 commandWidgetClass,
				 diaform,
				 XtNbackground,
				 maxc+2,
				 NULL);

  XtOverrideTranslations( dialog, XtParseTranslationTable("<Key>Return: dialogDone()"));

  wpopup = XtVaCreatePopupShell(
				"wpopup",
				transientShellWidgetClass,
				toplevel,
				NULL);
  
  wform = XtVaCreateManagedWidget(
				  "wform",
				  formWidgetClass,
				  wpopup,
				  NULL);

  wdialog = XtVaCreateManagedWidget(
				    "wdialog",
				    asciiTextWidgetClass,
				    wform,
				    XtNeditType,
				    XawtextAppend,
				    NULL);

  XtOverrideTranslations( wdialog, XtParseTranslationTable("<Key>Return: wDone()"));
  
  wdone = XtVaCreateManagedWidget(
				  "wdone",
				  commandWidgetClass,
				  wform,
				  XtNbackground,
				  maxc+2,
				  NULL);

  tpopup = XtVaCreatePopupShell(
				"tpopup",
				transientShellWidgetClass,
				toplevel,
				NULL);

  tform = XtVaCreateManagedWidget(
				  "tform",
				  formWidgetClass,
				  tpopup,
				  NULL);

  td1 = XtVaCreateManagedWidget(
				"td1",
				asciiTextWidgetClass,
				tform,
				XtNeditType,
				XawtextEdit,
				NULL);

  td2 = XtVaCreateManagedWidget(
				"td2",
				asciiTextWidgetClass,
				tform,
				XtNeditType,
				XawtextEdit,
				NULL);

  td3 = XtVaCreateManagedWidget(
				"td3",
				asciiTextWidgetClass,
				tform,
				XtNeditType,
				XawtextEdit,
				NULL);

  tlabel = XtVaCreateManagedWidget(
				   "tlabel",
				   commandWidgetClass,
				   tform,
				   XtNbackground,
				   0,
				   NULL);

  tstart = XtVaCreateManagedWidget(
				   "tstart",
				   commandWidgetClass,
				   tform,
				   XtNbackground,
				   0,
				   NULL);

  tcircle = XtVaCreateManagedWidget(
				    "tcircle",
				    commandWidgetClass,
				    tform,
				    XtNbackground,
				    maxc+2,
				    NULL);
  
  tgrid = XtVaCreateManagedWidget(
				  "tgrid",
				  commandWidgetClass,
				  tform,
				  XtNbackground,
				  maxc+2,
				  NULL);

  tnothing = XtVaCreateManagedWidget(
				     "tnothing",
				     commandWidgetClass,
				     tform,
				     XtNbackground,
				     maxc+2,
				     NULL);
  
  glpopup = XtVaCreatePopupShell(
				 "glpopup",
				 transientShellWidgetClass,
				 toplevel,
				 NULL);

  glform = XtVaCreateManagedWidget(
				   "glform",
				   formWidgetClass,
				   glpopup,
				   NULL);

  gldialog = XtVaCreateManagedWidget(
				     "gldialog",
				     asciiTextWidgetClass,
				     glform,
				     XtNeditType,
				     XawtextAppend,
				     NULL);

  gldone = XtVaCreateManagedWidget(
				   "gldone",
				   commandWidgetClass,
				   glform,
				   XtNbackground,
				   maxc+2,
				   NULL);

  XtOverrideTranslations( gldialog, XtParseTranslationTable("<Key>Return: glDone()"));

  helppopup = XtVaCreatePopupShell(
				   "helppopup",
				   transientShellWidgetClass,
				   toplevel,
				   NULL);
  
  helpform = XtVaCreateManagedWidget(
				     "helpform",
				     formWidgetClass,
				     helppopup,
				     NULL
				     );
  
  helpdone = XtVaCreateManagedWidget(
				     "helpdone",
				     commandWidgetClass,
				     helpform,
				     NULL
				     );
  
  helptext = XtVaCreateManagedWidget(
				     "helptext",
				     asciiTextWidgetClass,
				     helpform,
				     XtNeditType,
				     XawtextRead,
				     XtNscrollVertical,
				     TRUE,
				     NULL
				     );
  
  listvp = XtVaCreateManagedWidget(
				   "listvp",
				   viewportWidgetClass,
				   ctrlfile,
				   XtNallowVert,TRUE,
				   XtNallowHoriz,TRUE,
				   XtNuseBottom,TRUE,
				   NULL);
  
  listfile = XtVaCreateManagedWidget(
				     "no source file",
				     listWidgetClass,
				     listvp,
				     XtNdefaultColumns,1,
				     XtNforceColumns,TRUE,
				     XtNverticalList,TRUE,
				     NULL);
  
}
