h02659
s 00182/00000/00000
d D 1.1 93/06/23 17:21:57 kehrmann 1 0
c date and time created 93/06/23 17:21:57 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL	extern

#include <XSachen.h>
#include <globals.h>
#include <stdio.h>


/*
 * SetPixelWerte
 *
 * Bildet die eingelesenen Befehle auf die zur Verfuegung stehenden Pixel 
 * (anzPixel) ab. Anfang ist der erste Befehl und Ende ist der letzte Befehl
 * dieses Fensters.
 * Wenn es mehr Pixel als Befehle sind, muss man anders rechnen als wenn es mehr
 * Befehle als Pixel sind.
 *
 * IN:	index		Nummer des Grafikfensters
 *	anzPixel	Breite des Darstellungsbereiches
 *
*/
SetPixelWerte(index, anzPixel)
short	index;
int	anzPixel;
{

	int		aktPixel;
	int		BefProPixel;
	stat_typ	i;
	float		min;
	float		max;
	float		Faktor;
	stat_typ	aktBef;
	extrema		*ExtremWerte;
	proc_typ	aktProzessorAnzahl;
	stat_typ	blockZaehler;
	stat_typ	befehlsZaehler;
	stat_typ	AnzahlBefehle;
	stat_typ	ersterBef;
	stat_typ	letzterBef;

	proc_typ	wievieleProzBeiBefehl();
	float		Mittelwert();
	

	/* Allokiert werden muss nur #Pixel_in_x-Richtung */
	Bilder[index].PixelWerte.anzSpeicher = 
		galloc(Bilder[index].PixelWerte.anzSpeicher, 
				anzPixel, 1200, 
				(char **)&(Bilder[index].PixelWerte.Werte),
				sizeof(extrema));
	/* Nur eine Abkuerzung */
	ExtremWerte = Bilder[index].PixelWerte.Werte;

	/* Initialisieren */
	for (i=0; i<anzPixel; i++) {
		ExtremWerte[i].min = inp.maxProzessoren;
		ExtremWerte[i].avg = 0;
		ExtremWerte[i].max = 0;
	}

	ersterBef = Bilder[index].ersterBefehl[Bilder[index].anzAusschnitte];
	letzterBef = Bilder[index].letzterBefehl[Bilder[index].anzAusschnitte];
	AnzahlBefehle = letzterBef - ersterBef;

	/* nach float casten, weil auch nur dann wirklich ein float rauskommt */
	Faktor = (float)anzPixel/(float)(AnzahlBefehle + 1);

	min = 0;
	max = 0;
	
	/* mehr Pixel als Befehle */
	if (Faktor > 1) {
		/* Kehrwert des Faktors berechnen */
		Faktor = 1.0 / Faktor;
		aktBef = 0;
		for (i=0; i<anzPixel; i++) {
			min = max;
			max += Faktor;

			/* gegebenenfalls zum naechsten Befehl gehen */
			if (((int)min == aktBef) ||
			    (((int)min != (int)max) &&
			     ((int)max - min <Faktor/2))) {
				aktBef++;
				/* wieviele aktive Prozessoren ? */
				aktProzessorAnzahl = 
					wievieleProzBeiBefehl(
					aktBef + ersterBef - 1,
					&befehlsZaehler, &blockZaehler);
				
			} /* Ende if */

			/* Weil auf jedes Pixel hoechstens ein Befehl abgebildet
			   wird, sind Maximum, Minimum und Durchschnitt 
			   gleich */
			ExtremWerte[i].min = aktProzessorAnzahl;
			ExtremWerte[i].max = aktProzessorAnzahl;
			ExtremWerte[i].avg = aktProzessorAnzahl;
		} /* Ende for */
		
	} else {
	 	/* mehr Befehle als Pixel */

		aktPixel = 0;
		BefProPixel = 0;

		/* fuer alle Befehle vom ersten bis zum letzten */
		for (i=ersterBef; i<=letzterBef; i++) {
			min = max;
			max += Faktor;

			/* gegebenenfalls zum naechsten Pixel gehen */
			if (((int)min == aktPixel + 1) || (
			    ((int)min != (int)max) && 
			    ((int)max - min < Faktor/2))) {
				aktPixel++;
				BefProPixel = 0;
			}

			/* Wieviele Prozessoren waren bei diesem Befehl aktiv */
			if (i == ersterBef) {
				aktProzessorAnzahl = wievieleProzBeiBefehl(i, 
								&befehlsZaehler,
								&blockZaehler);
			} else {
				if (befehlsZaehler <= i) {
					blockZaehler++;
					befehlsZaehler += inp.bef_liste[blockZaehler].befehls_sum;
					aktProzessorAnzahl = inp.bef_liste[blockZaehler].beteiligte_prozessoren;
				}
			}
				
			/* Minimum, Maximum und Durchschnitt fuer das aktuelle
			   Pixel berechnen */
			ExtremWerte[aktPixel].min = 
					MIN(ExtremWerte[aktPixel].min, 
					    aktProzessorAnzahl);
			ExtremWerte[aktPixel].max = 
					MAX(ExtremWerte[aktPixel].max, 
					    aktProzessorAnzahl);
			ExtremWerte[aktPixel].avg = 
					Mittelwert(ExtremWerte[aktPixel].avg, 
						   BefProPixel,
						   aktProzessorAnzahl);

			/* Anzahl Befehle bei diesem Pixel erhoehen */
			BefProPixel++;

		} /* Ende for */
	} /* Ende else */

	/* Merken, wieviele Pixel in dieser Grafik dargestellt werden */
	Bilder[index].PixelWerte.anz = anzPixel; 
}



/* wievieleProzBeiBefehl
 *
 * Sucht aus der Liste der Befehle und der beteiligten Prozessoren raus,
 * wieviele Prozessoren bei Befehl Nummer 'bef' aktiv waren. 
 * IN:  bef	Befehl, dessen aktive Prozessoren man wissen moechte 
 * OUT:	Fkt.Erg	aktive Prozessoren bei Befehl Nummer 'bef'
*/
static proc_typ wievieleProzBeiBefehl(bef, befZaehler, blockZaehler)
stat_typ	bef;
stat_typ	*befZaehler;
stat_typ	*blockZaehler;
{
	(*blockZaehler) = 0;
	(*befZaehler) = inp.bef_liste[0].befehls_sum;

	/* solange summieren, bis man den richtigen Block in der Liste gefunden
	   hat. */
	while ((*befZaehler) < bef) {
		(*blockZaehler)++;
		(*befZaehler) += inp.bef_liste[*blockZaehler].befehls_sum;
	}

	/* Aktive Prozessoren in diesem Block returnen */
	return(inp.bef_liste[*blockZaehler].beteiligte_prozessoren);
}
E 1
