h24083
s 00312/00000/00000
d D 1.1 93/06/23 17:22:02 kehrmann 1 0
c date and time created 93/06/23 17:22:02 by kehrmann
e
u
U
f e 0
t
T
I 1
/* * Last edited: Aug 19 09:40 1992 (engelhar) */
#define GLOBAL	extern

#include 	<string.h>
#include	<XSachen.h>
#include	<globals.h>

#define	NO_ID	-1

/* druckenCB
 *
 * wird aufgerufen, wenn der "Drucken"-Knopf im Hauptmenue aufgerufen wird.
 * 
*/
void druckenCB(w, client_data, call_data)
Widget	w;
XtPointer	client_data;
XtPointer	call_data;
{
	char	name[256];
	void	ResetPSDialog();

	I_TRACE(1, "druckenCB");

	/* Wenn noch keine Datei eingelesen wurde, dann ist hier nichts
	   zu tun. */
	if (inp.anzBefehle == 0) {
		meldung(ERR_NO_FILE);
		return;
	}

	strncpy(name, Dateiname, strlen(Dateiname) - 3);
	name[strlen(Dateiname) - 3] = '\0';
	(void)strcat(name, "ps");

	/* Wenn die Datei erzeugt wurde, Meldung ausgeben, dass es geklappt
	   hat, sonst nach neuem Namen fragen */
	if (OK == ErzeugePSDatei(name)) {
		meldung(PS_FILE_CREATED);
	} else {
		ResetPSDialog();
		WaehleNeueDatei();
	}
} /* druckenCB */



GetWindowId()
{
	/* Falls kein Fenster offen, keine Id */
	if (anzDrawWidgets == 0)
		return(NO_ID);

	/* sonst das erste Fenster */
	return(0);
}


/* ErzeugePSDatei
 *
 * erzeugt eine Postscript-Datei, die die Grafik enthaelt.
 *
 * IN:	name		Name der Datei, die erzeugt werden soll
 *
 * OUT:	Fkt.erg:	OK	Datei wurde erstellt
 *			ERR	Datei konnte nicht erzeugt werden
 *
*/
ErzeugePSDatei(name)
char		*name;
{
	stat_typ	ersterBef;
	stat_typ	letzterBef;
	FILE		*fp;
	float		XSkal, YSkal;
	long		xSchritt;
	long		ySchritt;
	long		xdiff;
	long		ydiff;
	stat_typ	AnzahlBef;
	long		BerechneSchrittWeite();
	float		xpos;
	float		ypos;
	int		WinId;
	

	I_TRACE(1, "ErzeugePSDatei");

	/* Postscript-Datei oeffnen */
	if ((fp = fopen(name, "w")) ==NULL) {
		fclose(fp);
		return(ERR);
	}

	/* Anwender fragen, welches Fenster er ausdrucken will */
	if ((WinId = GetWindowId()) == NO_ID) {
		ersterBef = 1;
		letzterBef = inp.anzBefehle;
	} else {
		ersterBef = 
		    Bilder[WinId].ersterBefehl[Bilder[WinId].anzAusschnitte];
		letzterBef = 
		    Bilder[WinId].letzterBefehl[Bilder[WinId].anzAusschnitte];
	}


	AnzahlBef = letzterBef-ersterBef+1;
	XSkal = (float)576 / (float)AnzahlBef;
	YSkal = (float)432 / (float)inp.maxProzessoren;
	
	/* Header reinschreiben */
	fprintf(fp, "%%!PS-ADOBE-2.0 EPS-1.2\n");
	fprintf(fp, "%%%%Creator: pmon\n");
	fprintf(fp, "%%%%Pages: 1\n");
	fprintf(fp, "%%%%EndComments\n\n\n");


        fprintf (fp, "/rechteck {\n");
	fprintf (fp, "/Height exch def\n");
	fprintf (fp, "/Width  exch def\n");
	fprintf (fp, "/XStart exch def\n");
	fprintf (fp, "newpath\n");
	fprintf (fp, "XStart 72 moveto\n");
        fprintf (fp, "0 Height rlineto\n");
        fprintf (fp, "Width 0 rlineto\n");
        fprintf (fp, "0 0 Height sub rlineto\n");
        fprintf (fp, "closepath\n");
        fprintf (fp, "fill\n");
	fprintf (fp, "} def\n");

	/* Font fuer die Ueberschrift laden */
	fprintf(fp, "/Times-Roman findfont\n");
	fprintf(fp, "24 scalefont\n");
	fprintf(fp, "setfont\n");



	/* Ursprung verschieben und drehen */
	fprintf(fp, "newpath\n");
	fprintf(fp, "0 792 translate\n");
	fprintf(fp, "-90 rotate\n");

	/* Ueberschrift ausgeben */
	fprintf(fp, "80 554 moveto\n");
	fprintf(fp, "( Record-file: %s ) show\n", Dateiname);

	/* Achsen ausgeben */
	fprintf(fp, "658 72 moveto\n");
	fprintf(fp,"-586 0 rlineto\n");
	fprintf(fp, "0 442 rlineto\n");

	/* Font fuer die Beschriftung der Achsen laden */
	fprintf(fp, "/Times-Roman findfont\n");
	fprintf(fp, "14 scalefont\n");
	fprintf(fp, "setfont\n");

	/* Striche auf die Achsen malen */
	/* die y-Achse */
	ySchritt = BerechneSchrittWeite(inp.maxProzessoren);
	for (ydiff=0; ydiff<=inp.maxProzessoren; ydiff+=ySchritt) {
		ypos = YSkal * ydiff + 72.0;
		fprintf(fp, "72 %f moveto\n", ypos);
		fprintf(fp, "-10 0 rlineto\n");
		/* Beschriftung */
		fprintf(fp, "22 %f moveto\n", ypos - 5.0);
		fprintf(fp, "( %5d ) show\n", ydiff);
	}
	fprintf(fp, "stroke\n");

	xSchritt = BerechneSchrittWeite((long)AnzahlBef);
	/* die x-Achse */
	for (xdiff=0; xdiff<=AnzahlBef; xdiff+=xSchritt) {
		xpos = xdiff * XSkal + 72;
		fprintf(fp, "%f 72 moveto\n", xpos);
		fprintf(fp, "0 -5 rlineto\n");
		fprintf(fp, "%f 55 moveto\n", xpos - 5);
		fprintf(fp, "( %d ) show\n", xdiff + ersterBef - 1);
	}
	fprintf(fp, "stroke\n");

	/* Achsenbeschriftungen ausgeben */
	fprintf(fp, "300 25 moveto\n");
	fprintf(fp, "( Time in program stamps ) show\n");

	fprintf(fp, "gsave\n");
	fprintf(fp, "15 250 moveto\n");
	fprintf(fp, "90 rotate\n");
	fprintf(fp, "( Active Processors ) show\n");
	fprintf(fp, "grestore\n");


	/* zum Ursprung gehen */
	fprintf(fp, "72 72 moveto\n");

	/* Grafikstatus sichern */
#if 0
	fprintf(fp, "gsave\n");
	GibPfadaus(ersterBef, letzterBef, fp, XSkal, YSkal);
	fprintf(fp, "stroke\n");
	fprintf(fp, "grestore\n");
#endif

#if 0
	fprintf(fp, "gsave\n");
#endif

	GibPfadaus(ersterBef, letzterBef, fp, XSkal, YSkal);
#if 0
	fprintf(fp, "fill\n");
	fprintf(fp, "grestore\n");
#endif

	fprintf(fp, "showpage\n");
	
	{ extern druckeKuchen ();

        druckeKuchen (fp);

	fprintf(fp, "showpage\n");
        }

	fclose(fp);
	return(OK);
} /* ErzeugePSDatei */



GibPfadaus(ersterBef, letzterBef, fp, XSkal, YSkal)
stat_typ	ersterBef;
stat_typ	letzterBef;
FILE		*fp;
float		XSkal, YSkal;
{
	stat_typ	ersterBlock;
	stat_typ	letzterBlock;
	stat_typ	startsum;
	proc_typ	startAnz;
	stat_typ	endsum;
	proc_typ	diff;
	stat_typ 	i;
        stat_typ        summe, alteSumme;

	I_TRACE(1, "GibPfadaus");

	/* den ersten Block soweit ausgeben, wie es der erste Befehl angibt */
	ersterBlock = 0;
	startsum = inp.bef_liste[ersterBlock].befehls_sum;
	while (startsum < ersterBef) {
		ersterBlock++;
		startsum = startsum + inp.bef_liste[ersterBlock].befehls_sum;
	}
	startAnz = inp.bef_liste[ersterBlock].beteiligte_prozessoren;

#if 0
	/* senkrechter Strich */
	fprintf(fp, "0 %f rlineto\n", YSkal * startAnz);
	/* waagerechter Strich */
	fprintf(fp, "%f 0 rlineto\n", XSkal * (startsum - ersterBef + 1));
#endif
        summe = startsum - ersterBef + 1;

	letzterBlock = 0;
	endsum = inp.bef_liste[letzterBlock].befehls_sum;
	while (endsum < letzterBef) {
		letzterBlock++;
		endsum = endsum + inp.bef_liste[letzterBlock].befehls_sum;
	}

	/* Grafik ausgeben */
	for (i=ersterBlock+1; i<letzterBlock; i++) {
#if 0
		/* Differenz zwischen vorigem und aktuellem Befehl ausrechnen */
		diff = inp.bef_liste[i].beteiligte_prozessoren 
				- inp.bef_liste[i-1].beteiligte_prozessoren;
#endif
                fprintf (fp, "%f %f %f rechteck\n",
			 72.0 + XSkal * summe, 
			 XSkal * inp.bef_liste[i].befehls_sum, 
			 YSkal * inp.bef_liste[i].beteiligte_prozessoren);			 
		summe += inp.bef_liste[i].befehls_sum;

#if 0
		/* senkrechter Strich */
		fprintf(fp, "0 %f rlineto\n", YSkal * diff);
		/* waagerechter Strich */
		fprintf(fp, "%f 0 rlineto\n", 
				XSkal * inp.bef_liste[i].befehls_sum);
#endif	
	
	}

	/* den letzten Block soweit ausgeben, wie es der letzte Befehl
	   angibt */
	if ((endsum - inp.bef_liste[letzterBlock].befehls_sum != letzterBef) 
	     && (ersterBlock != letzterBlock)) {
		diff = inp.bef_liste[letzterBlock].beteiligte_prozessoren 
			- inp.bef_liste[letzterBlock-1].beteiligte_prozessoren;
#if 0
		/* senkrechter Strich */
		fprintf(fp, "0 %f rlineto\n", YSkal * diff);
		/* waagerechter Strich */
		fprintf(fp, "%f 0 rlineto\n", XSkal * (letzterBef - (endsum - inp.bef_liste[letzterBlock].befehls_sum)));
#endif
	}


	/* Polygon schliessen, fuellen und ausgeben */
#if 0
	fprintf(fp, "0 -%f rlineto\n", YSkal * inp.bef_liste[letzterBlock].beteiligte_prozessoren);
	fprintf(fp, "closepath\n");
#endif
}
E 1
