h54985
s 00218/00000/00000
d D 1.1 93/06/23 17:22:16 kehrmann 1 0
c date and time created 93/06/23 17:22:16 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL	extern

#include 	<XSachen.h>
#include	<globals.h>

#include	<X11/Xaw/Dialog.h>


/* SucheShellWidgetIndex
 *
 * sucht in der Grafikfenster-Liste nach dem Element, dessen ShellWidget-ID
 * gleich "w" ist. Wenn das Element gefunden wurde, gibt diese unktion den Index
 * zurueck, wenn kein Element mit dieser ID gefunden wird, returnt die Funktion
 * "-1".
 *
 * IN:	w		ID des Widgets, nach dem gesucht wird
 * OUT:	Fkt.erg.	Index, wenn die Suche erfolgreich war
 *			-1 sonst
 *
*/
short	SucheShellWidgetIndex(w)
Widget	w;
{
	short	i;

	for (i=0; i<anzDrawWidgets; i++)
		if (w == Bilder[i].DrawWidget_shell)
			return(i);

	return(-1);
} /* SucheShellWidgetIndex */



/* SucheDrawWidgetIndex
 *
 * sucht in der Grafikfenster-Liste nach dem Element, dessen DrawWidget-ID
 * gleich "w" ist. Wenn das Element gefunden wurde, gibt diese unktion den Index
 * zurueck, wenn kein Element mit dieser ID gefunden wird, returnt die Funktion
 * "-1".
 *
 * IN:	w		ID des Widgets, nach dem gesucht wird
 * OUT:	Fkt.erg.	Index, wenn die Suche erfolgreich war
 *			-1 sonst
 *
*/
short	SucheDrawWidgetIndex(w)
Widget	w;
{
	short	i;

	for (i=0; i<anzDrawWidgets; i++)
		if (w == Bilder[i].DrawWidget)
			return(i);

	return(-1);
} /* SucheDrawWidgetIndex */



/* WaehleNeueDatei
 *
 * wird aufgerufen, wenn das Schreiben der PostScript-Datei schief ging
 * stellt einen Dialog dar, in dem der Anwender einen neuen Dateinamen 
 * eingeben kann.
 *
*/
void WaehleNeueDatei()
{
	Position	x, y;
	XWindowAttributes	win_attrs;

	/* Groesse des Bildschirms (RootWindow) */
	XGetWindowAttributes(display, DefaultRootWindow(display),
		&win_attrs);
		
	/* Position ist die Mitte des Bildschirms */
	x = win_attrs.width/2;
	y = win_attrs.height/2;

	/* die Position setzen */
	XtVaSetValues(PSDialog_shell, 
			XtNx, x, 
			XtNy, y, 
			NULL);
	
	XtPopup(PSDialog_shell, XtGrabNonexclusive);
	
} /* WaehleNeueDatei */



/* dateiLesenCB
 * 
 * wird aufgerufen, wenn der Knopf "Datei lesen" im Haupt-Menue gedrueckt wird.
 * Stellt den Datei-Dialog auf dem Bildschirm dar.
 *
 * IN:	w, client_data, call_data	nicht verwendet
 *
*/
void dateiLesenCB(w, client_data, call_data)
Widget	w;
XtPointer	client_data;
XtPointer	call_data;
{
	Position	x, y;
	Dimension	width, height;

	XtVaGetValues(toplevelWidget, 
		      XtNwidth, &width,
		      XtNheight, &height,
		      NULL);
	
	XtTranslateCoords(toplevelWidget, (Position) width/2, 
			  (Position)height/2,
			  &x, &y);

	XtVaSetValues(DateiDialog_shell, XtNx, x, XtNy, y, NULL);
	
	XtPopup(DateiDialog_shell,XtGrabNonexclusive);

}



/* Mittelwert
 *
 * berechnet den Mittelwert mit dem alten Mittelwert, der Anzahl der beteiligten
 * Zahlen und der neuen Zahl.
 * Wenn man den Mittelwert normal berechnet, kann es passieren, dass man die
 * groesste darstellbare Zahl ueberschreitet und deswegen falsche Ergebnisse
 * erhaelt. Deshalb gibt es diese Funktion.
 *
 * IN:	avg		alter Mittelwert
 *	anz		aus wievielen Zahlen der alte Mittelwert gebildet wurde
 *	wert		neue Zahl, die dazugerechnet werden soll
 * OUT:	Fkt.erg.	neuer Mittelwert
 *
*/
float Mittelwert(avg, anz, wert)
float	avg;
long	anz;
long	wert;
{
	float	erg;

	if ((avg == 0) && (anz == 0))
		return((float)wert);
	else {
		erg = (avg * anz + wert) / (anz + 1);
		return(erg);
	}
} /* Mittelwert */



void meldung(s)
char	*s;
{
	Position	x, y;
	XWindowAttributes	win_attrs;

	/* Groesse des Bildschirms (RootWindow) */
	XGetWindowAttributes(display, DefaultRootWindow(display),
		&win_attrs);
		
	/* Position ist die Mitte des Bildschirms */
	x = win_attrs.width/2 - 200;
	y = win_attrs.height/2;

	/* die Position setzen */
	XtVaSetValues(p_shell, 
			XtNx, x, 
			XtNy, y, 
			XtNwidth, 400,
			NULL);
	
	/* den Text setzen */
	XtVaSetValues(meldungWidget, 
			XtNlabel, s, 
			NULL);

	/* und auf den Bildschirm bringen */
	XtPopup(p_shell, XtGrabNonexclusive);
} /* meldung */


/*****************************************************************************/
/* Bloeder Name */
void dialogdone(w, client_data, call_data)
Widget	w;
XtPointer	client_data;
XtPointer	call_data;
{

	XtPopdown(p_shell);

} /* dialogDone */



/* PopUpDialogAbbruch
 *
 * popt einen PopUp-Dialog, der sichtbar ist wieder down.
 * Die Widget-ID bekommt man, indem man den Grossvater des Knopfes nimmt.
 *
 * IN:	w		ID des Knopfes, der gedrueckt wurde
 *	client_data	nicht verwendet
 *	callt_data	nicht verwendet
 *
*/
void PopUpDialogAbbruchCB(w, client_data, call_data)
Widget	w;
XtPointer	client_data;
XtPointer	call_data;
{
	XtPopdown(XtParent(XtParent(w)));
} /* PopUpDialogAbbruch */
E 1
