h38780
s 00224/00000/00000
d D 1.1 93/06/23 17:21:58 kehrmann 1 0
c date and time created 93/06/23 17:21:58 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL	extern

#include	<XSachen.h>
#include	<globals.h>

#include <X11/Shell.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>

#include <string.h>


/* neue Translations beim AusschnittDialog */
static char    myZahlTranslations[] = "\
			<Key>Return:    AusschnittOKCB()  		\n\
			<Key>KP_Enter:  AusschnittOKCB()  		\n\
			<Key>Delete:    delete-previous-character()     \n\
			<Key>BackSpace: delete-previous-character()     \n\
			<Key>Right:     forward-character()             \n\
			<Key>Left:      backward-character()            \n\
			<Key>0:         insert-char()                   \n\
			<Key>1:         insert-char()                   \n\
			<Key>2:         insert-char()                   \n\
			<Key>3:         insert-char()                   \n\
			<Key>4:         insert-char()                   \n\
			<Key>5:         insert-char()                   \n\
			<Key>6:         insert-char()                   \n\
			<Key>7:         insert-char()                   \n\
			<Key>8:         insert-char()                   \n\
			<Key>9:         insert-char()                   \n\
			<Key>:          no-op(RingBell)";


/* AusschnittOKCB
 *
 * wird aufgerufen, wenn OK im Ausschnittdialog gedrueckt oder Return einge-
 * geben wird. Ruft "neuesBild" auf und entfernt die Dialogbox vom Bildschirm.
 *
 * IN:	w		Widget-ID de
 *	client_data	nicht verwendet
 *	callt_data	nicht verwendet
 *
*/
void AusschnittOKCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	void	neuesBild();

	I_TRACE(1, "AusschnittOKCB");

	neuesBild();
	PopUpDialogAbbruchCB(w, (XtPointer)NULL, (XtPointer)NULL);
} /* AusschnittOKCB */



/* GetAusschnittGrenzen
 *
 * gibt die Werte zurueck, die im Ausschnitt-Dialog in die beiden Felder "von"
 * und "bis" eigegeben wurden.
 *
 * IN/OUT:	anf	Zahl aus dem ersten Feld
 *		end	Zahl aus dem zweiten Feld
 *
*/
void GetAusschnittGrenzen(anf, end)
stat_typ	*anf;
stat_typ	*end;
{
	char	*anfTxt;
	char	*endTxt;
	long	atol();

	I_TRACE(1, "GetAusschnittGrenzen");

	XtVaGetValues(vonInput,
			XtNstring, &anfTxt,
			NULL);
	
	XtVaGetValues(bisInput,
			XtNstring, &endTxt,
			NULL);
	
	
	if ( ! strcmp("", anfTxt))
		*anf = 1;
	else {
		*anf = (stat_typ)(atol(anfTxt) + 1);
	}

	if ( ! strcmp("", endTxt))
		*end = inp.anzBefehle;
	else {
		*end = (stat_typ)(atol(endTxt) + 1);
	}
} /* GetAusschnittGrenzen */



/* Um mit den Cursor-Hoch und -Runter-Tasten zwischen den beiden Eingabewidgets
 * hin- und herschalten zu koennen
 *
*/
void AusDiaNextFeld(w)
Widget w;
{
	if (w == vonInput) {
		/* InputFocus setzen */
		return;
	}
	if (w == bisInput) {
		/* InputFocus setzen */
		return;
	}
	/* Warnung, falsche WidgetID */
} /* AusDiaNextFeld */


/* ErzeugeAusschnittDialog
 *
 * erzeugt die Widgets, die den Ausschnitt-Dialog bilden.
 *
*/
void ErzeugeAusschnittDialog()
{
	Widget		ausschnittDialog;
	Widget		nameWidget;
	Widget		vonWidget;
	Widget		bisWidget;
	Widget		AusschnittDialogOK;
	Widget		AusschnittDialogAbbruch;
	Widget		fooWidget;

	I_TRACE(1, "ErzeugeAusschnittDialog");

	/* Popup-Shell fuer den AusschnittDialog */
	AusschnittDialog_shell = XtCreatePopupShell("AusschnittDialog_shell", 
				transientShellWidgetClass,
				toplevelWidget, NULL, 0);

	/* Dialog, um die Ausschnittdaten einzugeben */
	ausschnittDialog = XtVaCreateManagedWidget("ausschnittDialog", 
					formWidgetClass,
					AusschnittDialog_shell, 
					XtNdefaultDistance, 10,
					NULL);


	nameWidget = XtVaCreateManagedWidget("Titel", labelWidgetClass,
				ausschnittDialog,
				XtNlabel, BEFEHLE_TXT,
				XtNtop, XtChainTop,
				XtNborderWidth, 0,
				NULL);

	fooWidget = XtVaCreateManagedWidget("foo", labelWidgetClass,
				ausschnittDialog,
				XtNlabel, "            ",
				XtNfromVert, nameWidget,
				XtNborderWidth, 0,
				NULL);

	vonWidget = XtVaCreateManagedWidget("von", labelWidgetClass,
				ausschnittDialog,
				XtNlabel, VON_TXT,
				XtNfromHoriz, nameWidget,
				XtNborderWidth, 0,
				NULL);

	bisWidget = XtVaCreateManagedWidget("bis", labelWidgetClass,
				ausschnittDialog,
				XtNlabel, BIS_TXT,
				XtNfromVert, vonWidget,
				XtNfromHoriz, fooWidget,
				XtNborderWidth, 0,
				NULL);

	vonInput = XtVaCreateManagedWidget("vonInput", asciiTextWidgetClass,
				ausschnittDialog,
				XtNlength, 7,
				XtNeditType, XawtextEdit,
				XtNfromHoriz, vonWidget,
				XtNtranslations, XtParseTranslationTable(myZahlTranslations),
				NULL);

	bisInput = XtVaCreateManagedWidget("bisInput", asciiTextWidgetClass,
				ausschnittDialog,
				XtNlength, 7,
				XtNeditType, XawtextEdit,
				XtNfromHoriz, bisWidget,
				XtNfromVert, vonInput,
				XtNtranslations, XtParseTranslationTable(myZahlTranslations),
				NULL);


	/* Der OK-Knopf im AusschnittDialog */
	AusschnittDialogOK = XtVaCreateManagedWidget("dialogDone", 
				commandWidgetClass,
				ausschnittDialog,
				XtNlabel, OK_TXT,
				XtNborderWidth, 3,
				XtNleft, XtChainLeft,
				XtNfromVert, bisInput,
				NULL);
	XtAddCallback(AusschnittDialogOK, 
		      XtNcallback, AusschnittOKCB, 
		      NULL);

	/* Der Abbruch-Knopf im AusschnittDialog */
	AusschnittDialogAbbruch = XtVaCreateManagedWidget("dialogDone", 
				commandWidgetClass,
				ausschnittDialog,
				XtNfromVert, bisInput,
				XtNfromHoriz, AusschnittDialogOK,
				XtNlabel, ABBRUCH_TXT,
				NULL);
	XtAddCallback(AusschnittDialogAbbruch, 
		      XtNcallback, PopUpDialogAbbruchCB,
		      NULL);
} /* ErzeugeAusschnittDialog */

E 1
