h32668
s 00142/00000/00000
d D 1.1 93/06/23 17:22:01 kehrmann 1 0
c date and time created 93/06/23 17:22:01 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL	extern

#include	<XSachen.h>
#include	<globals.h>

#include <X11/Shell.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>

#include <string.h>


/* neue Translations beim DateiDialog */
static char    myDialogTranslations[] = "\
		<Key>Return:	LiesDateiOK_CB()		\n\
                <Key>KP_Enter:  LiesDateiOK_CB()  		\n\
                <Key>Delete:    delete-previous-character()     \n\
                <Key>BackSpace: delete-previous-character()     \n\
                <Key>Right:     forward-character()             \n\
                <Key>Left:      backward-character()            \n\
                <Key>:          insert-char()";

/* Der OK-Knopf im DateiLesenDialog */
static Widget	DateiDialogOK;




/* LiesDateiOK_CB
 *
 * wird aufgerufen, wenn der OK-Knopf im Datei-Dialog gedrueckt wird. Ruft
 * lies_dateiCB und PopUpDialogAbbruch auf.
 *
*/
void LiesDateiOK_CB()
{
	void	lies_dateiCB();
	void	PopUpDialogAbbruchCB();

        PopUpDialogAbbruchCB(DateiDialogOK, (XtPointer)NULL, (XtPointer)NULL);
        lies_dateiCB(DateiDialogOK, (XtPointer)NULL, (XtPointer)NULL);
} /* LiesDateiOK_CB */



/* ErzeugeDateiDialog
 *
 * erzeugt die Widgets, die den Datei-Dialog bilden.
 *
*/
ErzeugeDateiDialog()
{
	Widget	DateiDialog;
	Widget	nameWidget;
	Widget	DateiDialogAbbruch;
	Widget	pfadWidget;
	Widget	dateiNameWidget;

	/* Popup-Shell fuer den DateiDialog */
	DateiDialog_shell = XtCreatePopupShell("File selection", 
				transientShellWidgetClass,
				toplevelWidget, NULL, 0);

	/* Dialog, um die Datei zu lesen */
	DateiDialog = XtVaCreateManagedWidget("DateiDialog", 
				formWidgetClass,
				DateiDialog_shell,
				XtNdefaultDistance, 10,
				NULL);

	nameWidget = XtVaCreateManagedWidget("Titel", labelWidgetClass,
			DateiDialog,
			XtNlabel, DAT_LES_TXT,
			XtNtop, XtChainTop,
			XtNborderWidth, 0,
			NULL);

	pfadWidget = XtVaCreateManagedWidget("pfad", labelWidgetClass,
			DateiDialog,
			XtNlabel, PFAD_TXT,
			XtNfromVert, nameWidget,
			XtNborderWidth, 0,
			NULL);

	dateiNameWidget = XtVaCreateManagedWidget("dateiName", labelWidgetClass,
			DateiDialog,
			XtNlabel, DAT_NAME_TXT,
			XtNfromVert, pfadWidget,
			XtNborderWidth, 0,
			NULL);

	pfadInput = XtVaCreateManagedWidget("pfadInput", asciiTextWidgetClass,
			DateiDialog,
			XtNlength, 40,
			XtNwidth, 200,
			XtNeditType, XawtextEdit,
			XtNfromHoriz, pfadWidget,
			XtNfromVert, nameWidget,
			XtNtranslations, XtParseTranslationTable(myDialogTranslations),
			NULL);

	dateiNameInput = XtVaCreateManagedWidget("dateiNameInput", 
			asciiTextWidgetClass,
			DateiDialog,
			XtNlength, 20,
			XtNwidth, 200,
			XtNeditType, XawtextEdit,
			XtNfromHoriz, dateiNameWidget,
			XtNfromVert, pfadInput,
			XtNtranslations, XtParseTranslationTable(myDialogTranslations),
			XtNscrollHorizontal, XawtextScrollWhenNeeded,
			NULL);

	/* Der OK-Knopf im DateiDialog */
	DateiDialogOK = XtVaCreateManagedWidget("DateiDialogOK", 
				commandWidgetClass,
				DateiDialog,
				XtNlabel, OK_TXT,
				XtNborderWidth, 3,
				XtNfromVert, dateiNameWidget,
				NULL);
	XtAddCallback(DateiDialogOK, 
			XtNcallback, PopUpDialogAbbruchCB,
			NULL);
	XtAddCallback(DateiDialogOK, 
			XtNcallback, lies_dateiCB,
			NULL);
	
	/* Der Abbruch-Knopf im DateiDialog */
	DateiDialogAbbruch = XtVaCreateManagedWidget("DateiDialogAbbruch", 
				commandWidgetClass,
				DateiDialog,
				XtNlabel, ABBRUCH_TXT,
				XtNfromVert, dateiNameWidget,
				XtNfromHoriz, DateiDialogOK,
				NULL);
	XtAddCallback(DateiDialogAbbruch, 
			XtNcallback, PopUpDialogAbbruchCB, 
			NULL);

} /* ErzeugeDateiDialog */
E 1
