h22476
s 00589/00000/00000
d D 1.1 93/06/23 17:22:07 kehrmann 1 0
c date and time created 93/06/23 17:22:07 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL	extern

#include 	<XSachen.h>
#include	<globals.h>
#include	<math.h>

#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>


static char	Ueberschrift1[] = "Timestamps of Scalar vs. Vector-statements";
static	char	Skalartxt[] = "Scalar";
static	char	Vektortxt[] = "Vector";

static String	kuchenTrans =
        "<ConfigureNotify>:     ResizeKuchen()         \n\
	 <Expose>:		RedrawPicture()";

/* GC zum Malen und GC zum Loeschen in der KuchenPixmap */
static GC		KuchenDrawGC;
static GC		KuchenEraseGC;



/* ErzeugeKuchenWidget
 *
 * erzeugt die Widgets, die das Kuchenfenster bilden.
 *
*/
void ErzeugeKuchenWidget()
{
	Widget		kuchenFormular;
	Widget		KuchenEnde;
	XGCValues	values;

	/* Popup-Shell fuer das Kuchenfenster */
	Kuchen_shell = XtVaCreatePopupShell("diagrams", 
			topLevelShellWidgetClass,
			toplevelWidget, 
			XtNresizable, False,
			NULL);

	/* Formular, das den Malbereich und den Ende-Knopf  enthaelt */
	kuchenFormular = XtVaCreateManagedWidget("kuchenFormular", 
			formWidgetClass,
			Kuchen_shell, 
			XtNresizable, False,
			NULL);

	/* der eigentliche Malbereich */
	kuchenDrawWidget = XtVaCreateManagedWidget("kuchenDrawWidget",
			widgetClass, kuchenFormular,
			XtNwidth, default_Breite,
			XtNheight, default_Hoehe,
			XtNtop, XtChainTop,
			XtNtranslations, XtParseTranslationTable(kuchenTrans),
			XtNresizable, False,
			NULL);


	/* Der Ende-Knopf im KuchenFormular */
	KuchenEnde = XtVaCreateManagedWidget("kuchenEnde", 
			commandWidgetClass,
			kuchenFormular,
			XtNfromVert, kuchenDrawWidget,
			XtNlabel, OK_TXT,
			XtNresizable, False,
			NULL);

	XtAddCallback(KuchenEnde, 
		XtNcallback, PopUpDialogAbbruchCB,
		NULL);


	/* Pixmap erzeugen */
	KuchenPixmap = XCreatePixmap(display, DefaultRootWindow(display),
			default_Breite, default_Hoehe, 1);

	/* GC's erzeugen */
	values.background = WhitePixel(display, DefaultScreen(display));
	values.foreground = BlackPixel(display, DefaultScreen(display));
	values.arc_mode = ArcPieSlice;
	KuchenDrawGC = XCreateGC(display, KuchenPixmap, 
			GCForeground | GCBackground| GCArcMode, &values);

	values.background = BlackPixel(display, DefaultScreen(display));
	values.foreground = WhitePixel(display, DefaultScreen(display));
	values.arc_mode = ArcPieSlice;
	KuchenEraseGC = XCreateGC(display, KuchenPixmap, 
			GCForeground | GCBackground| GCArcMode, &values);

	/* Fenstergroesse merken */
	KuchenFenstergroesse.x = default_Hoehe;
	KuchenFenstergroesse.y = default_Hoehe;
} /* ErzeugeKuchenWidget */



/* 
 * Zeichne Kuchen
 *
 * gibt die Kuchendiagramme in die Pixmap aus
 *
*/
void ZeichneKuchen()
{

	short	i;
	int	kuchenRandOben = KUCHEN_R_O;
	int	kuchenRandUnten = KUCHEN_R_U;
	int	kuchenRandLinks = KUCHEN_R_L;
	int	kuchenRandRechts = KUCHEN_R_R;
	float	Skalarwinkel;
	float	Vektorwinkel;
	int	strichlaenge = 10;
	int	xoff;
	int	yoff;
	int	x1;
	int	y1;
	int	x2;
	int	y2;
	int	xbbox;
	int	ybbox;
	int	lenbbox;
	int	startwinkel;
	int	hlpwinkel;
	char	tmp_string[2];
	char	tmp_txt[15];
	int	Skalarprozent;
	int	Vektorprozent;
	GC	tmpGC;

	double	sin();
	double	cos();
	double	rad2grad();


	I_TRACE(1, "ZeichneKuchen");

	if (KuchenFenstergroesse.x < KUCHEN_R_L+KUCHEN_R_R)
		return;
	if (KuchenFenstergroesse.y < KUCHEN_R_O+KUCHEN_R_U)
		return;

	/* erst mal die Pixmap leer machen */
	XFillRectangle(display, KuchenPixmap, 
			KuchenEraseGC, 0, 0, 
			KuchenFenstergroesse.x, KuchenFenstergroesse.y);

	Skalarprozent = (int)(inp.anzSkalarBefehle * 100 / inp.anzBefehle);
	Vektorprozent = 100 - Skalarprozent;
	Skalarwinkel = inp.anzSkalarBefehle * 360 / inp.anzBefehle;
	Vektorwinkel = 360.0 - Skalarwinkel;

	lenbbox = MIN(
		KuchenFenstergroesse.y/2 - kuchenRandOben - kuchenRandUnten,
		KuchenFenstergroesse.x/2 - kuchenRandRechts - kuchenRandLinks);
	xbbox = KuchenFenstergroesse.x/2 - lenbbox/2;
	ybbox = kuchenRandOben;

	/* Mittellinie zeichnen */
	XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
		0, KuchenFenstergroesse.y/2,
		KuchenFenstergroesse.x, KuchenFenstergroesse.y/2);

	/* Untere Kuchen mit einer senkrechten Linie trennen */
	XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
		KuchenFenstergroesse.x/2, KuchenFenstergroesse.y/2,
		KuchenFenstergroesse.x/2, KuchenFenstergroesse.y);

	/* Ueberschrift ausgeben */
	XDrawString(display, KuchenPixmap, KuchenDrawGC, 
		kuchenRandOben/2, 20, Ueberschrift1, strlen(Ueberschrift1));

	/* Einen Vollkreis ausgeben */
	XDrawArc(display, KuchenPixmap, KuchenDrawGC, xbbox,
		ybbox, lenbbox, lenbbox, 0, -64 * 360);

	XFillArc(display, KuchenPixmap, KuchenDrawGC, xbbox,
		ybbox, lenbbox, lenbbox, 64*90, (int)(-64 * Skalarwinkel));

	
	/* Beschriftung */
	if ((int)(Skalarwinkel) >120) {
		XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
			xbbox + lenbbox + 10,
			ybbox + lenbbox/2,
			xbbox + lenbbox + 40,
			ybbox + lenbbox/2);
			
		sprintf(tmp_txt, "%s %d%%", Skalartxt, Skalarprozent);
		XDrawString(display, KuchenPixmap, KuchenDrawGC,
			xbbox + lenbbox +50,
			ybbox + lenbbox/2 + 5,
			tmp_txt, strlen(tmp_txt));
	} else {
		xoff = (int)(sin(rad2grad((double)(Skalarwinkel/2))) 
			     * lenbbox/2 + 5);
		yoff = (int)(cos(rad2grad((double)(Skalarwinkel/2))) 
			     * lenbbox/2 + 5);
		x1 = xbbox + lenbbox/2 + xoff + 5;
		y1 = ybbox + lenbbox/2 - yoff;
		x2 = x1 + 40;
		y2 = y1;

		XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
			x1, y1, x2, y2);

		sprintf(tmp_txt, "%s %d%%", Skalartxt, Skalarprozent);
		XDrawString(display, KuchenPixmap, KuchenDrawGC,
			x2+5, y2+5, tmp_txt, strlen(tmp_txt));
	}

	if ((int)(Vektorwinkel) >120) {
		XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
			xbbox - 10,
			ybbox + lenbbox/2,
			xbbox - 40,
			ybbox + lenbbox/2);
			
		sprintf(tmp_txt, "%s %d%%", Vektortxt, Vektorprozent);
		XDrawString(display, KuchenPixmap, KuchenDrawGC,
			xbbox - 110,
			ybbox + lenbbox/2 + 5,
			tmp_txt, strlen(tmp_txt));
	} else {
		xoff = (int)(sin(rad2grad((double)(Vektorwinkel/2))) 
			     * lenbbox/2 + 5);
		yoff = (int)(cos(rad2grad((double)(Vektorwinkel/2))) 
			     * lenbbox/2 + 5);
		x1 = KuchenFenstergroesse.x/2 - xoff - 5;
		y1 = kuchenRandOben + lenbbox/2 - yoff;
		x2 = x1 - 40;
		y2 = y1;

		XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
			x1, y1, x2, y2);

		sprintf(tmp_txt, "%s %d%%", Vektortxt, Vektorprozent);
		XDrawString(display, KuchenPixmap, KuchenDrawGC,
			x2 - 70, y2+5, tmp_txt, strlen(tmp_txt));
	}


	/* jetzt die unteren zwei Kuchendiagramme */
	/* Die Vektorbefehle im Einzelnen */
	lenbbox = MIN(
		KuchenFenstergroesse.y/2 - kuchenRandOben - kuchenRandUnten, 
		KuchenFenstergroesse.x/2 - kuchenRandRechts - kuchenRandLinks);
	xbbox = kuchenRandLinks;
	ybbox = KuchenFenstergroesse.y/2 + kuchenRandOben;
	

	/* Ueberschrift ausgeben */
	XDrawString(display, KuchenPixmap, KuchenDrawGC,
		xbbox-20, ybbox-20, Vektortxt, strlen(Vektortxt));

	/* Einen Vollkreis ausgeben */
	XDrawArc(display, KuchenPixmap, KuchenDrawGC, xbbox,
		ybbox, lenbbox, lenbbox, 0, -64 * 360);

	tmpGC = KuchenDrawGC;
	startwinkel = 90;
	hlpwinkel = 0;
	for (i=0; i<26; i++) {
		if (inp.V_Kommandos[i] != 0) {
			Vektorwinkel = inp.V_Kommandos[i] * 360 
						/ inp.anzVektorBefehle;
if (tmpGC == KuchenDrawGC) {
			XFillArc(display, KuchenPixmap, tmpGC, 
				xbbox, ybbox, 
				lenbbox, lenbbox, 
				startwinkel*64, (int)(-64 * Vektorwinkel));
}
			startwinkel -= Vektorwinkel;
			hlpwinkel += Vektorwinkel;

			/* Beschriftung */
			xoff = (int)((lenbbox/2 + 5)
				* sin(rad2grad((double)(hlpwinkel - Vektorwinkel/2))));
			yoff = (int)((lenbbox/2 + 5)
				* cos(rad2grad((double)(hlpwinkel - Vektorwinkel/2))));
			x1 = xbbox + lenbbox/2 + xoff;
			y1 = ybbox + lenbbox/2 - yoff;
			
			xoff = (int)(strichlaenge 
				* sin(rad2grad((double)(hlpwinkel - Vektorwinkel/2))));
			yoff = (int)(strichlaenge 
				* cos(rad2grad((double)(hlpwinkel - Vektorwinkel/2))));
			x2 = x1 + xoff;
			y2 = y1 - yoff;
/*
			XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
				x1, y1, x2, y2);
*/
			tmp_string[0] = 'A' + i;
			XDrawString(display, KuchenPixmap, KuchenDrawGC, 
				x2, y2, tmp_string, 1);

			/* Farbe wechseln */
			if (tmpGC == KuchenDrawGC)
				tmpGC = KuchenEraseGC;
			else
				tmpGC = KuchenDrawGC;
		}
	}


	/* Die Skalarbefehle im Einzelnen */
	xbbox += KuchenFenstergroesse.x/2;

	/* Ueberschrift ausgeben */
	XDrawString(display, KuchenPixmap, KuchenDrawGC,
		xbbox-20, ybbox-20, Skalartxt, strlen(Skalartxt));

	/* Einen Vollkreis ausgeben */
	XDrawArc(display, KuchenPixmap, KuchenDrawGC, xbbox,
		ybbox, lenbbox, lenbbox, 0, -64 * 360);

	tmpGC = KuchenDrawGC;
	startwinkel = 90;
	hlpwinkel = 0;
	for (i=0; i<26; i++) {
		if (inp.S_Kommandos[i] != 0) {
			Skalarwinkel = inp.S_Kommandos[i] * 360 
						/ inp.anzSkalarBefehle;
if (tmpGC == KuchenDrawGC) {
			XFillArc(display, KuchenPixmap, tmpGC, 
				xbbox, ybbox, 
				lenbbox, lenbbox, 
				startwinkel*64, (int)(-64 * Skalarwinkel));
}
			startwinkel -= Skalarwinkel;
			hlpwinkel += Skalarwinkel;

			/* Beschriftung */
			xoff = (int)((lenbbox/2 + 5)
				* sin(rad2grad((double)(hlpwinkel - Skalarwinkel/2))));
			yoff = (int)((lenbbox/2 + 5)
				* cos(rad2grad((double)(hlpwinkel - Skalarwinkel/2))));
			x1 = xbbox + lenbbox/2 + xoff;
			y1 = ybbox + lenbbox/2 - yoff;
			
			xoff = (int)(strichlaenge 
				* sin(rad2grad((double)(hlpwinkel - Skalarwinkel/2))));
			yoff = (int)(strichlaenge 
				* cos(rad2grad((double)(hlpwinkel - Skalarwinkel/2))));
			x2 = x1 + xoff;
			y2 = y1 - yoff;
/*
			XDrawLine(display, KuchenPixmap, KuchenDrawGC, 
				x1, y1, x2, y2);
*/

			tmp_string[0] = 'a' + i;
			XDrawString(display, KuchenPixmap, KuchenDrawGC, 
				x2, y2, tmp_string, 1);

			/* Farbe wechseln */
			if (tmpGC == KuchenDrawGC)
				tmpGC = KuchenEraseGC;
			else
				tmpGC = KuchenDrawGC;
		}
	}

} /* ZeichneKuchen */



/* kuchenCB
 *
 * wird aufgerufen, wenn der Diagrams-Knopf im Haupt-Menue gedrueckt wird.
 * Dann wird das KuchenWidget auf dem Bildschirm dargestellt.
 *
 * IN:	w, client_data, call_data	nicht verwendet
 *
*/
void kuchenCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	Position	x, y;
	Dimension	width, height;

	/* Wenn noch keine Datei eingelesen wurde, dann ist hier 
	   nichts zu tun. */
	if (inp.anzBefehle == 0) {
		meldung(ERR_NO_FILE);
		return;
	}

	/* Statistikfenster darstellen */
	XtVaGetValues(toplevelWidget, 
		      XtNwidth, &width,
		      XtNheight, &height,
		      NULL);
	
	XtTranslateCoords(toplevelWidget, (Position) width, 
			  (Position)height/2,
			  &x, &y);

	XtVaSetValues(Kuchen_shell, XtNx, x, XtNy, y, NULL);
	
	XtPopup(Kuchen_shell,XtGrabNone);

} /* kuchenCB */


/* 
 * rad2grad
 *
 * rechnet einen Winkel von Radiant in Gradiant um.
 *
 * IN:	radWinkel	Winkel in Radiant (0 - 360 Grad)
 * OUT:	Fkt.erg:	Winkel in Gradiant (0 - 2*Pi)
*/
double rad2grad(radWinkel)
double	radWinkel;
{
	return(2*radWinkel*M_PI/360.0);
} /* rad2grad */




/* 
 * Drucke Kuchen
 *
 * gibt die Kuchendiagramme in das PostScript-File aus
 *
*/
void druckeKuchen (fp)

  FILE *fp;

{
	short	i;
	float   Skalarprozent, Vektorprozent;

	I_TRACE(1, "druckeKuchen");

	Skalarprozent = (float) inp.anzSkalarBefehle / (float) inp.anzBefehle;
	Vektorprozent = 1.0 - Skalarprozent;

        PrintPieDefinition (fp);

        fprintf (fp, "(Timestamps of Scalar vs. Vector Statements)\n");
        fprintf (fp, "24 12\n");
	fprintf (fp, "[\n");
        fprintf (fp, "[(Scalar (%4.1f)) %4.3f]\n", Skalarprozent * 100.0, Skalarprozent);
        fprintf (fp, "[(Vector (%4.1f)) %4.3f]\n", Vektorprozent * 100.0, Vektorprozent);
        fprintf (fp, "] 300 400 140 DrawPieChart\n");
	fprintf (fp, "showpage\n");
       
        fprintf (fp, "(Vector Statements)\n");
        fprintf (fp, "24 12\n");
        fprintf (fp, "[\n");

	for (i = 0; i < 26; i++) {
	   if (inp.anzVektorBefehle > 0 && inp.V_Kommandos [i] > 0) {
	     fprintf (fp, "[(%c) %4.3f]\n", (char) ('A' + i),
		      ((float) inp.V_Kommandos [i]) / ((float) inp.anzVektorBefehle));
	   }
	}
       
        fprintf (fp, "] 300 400 140 DrawPieChart\n");
	fprintf (fp, "showpage\n");

        fprintf (fp, "(Scalar Statements)\n");
        fprintf (fp, "24 12\n");
        fprintf (fp, "[\n");

	for (i = 0; i < 26; i++) {
	   if (inp.anzSkalarBefehle > 0 && inp.S_Kommandos [i] > 0) {
	     fprintf (fp, "[(%c) %4.3f]\n", (char) ('a' + i),
		      ((float) inp.S_Kommandos [i]) / ((float) inp.anzSkalarBefehle));
	   }
	}
       
        fprintf (fp, "] 300 400 140 DrawPieChart\n");
} /* druckeKuchen */



int PrintPieDefinition (fp)

  FILE *fp;

{
  fprintf (fp, "/PieDict 24 dict def\n");
  fprintf (fp, "PieDict begin\n");
  fprintf (fp, "/DrawSlice\n");
  fprintf (fp, "{ /Grayshade exch def\n");
  fprintf (fp, "/Endangle exch def\n");
  fprintf (fp, "/Startangle exch def\n");
  fprintf (fp, "/TheLabel exch def\n");
  fprintf (fp, "newpath\n");
  fprintf (fp, "0 0 moveto\n");
  fprintf (fp, "0 0 Radius Startangle\n");
  fprintf (fp, "Endangle arc\n");
  fprintf (fp, "closepath\n");
  fprintf (fp, "1.415 setmiterlimit\n");
  fprintf (fp, "gsave\n");
  fprintf (fp, "Grayshade setgray\n");
  fprintf (fp, "fill\n");
  fprintf (fp, "grestore stroke\n");
  fprintf (fp, "gsave\n");
  fprintf (fp, "Startangle Endangle add\n");
  fprintf (fp, "2 div rotate\n");
  fprintf (fp, "Radius 0 translate\n");
  fprintf (fp, "newpath 0 0 moveto\n");
  fprintf (fp, "LabelPS .8 mul\n");
  fprintf (fp, "0 lineto stroke\n");
  fprintf (fp, "LabelPS 0 translate\n");
  fprintf (fp, "0 0 transform\n");
  fprintf (fp, "grestore\n");
  fprintf (fp, "itransform\n");
  fprintf (fp, "\n");
  fprintf (fp, "/y exch def /x exch def\n");
  fprintf (fp, "x y moveto\n");
  fprintf (fp, "x 0 lt\n");
  fprintf (fp, "{ TheLabel stringwidth\n");
  fprintf (fp, "pop neg 0 rmoveto\n");
  fprintf (fp, "} if\n");
  fprintf (fp, "y 0 lt\n");
  fprintf (fp, "{ 0 LabelPS neg rmoveto } if\n");
  fprintf (fp, "TheLabel show\n");
  fprintf (fp, "} def\n");
  fprintf (fp, "\n");
  fprintf (fp, "/FindGray\n");
  fprintf (fp, "{ /i exch def\n");
  fprintf (fp, "/n exch def\n");
  fprintf (fp, "i 2 mod 0 eq\n");
  fprintf (fp, "{ i 2 div n 2 div\n");
  fprintf (fp, "round add n div\n");
  fprintf (fp, "}\n");
  fprintf (fp, "{ 1 1 add 2 div n div }\n");
  fprintf (fp, "ifelse\n");
  fprintf (fp, "} def\n");
  fprintf (fp, "\n");
  fprintf (fp, "end\n");
  fprintf (fp, "\n");
  fprintf (fp, "/DrawPieChart\n");
  fprintf (fp, "{  PieDict begin\n");
  fprintf (fp, "/Radius exch def  \n");
  fprintf (fp, "/YCenter exch def\n");
  fprintf (fp, "/XCenter exch def\n");
  fprintf (fp, "/PieArray exch def\n");
  fprintf (fp, "/LabelPS exch def\n");
  fprintf (fp, "/TitlePS exch def\n");
  fprintf (fp, "/Title exch def\n");
  fprintf (fp, "gsave\n");
  fprintf (fp, "XCenter YCenter translate\n");
  fprintf (fp, "/Helvetica findfont\n");
  fprintf (fp, "TitlePS scalefont setfont\n");
  fprintf (fp, "Title stringwidth\n");
  fprintf (fp, "pop 2 div neg\n");
  fprintf (fp, "Radius neg\n");
  fprintf (fp, "TitlePS 3 mul sub moveto\n");
  fprintf (fp, "Title show\n");
  fprintf (fp, "/Helvetica findfont\n");
  fprintf (fp, "LabelPS scalefont setfont\n");
  fprintf (fp, "/NumSlices\n");
  fprintf (fp, "PieArray length def\n");
  fprintf (fp, "/SliceCount 0 def\n");
  fprintf (fp, "/CurAngle 0 def\n");
  fprintf (fp, "PieArray\n");
  fprintf (fp, "{ /SliceArray exch def\n");
  fprintf (fp, "SliceArray aload pop\n");
  fprintf (fp, "/Percent exch def\n");
  fprintf (fp, "/Label exch def\n");
  fprintf (fp, "/PerAngle\n");
  fprintf (fp, "Percent 360 mul def\n");
  fprintf (fp, "/SliceCount \n");
  fprintf (fp, "SliceCount 1 add def\n");
  fprintf (fp, "Label CurAngle CurAngle PerAngle add\n");
  fprintf (fp, "NumSlices SliceCount FindGray\n");
  fprintf (fp, "DrawSlice\n");
  fprintf (fp, "/CurAngle\n");
  fprintf (fp, "CurAngle PerAngle\n");
  fprintf (fp, "add def\n");
  fprintf (fp, "} forall\n");
  fprintf (fp, "grestore\n");
  fprintf (fp, "end\n");
  fprintf (fp, "} def\n");
}
E 1
