h56047
s 00238/00000/00000
d D 1.1 93/06/23 17:22:10 kehrmann 1 0
c date and time created 93/06/23 17:22:10 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL extern

#include	<XSachen.h>
#include	<globals.h>


/* Um die Mauspositionen zu merken */
static	flaeche		MausStart;
static	flaeche		MausEnde;
static	GC		xorGC;



/* init_xor_GC
 *
 * erzeugt einen Graphics-Context, mit desen Holfe man mit xor Bereiche des
 * Bildschirms un dAusgaben verknuepfen kann. Wird fuer das 'Rubberband' beim
 * Ausschnitt-waehlen mit der MAus gebraucht.
 *
*/
void init_xor_GC()
{
	XGCValues	values;

	values.function = GXxor;
	values.background = WhitePixel(display, DefaultScreen(display));
	values.foreground = BlackPixel(display, DefaultScreen(display));
	xorGC = XCreateGC(display, XtWindow(toplevelWidget), 
			  GCFunction | GCForeground | GCBackground,
			  &values);
}



/* MausKnopfGedrueckt
 *
 * wird aufgerufen, wenn der linke Maustaste in einem Grafik-Fenster gedrueckt
 * wird. Die dabei aktuellen Maus-Koordinaten werden gespeichert.
 *
 * IN:	w		ID des Widgets, in dem die Maustaste gedrueckt wurde.
 *	ereignis	Der Event, der beim Druecken erzeugt wurde.
 *
*/
void MausKnopfGedrueckt(w, ereignis)
Widget	w;
XButtonEvent	*ereignis;
{

	/* Knopf im Widget gedrueckt. */
	WahlFlag = TRUE;

	if ( ! ereignis)
		return;

	/* Koordinaten merken */
	MausStart.x = ereignis->x;
	MausStart.y = ereignis->y;
	MausEnde.x = ereignis->x;
	MausEnde.y = ereignis->y;
} /* MausKnopfGedrueckt */



/* ZeigeGummiBand
 *
 * wird bei jeder Bewegung der Maus mit gedrueckter linker Taste aufgerufen.
 * Loescht das alte Rechteck und zeichnet ein neues.
 *
 * IN:	w		ID des Widgets, in dem die Maus bewegt wird.
 *	ereignis	Das dabei erzeugte Event.
 *
*/
void ZeigeGummiBand(w, ereignis)
Widget	w;
XMotionEvent	*ereignis;
{
	void	DrawBox();

	/* Wenn der Knopf ausserhalb des Widgets gedrueckt wurde, Ende */
	if (WahlFlag != TRUE)
		return;

	/* alten Rahmen entfernen */
	DrawBox(XtWindow(w), MausStart.x, MausStart.y, 
		MausEnde.x, MausEnde.y, xorGC);

	/* neuen Rahmen malen */
	DrawBox(XtWindow(w), MausStart.x, MausStart.y, 
		ereignis->x, ereignis->y, xorGC);

	MausEnde.x = ereignis->x;
	MausEnde.y = ereignis->y;
} /* ZeigeGummiBand */



/* MausKnopfLosgelassen
 *
 * wird aufgerufen, wenn die Maustaste wieder losgelassen wird. Dann wird der
 * Bereich berechnet, der mit gedrueckter Maus gewaehlt wurde.
 *
 * IN:	w		ID des Widgets, in dem die Taste losgelassen wurde.
 *	ereignis	Das dabei erzeugte Event.
 *
*/
void MausKnopfLosgelassen(w, ereignis)
Widget	w;
XButtonEvent	*ereignis;
{
	short		index;
	void		BerechneBereich();
	void		ZeichneGrafikNeu();

	/* Wenn der Knopf ausserhalb des Widgets gedrueckt wurde, Ende */
	if (WahlFlag != TRUE)
		return;

	/* Index des Widgets feststellen */
	index = SucheDrawWidgetIndex(w);

	/* Mauskoordinaten erfragen */
	MausEnde.x = ereignis->x;
	MausEnde.y = ereignis->y;

	/* Befehlsbereich ausrechnen */
	BerechneBereich(index, MIN(MausStart.x, MausEnde.x), 
			MAX(MausStart.x, MausEnde.x));

	/* Grafik neu ausgeben */
	ZeichneGrafikNeu(index);

	/* Knopf wieder losgelassen */
	WahlFlag = FALSE;
} /* MausKnopfLosgelassen */




/* BerechneBereich
 *
 * berechnet den Bereich, der mit gedrueckter linker Maustaste ueberstrichen
 * wurde. Wenn das Grafik-Fenster mit gedrueckter Taste verlassen wurde, wird
 * der linke bzw. rechte Rand als maximaler Mauswert verwendet.
 *
 * IN:	index	Index des Grafik-Fensters
 *	xStart	x-Koordinate des Punktes, an dem die Maus gedrueckt wurde.
 *	xEnde	x-Koordinate des Punktes, an dem die Maus losgelassen wurde.
 *
*/
static void BerechneBereich(index, xStart, xEnde)
short	index;
int	xStart;
int	xEnde;
{
	int	i;

	/* Falls die Maus ausserhalb des Malbereichs gedrueckt oder losgelassen
	   wurde, muss man xStart und xEnde auf den Rand des Malbereichs setzen.
	   Dadurch wird dieser Fall behandelt, als haette man an der Grenze des
	   Malbereichs gedrueckt bzw. losgelassen.
	*/
	xStart = MAX(Bilder[index].Rand.Links, xStart);
	xStart = MIN(xStart, 
			Bilder[index].Rand.Links + Bilder[index].Malbereich.x);

	xEnde = MAX(Bilder[index].Rand.Links, xEnde);
	xEnde = MIN(xEnde, 
			Bilder[index].Rand.Links + Bilder[index].Malbereich.x);

	/* Damit nicht jedes Druecken der Maustaste einen Bereich waehlt */
	if (xEnde - xStart < MausToleranz)
		return;

	/* den ausgewaehlten Bereich noch so nach links schieben, dass der 
	   Anfang bei 0 liegt. */
	xStart -= Bilder[index].Rand.Links;
	xEnde -= Bilder[index].Rand.Links;

	/* eventuell neuen Speicher holen */
	(void)galloc(Bilder[index].anzSpeicher,
                       Bilder[index].anzAusschnitte + 1,
                       AUSSCHNITT_ALLOCSTEP,
                       (char **)(&(Bilder[index].ersterBefehl)),
                       sizeof(stat_typ));
        Bilder[index].anzSpeicher =
                galloc(Bilder[index].anzSpeicher,
                       Bilder[index].anzAusschnitte + 1,
                       AUSSCHNITT_ALLOCSTEP,
                       (char **)(&(Bilder[index].letzterBefehl)),
                       sizeof(stat_typ));

	/* jetzt gibt es einen Ausschnitt mehr */
	Bilder[index].anzAusschnitte++;

	/* ersten und letzten darzustellenden Befehl ausrechnen und 
	   Fensterdaten updaten */
	Bilder[index].letzterBefehl[Bilder[index].anzAusschnitte] 
		= Bilder[index].ersterBefehl[Bilder[index].anzAusschnitte-1]
		+ (stat_typ)(xEnde / Bilder[index].XskalFaktor);

	if (Bilder[index].letzterBefehl[Bilder[index].anzAusschnitte] 
	    > inp.anzBefehle) {
		Bilder[index].letzterBefehl[Bilder[index].anzAusschnitte] 
			= inp.anzBefehle;
	}


	/* erster Befehl ist 'erster Befehl des vorigen Ausschnittes' plus
	   'Pixel in Befehle umgerechnet' */
	Bilder[index].ersterBefehl[Bilder[index].anzAusschnitte] = 
		Bilder[index].ersterBefehl[Bilder[index].anzAusschnitte - 1] 
		+ (stat_typ)(xStart / Bilder[index].XskalFaktor);

} /* BerechneBereich */



void DrawBox(win, x1, y1, x2, y2, DrawBoxGC)
Window	win;
int	x1;
int	y1;
int	x2;
int	y2;
GC	DrawBoxGC;
{
	int	xStart;
	int	yStart;
	int	laenge;
	int	hoehe;

	xStart = MIN(x1, x2);
	yStart = MIN(y1, y2);
	laenge = abs(x1 - x2);
	hoehe = abs(y1 - y2);

	XDrawRectangle(display, win, DrawBoxGC, xStart, yStart, laenge, hoehe);
	
}
E 1
