h58513
s 00119/00000/00000
d D 1.1 93/06/23 17:22:14 kehrmann 1 0
c date and time created 93/06/23 17:22:14 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL	extern

#include	<XSachen.h>
#include	<globals.h>




/* ResizePicture
 *
 * wird jedesmal aufgerufen, wenn ein Grafikwidget vergroessert oder verkleinert
 * wird. Dann wird die alte Pixmap zerstoert, eine neue Pixmap in der neuen
 * Groesse besorgt, die Grafik in die neue Pixmap gezeichnet und die Pixmap
 * ins Window kopiert.
 * 
 * IN:	w	Widget-Id des geaenderten Widgets
 *
*/
void ResizePicture(w)
Widget	w;
{
	short	index;
	Dimension	breite;
	Dimension	hoehe;

	/* neue Fenstergroesse abfragen */
	XtVaGetValues(w, XtNwidth, &breite,
			 XtNheight, &hoehe,
			 NULL);
	

	/* Index des Widgets feststellen */
	index = SucheDrawWidgetIndex(w);

	/* neue Groesse speichern */
	Bilder[index].Fenstergroesse.x = breite;
	Bilder[index].Fenstergroesse.y = hoehe;
	

	/* Alte Pixmap wegwerfen */
	XFreePixmap(display, Bilder[index].DrawPixmap);

	/* Neue Pixmap in neuer Groesse erzeugen */
	Bilder[index].DrawPixmap = XCreatePixmap(display, 
				RootWindowOfScreen(XtScreen(toplevelWidget)),
                        	breite, hoehe, 1);

	/* SetWindowWerte */
        Bilder[index].Malbereich.x = breite - RAND_LINKS - RAND_RECHTS;
        Bilder[index].Malbereich.y = hoehe - RAND_OBEN - RAND_UNTEN;

	/* die neue Grafik auch wieder ausgeben */
	ZeichneGrafikNeu(index);
} /* ResizePicture */



/* ResizeKuchen
 *
 * wird jedesmal aufgerufen, wenn das KuchenWidget vergroessert oder verkleinert
 * wird. Dann wird die alte Pixmap zerstoert, eine neue Pixmap in der neuen
 * Groesse besorgt, die Kuchen in die neue Pixmap gezeichnet und die Pixmap
 * ins Window kopiert.
 * 
 * IN:	w	Widget-Id des geaenderten Widgets
 *
*/
void ResizeKuchen(w)
Widget	w;
{
	short	index;
	Dimension	breite;
	Dimension	hoehe;
	void		ZeichneKuchen();

	I_TRACE(1, "ResizeKuchen");

	/* neue Fenstergroesse abfragen */
	XtVaGetValues(w, XtNwidth, &breite,
			 XtNheight, &hoehe,
			 NULL);
	
	/* neue Groesse speichern */
	KuchenFenstergroesse.x = breite;
	KuchenFenstergroesse.y = hoehe;
	
        if (KuchenFenstergroesse.x/2 < KUCHEN_R_L+KUCHEN_R_R+50)
                KuchenFenstergroesse.x 
                        = 2*(KUCHEN_R_R + KUCHEN_R_L + 50);
        if (KuchenFenstergroesse.y/2 < KUCHEN_R_O+KUCHEN_R_U+50)
                KuchenFenstergroesse.y
                        = 2*(KUCHEN_R_O + KUCHEN_R_U + 50);


	/* Alte Pixmap wegwerfen */
	XFreePixmap(display, KuchenPixmap);

	/* Neue Pixmap in neuer Groesse erzeugen */
	KuchenPixmap = XCreatePixmap(display, 
				RootWindowOfScreen(XtScreen(toplevelWidget)),
                        	KuchenFenstergroesse.x, 
				KuchenFenstergroesse.y, 1);

	/* die neue Grafik auch wieder ausgeben */
	ZeichneKuchen();
	if (DefaultDepthOfScreen(XtScreen(toplevelWidget)) == 1) {
		XCopyArea(display, KuchenPixmap, 
			  XtWindow(kuchenDrawWidget), 
			  copy_GC, 0, 0, 
			  KuchenFenstergroesse.x, 
			  KuchenFenstergroesse.y, 0, 0);
	} else {
		XCopyPlane(display, KuchenPixmap,
			   XtWindow(kuchenDrawWidget), 
			   copy_GC, 0, 0, 
			   KuchenFenstergroesse.x, 
			   KuchenFenstergroesse.y, 0, 0, 1);
	}
} /* ResizeKuchen */
E 1
