h63375
s 00218/00000/00000
d D 1.1 93/06/23 17:22:03 kehrmann 1 0
c date and time created 93/06/23 17:22:03 by kehrmann
e
u
U
f e 0
t
T
I 1
/* * Last edited: Aug 28 12:01 1992 (engelhar) */
#include <stdio.h>
#include <math.h>
  
FILE *in ;
FILE *out ;

char  inputname[100] , outputname[100] , 
      input[100] , 
      ch ,
      string1[10], string2[10] , string3[10] ;

unsigned long long gesamt_schritte, gesamt_summe, total_schritte = 0, total_summe = 0;

int   stat[256] , schritte , anfang , programm_schritte ,
      max_proz , summe , teil , nur_statistik , nur_prozessoren ,
      vorschritt = 0 , schritt , proz , i, faktor , zaehler , prop_faktor , reduce_faktor ,
      total_pr_schritte = 0 , MAX_proz = 0 ;

statistik()
{
  fprintf( out , " Statistik:\n" ) ;
  for( i=1 ; i<256 ; ++i )
   if( stat[i] > 0 ) 
    fprintf( out , "  Befehl %c ist %3d mal vorhanden\n", i , stat[i] ) ;

  fprintf( out , "\n" ) ;
  if( !nur_statistik )
    fprintf( out , "  Komprimierungsfaktor                       : %d\n" , faktor ) ;

  fprintf( out , "  Anzahl Taktzyklen                          : %.0f\n" , rint((float) gesamt_schritte-1) ) ;
  fprintf( out , "  Anzahl Programmschritte                    : %d\n" , programm_schritte-1 ) ;
  fprintf( out , "  Maximale Anzahl aktiver Prozessoren        : %d\n" , max_proz ) ;
  fprintf( out , "  Durchschnittliche Zahl aktiver Prozessoren : %.0f\n" , rint((float)gesamt_summe/(float)(gesamt_schritte-1)) ) ;
  fprintf( out , "  Auslastung bei %5d Prozessoren           : %.1f%%\n", max_proz , ( (float)gesamt_summe/((float)(gesamt_schritte-1)))/(float)max_proz * 100.0 ) ;

  total_schritte += gesamt_schritte-1 ;
  total_pr_schritte += programm_schritte-1 ;
  total_summe += gesamt_summe ;
  if( max_proz > MAX_proz ) MAX_proz = max_proz ;

  for( i=0 ; i<256 ; ++i )
   stat[i] = 0 ;
}

total()
{
  fprintf( out , "\n Total:\n" ) ;

  fprintf( out , "  Anzahl Taktzyklen                          : %.0f\n" , rint((float)total_schritte-1 )) ;
  fprintf( out , "  Anzahl Programmschritte                    : %d\n" , total_pr_schritte-1 ) ;
  fprintf( out , "  Maximale Anzahl aktiver Prozessoren        : %d\n" , MAX_proz ) ;
  fprintf( out , "  Durchschnittliche Zahl aktiver Prozessoren : %.0f\n" , rint((float)total_summe/(float)(total_schritte-1)) ) ;
  fprintf( out , "  Auslastung bei %5d Prozessoren           : %.1f%%\n", MAX_proz , ( (float)total_summe/((float)(total_schritte-1)))/(float)MAX_proz * 100.0 ) ;

  for( i=0 ; i<256 ; ++i )
   stat[i] = 0 ;
}

main()
{     
  puts("Name der Eingabedatei : " ) ;
  gets( inputname ) ;

  puts("Name der Ausgabedatei ( RETURN = stdout ) : " ) ;
  gets( outputname ) ;

  puts("Komprimierungsfaktor\n( RETURN oder 1 = Statistik / keine Komprimierung\n  0             = nur Statistik\n  negative Zahl = Komprimierung ohne Statistik ) : " ) ;
  gets( input ) ;

  if( strlen( input ) )
    sscanf( input , "%d" , &faktor ) ;
   else
    faktor = 1 ;
              
  puts("Propagate-Faktor ( nur ganze Zahlen ; RETURN = 10 ) : " ) ;
  gets( input ) ;

  if( strlen( input ) )
    sscanf( input , "%d" , &prop_faktor ) ;
   else
    prop_faktor = 10 ;
              
  puts("Reduce-Faktor ( nur ganze Zahlen ; RETURN = 10 ) : " ) ;
  gets( input ) ;

  if( strlen( input ) )
    sscanf( input , "%d" , &reduce_faktor ) ;
   else
    reduce_faktor = 10 ;
              
  nur_statistik = 0 ;
  nur_prozessoren = 0 ;
  if( faktor == 0 )
   { nur_statistik = 1 ; faktor = 1 ; }

  if( faktor < 0 )
   { nur_prozessoren = 1 ; faktor = -faktor ; }

  in = fopen( inputname , "r" ) ;

  if( strlen(outputname ) )
    out = fopen( outputname , "w" ) ;
   else
    out = stdout ;

  if( !in || !strlen(inputname ) )
   { puts( "Kann Eingabedatei nicht oeffnen!\n") ;
     exit(1) ; }

  if( !out )
   { puts( "Kann Ausgabedatei nicht oeffnen!\n") ;
     exit(1) ; }

  for( i=0 ; i<256 ; ++i )
   stat[i] = 0 ;
  anfang = 1 ;
  schritte = 0 ;
  programm_schritte = 0 ;
  gesamt_schritte = 0 ; gesamt_summe = 0 ;
  max_proz = 0 ;             
  teil = 0 ;

  while(fgets( input , 100 , in ) )
   {
    if( input[0] == ' ' )
     { 
       if( anfang && !nur_prozessoren )
        fprintf( out , "\n -->Programmteil%d\n" , ++teil ) ;

       proz = 1 ;
       sscanf( input , "%d %s %s %d %s\n" , &schritt , string1 , string2 , &proz , string3 ) ;
       if( (string2[0] != 'L') && (proz > max_proz) )
         max_proz = proz ;
       ++gesamt_schritte ;
       ++programm_schritte ;

       if( (vorschritt+1 != schritt) && !anfang )
         {
          if( summe ) 
           {
            summe = summe / schritte ;
            if( !nur_statistik )
             fprintf( out , "%d\n" , summe ) ;
           }
          if( !nur_prozessoren )
            { statistik() ;
              fprintf( out , "\n -->Programmteil%d\n" , ++teil ) ;
            }
           else
            fprintf( out , "\n" ) ;
          schritte = 0 ; 
          gesamt_schritte = 1 ;
          programm_schritte = 1 ;
          max_proz = proz ;
          summe    = 0 ;
          gesamt_summe = 0 ;
         }

       ch = string2[0] ;
       ++stat[(int)ch] ;

       zaehler = 1 ;
       if( ch == 'P' )
         zaehler = prop_faktor ;

       if( ch == 'U' )
         zaehler = reduce_faktor*(int)( log((double)proz)/log((double)2.0) + (double)1.0 ) ;

       if( ch == 'L' )
         { zaehler = proz ; proz = 2 ; }

       --gesamt_schritte ;
       for( i=0 ; i<zaehler ; ++i )
        {
         ++gesamt_schritte ;
         ++schritte ;
         gesamt_summe = gesamt_summe + proz ;
         summe = summe + proz ;

         if( schritte == faktor )
          {
           summe = summe / faktor ;
           if( !nur_statistik )
             fprintf( out , "%d\n" , summe ) ;
           schritte = 0 ; 
           summe = 0 ;
          } 
        }
       vorschritt = schritt ;
       anfang = 0 ;
     }
   }

  if( summe )
   {
    summe = summe / schritte ;
    if( !nur_statistik )
      fprintf( out , "%d\n" , summe ) ;
   }

  ++gesamt_schritte ;
  ++programm_schritte ;
  if( !nur_prozessoren )
   {
    statistik() ;

    if( teil == 1 )
      fprintf( out , "\n  Insgesamt 1 Programmteil gefunden.\n" ) ;
     else
      { 
       fprintf( out , "\n  Insgesamt %d Programmteile gefunden.\n",teil ) ;
       total() ;
      }
   }

  fclose(in) ; fclose(out) ;
}
E 1
