h28031
s 00158/00000/00000
d D 1.1 93/06/23 17:22:05 kehrmann 1 0
c date and time created 93/06/23 17:22:05 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL	extern

#include	<XSachen.h>
#include	<globals.h>

#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>

/* Groesse des Hilfefensters */
#define	HILFE_BREITE	560
#define	HILFE_HOEHE	410

/* Der Hilfetext muss in 2 Strings aufgeteilt werden, da der ULTRIX-Compiler
   nur eine bestimmte Stringlaenge bei Konstanten verkraftet. */

#define	HILFE_TEXT1	"Main menu:\n\
\n\
1. Graphics..\n\
   Pressing this button brings up a dialog. In this dialog you can enter\n\
   the first and the last statement to be displayed. If no data is entered,\n\
   the first (the last) statement of the input-file is taken.\n\
   After pressing 'OK' in the dialog a window with the graphic representation\n\
   of the input-file is displayed.\n\
\n\
2. Diagrams\n\
   Pressing this button displays a window containing some pie charts.\n\
\n\
3. PrintGraphics...\n\
   When this button is pressed, a PostScript-file is created that contains\n\
   the graphic in PostScript-code. The graphic will be taken from the first\n\
   graphics window and the actual area in this window will be printed. The \n\
   name of the file is automatically generated by replacing the ending 'rec' \n\
   with 'ps'.\n\
\n\
4. Statistics\n\
   Pressing this button creates a window, that contains some numeric values\n\
   which are interesting for analyzing the quality of the algorithm.\n\
\n\
5. Read file...\n\
   This button brings up the fileselection-dialog in which you can enter the\n\
   name of another input-file that should be analyzed.\n\n"

#define HILFE_TEXT2	"6. Help\n\
   Brings up this window.\n\
\n\
7. Quit\n\
   Press this button to exit from 'pmon'. A dialog is displayed to confirm\n\
   the exit.\n\
\n\
The graphics window:\n\n\
   This window has two areas, a display area and a control area.  In the \n\
   display area you see a graph, which represents the load of the program, \n\
   which you are analyzing.\n\
   To get a closer look, you can select areas of the graph with the mouse.\n\
   To select an area press the left mouse button at the start of the area \n\
   you want to see in detail and then drag the mouse (with the button \n\
   pressed) to the end of the area. When you release the button, the \n\
   selected area is displayed.\n\
   The control area consists of six buttons:\n\
      - Min, Avg, Max\n\
	If it are more statements than pixel, some pixel contain more than\n\
	one statement. In this case you can control which statement you\n\
	want to see. You can chose the statement with the highest load\n\
	with the smallest load or the average load of the statements\n\
	that are in one pixel.\n\
      - Previous region\n\
	Pressing this button displays the previous region you have selected\n\
	with the mouse. If there are no previous regions, a message pops\n\
	up.\n\
      - All statements\n\
	If you have selected regions, you can display the whole graph by\n\
	pressing this button. All regions that you selected so far are\n\
	lost.\n\
      - Close Window\n\
	Pressing this button closes the graphics window.\n"



/* ErzeugeHilfeWidget
 *
 * erzeugt die Widgets, die das Hilfefenster bilden.
 *
*/
void ErzeugeHilfeWidget()
{
	Widget	hilfeFormular;
	Widget	hilfeText;
	Widget	hilfeAbbruch;
	char	*hilfe_text;


	I_TRACE(1, "ErzeugeHilfeWidget");

	hilfe_text = HILFE_TEXT1;
	strcat(hilfe_text, HILFE_TEXT2);

	Hilfe_shell = XtCreatePopupShell("Help", topLevelShellWidgetClass,
			toplevelWidget, NULL, 0);

	hilfeFormular = XtCreateManagedWidget("hilfeFormular", formWidgetClass,
			Hilfe_shell, NULL, 0);

	hilfeText = XtVaCreateManagedWidget("hilfeText", asciiTextWidgetClass,
			hilfeFormular,
			XtNwidth, HILFE_BREITE,
			XtNheight, HILFE_HOEHE,
			XtNtop, XtChainTop,
			XtNtype, XawAsciiString,
			XtNstring, hilfe_text,
			XtNeditType, XawtextRead,
			XtNdisplayCaret, False,
			XtNscrollVertical, XawtextScrollAlways,
			NULL);

	hilfeAbbruch = XtVaCreateManagedWidget("hilfeAbbruch", 
			commandWidgetClass,
			hilfeFormular,
			XtNfromVert, hilfeText,
			XtNlabel, OK_TXT,
			NULL);

	XtAddCallback(hilfeAbbruch, XtNcallback, PopUpDialogAbbruchCB, NULL);
} /* ErzeugeHilfeWidget */
			


/* hilfeCB
 *
 * wird aufgerufen, wenn der Hilfe-Knopf im Hauptmenue gedrueckt wird.
 * Dann wird das HilfeWidget auf dem Bildschirm dargestellt.
 *
*/
void hilfeCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	Position	x, y;
	Dimension	width, height;

	I_TRACE(1, "hilfeCB");

	/* HilfeFenster darstellen */
	XtVaGetValues(toplevelWidget,
			XtNwidth, &width,
			XtNheight, &height,
			NULL);

	XtTranslateCoords(toplevelWidget, (Position) width,
			(Position) height/2,
			&x, &y);

	XtVaSetValues(Hilfe_shell, XtNx, x, XtNy, y, NULL);

	XtPopup(Hilfe_shell, XtGrabNone);
} /* hilfeCB */
E 1
