h34918
s 00654/00000/00000
d D 1.1 93/06/23 17:22:11 kehrmann 1 0
c date and time created 93/06/23 17:22:11 by kehrmann
e
u
U
f e 0
t
T
I 1
#define GLOBAL


/* Name und Version von pmon */
#define	NAME_UND_VERSION	"pmon V2.1"


#include	<XSachen.h>
#include	<globals.h>

#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Toggle.h>

#include <string.h>


static String	trans = 
	"<ConfigureNotify>:	ResizePicture()  	\n\
	 <Expose>:		RedrawPicture()		\n\
	 <Btn1Down>:		MausKnopfGedrueckt()		\n\
	 <Btn1Motion>:		ZeigeGummiBand()	\n\
	 <Btn1Up>:		MausKnopfLosgelassen()";

/* Translations, damit die Min-,Avg- und Max-Knoepfe sich wie Toggle-Buttons 
   verhalten */
static String	ToggleTrans[] =
	"<EnterWindow>:		highlight(Always) 	\n\
	 <LeaveWindow>:		unhighlight()     	\n\
	 <Btn1Down>,<Btn1Up>:	set() notify()";


/* Das Hauptprogramm */
void main(argc, argv)
Cardinal	argc;
String		argv[];
{
	short	i;

	void	usage();
	void	reset_input_daten();
	void	neuesBild();
	void	LiesDateiOK_CB();
	void	AusschnittOKCB();
	void	AusDiaNextFeld();
	void	init_copy_GC();
	void	init_xor_GC();
	void	init_widgets();
	void	TryPSAgain();
	char	*strcpy();

	static String fallback_resources [] = {
		"*ausschnittKnopf.label:	Graphics...",
		"*diagrammKnopf.label:		Diagramms...",
		"*druckenKnopf.label:		Print...",
		"*statistikKnopf.label:		Statistics",
		"*dateiKnopf.label:		Read file...",
		"*hilfeKnopf.label:		Help",
		"*quitKnopf.label:		Quit",
		NULL,
	};

	static XtActionsRec	window_actions[] = {
		{"RedrawPicture",		RedrawPicture},
		{"ResizePicture",		ResizePicture},
		{"ResizeKuchen",		ResizeKuchen},
		{"MausKnopfGedrueckt",		MausKnopfGedrueckt},
		{"ZeigeGummiBand",		ZeigeGummiBand},
		{"MausKnopfLosgelassen",	MausKnopfLosgelassen},
		{"LiesDateiOK_CB",		LiesDateiOK_CB},
		{"AusschnittOKCB",		AusschnittOKCB},
		{"TryPSAgain",			TryPSAgain},
	};

	static XrmOptionDescRec	table[] = {
		{"-debug",	"*debug",	XrmoptionNoArg, "True"}
	};


	for (i=0; i<MAX_WIDGETS; i++) {
		Bilder[i].PixelWerte.anzSpeicher = 0;
		Bilder[i].PixelWerte.anz = 0;
	}
	MausToleranz = 10;
	default_Hoehe = 400;
	default_Breite = 400;
	anzDrawWidgets = 0;
	WahlFlag = FALSE;
	inp.anzSpeicher = 0;
	reset_input_daten();
	PropagateLength = 8;

	/* Das uebliche Toplevel-Widget */
	toplevelWidget = XtVaAppInitialize(
			&context,		/* Application Context */
			"pmon",		/* Name */
			table, XtNumber(table),	/* command line options */
			&argc, argv,		/* command line args */
			fallback_resources,	/* falls kein app-default File
						   existiert */
			XtNtitle, NAME_UND_VERSION,
			NULL);			/* Ende Varargs */

	/* falsche Kommandozeilenparameter-Anzahl */
	if (argc > 4) {
		usage(argv[0]);
		exit(2);
	}

	display = XtDisplay(toplevelWidget);
	if (display == NULL) {
		fprintf(stderr, "Can't open display.\n");
		exit(1);
	}

	/* Widgets erzeugen */
	init_widgets();


	XtAppAddActions(context, window_actions, XtNumber(window_actions));
	XtRealizeWidget(toplevelWidget);
	init_copy_GC();
	init_xor_GC();

	if ((argc == 3) || (argc == 4)) {
		if (strcmp(argv[1], "-T")) {
			usage(argv[0]);
			exit(3);
		}
		PropagateLength = atoi(argv[2]);
		if (PropagateLength <1)
			PropagateLength = 1;
	}
	if ((argc == 2) || (argc == 4)) {
		(void)strcpy(Dateiname, argv[argc-1]);
		lies_dateiCB((Widget)0, (XtPointer)NULL, (XtPointer)NULL);
	}


	/* Wenn Datei erfolgreich eingelesen Wurde, gleich ein Fenster 
	   darstellen */
	if (inp.anzBefehle != 0)
		neuesBild();

	XtAppMainLoop(context);

	exit(0);

} /* main */


/* usage
 *
 * gibt bei falschem Programmaufruf die richtige Aufruf-Syntax aus.
 * IN:	prg_name	Der Name des Programms
 *
*/
static void usage(prg_name)
char	*prg_name;
{
	fprintf(stderr, "Usage: %s [ -T n ] [ dateiname ]\n", prg_name);
} /* usage */



/* reset_input_daten
 *
 * initialisiert die Elemente der Struktur, in der die Daten gespeichert werden.
 * 
*/
void reset_input_daten()
{
	short	i;

	inp.anzElemente = 0;
	inp.anzBefehle = 0;
	inp.maxProzessoren = 0;
	inp.anzVektorBefehle = 0;
	inp.anzSkalarBefehle = 0;
	for (i=0; i<26; i++) {
		inp.V_Kommandos[i] = 0;
		inp.S_Kommandos[i] = 0;
	}
	inp.avgAktProzessoren = 0.0;
	inp.anzMaxAktBefehle = 0;
	inp.anzMinAktBefehle = 0;
	
} /* reset_input_daten */



/* init_copy_GC
 *
 * Erzeugt den Graphics-Context fuer's Kopieren der Pixmap ins Window.
 *
*/
void	init_copy_GC()
{
	XGCValues	values;

	values.foreground = BlackPixel(display, DefaultScreen(display));;
	values.background = WhitePixel(display, DefaultScreen(display));;
	copy_GC = XCreateGC(display, XtWindow(toplevelWidget), GCForeground |
			    GCBackground, &values);
} /* init_copy_GC */




/* minmaxCB
 *
 * wird aufgerufen, sobald einer der drei Knoepfe min, max oder avg gedrueckt
 * wird. Gibt dann entsprechend dem gedrueckten Knopf die Minima, Maxima oder
 * Durchschnitte in dem entsprechenden Fenster aus.
 *
 * IN:	w		Widget-ID des gedrueckten Knopfes
 *	client_data	Gibt an, ob MIN, MAX oder AVG
 *	call_data	nicht verwendet
 *
*/
void minmaxCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	short	index;
	short	SucheWidgetIndex();
	short	SucheShellWidgetIndex();
	void	ClearPixmap();
	void	MaleAchsen();

	if ((int)call_data == 0)
		return;

	index = SucheShellWidgetIndex(XtParent(XtParent(XtParent(w))));

	/* alte Grafik loeschen */
	ClearPixmap(index);

	switch ((int)client_data) {
		case MINIMA: 	GibPixelaus(index, MINIMA);
				break;
		case AVERAGE:	GibPixelaus(index, AVERAGE);
				break;
		case MAXIMA:	GibPixelaus(index, MAXIMA);
				break;
		default:
				break;
	}
	MaleAchsen(index);
	ZeigePixmap(index);

} /* minmaxCB */



void onebackCB(w, client_data, call_data)
Widget          w;
XtPointer       client_data;
XtPointer       call_data;
{
	short	index;
	void	ZeichneGrafikNeu();
	void	meldung();
	short	SucheShellWidgetIndex();


	if ((index = SucheShellWidgetIndex(XtParent(XtParent(w)))) == -1) {
		exit(1);
	}

	/* Falls es nur einen Ausschnitt bei diesem Fenster gibt */
	if (Bilder[index].anzAusschnitte == 0) {
		meldung(NO_MORE_REGIONS);
		return;
	}

	/* jetzt gibt es einen Ausschnitt weniger */
	Bilder[index].anzAusschnitte--;


	ZeichneGrafikNeu(index);
}



/* startGroesseCB
 *
 * wird aufgerufen, wenn der Knopf "Alle Befehle" in einem Ausschnittfenster
 * gedrueckt wird. Setzt ersten und letzten Befehl in der Struktur auf die
 * Anfangswerte un dgibt dann die Grafik in diesem Fenster neu aus.
 *
 * IN:	w		Widget-ID des gedrueckten Knopfes
 *	client_data	nicht verwendet
 *	call_data	nicht verwendet
 *
*/
void startGroesseCB(w, client_data, call_data)
Widget          w;
XtPointer       client_data;
XtPointer       call_data;
{
	short	index;
	void	ZeichneGrafikNeu();
	short	SucheShellWidgetIndex();

	if ((index = SucheShellWidgetIndex(XtParent(XtParent(w)))) == -1) {
		exit(1);
	}
	Bilder[index].ersterBefehl[0] = 1;
	Bilder[index].letzterBefehl[0] = inp.anzBefehle;

	/* Alle anderen Ausschnitte sind jetzt nicht mehr zugaenglich */
	Bilder[index].anzAusschnitte = 0;

	ZeichneGrafikNeu(index);
} /* startGroesseCB */



/* ausschnittEndeCB
 *
 * wird aufgerufen, wenn der "Ende"-Knopf in einem Grafikfenster gedrueckt
 * wird. Entfernt das entsprechende Widget mit allen Kindern und verschiebt
 * alle in der Grafikfenster-Liste nach ihm kommenden Widgets um eine Position
 * nach vorne.
 * IN:	w		Widget-ID des gedrueckten Knopfes
 *	client_data	nicht verwendet
 *	call_data	nicht verwendet
 *
*/
void ausschnittEndeCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	short	index;
	void 	VerschiebeWidgets();
	short	SucheShellWidgetIndex();

	I_TRACE(1, "ausschnittEndeCB");
	
	if ((index = SucheShellWidgetIndex(XtParent(XtParent(w)))) == -1) {
		exit(-1);
	}

	XtDestroyWidget(Bilder[index].DrawWidget_shell);
	VerschiebeWidgets(index);
} /* ausschnittEndeCB */



/* VerschiebeWidgets
 *
 * verschiebt alle nach ihm kommenden Widgets in der Grafikfenster-Liste um
 * eine Position nach vorne.
 *
 * IN:	index	Index des Widgets, ab dem geschoben werden soll.
 *
*/
static void VerschiebeWidgets(index)
short	index;
{
	short	i;

	if (anzDrawWidgets > 0) {
		for (i=index; i<anzDrawWidgets-1; i++) {
			Bilder[i] = Bilder[i+1];
		}
		anzDrawWidgets--;
	}
} /* VerschiebeWidgets */



/* ausschnittCB
 * wird aufgerufen, wenn der "Ausschnitte.."-Knopf im Hauptmenue gedrueckt wird.
 * Stellt den Ausschnittdialog dar.
 *
 * IN:	w		Widget-ID des Knopfes
 *	client_data	nicht verwendet
 *	call_data	nicht verwendet
 *
*/
void ausschnittCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	call_data;
{
	Position	x, y;
	Dimension	width, height;
	void		meldung();


	/* Zuviele Fenster ? */
	if (anzDrawWidgets == MAX_WIDGETS) {
		meldung(NO_MORE_WINDOWS);
		return;
	}

	/* Datei eingelesen ? */
	if (inp.anzBefehle == 0) {
		meldung(ERR_NO_FILE);
		return;
	}

	XtVaGetValues(toplevelWidget, 
		      XtNwidth, &width,
		      XtNheight, &height,
		      NULL);
	
	XtTranslateCoords(toplevelWidget, (Position) width/2, 
			  (Position)height/2,
			  &x, &y);

	XtVaSetValues(AusschnittDialog_shell, XtNx, x, XtNy, y, NULL);
	
	XtPopup(AusschnittDialog_shell,XtGrabNonexclusive);

} /* ausschnittCB */



/* Eine Abkuerzung */
#define	AKT_BILD	Bilder[anzDrawWidgets]

/*******************
Funktion, die ein neues Grafikwidget erstellt 
*******************/
/* neuesBild
 *
 * wird aufgerufen, wenn im Ausschnitt-Dialog der "OK"-Knopf gedrueckt wird.
 * Erzeugt ein neues Grafik-Widget, traegt es in der Liste ein und stellt es
 * auf dem Bildschirm dar.
 *
*/
void neuesBild()
{
	Position	x, y;
	Dimension	width, height;
	XGCValues	values;
	Widget		formWidget;
	Widget		min_Knopf;
	Widget		avg_Knopf;
	Widget		max_Knopf;
	Widget		radio_box;
	Widget		startGroesseKnopf;
	Widget		onebackKnopf;
	stat_typ	anfang;
	stat_typ	ende;

	void		ZeichneGrafikNeu();


	I_TRACE(1, "neuesBild");

	/* Falls noch keine Datei eingelesen wurde, Fkt. beenden. */
	if (inp.anzBefehle == 0)
		return;

	/* Shell-Widget mit Namen der eingelesenen Datei erzeugen */
	AKT_BILD.DrawWidget_shell
		= XtVaCreatePopupShell( Dateiname, 
					topLevelShellWidgetClass, 
					toplevelWidget,
					XtNresizable, True,
					NULL);


	/* Form-Widget, das die Geometrie regelt */
	formWidget = XtCreateManagedWidget("form", formWidgetClass,
				AKT_BILD.DrawWidget_shell, 
				(Arg *)NULL, 0);

	/* Die eigentliche Zeichenflaeche */
	AKT_BILD.DrawWidget = XtVaCreateManagedWidget("drawing", 
				widgetClass, formWidget, 
				XtNwidth, default_Breite,
				XtNheight, default_Hoehe,
				XtNtop, XtChainTop,
				XtNtranslations, XtParseTranslationTable(trans),
				NULL); 

	/* drei Knoepfe als Radio-Buttons, fuer Min, Avg, Max */
	radio_box = XtVaCreateManagedWidget("RadioBox", boxWidgetClass,
				formWidget,
				XtNfromVert, AKT_BILD.DrawWidget,
				NULL);

	/* Knopf, wenn Minima angezeigt werden sollen */
	min_Knopf = XtVaCreateManagedWidget("min-Knopf", toggleWidgetClass,
				radio_box,
				XtNresizable, True,
				XtNlabel, "Min",
				NULL);
	XtAddCallback(min_Knopf, XtNcallback, minmaxCB, MINIMA);

	/* Knopf, wenn Durchschnitte angezeigt werden sollen */
	avg_Knopf = XtVaCreateManagedWidget("avg-Knopf", toggleWidgetClass,
				radio_box,
				XtNresizable, True,
				XtNlabel, "Avg",
				XtNradioGroup, min_Knopf,
				XtNstate, TRUE,
				NULL);
	XtAddCallback(avg_Knopf, XtNcallback, minmaxCB, AVERAGE);

	/* Knopf, wenn Maxima angezeigt werden sollen */
	max_Knopf = XtVaCreateManagedWidget("max-Knopf", toggleWidgetClass,
				radio_box,
				XtNresizable, True,
				XtNlabel, "Max",
				XtNradioGroup, min_Knopf,
				NULL);
	XtAddCallback(max_Knopf, XtNcallback, minmaxCB, MAXIMA);



	/* Knopf um den Ausschnittdialog zu schliessen*/
	AKT_BILD.DrawWidget_Knopf = 
			XtVaCreateManagedWidget("ausschnittEnde", 
				commandWidgetClass, formWidget,
				XtNresizable, True,
				XtNlabel, SCHLIESSEN_TXT,
				XtNfromVert, AKT_BILD.DrawWidget,
				XtNfromHoriz, radio_box,
				NULL);
	XtAddCallback(AKT_BILD.DrawWidget_Knopf, XtNcallback, 
		      ausschnittEndeCB, NULL);


	/* Knopf um den Ausschnitt auf max. Groesse zu bringen */
	startGroesseKnopf = XtVaCreateManagedWidget("startGroesse", 
				commandWidgetClass, formWidget,
				XtNresizable, True,
				XtNlabel, ALL_BEF_TXT,
				XtNfromVert, AKT_BILD.DrawWidget_Knopf,
				XtNfromHoriz, radio_box,
				NULL);
	XtAddCallback(startGroesseKnopf, XtNcallback, startGroesseCB, NULL);

	/* Knopf um den letzten Ausschnitt wieder zu sehen */
	onebackKnopf = XtVaCreateManagedWidget("oneback", 
				commandWidgetClass, formWidget,
				XtNresizable, True,
				XtNlabel, ONE_BACK_TXT,
				XtNfromVert, startGroesseKnopf,
				XtNfromHoriz, radio_box,
				NULL);
	XtAddCallback(onebackKnopf, XtNcallback, onebackCB, NULL);

	/* Pixmap erzeugen */
	AKT_BILD.DrawPixmap = XCreatePixmap(display, 
			DefaultRootWindow(display), 
			default_Breite, default_Hoehe, 1);

	XtVaGetValues(toplevelWidget, 
		      XtNwidth, &width,
		      XtNheight, &height,
		      NULL);
	
	XtTranslateCoords(toplevelWidget, (Position) width/2, 
			  (Position)height/2,
			  &x, &y);

	XtVaSetValues(AKT_BILD.DrawWidget_shell, 
			XtNx, x, 
			XtNy, y, 
			NULL);
	
	XtSetSensitive(ausschnittKnopf, TRUE);
	XtPopup(AKT_BILD.DrawWidget_shell, XtGrabNone);
	
	values.background = BlackPixel(display, DefaultScreen(display));;
	values.foreground = WhitePixel(display, DefaultScreen(display));;
	AKT_BILD.ClearGC = XCreateGC(display, 
			AKT_BILD.DrawPixmap, 
			GCForeground | GCBackground, &values);

	values.background = WhitePixel(display, DefaultScreen(display));;
	values.foreground = BlackPixel(display, DefaultScreen(display));;
	AKT_BILD.DrawGC = XCreateGC(display, 
			AKT_BILD.DrawPixmap, 
			GCForeground | GCBackground, &values);

/* MIT DEM GC AUFPASSEN:
	Wenn man in eine Pixmap malt, muss das GC scheinbar auch zu dieser
	Pixmap erzeugt worden sein.
*/


	/* Falls der Anwender schon einen Bereich vorgegeben hat, muss man die
	   Werte lesen. */
	GetAusschnittGrenzen(&anfang, &ende);
	

	/* SetWindowWerte */
	AKT_BILD.Fenstergroesse.x = default_Breite;
	AKT_BILD.Fenstergroesse.y = default_Hoehe;
	AKT_BILD.Rand.Links = RAND_LINKS;
	AKT_BILD.Rand.Rechts = RAND_RECHTS;
	AKT_BILD.Rand.Unten = RAND_UNTEN;
	AKT_BILD.Rand.Oben = RAND_OBEN;
	AKT_BILD.Malbereich.x = 
			default_Breite - RAND_LINKS - RAND_RECHTS;
	AKT_BILD.Malbereich.y = 
			default_Hoehe - RAND_OBEN - RAND_UNTEN;


	/* es gibt noch keine Ausschnitte */
	AKT_BILD.anzAusschnitte = 0;

	/* Speicher fuer die Ausschnittliste holen */
	(void)galloc(AKT_BILD.anzSpeicher,
		       AUSSCHNITT_ALLOCSTEP,
		       AUSSCHNITT_ALLOCSTEP,
		       (char **)(&(AKT_BILD.ersterBefehl)),
		       sizeof(stat_typ));
	AKT_BILD.anzSpeicher = 
		galloc(AKT_BILD.anzSpeicher,
		       AUSSCHNITT_ALLOCSTEP,
		       AUSSCHNITT_ALLOCSTEP,
		       (char **)(&(AKT_BILD.letzterBefehl)),
		       sizeof(stat_typ));
	/* Ausschnitt nur, wenn mehr als 10 Befehle als Ausschnitt gewaehlt
	   werden. Falls zu kleine oder zu grosse Werte eingegeben werden,
	   werden sie auf die maximal moeglichen Werte gesetz.
	*/
	if (ende - anfang > 10) {
		if (anfang < 1 || anfang > inp.anzBefehle)
			anfang = 1;
		if ( ende < 1 || ende > inp.anzBefehle)
			 ende = inp.anzBefehle;

		AKT_BILD.ersterBefehl[AKT_BILD.anzAusschnitte] = anfang;
		AKT_BILD.letzterBefehl[AKT_BILD.anzAusschnitte] = ende;
	} else {
		AKT_BILD.ersterBefehl[AKT_BILD.anzAusschnitte] = 1;
		AKT_BILD.letzterBefehl[AKT_BILD.anzAusschnitte] = inp.anzBefehle;
	}

	/* Bei einem neuen Grafikfenster wird zunaechst der Durchschnitt angezeigt.
	*/
	AKT_BILD.PixelWerte.aktAusgabe = AVERAGE;

	/* Und die Grafik ausgeben */
	ZeichneGrafikNeu(anzDrawWidgets);

	/* Anzahlk vorhandener DrawingWidgets erhoehen */
	anzDrawWidgets++;
} /* neuesBild */
E 1
