/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : atof.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.atof.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:40        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Ersatz fuer die Funktion atof

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)atof.c	1.3  9/27/93 PARZ - General (Frank Sembach)";

#include <math.h>

double myatof(s)
register char *s;
{ double erg = 0.0;
  register int addexp = 0;
  register int expo, esign;

  for (; *s >= '0' && *s <= '9'; erg = 10.0 * erg + *s++ - '0');
  if (*s == '.')
  { s++;
    for (; *s >= '0' && *s <= '9';
           erg = 10.0 * erg + *s++ - '0', addexp--);
  }
  if (*s == 'e' || *s == 'E')
  { s++; expo = 0;
    if (*s == '-') { s++; esign = -1; }
    else
    { if (*s == '+') s++;
      esign = 1;
    }
    for (; *s >= '0' && *s <= '9'; expo = 10 * expo + *s++ - '0');
    return erg * exp((esign * expo + addexp) * log(10.0));
  }
  else return erg * exp(addexp * log(10.0));
}
