/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Debugger
  Filename     : debdefs.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.debdefs.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:29        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Definitionen fuer den symbolischen Debugger von PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


#define BMAX (BUFSIZ + 20)
#define MAGIC "423310825\n"

                /* Fehlercodes */
#define MAGIC_FALSCH -1
#define WB_FALSCH -2
#define SYM_FALSCH -3
#define GELT_FALSCH -4
#define ZNR_FALSCH -5
#define TYP_FALSCH -6
#define MITG_FALSCH -7
#define CONST_FALSCH -8
#define KEIN_E -9
#define NO_MEM -10

                /* Symbolklassen */
#define SY_UNDEF 0
#define SY_SYSNAME 1
#define SY_CONSTNAME 2
#define SY_TYPENAME 3
#define SY_CONFNAME 4
#define SY_SCALNAME 5
#define SY_VECNAME 6
#define SY_PROCNAME 7
#define SY_IOPORTNAME 8
#define SY_INPORTNAME 9
#define SY_OUTPORTNAME 10
#define SY_STDFKT 11
#define SY_STDPROC 12
#define SY_SPEZ 13
                /* bis hier im xrf-File */
#define SY_RED_STDF 14
#define SY_REDOPER 15

#define SY_INDFLAG 32
#define ALL_SYMS (SY_INDFLAG - 1)
#define SY_LEVUNIT 64

                /* Typklassen */
#define TYP_UNDEF 0
#define TYP_BOOL 1
#define TYP_CHA 2
#define TYP_INT 3
#define TYP_REAL 4
#define TYP_STRING 5
#define TYP_ARRAY 6
#define TYP_RECORD 7
#define TYP_UNION 8
#define TYP_SET 9
#define TYP_POINTER 10
#define TYP_SUBRANGE 11
#define TYP_ENUM 12
#define TYP_PORT 13
#define TYP_PORTTYPE 14

                /* Standardfunktionen */
#define F_ABS 1
#define F_CAP 2
#define F_CHR 3
#define F_EVEN 4
#define F_FLOAT 5
#define F_MAX 6
#define F_MIN 7
#define F_ODD 8
#define F_ORD 9
#define F_SIZE 10
#define F_TRUNC 11
#define F_VAL 12
#define F_STRCMP 13
#define F_STREQ 14
#define F_SIRANDOM 15
#define F_SRRANDOM 16
#define F_SCRANDOM 17
#define F_SBRANDOM 18
#define F_VIRANDOM 19
#define F_VRRANDOM 20
#define F_VCRANDOM 21
#define F_VBRANDOM 22
#define F_IN_CONNECTED 23
#define F_OUT_CONNECTED 24
#define F_IN_LINECONNECTED 25
#define F_OUT_LINECONNECTED 26
#define F_ARCCOS 27
#define F_ARCSIN 28
#define F_ARCTAN 29
#define F_ARCTAN2 30
#define F_COS 31
#define F_EXP 32
#define F_LN 33
#define F_SIN 34
#define F_SQRT 35
#define F_TAN 36
#define F_GETPIXEL 37

typedef struct wb
{ char **start_ptr;
  int *start_tok;
  int wcount; 
} WB;

typedef struct symtab
{ int sym_art;
  int ind_flag;
  int sym_lev;
  long name_key;
  int sym_type_scope;
  long sym_spez;
} SYMTAB;

typedef struct scopetab
{ int von_sym, anz_sym;
  struct scopetab *parent;
  int sc_lev;
  long proc_key;
  int par_flag;
  int von_lab, entry_lab, next_lab;
  struct scopetab *sym_parent;
} SCOPETAB;

typedef struct zeiltab
{ int source_line;
  int stat_in_line;
  int prog_von, prog_next;
  struct zeiltab *parent_line;
} ZEILTAB;

typedef struct typtab
{ int typ_art;
  long typ_key;
  long typ_arg1, typ_arg2, typ_arg3;
  DECLIST parz_decl;
  int ausg_zeilen;
} TYPTAB;

typedef struct mitgtab
{ long mem_key;
  long typ_wert;
  int flag_last;
} MITGTAB;

#define LAST_FLAG 1
#define STRING_FLAG 2

typedef struct consttab
{ int last_flag, string_flag;
  ITEM const_wert;
} CONSTTAB;

        /* Werte fuer expr_art, sexpr_art */
#define EXPR_FALSCH 0
#define EXPR_VAR 1
#define EXPR_TYP 2
#define EXPR_IO_PORT 3
#define EXPR_IN_PORT 4
#define EXPR_OUT_PORT 5
#define EXPR_SEL_LEER 6

typedef struct sexpr
{ ARG serg;
  int typserg;
  char sexpr_art;
  char *sexpr_str;
} SEXPR;

typedef struct expr
{ ARG erg;
  ARG lastval;
  int typerg, typlast;
  char expr_art;
  char *expr_str;
} EXPR;

typedef struct exprlist
{ EXPR *expr_array;
  int expr_count;
} EXPRLIST;

typedef struct select
{ SEXPR exp;
  int dimnum;
} SELECT;

typedef struct expr_range
{ SEXPR ex1, ex2;
} EXPR_RANGE;
