/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Debugger
  Filename     : debexts.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.debexts.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:30        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : externe Variablen und Funktionen fuer den
                 symbolischen Debugger von PARZ
******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


#ifdef MAC
extern char *xrf_source;
#else
extern char xrf_source[BMAX];
#endif

extern int prime, factor, uppercase_flag;
extern long stringcount;
extern char *name_string;
extern char **name_ptrs;
extern int *tok_ptrs;
extern WB *wbuch;

extern long symbolcount;
extern SYMTAB *sym_table;

extern long geltcount;
extern SCOPETAB *scope_table;
extern SCOPETAB std_scope;

extern long zeilcount;
extern ZEILTAB *lines_table;

extern long typcount;
extern TYPTAB *types_table;

extern int para_typ[STR+1];
extern int cardinal_typ, bitset_typ, nil_typ, color_typ;
extern int string_typ1, index_typ1, string_typ2, index_typ2;   /* variable Stringtypen */
extern int akt_index_typ;      /* Naechster zu verwendender Index-Typ bei Stringeingabe */

extern long mitgcount;
extern MITGTAB *member_table;

extern long constcount;
extern CONSTTAB *constant_table;

extern int source_count;
extern char **source_text;

extern int sym_debugging;               /* Flag: symbolisches Debuggen */
extern int examining;                   /* Flag: Examine-Befehl laeuft */
extern int debcode_start;               /* erste Debug-Programmzeile */
extern int debug_lev;                   /* Ebene des Debugcodes */

extern char *system_name;               /* System-Name im Quellprogramm */

extern int hash();

extern long name_to_key();

extern char *key_to_name();

extern SYMTAB *look_sym();

extern DECL *copy_decl();
extern DECLIST *copy_declist();

extern DECLIST *parz_typ();
extern TYP first_typ();

extern int obertyp();

extern char *exprlist_string();

extern int error_num();

extern int find_aktblock();

extern char zuw_ok();
extern char rel_ok();
extern char add_ok();
extern char mul_ok();
extern char pow_ok();
extern char sign_ok();
extern char not_ok();
extern char red_ok();
extern int init_pe_vals();
extern char *ex_string();
extern char *rest_name();
extern int fill_komp_names();
extern int make_komp_names();
extern int make_val_strings();
extern char *conf_count_string();
extern int inc_conf_count();
extern char *get_conf();

extern char elist_out();
