/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Debugger
  Filename     : debug.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.debug.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:44        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Funktionen fuer den symbolischen Debugger von PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)debug.c	1.3  9/27/93 PARZ - Debugger (Frank Sembach)";


#include "parzdefs.h"
#include "komdefs.h"
#include "y_tab.h"
#include "externs.h"
#include "rundefs.h"
#include "runexts.h"
#include "komexts.h"
#include "funcs.h"

int prime, factor, uppercase_flag;
long stringcount;
char *name_string;
char **name_ptrs;
int *tok_ptrs;
WB *wbuch;

long symbolcount;
SYMTAB *sym_table;

long geltcount;
SCOPETAB *scope_table;
SCOPETAB std_scope =
{ 0, 0,
  NULL,
  -1,
  0l,
  0,
  0, 0, 0,
  NULL
};

long zeilcount;
ZEILTAB *lines_table;

long typcount;
TYPTAB *types_table;

int para_typ[STR+1];
int cardinal_typ, bitset_typ, nil_typ, color_typ;
int string_typ1, index_typ1, string_typ2, index_typ2;   /* variable Stringtypen */
int akt_index_typ;      /* Naechster zu verwendender Index-Typ bei Stringeingabe */

long mitgcount;
MITGTAB *member_table;

long constcount;
CONSTTAB *constant_table;

int source_count;
char **source_text;

int sym_debugging = FALSE;           /* Flag: symbolisches Debuggen */
int examining = FALSE;               /* Flag: Examine-Befehl laeuft */
int debcode_start;                   /* erste Debug-Programmzeile */
int debug_lev;                       /* Ebene des Debugcodes */

char *system_name = "";              /* System-Name im Quellprogramm */

extern int hash();

extern long name_to_key();

extern char *key_to_name();

extern SYMTAB *look_sym();

extern DECL *neu_decl();

extern DECLIST *dlptr();

DECLIST *copy_declist();

extern DECLIST deb_s_decls;         /* SCALAR-Deklaration fuer sym. Debugger */
extern DECLIST deb_v_decls;         /* VECTOR-Deklaration fuer sym. Debugger */


/**************************************************************************
 ***                      Funktion find_aktblock
 ***
 *** Raeumt den Aktivierungsstapel ab bis zum obersten Aktivierungsblock
 *** der PROC-Anweisung an Adresse 'procadr'.
 *** next = TRUE : obersten Aktivierungsblock auf jeden Fall abraeumen
 *** Ergebnis : Zahl der entfernten Aktivierungsbloecke
 ***
 **************************************************************************/
                                             
int find_aktblock(procadr, next)
int procadr, next;
{ DISPLAY d;
  char *start_pes;
  register int erg = 0;

  if (akt_tiefe >= 0)
  { for (d = disp[akt_tiefe];
         akt_tiefe >= 0 && ( next || d->procadr != procadr);
         next = FALSE)
    { disp[akt_tiefe] = d->dispalt; /* Display zuruecksetzen */
      akt_tiefe = d->aufr_tiefe;
      akt_line = d->para_call_zeile;
      erg++;
      if (akt_tiefe >= 0)
      { newest_scope = (d = disp[akt_tiefe])->new_scope;
        akt_scope = d->top_scope;
      }
      else
      { newest_scope = akt_scope = NULL; }
    }
    if (start_pes = d->start_aktiv)
    { strcpy(aktive_pes, start_pes); }
  }
  return erg;
}

/**************************************************************************
 ***       Funktion copy_decl (rekursiv, direkt und ueber copy_declist)
 ***
 *** Erzeugt ein identisches Deklarationsarray zu 'dec' der Laenge 'len'
 *** auf neu alloziertem Platz
 ***
 **************************************************************************/

DECL *copy_decl(dec, len)
DECL *dec;
int len;
{ register DECL *erg = (DECL *)calloc((size_t)Max(len,1), (size_t)sizeof(DECL));
  register DECL *dneu;

  if (!erg)
  { komerr(texte[80],30); return NULL; }
  for (dneu = erg; len; len--, dneu++, dec++)
  { *dneu = *dec;
    switch (DECL_art(*dneu))
    { case KLAM :
        DECL_klamdecl(*dneu).darray =
          copy_decl(DECL_klamdecl(*dneu).darray, DECL_klamdecl(*dneu).dcount);
        break;
      case UNION :
        DECL_ul(*dneu).uarray =
          copy_declist(DECL_ul(*dneu).uarray, DECL_ul(*dneu).ucount);
    }
  }
  return erg;
}

/**************************************************************************
 ***          Funktion copy_declist (rekursiv ueber copy_decl)
 ***
 *** Erzeugt ein identisches DECLIST-Array zu '*dl' der Laenge 'len'
 *** auf neu alloziertem Platz
 ***
 **************************************************************************/

DECLIST *copy_declist(dl, len)
DECLIST *dl;
int len;
{ register DECLIST *erg = (DECLIST *)calloc((size_t)Max(len,1), (size_t)sizeof(DECLIST));
  register DECLIST *dlneu;

  if (!erg)
  { komerr(texte[80],31); return NULL; }
  for (dlneu = erg; len; len--, dlneu++, dl++)
  { *dlneu = *dl;
    dlneu->darray = copy_decl(dlneu->darray, dlneu->dcount);
  }
  return erg;
}

/**************************************************************************
 ***               Funktion decl_append
 ***
 *** Haengt den Inhalt von '*dlneu' an '*dl' an
 ***
 **************************************************************************/

decl_append(dl, dlneu)
DECLIST *dl, *dlneu;
{ register DECL *neu, *dec;
  register int i, merge = 0;

  if (dl->darray && dlneu->darray &&
      DECL_art(*(dec = dl->darray + dl->dcount - 1)) == FELD &&
      DECL_art(*(neu = dlneu->darray)) == FELD &&
      DECL_t(*dec) == DECL_t(*neu))
  { merge = 1;
    DECL_zahl(*dec) += DECL_zahl(*neu);
  }
  if (!(neu = (DECL *)(dl->darray ?
                       realloc(dl->darray,
                               (size_t)(sizeof(DECL) *
                                          (dl->dcount + dlneu->dcount - merge))) :
                       calloc((size_t)dlneu->dcount, (size_t)sizeof(DECL)))))
  { if (dl->darray) loesch_decl(dl);
    komerr(texte[80],32); return;
  }
  dl->darray = neu;
  neu += dl->dcount;
  dl->dcount += dlneu->dcount - merge;
  for (i = merge, dec = dlneu->darray + merge;
       i < dlneu->dcount;
       i++, *(neu++) = *(dec++));
  for (i = BOOL; i <= SUMM; dl->typ_zahl[i] += dlneu->typ_zahl[i], i++);
}

/**************************************************************************
 ***               Funktion parz_typ (rekursiv)
 ***
 *** Liefert den PARZ-Typ zum Typtabelleneintrag mit Index 't'
 *** Traegt noch nicht vorhandene PARZ-Deklarationen ein.
 *** Ermittelt die Zahl der Ausgabezeilen.
 ***
 **************************************************************************/

DECLIST *parz_typ(t)
int t;
{ register TYPTAB *tptr = types_table + t - 1;
  register DECLIST *dlptr = &tptr->parz_decl;
  register int *az = &tptr->ausg_zeilen;

  if (!tptr->parz_decl.darray)
  { switch (tptr->typ_art)
    { case TYP_UNDEF    :
        break;
      case TYP_BOOL     :
      case TYP_CHA      :
      case TYP_INT      :
      case TYP_REAL     :
        { register DECL *d = neu_decl(dlptr, FELD);

          DECL_t(*d) = tptr->typ_art - TYP_BOOL;
          *az = DECL_zahl(*d) = dlptr->typ_zahl[DECL_t(*d)] =
            dlptr->typ_zahl[SUMM] = 1;
        }
        break;
      case TYP_STRING   :
        { register DECL *d = neu_decl(dlptr, FELD);
          register TYPTAB *ti= types_table + tptr->typ_arg1 - 1;

          parz_typ((int)tptr->typ_arg1);
          DECL_t(*d) = CHA;
          DECL_zahl(*d) = dlptr->typ_zahl[CHA] = dlptr->typ_zahl[SUMM] =
            ti->typ_arg3 - ti->typ_arg2 + 1;
          *az = 1;
        }
        break;
      case TYP_ARRAY    :
        { register TYPTAB *ti = types_table + tptr->typ_arg1 - 1;
          register DECLIST *de = parz_typ((int)tptr->typ_arg2);
          register int w, i;                                   

          parz_typ((int)tptr->typ_arg1);
          switch (ti->typ_art)
          { case TYP_BOOL     : w = 2;
                                break;
            case TYP_SUBRANGE :
            case TYP_ENUM     : w = ti->typ_arg3 - ti->typ_arg2 + 1;
                                break;
            default : bug("debug.c/parz_typ : Falscher Array-Indextyp");
          }
          if (de->typ_zahl[SUMM] == 1 && de->typ_zahl[CHA] == 1)
          { register DECL *d = neu_decl(dlptr, FELD);

            DECL_t(*d) = CHA;
            DECL_zahl(*d) = dlptr->typ_zahl[CHA] = dlptr->typ_zahl[SUMM] = w;
            *az = 1;
          }
          else
          { register DECL *d = neu_decl(dlptr, KLAM);

            DECL_klamdecl(*d) = *de;
            DECL_wiederh(*d) = w;
            *az = w * types_table[tptr->typ_arg2 - 1].ausg_zeilen;
            for (i = BOOL; i <= SUMM; dlptr->typ_zahl[i] = w * de->typ_zahl[i], i++);
          }
        }
        break;
      case TYP_RECORD   :
        { register MITGTAB *mt = member_table + tptr->typ_arg1 - 1;
          register int fertig;

          for (fertig = FALSE, *az = 0; !fertig; mt++)
          { decl_append(dlptr, parz_typ((int)mt->typ_wert));
            *az += types_table[mt->typ_wert - 1].ausg_zeilen;
            fertig = mt->flag_last;
          }
        }
        break;
      case TYP_UNION    :
        { register DECL *d = neu_decl(dlptr, UNION);
          register MITGTAB *mt = member_table + tptr->typ_arg1 - 1;
          register int i, fertig;

          for (fertig = FALSE, *az = 0; !fertig; mt++)
          { neu_ulist(&DECL_ul(*d), parz_typ((int)mt->typ_wert));
            *az += types_table[mt->typ_wert - 1].ausg_zeilen;
            fertig = mt->flag_last;
          }
          for (i = BOOL;
               i <= SUMM;
               dlptr->typ_zahl[i] += DECL_ul(*d).utyp_anz[i], i++);
        }
        break;
      case TYP_SET      :
        { register DECL *d = neu_decl(dlptr, FELD);

          parz_typ((int)tptr->typ_arg1);
          DECL_t(*d) = BOOL;
          DECL_zahl(*d) = dlptr->typ_zahl[BOOL] = dlptr->typ_zahl[SUMM] =
            tptr->typ_arg3 - tptr->typ_arg2 + 1;
          *az = 1;
        }
        break;
      case TYP_POINTER  :
        { register DECL *d = neu_decl(dlptr, FELD);

          DECL_t(*d) = INT;
          DECL_zahl(*d) = dlptr->typ_zahl[INT] = dlptr->typ_zahl[SUMM] = 1;
          *az = 1;
        }
        break;
      case TYP_SUBRANGE :
        *dlptr = *parz_typ((int)tptr->typ_arg1);
        *az = 1;
        break;
      case TYP_ENUM     :
        { register DECL *d = neu_decl(dlptr, FELD);
          register MITGTAB *mt = member_table + tptr->typ_arg1 - 1;

          DECL_t(*d) = INT;
          DECL_zahl(*d) = dlptr->typ_zahl[INT] = dlptr->typ_zahl[SUMM] = 1;
          tptr->typ_arg2 = mt->typ_wert;
          for (; !mt->flag_last; mt++);
          tptr->typ_arg3 = mt->typ_wert;
          *az = 1;
        }
        break;
      case TYP_PORT     :
      case TYP_PORTTYPE :
        { register DECL *d = neu_decl(dlptr, FELD);

          DECL_t(*d) = INT;
          DECL_zahl(*d) = dlptr->typ_zahl[INT] = dlptr->typ_zahl[SUMM] = 1;
          *az = 1;
        }
        break;
      default : bug("debug.c/parz_typ : Falsche Typart");
    }
  }
  return dlptr;
}

/**************************************************************************
 ***                      Funktion first_typ (rekursiv)
 ***
 *** Ermittelt den Typ des ersten Deklarationselements von 'dl'
 ***
 **************************************************************************/

TYP first_typ(dl)
DECLIST *dl;
{ if (dl && dl->typ_zahl[SUMM])
  { register DECL *dec;
    register int count;

    for (count = dl->dcount, dec = dl->darray; count; count--, dec++)
    { switch (DECL_art(*dec))
      { case FELD  :
          return DECL_t(*dec);
        case KLAM  :
          if (DECL_wiederh(*dec) && DECL_typ_anz(*dec)[SUMM])
          { return first_typ(&DECL_klamdecl(*dec)); }
          break;
        case UNION :
          if (DECL_ul(*dec).utyp_anz[SUMM])
          { register TYP erg = -1;

            for (count = DECL_ul(*dec).ucount, dl = DECL_ul(*dec).uarray;
                 count && erg < 0;
                 count--, dl++)
            { erg = first_typ(dl); }
            return erg;
          }
      }
    }
  }
  else
  { return -1; }
}

/**************************************************************************
 ***                  Funktion obertyp (rekursiv)
 ***
 *** ermittelt den Obertyp des Typs 't' (Index in Typtabelle)
 *** Ergebnis unterscheidet sich nur bei Unterbereichen von 't'
 ***
 **************************************************************************/

int obertyp(t)
int t;
{ register TYPTAB *tt = types_table + t - 1;

  if (tt->typ_art == TYP_SUBRANGE)
  { return obertyp((int)tt->typ_arg1); }
  else
  { return t; }
}

/**************************************************************************
 ***                      Funktion exprlist_string
 ***
 *** Erzeugt einen String aus den 'expr_str's in 'elist'
 ***
 **************************************************************************/

char *exprlist_string(elist)
EXPRLIST *elist;
{ register size_t slen;
  register char *erg, *inp;
  register int ec;
  register EXPR *exp;

  if (elist)
  { for (exp = elist->expr_array, ec = elist->expr_count, slen = ec;
         ec;
         exp++, ec--)
    { if (exp->expr_str)
      { slen += strlen(exp->expr_str); }
    }
    if (erg = malloc(slen))
    { for (exp = elist->expr_array, ec = elist->expr_count, inp = erg, *inp = '\0';
           ec;
           exp++, ec--)
      { if (exp->expr_str)
        { strcpy(inp, exp->expr_str);
          inp += strlen(inp);
        }
        if (ec > 1) { *inp++ = ','; *inp = '\0'; }
      }
    }
    else
    { komerr(texte[80],33); }
  }
  else
  { erg = calloc((size_t)1,(size_t)sizeof(char)); }
  return erg;
}

/**************************************************************************
 ***                      Funktion exprlist_free
 ***
 *** Gibt die 'expr_str's in 'elist' frei.
 ***
 **************************************************************************/

exprlist_free(elist)
EXPRLIST *elist;
{ register int i;
  register EXPR *exp;

  if (elist)
  { for (i = elist->expr_count, exp = elist->expr_array; i; i--, exp++)
    { if (exp->expr_str) free(exp->expr_str); }
  }
}

/**************************************************************************
 ***                      Funktion new_var
 ***
 *** Macht aus '*var' eine Variable vom Typ 'typ':
 *** typ   : Index in Debugger-Typtabelle
 *** vflag : Gibt an, ob Variable VECTOR oder SCALAR wird
 ***
 **************************************************************************/

new_var(var, typ, vflag)
ARG *var;
int typ;
ARGART vflag;
{ register DECLIST *dl = parz_typ(typ);
  register TYP adrtyp = first_typ(dl);
  register DECLIST *deb_dl = vflag ? &deb_v_decls : &deb_s_decls;

  ARG_argsort(*var) = adrtyp | vflag;
  ARG_tiefe(*var) = debug_lev;
  ARG_num(*var) = deb_dl->typ_zahl[adrtyp] + 1;
  ARG_gut_proc(*var) = -2;
  decl_append(deb_dl, dl);
}

/**************************************************************************
 ***                      Funktion zuw_ok
 ***
 *** Liefert 'TRUE', wenn 'typ2' an 'typ1' zugewiesen werden kann
 *** typ1, typ2 : Indizes in Debugger-Typtabelle
 ***
 **************************************************************************/

char zuw_ok(typ1, typ2)
int typ1, typ2;
{ register TYPTAB *t1, *t2;

  if (!typ1 || !typ2) return FALSE;
  if (typ1 == typ2) return TRUE;
  t1 = types_table + typ1 - 1;
  t2 = types_table + typ2 - 1;
  switch (t1->typ_art)
  { case TYP_BOOL :
    case TYP_CHA :
    case TYP_INT :
    case TYP_ENUM :
      if (t2->typ_art == TYP_SUBRANGE)
      { return zuw_ok(typ1, (int)t2->typ_arg1); }
    case TYP_SUBRANGE :
      return zuw_ok((int)t1->typ_arg1, typ2);
    case TYP_ARRAY :
      if (t1->typ_arg2 == para_typ[CHA])
      { if (t2->typ_art == TYP_CHA)
        { t1 = types_table + t1->typ_arg1 - 1;
          if (t1->typ_arg3 - t1->typ_arg2 > 1)
          { return TRUE; }
        }
        else if (t2->typ_art == TYP_STRING)
        { t1 = types_table + t1->typ_arg1 - 1;
          t2 = types_table + t2->typ_arg1 - 1;
          if (t2->typ_arg3 - t2->typ_arg2 <= t1->typ_arg3 - t1->typ_arg2)
          { return TRUE; }
        }
      }
      break;
    case TYP_POINTER :
      if (typ2 == nil_typ ||
          (t2->typ_art == TYP_POINTER && t1->typ_arg1 == t2->typ_arg1))
      { return TRUE; }
  }
  return FALSE;
}

/**************************************************************************
 ***                      Funktion rel_ok
 ***
 *** Liefert 'TRUE', wenn die Typen 'typ1' und 'typ2' mit 'op' verglichen
 *** werden koennen
 *** typ1, typ2 : Indizes in Debugger-Typtabelle
 *** op         : Relop-Token
 ***
 **************************************************************************/

char rel_ok(typ1, op, typ2)
int typ1, op ,typ2;
{ register TYPTAB *tt;

  if (!typ1 || !typ2) return FALSE;
  switch (op)
  { case IN :
      tt = types_table + typ2 - 1;
      return tt->typ_art == TYP_SET && zuw_ok(typ1, (int)tt->typ_arg1);
    case EQ :
    case NE :
      if (typ1 == typ2) return TRUE;
      tt = types_table + typ1 - 1;
      switch (tt->typ_art)
      { case TYP_BOOL :
        case TYP_CHA :
        case TYP_INT :
        case TYP_ENUM :
          return zuw_ok(typ1, typ2);
        case TYP_POINTER :
          return zuw_ok(typ1, typ2) || zuw_ok(typ2, typ1);
        case TYP_SUBRANGE :
          return zuw_ok((int)tt->typ_arg1, typ2);
      }
      break;
    case LT :
    case GT :
      tt = types_table + typ1 - 1;
      switch (tt->typ_art)
      { case TYP_BOOL :
        case TYP_CHA :
        case TYP_INT :
        case TYP_REAL :
        case TYP_SUBRANGE :
        case TYP_ENUM :
          return zuw_ok(typ1, typ2);
      }
      break;
    case LE :
    case GE :
      tt = types_table + typ1 - 1;
      switch (tt->typ_art)
      { case TYP_BOOL :
        case TYP_CHA :
        case TYP_INT :
        case TYP_REAL :
        case TYP_SUBRANGE :
        case TYP_ENUM :
        case TYP_SET :
          return zuw_ok(typ1, typ2);
      }
  }
  return FALSE;
}

/**************************************************************************
 ***                      Funktion add_ok (rekursiv)
 ***
 *** Liefert 'TRUE', wenn die Typen 'typ1' und 'typ2' mit 'op' addiert
 *** werden koennen
 *** typ1, typ2 : Indizes in Debugger-Typtabelle
 *** op         : Addop-Token
 ***
 **************************************************************************/

char add_ok(typ1, op, typ2)
int typ1, op ,typ2;
{ register TYPTAB *t1 = types_table + typ1 - 1;

  if (!typ1 || !typ2) return FALSE;
  switch (op)
  { case PLUS :
    case MINUS :
      switch (t1->typ_art)
      { case TYP_INT :
        case TYP_REAL :
        case TYP_SET :
          return zuw_ok(typ1, typ2);
        case TYP_SUBRANGE :
          return add_ok((int)t1->typ_arg1, op, typ2);
      }
      break;
    case OR :
      switch (t1->typ_art)
      { case TYP_BOOL :
          return zuw_ok(typ1, typ2);
        case TYP_SUBRANGE :
          return add_ok((int)t1->typ_arg1, op, typ2);
      }
  }
  return FALSE;
}

/**************************************************************************
 ***                      Funktion mul_ok (rekursiv)
 ***
 *** Liefert 'TRUE', wenn die Typen 'typ1' und 'typ2' mit 'op' multipliziert
 *** werden koennen
 *** typ1, typ2 : Indizes in Debugger-Typtabelle
 *** op         : Mulop-Token
 ***
 **************************************************************************/

char mul_ok(typ1, op, typ2)
int typ1, op ,typ2;
{ register TYPTAB *t1 = types_table + typ1 - 1;

  if (!typ1 || !typ2) return FALSE;
  switch (op)
  { case MAL :
      switch (t1->typ_art)
      { case TYP_INT :
        case TYP_REAL :
        case TYP_SET :
          return zuw_ok(typ1, typ2);
        case TYP_SUBRANGE :
          return mul_ok((int)t1->typ_arg1, op, typ2);
      }
      break;
    case DURCH :
      switch (t1->typ_art)
      { case TYP_REAL :
        case TYP_SET :
          return zuw_ok(typ1, typ2);
      }
      break;
    case DIV :
    case MOD :
      switch (t1->typ_art)
      { case TYP_INT :
          return zuw_ok(typ1, typ2);
        case TYP_SUBRANGE :
          return mul_ok((int)t1->typ_arg1, op, typ2);
      }
      break;
    case AND :
      switch (t1->typ_art)
      { case TYP_BOOL :
          return zuw_ok(typ1, typ2);
        case TYP_SUBRANGE :
          return mul_ok((int)t1->typ_arg1, op, typ2);
      }
  }
  return FALSE;
}
            
/**************************************************************************
 ***                      Funktion pow_ok (rekursiv)
 ***
 *** Liefert 'TRUE', wenn 'typ1' mit 'typ2' potenziert werden kann
 *** typ1, typ2 : Indizes in Debugger-Typtabelle
 ***
 **************************************************************************/

char pow_ok(typ1, typ2)
int typ1, typ2;
{ register TYPTAB *t1 = types_table + typ1 - 1;

  if (!typ1 || !typ2) return FALSE;
  switch (t1->typ_art)
  { case TYP_INT :
      return zuw_ok(typ1, typ2);
    case TYP_REAL :
      return zuw_ok(typ1, typ2) || zuw_ok(para_typ[INT], typ2);
    case TYP_SUBRANGE :
      return pow_ok((int)t1->typ_arg1, typ2);
  }
  return FALSE;
}

/**************************************************************************
 ***                      Funktion sign_ok (rekursiv)
 ***
 *** Liefert 'TRUE', wenn der Typ 'typ' ein Vorzeichen haben kann
 *** typ : Index in Debugger-Typtabelle
 ***
 **************************************************************************/

char sign_ok(typ)
int typ;
{ register TYPTAB *tt = types_table + typ - 1;

  if (!typ) return FALSE;
  switch (tt->typ_art)
  { case TYP_INT :
    case TYP_REAL :
      return TRUE;
    case TYP_SUBRANGE :
      return sign_ok((int)tt->typ_arg1);
  }
  return FALSE;
}

/**************************************************************************
 ***                      Funktion not_ok (rekursiv)
 ***
 *** Liefert 'TRUE', wenn der Typ 'typ' mit 'NOT' negiert werden darf
 *** typ : Index in Debugger-Typtabelle
 ***
 **************************************************************************/

char not_ok(typ)
int typ;
{ register TYPTAB *tt = types_table + typ - 1;

  if (!typ) return FALSE;
  switch (tt->typ_art)
  { case TYP_BOOL :
      return TRUE;
    case TYP_SUBRANGE :
      return not_ok((int)tt->typ_arg1);
  }
  return FALSE;
}

/**************************************************************************
 ***                      Funktion red_ok (rekursiv)
 ***
 *** Liefert 'TRUE', wenn der Typ 'typ' mit 'op' reduziert werden darf
 *** typ : Index in Debugger-Typtabelle
 ***
 **************************************************************************/

char red_ok(op, typ)
int op, typ;
{ register TYPTAB *tt = types_table + typ - 1;

  if (!typ) return FALSE;
  switch (op)
  { case FIRST :
    case LAST :
      switch (tt->typ_art)
      { case TYP_BOOL :
        case TYP_CHA :
        case TYP_INT :
        case TYP_REAL :
        case TYP_POINTER :
        case TYP_SUBRANGE :
        case TYP_ENUM :
          return TRUE;
      }
      break;
    case SUM :
    case PRODUCT :
      switch (tt->typ_art)
      { case TYP_INT :
        case TYP_REAL :
          return TRUE;
        case TYP_SUBRANGE :
          return red_ok(op, (int)tt->typ_arg1);
      }
      break;
    case MAX :
    case MIN :
      switch (tt->typ_art)
      { case TYP_BOOL :
        case TYP_CHA :
        case TYP_INT :
        case TYP_REAL :
        case TYP_SUBRANGE :
        case TYP_ENUM :
          return TRUE;
      }
      break;
    case AND :
    case OR :
      switch (tt->typ_art)
      { case TYP_BOOL :
          return TRUE;
        case TYP_SUBRANGE :
          return red_ok(op, (int)tt->typ_arg1);
      }
      break;
    default : bug("debug.c/red_ok : Falscher REDUCE Operator");
  }
  return FALSE;
}
