/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : externs.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.externs.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:31        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : externe Variablen und Funktionen fuer PARZ aus main.c

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


extern int pe_anz, port_anz, stat_anz; /* Anzahl der PEs, Ports, Programmzeilen */
extern int pe_width;                   /* Ausgabebreite fuer PE-Listen */
extern int max_source_zeile;           /* Groesste Parallaxis-Zeile */
extern int max_label;                  /* Groesstes PARZ-Label */
extern int szlen;                      /* Max. Laenge der Source-Zeilennummer */
extern int lablen;                     /* Max. Laenge der Labelnummer */
extern int max_lev;                    /* Maximale Prozedurschachtelungstiefe */

extern int fehlermax;                  /* Begrenzung der Zahl der Meldungen */
extern int anz_meldungen, anz_fehler;  /* Zahl der ausgegebenen Meldungen, davon Fehler */

extern
#ifdef RS6000
       signed
#endif
              char parse_start;        /* Benutzungsart des Parsers :
                                           1 : Programm (anfangs),
                                           2 : Kommandos (anfangs)
                                          -1 : im Programm
                                          -2 : im Kommando
                                          -3 : Kommandoeingabe von Programmteilen */
extern char breaked;                   /* Programmausfuehrung ist unterbrochen */
extern char uebersetzen;               /* Compiler wird aufgerufen */

extern PORT *portarray;                /* Zeiger auf Ports */

extern STACK **vec_stacks;             /* Vektorielle Parameterstacks */
extern STACK *scal_stack;              /* Skalare Parameterstacks */

extern STAT *programm;                 /* Programmtext */

/*extern struct func_ptrs
       { int (* do_f[2][REAL + 1])();
         int (* print_f)();
       } *op_funcs;  */                /* Zeiger auf Funktionen fuer unaere und binaere
                                          Operatoren */

extern DECLIST glob_s_decl, glob_v_decl;/* globale Variablendeklarationen */

extern FILE *listout;                  /* Dateizeiger fuer Listingausgabe */
extern FILE *protokollout;             /* Dateizeiger fuer Protokollausgabe */
extern FILE *kommandin;                /* Dateizeiger fuer Kommandoeingabe */
extern FILE *kommandout;               /* Dateizeiger fuer Kommandoausgabe */
extern FILE *runin;                    /* Dateizeiger fuer Laufzeiteingabe */
extern FILE *runout;                   /* Dateizeiger fuer Laufzeitausgabe */
extern FILE *debugout;                 /* Dateizeiger fuer Debugausgabe */

extern char fperror, abbruch, quitted; /* Flags fuer Fehler und Abbruchsituationen */

extern char deb_mod, more_mod, more_mod_save, ss_fast, warnings_on; /* Flags fuer Systemeinstellungen */
                      
extern int prot, alt_prot, ss_mod, ss_modus, ss_mod_start;   /* Systemparameter */
extern int more_count;                 /* Zaehlt ausgegebene Zeilen seit --MEHR-- */

extern int file_gelesen;               /* Flag : Programm erfolgreich gelesen */
extern int prot_geschrieben;           /* Flag : auf Protokolldatei wurde geschrieben */
extern int prot_offen;                 /* Flag : Protokolldatei ist geoeffnet */

extern char the_filename[270];         /* tatsaechlicher Programmdateiname */
extern char *home_path;                /* Inhalt der Environment-Variablen HOME */

extern char the_sourcename[270];       /* Name der Quelldatei */
extern char sourcename_gilt;           /* Flag : In the_sourcename steht ein Dateiname */
extern char sourcename_sicher;         /* Flag : Text in the_sourcename gilt als richtig */

extern int sign(), ziel(),
           get_absoffs(), set_absoffs();
extern long lsign();

extern FILE *parzopen(), *popen();
