/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : getunget.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.getunget.c
  Version      : 1.4 
  Last changed : 8/31/94 at 00:18:42        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Eingaberoutinen mit grossem Rueckgabepuffer

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)getunget.c	1.4  8/31/94 PARZ - General (Frank Sembach)";


#include <stdio.h>

#ifdef MAC

#include <console.h>
#define CTRL_C 3
#define CTRL_D 4
extern int cmode;
#include <signal.h>

#define STDINLEN 1024
static int *stdinbuf;
#define bufmid (stdinbuf + STDINLEN / 2)
#define bufend (stdinbuf + STDINLEN - 1)

static int *bufles;
static int *bufschreib;
static int buffill = 0;

#define UNECHOLEN 512
static int *unechoed;
static int unecholes = 0;
static int unechoschreib = 0;
static int unechofill = 0;

extern int zeile_fertig;

extern char **texte;
extern void *calloc();

init_getunget()
{ if (!(stdinbuf = (int *)calloc((size_t)STDINLEN, (size_t)sizeof(int))))
  { fatal(texte[4]); parzexit(1); }
  if (!(unechoed = (int *)calloc((size_t)UNECHOLEN, (size_t)sizeof(int))))
  { fatal(texte[4]); parzexit(1); }
  buffill = unecholes = unechoschreib = unechofill = 0;
  bufles = bufschreib = bufmid;
}

/**************************************************************************
 ***                      Funktion ctrl_c_test
 ***
 *** Untersucht die Standardeingabe auf ein CTRL-C
 ***
 **************************************************************************/

ctrl_c_test()
{ int c, cmode_save;

  if (unechofill < UNECHOLEN)
  { cmode_save = cmode;
    csetmode(C_RAW, stdin); cmode = C_RAW;
    do
    { unechoed[unechoschreib++] = c = getchar();
      unechoschreib %= UNECHOLEN; unechofill++;
    } while (c != EOF && c != CTRL_C && unechofill < UNECHOLEN);
    if (c == CTRL_C)
    { unechoed[unechoschreib ? unechoschreib - 1 : UNECHOLEN - 1] = '\n';
      raise(SIGINT);
    }
    else if (c == EOF)
    { unechoschreib += (unechoschreib ? -1 : UNECHOLEN - 1);
      unechofill--;
    }
    csetmode(cmode_save, stdin); cmode = cmode_save;
  }
}

testline()
{ int cmode_save, c, *testanf;

  if (!buffill) bufles = bufschreib = bufmid;
  cmode_save = cmode;
  csetmode(C_RAW, stdin); cmode = C_RAW;
  testanf = bufschreib;
  do
  { if (unechofill)
    { unechofill--;
      c = unechoed[unecholes++];
      unecholes %= UNECHOLEN;
    }
    else
    { do { c = getchar(); }
      while (c == EOF);
    }
    *bufschreib++ = c;
    buffill++;
    if (bufschreib > bufend - 1)
    { *bufschreib++ = c = '\n';
      buffill++;
    }
    if (c == '\r')
    { bufschreib[-1] = c = '\n'; }
    if (c == CTRL_C)
    { bufschreib[-1] = c = '\n';
      raise(SIGINT);
    }
    if (c == '\b')
    { bufschreib--; buffill--;
      if (bufschreib > testanf)
      { bufschreib--; buffill--; fputs("\b \b", stdout); }
    }
    else if (c == '\n') putc('\n', stdout);
    else if (c >= ' ') putc(c, stdout);
    fflush(stdout);
  } while (c != '\n');
  csetmode(cmode_save, stdin); cmode = cmode_save;
}

int my_getchar()
{ if (!buffill)
  { if (cmode == C_RAW) return getchar();
    else
    { testline(); }
  }    
  buffill--;
  return *bufles++;
}

int my_getc(stream)
FILE *stream;
{ if (stream == stdin) return my_getchar();
  else return getc(stream);
}

int my_fgetc(stream)
FILE *stream;
{ if (stream == stdin) return my_getchar();
  else return fgetc(stream);
}

char *my_gets(s)
char *s;
{ register char *sp = s;

  if (!buffill)
  { testline(); }
  do
  { buffill--;
    *sp++ = (char)*bufles++;
  } while (sp[-1] != '\n');
  *--sp = '\0';
  return s;
}

char *my_fgets(s, n, stream)
char *s;
int n;
FILE *stream;
{ if (stream == stdin)
  { register int bisher = 0;
    register char *sp = s;

    if (!buffill)
    { testline(); }
    if (n)
    { do
      { buffill--;
        bisher++;
        *sp++ = (char)*bufles++;
      } while (sp[-1] != '\n' && bisher < n);
    }
    *sp = '\0';
    return s;
  }
  else return fgets(s, n, stream);
}

int my_ungetc(c, stream)
int c;
FILE *stream;
{ if (stream == stdin)
  { if (bufles == stdinbuf || c == EOF) return EOF;
    buffill++;
    return *--bufles = c;
  }
  else return ungetc(c, stream);
}

kill_input()
{ register int c;

  unecholes = unechoschreib = unechofill = buffill = 0;
  do { c = getchar(); } while (c != EOF);
}
  
#else

static int stdinbuf[257], *bufp = stdinbuf;
static int buffill = 0;

int my_getc(stream)
FILE *stream;
{ if (stream == stdin && buffill > 0)
  { buffill--;
    return *(bufp--);
  }
  else return getc(stream);
}

int my_getchar()
{ if (buffill > 0)
  { buffill--;
    return *(bufp--);
  }
  else return getchar();
}

int my_fgetc(stream)
FILE *stream;
{ if (stream == stdin && buffill > 0)
  { buffill--;
    return *(bufp--);
  }
  else return fgetc(stream);
}

char *my_gets(s)
char *s;
{ register char *sp = s;

  *sp = '\0';
  while (buffill)
  { buffill--;
    *sp = (char)*(bufp--);
    if (*sp == '\n') break;
    *(++sp) = '\0';
  }
  if (*sp == '\n')
  { *sp = '\0'; return s; }
  else
  { gets(sp); return s; }
}

char *my_fgets(s, n, stream)
char *s;
int n;
FILE *stream;
{ if (stream == stdin && buffill > 0)
  { register int bisher = 0;
    register char *sp = s;

    *sp = '\0';
    while (buffill && bisher < n - 1)
    { buffill--;
      bisher++;
      *sp = (char)*(bufp--);
      if (*sp == '\n') break;
      *(++sp) = '\0';
    }
    if (*sp == '\n')
    { *(++sp) = '\0'; return s; }
    else
    { fgets(sp, n - bisher, stream); return s; }
  }
  else return fgets(s, n, stream);
}

int my_ungetc(c, stream)
int c;
FILE *stream;
{ if (stream == stdin)
  { if (buffill >= 257 || c == EOF) return EOF;
    buffill++;
    return *(++bufp) = c;
  }
  else return ungetc(c, stream);
}

#ifdef PC

#include <conio.h>

kill_input()
{ buffill = 0; bufp = stdinbuf;
  while (kbhit()) getch();
}

#else

#include <curses.h>

#ifndef FIONREAD
#  include <sys/filio.h>
#endif

#  ifdef HP_UX
kill_input()
{ flushinp(); }
#  else
kill_input()            /* direkt lesbare Eingabe ueberlesen */
{ long arg;

  buffill = 0; bufp = stdinbuf;
  ioctl(fileno(stdin), FIONREAD, &arg);
  for (; arg; arg--)
  { if (getchar() == EOF) return; }
}

# endif
#endif

#endif
