/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : main.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.main.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:41        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Hauptprogramm fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)main.c	1.3  9/27/93 PARZ - General (Frank Sembach)";

/******* Datei main.c ******
 *
 *      Hauptprogramm fuer PARZ
 *      Frank Sembach
 */

#if defined(HP_UX) || defined(RS6000)
#include <curses.h>
#endif

#include "parzdefs.h"
#include "komdefs.h"
#include "y_tab.h"

#ifdef PC
# ifndef YYMAXDEPTH
#  define YYMAXDEPTH 150
# endif
extern YYSTYPE *yyv;
#endif

#include "rundefs.h"
#include "funcs.h"
#include "komexts.h"
#ifdef MAC
# include <console.h>
int cmode = C_ECHO;

/* @@ Thomas Declarations */
/* ---------------------- */
Point       xtopleft;
SFTypeList  xfilefilter;
SFReply     xreply;
int                   xmes,xcnt;
AppFile               *xthefile;

pascal Boolean myfilefilter(pablock)
ParmBlkPtr pablock;
{ int i;
  i = (int) (pablock->fileParam.ioNamePtr)[0];
  return !( ((pablock->fileParam.ioNamePtr)[i-1] == '.') &&
            ((pablock->fileParam.ioNamePtr)[i]   == 'z') );
}
/* ---------------------- */

#endif

/*********************************************/
int pe_anz, port_anz, stat_anz; /* Anzahl der PEs, Ports, Programmzeilen */
int pe_width;                   /* Ausgabebreite fuer PE-Listen */
int max_source_zeile;           /* Groesste Parallaxis-Zeile */
int max_label;                  /* Groesstes PARZ-Label */
int szlen;                      /* Max. Laenge der Source-Zeilennummer */
int lablen;                     /* Max. Laenge der Labelnummer */
int max_lev;                    /* Maximale Prozedurschachtelungstiefe */

int fehlermax;                  /* Begrenzung der Zahl der Meldungen */
int anz_meldungen, anz_fehler;  /* Zahl der ausgegebenen Meldungen, davon Fehler */
int morelen;                    /* Bildschirmlaenge fuer Ausgabe */

#ifdef RS6000
signed
#endif
       char parse_start;        /* Benutzungsart des Parsers :
                                    1 : Programm (anfangs),
                                    2 : Kommandos (anfangs)
                                   -1 : im Programm
                                   -2 : im Kommando
                                   -3 : Kommandoeingabe von Programmteilen */
char breaked;                   /* Programmausfuehrung ist unterbrochen */
char uebersetzen, compile;      /* Compiler wird aufgerufen */

PORT *portarray;                /* Zeiger auf Ports */

STACK **vec_stacks;             /* Vektorielle Parameterstacks */
STACK *scal_stack;              /* Skalare Parameterstacks */

STAT *programm;                 /* Programmtext */

/*
struct func_ptrs
{ int (* do_f[2][REAL + 1])();
  int (* print_f)();
} *op_funcs;  */                /* Zeiger auf Funktionen fuer unaere und binaere
                                   Operatoren */

DECLIST glob_s_decl, glob_v_decl;/* globale Variablendeklarationen */

FILE *listout = stdout;         /* Dateizeiger fuer Listingausgabe */
FILE *protokollout = NULL;      /* Dateizeiger fuer Protokollausgabe */
FILE *kommandin = stdin;        /* Dateizeiger fuer Kommandoeingabe */
FILE *kommandout = stdout;      /* Dateizeiger fuer Kommandoausgabe */
FILE *runin = stdin;            /* Dateizeiger fuer Laufzeiteingabe */
FILE *runout = stdout;          /* Dateizeiger fuer Laufzeitausgabe */
FILE *debugout = stdout;        /* Dateizeiger fuer Debugausgabe */

char fperror, abbruch, quitted; /* Flags fuer Fehler und Abbruchsituationen */

char deb_mod, more_mod, more_mod_save, ss_fast, warnings_on; /* Flags fuer Systemeinstellungen */
                      
int prot, alt_prot, ss_mod, ss_modus, ss_mod_start;   /* Systemparameter */
int more_count;                 /* Zaehlt ausgegebene Zeilen seit --MEHR-- */

int file_gelesen;               /* Flag : Programm erfolgreich gelesen */
int prot_geschrieben;           /* Flag : auf Protokolldatei wurde geschrieben */
int prot_offen = FALSE;         /* Flag : Protokolldatei ist geoeffnet */

char the_filename[270];         /* tatsaechlicher Programmdateiname */
char *home_path;                /* Inhalt der Environment-Variablen HOME */

char the_sourcename[270];       /* Name der Quelldatei */
char sourcename_gilt;           /* Flag : In the_sourcename steht ein Dateiname */
char sourcename_sicher;         /* Flag : Text in the_sourcename gilt als richtig */

/*********************************************/

void fp_err_func(), quit_func();        /* Funktionen fuer 'signal()' */
FILE *parzopen();
int getnum();

char *protname;                 /* Auf Kommandozeile angegebener Protokollname */
char the_protname[270];         /* tatsaechlicher Protokollname */

extern FILE *yyin
#                  ifndef PC
                 , *popen()
#                  endif
                           ;

extern char *getenv();

/**************************************************************************
 ***                       Funktion main
 ***
 *** Hauptprogramm fuer Parz
 *** liest UNIX-Kommandozeile von links nach rechts:
 *** Bei Optionen werden Flags gesetzt,
 *** Dateien werden den Flags entsprechend ausgefuehrt, kompiliert etc.
 ***
 **************************************************************************/

main(argc,argv)
int argc;
char *argv[];
{
#ifndef CRAY
# ifdef APOLLO
  int
# else
  void
# endif
      (*sfpalt)() = signal(SIGFPE,fp_err_func); /* Floating error umbiegen */
# ifdef APOLLO
  int
# else
  void
# endif
      (* altesigs[3])();
#endif
  register int i;
  register int starten = TRUE;
  register int filter = FALSE;
  register int filecount = 0;

#ifdef MAC
  InitGraf(&thePort);                         /*      Initialize QuickDraw  */
  console_options.title = "\pParallaxis Simulator";
  console_options.nrows = (int) (screenBits.bounds.bottom - 60) / 12;
  morelen = console_options.nrows - 2;
  console_options.ncols = 80;
  cgotoxy(1,1,stdout);
  CountAppFiles(&xmes,&xcnt);
  
  if (xcnt>0)
   { if (xmes == appPrint) fprintf(stderr,"use a word processor for printing files\n");
     else
     {  argv= (char **) calloc((size_t)(xcnt+1),(size_t)sizeof(char *));
        for (argc=1; argc <= xcnt; argc++)
        { xthefile = (AppFile *) calloc((size_t)1,(size_t)sizeof(AppFile));
          GetAppFiles(argc,xthefile);
          SetVol("\p", xthefile->vRefNum);
          PtoCstr((char *) xthefile->fName);
          argv[argc] = (char *) xthefile->fName;
        }
     }
   }
  else argc = ccommand(&argv);
#endif

#ifndef CRAY
  sigon(altesigs, quit_func);   /* Abbruchsignale umbiegen */
#endif
  uebersetzen = compile = FALSE;

  if (argc == 1)
#ifdef MAC
  /* keine Argumente, bringe FileSelectorBox, -- Thomas stuff -- */
  	{ 
  		xtopleft.h = 10; xtopleft.v = 30;
		xfilefilter[0] = 'TEXT';
		SFGetFile(xtopleft,"\p",myfilefilter,1,xfilefilter,NULL,&xreply);
		if (xreply.good)
		{ /* ATTENTION PASCAL-STRING !! convert to C-String */
			PtoCstr((char *) xreply.fName);
			SetVol(NULL,xreply.vRefNum);
					  
			argv = (char **) calloc((size_t)2,(size_t)sizeof(char**));
			argv[0] = "pz";
			argv[1] = (char *) xreply.fName;
			argc = 2;
		}
		else printhelp(texte[181]); /* keine Argumente */
  	};
#else
                 printhelp(texte[181]); /* keine Argumente */
#endif
  	
  init_first();
  /*init_op_funcs();*/
                /* Schleife ueber alle Argumente */
  for (i = 1; i < argc; i++)
  { char *arg = argv[i];

    if (*arg == '-')
                /* Argument ist Optionsmenge */
    { if (*(++arg) == 'r')
                /* Protokolloption evtl. mit Filename */
      { register int c = *(++arg);

        if (c >= '0' && c <= '2')       /* Protokollmodus */
        { prot = c - '0';
          alt_prot = prot ? prot : 1;
          arg++;
        }

        if (*arg) protname = arg;       /* Protokollname */
        else if (*(arg - 1) == 'r') prot = alt_prot = 1;    /* Protokoll kurz */
      }
      else while (*arg)
                /* keine Protokolloption am Anfang : Schleife ueber Optionen */
      { register int num;

        switch (*arg)
        {
#ifndef CRAY
          case 'l' : starten = FALSE;   /* naechstes Programm nur laden bzw. 
                                           im Kommandointerpreter bleiben */
                     arg++;
                     break;
#endif
          case 'f' : filter = TRUE;     /* von stdin lesen */
                     arg++;
                     break;
          case 'e' : ++arg;             /* Zahl der Fehlermeldungen begrenzen */
                     num = getnum(&arg);
                     if (num >= 0) fehlermax = num;
                     break;
          case 'r' : ++arg;             /* Protokollmodus waehlen */
                     num = getnum(&arg);
                     if (num > 2)
                     { fprintf(stderr,texte[1],num); }
                     else if (num >= 0)
                     { prot = num;
                       alt_prot = prot ? prot : 1;
                     }
                     else
                     { prot = alt_prot = 1; }
                     break;
          case 'd' : ++arg;             /* Debug-Modus ein/ausschalten */
                     num = getnum(&arg);
                     if (num > 1)
                     { fprintf(stderr,texte[152],num); }
                     else if (num >= 0)
                     { deb_mod = num; }
                     else
                     { deb_mod = TRUE; }
                     break;
#ifndef CRAY
          case 'm' : ++arg;             /* Bildschirmlaenge einstellen */
                     num = getnum(&arg);
                     if (!num)
                     { more_mod = more_mod_save = FALSE; }
                     else if (num > 0)
                     { more_mod = more_mod_save = TRUE;
                       morelen = num;
                     }
                     else
                     { more_mod = more_mod_save = TRUE; }
                     break;
#endif
          case 'w' : ++arg;             /* Laufzeitwarnungen ein/aus */
                     num = getnum(&arg);
                     if (num > 1)
                     { fprintf(stderr,texte[188],num); }
                     else if (num >= 0)
                     { warnings_on = num; }
                     else
                     { warnings_on = TRUE; }
                     break;
          case 'c' : ++arg;             /* Naechstes File compilieren */
                     num = getnum(&arg);
                     if (num > 1)
                     { fprintf(stderr,texte[155],num); }
                     else if (num >= 0)
                     { compile = uebersetzen = num; }
                     else
                     { compile = uebersetzen = TRUE; }
                     break;
          case 's' : ++arg;             /* Singlestep-Modus einstellen */
                     num = getnum(&arg);
                     if (num > 2)
                     { fprintf(stderr,texte[156],num); }
                     else if (num >= 0)
                     { switch(num)
                       { case 0 : ss_mod = ss_modus = ss_mod_start = 0;
                                  break;
                         case 1 : ss_mod = ss_modus = ss_mod_start = STEP_COMP;
                                  break;
                         case 2 : ss_mod = ss_modus = ss_mod_start = STEP_INTER;
                                  break;
                       }
                     }
                     else
                     { ss_mod = ss_modus = ss_mod_start = STEP_COMP; }
                     break;
          default  : printhelp(texte[192]);     /* Falsche Option */
        }
      }
    }
    else
                /* Argument ist Filename */
    { register int infoout =    /* TRUE heisst, Dateinamen ausgeben */
        (filecount++ > 0) || (i < argc - 1) || !starten || prot;

      if (filter) printhelp(texte[193]);        /* Kein Filename erlaubt */
      file_gelesen = FALSE;
      strcpy(loadfilename, arg);        /* Filename merken */
#ifdef MAC
      { register int len = strlen(loadfilename);

        if (strcmp(loadfilename + len - 4, ".xrf") == 0)
        { loadfilename[len - 3] = 'z';
          loadfilename[len - 2] = '\0';
        }
      }
#endif
      uebersetzen = compile;
      laden(uebersetzen ? DO_COMPILE : DO_LOAD, FALSE, infoout);
      protopen(protname, file_gelesen, starten, infoout);
      if (starten)
                /* Programm starten, kommt es mit Ladebefehl zurueck,
                   neues Programm laden und gleich starten */
      { register int ex, nochmal, erster_lauf = TRUE;
        register int file_gelesen_save = file_gelesen;

        do
        { if (file_gelesen || erster_lauf)
          { ex = run_prog();
            erster_lauf = FALSE;
          }
          else
          { ex = 0; }
          if (nochmal = (ex == DO_LOAD || ex == DO_COMPILE))
          { file_gelesen = FALSE;
            laden(ex, TRUE, TRUE);      /* neues Programm laden */
            if (file_gelesen) file_gelesen_save = file_gelesen;
          }
        } while (nochmal);
        file_gelesen = file_gelesen_save;
        protname = NULL;
        the_filename[0] = '\0';
      }
      else break;       /* Option -l : im Kommandointerpreter bleiben */
    }
  }     /* end for ( Parameterabarbeitung ) */

  if (filter)
                /* Programm von stdin lesen und starten */
  { the_filename[0] = '\0';
    yyin = stdin;
    more_mod = more_mod_save = FALSE;
    file_gelesen = parse(FALSE);
    protopen(protname, file_gelesen, TRUE, FALSE);
#ifndef CRAY
    sigoff(altesigs);   /* Stopsignale restaurieren */
#endif
    ss_fast = TRUE;
    run_prog();
    parzexit(0);
  }
  if (!starten)
                /* gehe in Kommandointerpreter */
  { if (!prot_offen)
    { protopen(protname, FALSE, FALSE, TRUE); }
    fputs(texte[181], stderr);
    fputs(texte[191], stderr);
    kommandoloop();
  }
#ifndef CRAY
  sigoff(altesigs);
  signal(SIGFPE,sfpalt);
#endif
  parzexit(0);          /* evtl. leeres Protokollfile loeschen */
}

/**************************************************************************
 ***                       Funktion getnum
 ***
 *** liest aus dem String '*st' eine Zahl ein und liefert sie als Ergebnis
 *** '*st' zeigt nachher hinter die eingelesene Zahl
 ***
 **************************************************************************/

int getnum(st)
char **st;
{ register int erg = 0;

  if (**st < '0' || **st > '9') return -1;
  for (; **st >= '0' && **st <= '9'; (*st)++)
  { erg = erg * 10 + **st - '0'; }
  return erg;
}

/**************************************************************************
 ***                       Funktion make_prot
 ***
 *** versucht eine Protokolldatei zu oeffnen
 *** name    : Name der zu oeffnenden Datei
 *** infoout : wenn TRUE, dann Name der geoeffneten Datei melden
 *** Ergebnis zeigt Erfolg/Misserfolg an
 *** laesst sich 'name' nicht oeffnen, so werden nacheinander folgende
 *** Dateien ausprobiert : ('end(name)' sei letzte Komponente von 'name')
 *** end(name),
 *** $HOME/end(name),
 *** $HOME/parz.rec
 *** $HOME/rec.XXXXXX          (Temporaerer eindeutiger Dateiname)
 ***
 **************************************************************************/

int make_prot(name, infoout)
char *name;
int infoout;
{ register char *np;

  if (protokollout = fopen(name,"w"))
  { if (infoout) fprintf(stderr, texte[163], name);
    strcpy(the_protname, name);
  }
  else
  { for (np = name + strlen(name); *np != '/' && np > name; np--);
    if (*np == '/') np++;
    strcpy(the_protname,np);
    if (protokollout = fopen(the_protname,"w"))
    { if (infoout) fprintf(stderr, texte[163], the_protname); }
    else
    { strcpy(the_protname, home_path);
      strcat(the_protname,"/"); strcat(the_protname,np);
      if (protokollout = fopen(the_protname,"w"))
      { if (infoout) fprintf(stderr, texte[163], the_protname); }
      else
      { strcpy(the_protname, home_path);
        strcat(the_protname, "/parz.rec");
        if (protokollout = fopen(the_protname,"w"))
        { if (infoout) fprintf(stderr, texte[163], the_protname); }
        else
        { strcpy(the_protname, home_path);
          strcat(the_protname, "/rec.XXXXXX");
          if (!(protokollout = fopen(
#                                        ifdef PC
                                     tmpnam(the_protname)
#                                        else
                                     mktemp(the_protname)
#                                        endif
                                                         , "w")))
          { if (infoout) fprintf(stderr,texte[164]); return FALSE; }
        }
      }
    }
  }
  return TRUE;
}

/**************************************************************************
 ***                       Funktion protappend
 ***
 *** ersetzt eine Standardendung von 'name' durch ".rec" bzw.
 *** haengt ".rec" an 'name' an.
 ***
 **************************************************************************/

protappend(name)
char *name;
{ char *app_point = name + strlen(name);

  if ( strcmp(app_point - 2, ".z") == 0 ||
       strcmp(app_point - 2, ".p") == 0 )
  { app_point -= 2; }
  else if ( strcmp(app_point - 4, ".pre") == 0 )
  { app_point -= 4; }
  else if ( strcmp(app_point - 5, ".parz") == 0 ||
            strcmp(app_point - 5, ".para") == 0 )
  { app_point -= 5; }
  strcpy(app_point, ".rec");
}

/**************************************************************************
 ***                       Funktion protopen
 ***
 *** schliesst (und loescht falls leer) evtl. offene Protokolldatei,
 *** oeffnet neue Protokolldatei.
 *** name      : Name der mit -r angegeben wurde (keine Angabe : NULL)
 *** parse_gut : Flag: Programm ohne Fehler eingelesen
 *** starten   : Flag: File nachher gleich starten
 *** infoout   : Flag: Filename auf Terminal melden
 ***
 **************************************************************************/

protopen(name, parse_gut, starten, infoout)
char *name;
int parse_gut, starten, infoout;
{ char pname[257];

  if (prot_offen)
  { fclose(protokollout);
    prot_offen = FALSE;
    if (!prot_geschrieben)
    { unlink(the_protname); }
  }
  if (starten)
  { if (parse_gut)      /* Nur oeffnen wenn Programm ausfuehrbar */
    { if (name)
      { prot_offen = make_prot(name,infoout); }
      else              /* kein Protokollname gewaehlt */
      { if (the_filename[0])
        { strcpy(pname,the_filename);
          protappend(pname);
        }
        else            /* lesen von stdin */
        { strcpy(pname,"stdin.rec"); }
        prot_offen = make_prot(pname,infoout);
      }
    }
  }
  else                  /* Programm nicht gleich starten */
  { if (name)
    { prot_offen = make_prot(name,infoout); }
    else                /* kein Protokollname gewaehlt */
    { if (the_filename[0])
      { strcpy(pname,the_filename);
        protappend(pname);
      }
      else              /* Kommandoebene */
      { strcpy(pname,"parz.rec"); }
      prot_offen = make_prot(pname,infoout);
    }
  }
  if (prot_offen)
  { fprintf(protokollout, texte[202], prot);
    if (file_gelesen) fprintf(protokollout, texte[203], the_filename);
    prot_geschrieben = FALSE;
  }
}

/**************************************************************************
 ***                    Funktion parzopen
 ***
 *** oeffnet Eingabedatei, Name wird aus 'fn' abgeleitet.
 *** Dateiname steht nachher in 'the_filename'.
 *** Ergebnis ist NULL bei Misserfolg
 ***
 **************************************************************************/

FILE *parzopen(fn)
char *fn;
{ register FILE *erg;

  strcpy(the_filename, fn);
  if (strcmp(fn + strlen(fn) - 2, ".z") == 0)   /* Endung ist .z */
  { erg = fopen(the_filename, "r"); }
  else
  { strcat(the_filename, ".z");                 /* Versuch mit .z */
    if (!(erg = fopen(the_filename, "r")))
    { strcpy(the_filename, fn);                 /* Versuch ohne .z */
      erg = fopen(the_filename, "r");
    }
  }
  return erg;
}

/**************************************************************************
 ***                       Funktion parallaxistry
 ***
 *** leitet aus 'fn' Dateinamen fuer Parallaxis-Quelldatei ab,
 *** schribt Dateinamen nach 'the_filename'.
 *** Ergebnis : 0: nichts gefunden, 1: X.p oder fn, -1: X.pre
 ***
 **************************************************************************/

int parallaxistry(fn)
char *fn;
{ register FILE *erg;
  register int pre = FALSE;

  strcpy(the_filename, fn);
  if (strcmp(fn + strlen(fn) - 2, ".p") == 0)           /* Endung ist .p */
  { erg = fopen(the_filename, "r"); }
  else if (strcmp(fn + strlen(fn) - 4, ".pre") == 0)    /* Endung ist .pre */
  { erg = fopen(the_filename, "r");
    if (erg) pre = TRUE;
  }
  else
  { strcat(the_filename, ".p");                 /* Versuch mit .p */
    if (!(erg = fopen(the_filename, "r")))
    { strcpy(the_filename, fn);
      strcat(the_filename, ".pre");             /* Versuch mit .pre */
      if (erg = fopen(the_filename, "r"))
      { pre = TRUE; }
      else
      { strcpy(the_filename, fn);               /* Versuch ohne Endung */
        erg = fopen(the_filename, "r");
      }
    }
  }
  if (erg) fclose(erg);                         /* Dummy schliessen */
  return erg ? (pre ? -1 : 1) : 0;
}

#ifndef CRAY
/**************************************************************************
 ***                    Funktion sigon
 ***
 *** leitet Signale QUIT, INT, TSTP auf 'quit_func' um
 ***
 **************************************************************************/

sigon(sigarr, quit_func)
#ifdef APOLLO
int
#else
void
#endif
    (* sigarr[])(), (* quit_func)();
{
#ifndef PC
  sigarr[0] = signal(SIGQUIT,quit_func);
#endif
  sigarr[1] = signal(SIGINT,quit_func);
#ifndef PC
  sigarr[2] = signal(SIGTSTP,quit_func);
#endif
}

/**************************************************************************
 ***                    Funktion sigoff
 ***
 *** setzt verbogene Signale auf urspruengliche Werte
 ***
 **************************************************************************/

sigoff(sigarr)
#ifdef APOLLO
int
#else
void
#endif
    (* sigarr[])();
{
#ifndef PC
  signal(SIGQUIT,sigarr[0]);
#endif
  signal(SIGINT,sigarr[1]);
#ifndef PC
  signal(SIGTSTP,sigarr[2]);
#endif
}

#endif

/**************************************************************************
 ***                Funktion init_first
 ***
 *** Einmalige Initialisierungen beim Start von PARZ
 ***
 **************************************************************************/

init_first()
{ srandom(time(NULL));
#ifdef PC
  if (!(yyv = (YYSTYPE *)calloc(YYMAXDEPTH, sizeof(YYSTYPE))))
  { fatal(texte[270]); parzexit(1); }
#endif
#ifndef PC
/*# if defined(HP_UX) || defined(MIPS)*/
  setvbuf(stderr, NULL, _IONBF, BUFSIZ);       /* stderr ist ungepuffert */
  setvbuf(stdout, NULL, _IONBF, BUFSIZ);       /* stdout ist ungepuffert */
/*# else*/
/*  setlinebuf(stderr);   */    /* stderr ist Zeilenweise gepuffert */
/*# endif*/
#endif
#ifdef MAC
  init_texte();
  init_debio_buffers();
  init_debio_ids();
  init_getunget();
#endif
  programm = NULL;
  stat_anz = max_lev = 0;
  pe_width = 50;
  vec_stacks = NULL;
  portarray = NULL;
  null_dlist(&glob_s_decl);
  null_dlist(&glob_v_decl);
  deb_mod = TRUE;
  prot = 0;
  alt_prot = 1;
  ss_modus = STEP_COMP;
#ifdef CRAY
  more_mod = more_mod_save = FALSE;
#else
  more_mod = more_mod_save = TRUE;
#endif
  warnings_on = TRUE;
  fperror = FALSE;
  abbruch = FALSE;
  fehlermax = FEHLERMAX;
#ifndef CRAY
#ifndef MAC
  morelen = MORELEN;
#endif
#endif
  quitted = 0;
  protname = NULL;
  home_path = getenv("HOME");
  sourcename_gilt = sourcename_sicher = FALSE;
#if defined(HP_UX) || defined(RS6000)
  init_term();
#endif
  init_breite();            /* ermittelt max. Ausgabebreite fuer int und float */
}

/**************************************************************************
 ***                       Funktion init_op_funcs
 ***
 *** belegt die relevanten Felder von 'op_funcs' mit Funktionszeigern
 ***
 **************************************************************************/

/* init_op_funcs()
{ if (!(op_funcs = (struct func_ptrs *)calloc((size_t)(ABS - ' ' + 1), 
                                              (size_t)sizeof(struct func_ptrs))))
  { fatal(texte[270]); parzexit(1); }
  op_funcs['+'-' '].do_f[0][INT] = do_si_add;
  op_funcs['+'-' '].do_f[0][REAL] = do_sr_add;
  op_funcs['+'-' '].do_f[1][INT] = do_vi_add;
  op_funcs['+'-' '].do_f[1][REAL] = do_vr_add;
  op_funcs['+'-' '].print_f = print_add;
  op_funcs['-'-' '].do_f[0][INT] = do_si_sub;
  op_funcs['-'-' '].do_f[0][REAL] = do_sr_sub;
  op_funcs['-'-' '].do_f[1][INT] = do_vi_sub;
  op_funcs['-'-' '].do_f[1][REAL] = do_vr_sub;
  op_funcs['-'-' '].print_f = print_sub;
  op_funcs['*'-' '].do_f[0][INT] = do_si_mul;
  op_funcs['*'-' '].do_f[0][REAL] = do_sr_mul;
  op_funcs['*'-' '].do_f[1][INT] = do_vi_mul;
  op_funcs['*'-' '].do_f[1][REAL] = do_vr_mul;
  op_funcs['*'-' '].print_f = print_mul;
  op_funcs['/'-' '].do_f[0][INT] = do_si_div;
  op_funcs['/'-' '].do_f[0][REAL] = do_sr_div;
  op_funcs['/'-' '].do_f[1][INT] = do_vi_div;
  op_funcs['/'-' '].do_f[1][REAL] = do_vr_div;
  op_funcs['/'-' '].print_f = print_div;
  op_funcs['~'-' '].do_f[0][INT] = do_si_minus;
  op_funcs['~'-' '].do_f[0][REAL] = do_sr_minus;
  op_funcs['~'-' '].do_f[1][INT] = do_vi_minus;
  op_funcs['~'-' '].do_f[1][REAL] = do_vr_minus;
  op_funcs['~'-' '].print_f = print_minus;
  op_funcs[MOD-' '].do_f[0][INT] = do_si_mod;
  op_funcs[MOD-' '].do_f[1][INT] = do_vi_mod;
  op_funcs[MOD-' '].print_f = print_mod;
  op_funcs[AND-' '].do_f[0][BOOL] = do_sb_and;
  op_funcs[AND-' '].do_f[1][BOOL] = do_vb_and;
  op_funcs[AND-' '].print_f = print_and;
  op_funcs[OR-' '].do_f[0][BOOL] = do_sb_or;
  op_funcs[OR-' '].do_f[1][BOOL] = do_vb_or;
  op_funcs[OR-' '].print_f = print_or;
  op_funcs[SQRT-' '].do_f[0][REAL] = do_sr_sqrt;
  op_funcs[SQRT-' '].do_f[1][REAL] = do_vr_sqrt;
  op_funcs[SQRT-' '].print_f = print_sqrt;
  op_funcs[EXP-' '].do_f[0][REAL] = do_sr_exp;
  op_funcs[EXP-' '].do_f[1][REAL] = do_vr_exp;
  op_funcs[EXP-' '].print_f = print_exp;
  op_funcs[LN-' '].do_f[0][REAL] = do_sr_ln;
  op_funcs[LN-' '].do_f[1][REAL] = do_vr_ln;
  op_funcs[LN-' '].print_f = print_ln;
  op_funcs[SIN-' '].do_f[0][REAL] = do_sr_sin;
  op_funcs[SIN-' '].do_f[1][REAL] = do_vr_sin;
  op_funcs[SIN-' '].print_f = print_sin;
  op_funcs[COS-' '].do_f[0][REAL] = do_sr_cos;
  op_funcs[COS-' '].do_f[1][REAL] = do_vr_cos;
  op_funcs[COS-' '].print_f = print_cos;
  op_funcs[TAN-' '].do_f[0][REAL] = do_sr_tan;
  op_funcs[TAN-' '].do_f[1][REAL] = do_vr_tan;
  op_funcs[TAN-' '].print_f = print_tan;
  op_funcs[ARCSIN-' '].do_f[0][REAL] = do_sr_arcsin;
  op_funcs[ARCSIN-' '].do_f[1][REAL] = do_vr_arcsin;
  op_funcs[ARCSIN-' '].print_f = print_arcsin;
  op_funcs[ARCCOS-' '].do_f[0][REAL] = do_sr_arccos;
  op_funcs[ARCCOS-' '].do_f[1][REAL] = do_vr_arccos;
  op_funcs[ARCCOS-' '].print_f = print_arccos;
  op_funcs[ARCTAN-' '].do_f[0][REAL] = do_sr_arctan;
  op_funcs[ARCTAN-' '].do_f[1][REAL] = do_vr_arctan;
  op_funcs[ARCTAN-' '].print_f = print_arctan;
  op_funcs[ARCTANT-' '].do_f[0][REAL] = do_sr_arctant;
  op_funcs[ARCTANT-' '].do_f[1][REAL] = do_vr_arctant;
  op_funcs[ARCTANT-' '].print_f = print_arctant;
  op_funcs[ABS-' '].do_f[0][INT] = do_si_abs;
  op_funcs[ABS-' '].do_f[0][REAL] = do_sr_abs;
  op_funcs[ABS-' '].do_f[1][INT] = do_vi_abs;
  op_funcs[ABS-' '].do_f[1][REAL] = do_vr_abs;
  op_funcs[ABS-' '].print_f = print_abs;
}
*/

/**************************************************************************
 ***                       Funktion ziel
 ***
 *** ermittelt Befehlsnummer zu 'lab'.
 *** lab < 0  : -lab ist Label, suche Befehl mit Label -lab
 ***            Ergebnis ist Befehlsnummer falls gefunden, sonst lab
 *** lab >= 0 : lab ist schon Befehlsnummer, Ergebnis = lab
 ***
 **************************************************************************/

int ziel(lab)
int lab;
{ if (lab < 0)
  { register STAT *s_ptr = programm;
    register int z;
    register int neglab = -lab;

    for (z = 0; z < stat_anz; z++)
    { if (STAT_label(*s_ptr++) == neglab)
        return z;
    }
    return lab;
  }
  else
    return lab;
}

/**************************************************************************
 ***                   Funktion bs
 ***
 *** fuehre 'anz' mal backspace-delete auf 'f' aus
 ***
 **************************************************************************/

bs(anz, f)
int anz;
FILE *f;
{ for (; anz > 0; anz--)
  { fputs(texte[2], f); }
}
#ifndef CRAY
/**************************************************************************
 ***                       Funktion if_more
 ***
 *** wird bei Ausgaben des Kommandointerpreters nach jeder Ausgabezeile
 *** aufgerufen und unterbricht Ausgabe jeweils nach 'morelen' Zeilen
 *** im Stil von MORE.
 *** 'f' : Ausgabefile fuer Dialog.
 ***
 **************************************************************************/

ifmore(f)
FILE *f;
{ register int incha;
  register int innum, ziffzaehl;

#if defined(HP_UX) || defined(RS6000)
  putc('\r', f);
#endif
#ifdef MAC
  ctrl_c_test();
#endif
  more_count++;                 /* Zaehler hochzaehlen */
  if (more_mod)                 /* MORE aktiviert? */
  { if (more_count >= morelen)  /* Bildschirm voll? */
    { kill_input();
      fputs(texte[189], f); fflush(f);
      innum = -1; incha = '\0'; ziffzaehl = 0;
      while (!incha)            /* Eingabeschleife */
      { while (!incha)          /* Eingabeschleife fuer Ziffern */
        { 
#ifdef PC
#  ifdef MAC
          do {incha = getchar(); } while (incha == EOF);
#  else
          incha = getch();
#  endif
#else
# ifdef HPUX
          incha = getch();
          { switch (incha)
            { case '\b' : fputs(" \b", f); fflush(f); break;
              
              default : bs(1,f); fflush(f);
            }
          }
# else
#  if (defined(RS6000) && !defined(MIPS))
          incha = getch();
          { switch (incha)
            { case '\b' : fputs("\b\b\b   \b\b\b", f); fflush(f); break;
              case '\n' : fputs("\b\b\b   \b\b\b", f); fflush(f); break;
              default : bs(1,f); fflush(f);
            }
          }
#  else
          incha = getchar();
#  endif
# endif
#endif             
          if (incha >= '0' && incha <= '9')
          { if (innum < 0 ||
                innum < (((1<<(8*sizeof(int)-1))-1) - incha + '0') / 10)
            { putc(incha, f); fflush(f);  /* echo */
              innum = (innum < 0) ? incha - '0' : innum * 10 + incha - '0';
              ziffzaehl++;
            }
            incha = '\0';       /* bereit fuer naechste Ziffer */
          }
        }
        switch (incha)          /* Befehlsbuchstabe */
        { case 'h'  :
          case 'H'  :
          case '?'  : bs(ziffzaehl, f);
                      fputs(texte[190], f);
                      print_more_help(f);
                      incha = '\0'; innum = -1; ziffzaehl = 0;
                      fputs(texte[189], f); fflush(f);
                      break;
          case 'q'  :
          case 'Q'  : bs(ziffzaehl, f);
                      fputs(texte[190], f); fflush(f);
                      more_count = 0;
                      quitted += 2;
                      break;
          case ' '  : bs(ziffzaehl, f);
                      fputs(texte[190], f);
                      more_count = 0;
                      if (innum > 0) morelen = innum;
                      break;
          case '\r':
          case '\n' :
#ifdef HP_UXXXXXX
                      fputs(texte[81], f);
                      for (; ziffzaehl > 0; ziffzaehl--, fputc(' ', f));
                      putc('\r', f); fflush(f);
#else
# if (defined(RS6000) && !defined(MIPS)) || defined(HP_UX)
                      bs(ziffzaehl + 1, f);
                      fputs(texte[190], f);
                      putc('\r', f); fflush(f);
# else
                      bs(ziffzaehl, f);
                      fputs(texte[190], f);
# endif
#endif
                      if (innum > 0) more_count = morelen - innum;
                      break;
          case '\b' :
#if defined(HPUX) || (defined(RS6000) && !defined(MIPS))
                      if (ziffzaehl)
                      { innum = (innum < 10) ? -1 : innum / 10;
                        ziffzaehl--;
                      }
                      else { putc('-', f); fflush(f); }
#else
                      if (ziffzaehl)
                      { bs(1, f);
                        innum = (innum < 10) ? -1 : innum / 10;
                        ziffzaehl--;
                      }
#endif
                      incha = '\0';
                      break;
          default   : bs(ziffzaehl, f);
                      incha = '\0'; innum = -1; ziffzaehl = 0;
        }
      }
      kill_input();
    }
  }
}
#else
ifmore(f)FILE*f;{}
#endif
/**************************************************************************
 ***                  Funktionen sign, lsign
 ***
 *** liefert Vorzeichen von 'n': -1, 0, 1 fuer <, =, > 0
 ***
 **************************************************************************/

int sign(n)
register int n;
{return n ? (n < 0 ? -1 : 1) : 0;}

long lsign(n)
register long n;
{return n ? (n < 0 ? -1l : 1l) : 0l;}

#ifndef CRAY
/**************************************************************************
 ***               Funktion fp_err_func
 ***
 *** wird bei floating-point-exception aufgerufen, setzt 'fperror'
 ***
 **************************************************************************/

void fp_err_func(sig)
int sig;
{ fperror = TRUE;
  signal(sig,fp_err_func);
}

/**************************************************************************
 ***                       Funktion quit_func
 ***
 *** wird bei Programmabbruch aufgerufen, zaehlt 'quitted' hoch
 ***
 **************************************************************************/

void quit_func(sig)
int sig;
{ signal(sig,quit_func);
  quitted++;
}
#endif

/**************************************************************************
 ***                       Funktion parzexit
 ***
 *** ersetzt 'exit(ex)', loescht zusaetzlich Protokolldatei, falls
 *** nichts protokolliert wurde.
 ***
 **************************************************************************/

parzexit(ex)
int ex;
{ if (prot_offen)
  { fclose(protokollout);
    if (!prot_geschrieben)
    { unlink(the_protname); }
  }
#if defined(HP_UX) || defined(RS6000)
  end_term();
#endif
  exit(ex);
}
