/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : mem.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.mem.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:56        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Debug-Versionen der Speicherverwaltungsfunktionen fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)mem.c	1.3  9/27/93 PARZ - General (Frank Sembach)";


#include <stdio.h>
#ifdef YYDEBUG
extern int yydebug;
#endif

#ifdef PC
#  include <stdlib.h>
#else
#  define size_t unsigned
#  if defined(RS6000) && !defined(MIPS)
extern void *pscalloc(), *psmalloc();
#    define calloc pscalloc
#    define malloc psmalloc
#  else
extern char *calloc(), *malloc();
#  endif
extern char *realloc();
extern void free();
#endif

#ifdef YYDEBUG

char *my_calloc(nelem,elsize)
size_t nelem,elsize;
{ char *erg;

  if (yydebug) printf("calloc : %u Bytes, ",nelem * elsize);
  erg = calloc(nelem,elsize);
  if (yydebug) printf("Ergebnis : %u\n",erg);
  return erg;
}

char *my_realloc(ptr,size)
char *ptr;
size_t size;
{ char *erg;

  if (yydebug) printf("realloc : alter Zeiger =  %u, %u Bytes, ",ptr,size);
  erg = realloc(ptr,size);
  if (yydebug) printf("Ergebnis : %u\n",erg);
  return erg;
}

void my_free(ptr)
char *ptr;
{ if (yydebug) printf("free : Zeiger = %u, ",ptr);
  free(ptr);
  if (yydebug) printf("fertig\n");
}

char *my_malloc(size)
size_t size;
{ char *erg;

  if (yydebug) printf("malloc : %u Bytes, ",size);
  erg = malloc(size);
  if (yydebug) printf("Ergebnis : %u\n",erg);
  return erg;
}

#endif
