/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : message.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.message.c
  Version      : 1.3 
  Last changed : 9/27/93 at 14:04:58        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Meldungen

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)message.c	1.3  9/27/93 PARZ - General (Frank Sembach)";


#include "parzdefs.h"

#define VARARG fmt,v1,v2,v3,v4,v5,v6
#define VARPARM (VARARG) char *fmt;

extern STAT *programm;          /* Programmtext */
extern int pc, pec, pe_anz;     /* Programmzaehler, PE-Zaehler, PE-Anzahl */
extern ZEILTAB *akt_line;       /* aktueller Quellzeileneintrag */
extern char err;                /* Fehler ist aufgetreten */
extern char abbruch;            /* fataler Fehler ist aufgetreten */
extern char vec_bef;            /* ausgefuehrter Befehl war Vektorbefehl */
extern
#ifdef RS6000
       signed
#endif
              char parse_start; /* Unterscheidung Programm/Kommando-Modi */
extern char im_programm;        /* Programmausfuehrung laeuft */
extern char warnings_on;        /* Warnungen werden ausgegeben */
extern char quitted;            /* Flag fuer Ausgabeabbruch */
extern FILE *yyerfp;            /* Fehlerausgabestream */
extern FILE *kommandout;        /* Kommandoausgabestream */
extern FILE *runout;            /* Laufzeitausgabestream */
extern int fehlermax;           /* Begrenzung der Zahl der Meldungen */
extern int anz_meldungen, anz_fehler, anz_runwarnings;/* Anzahl ausgeg. Meldungen */
extern int yynerrs;             /* Fehlerzaehler des Parsers */
extern int more_count;          /* Anzahl ausgegebene Zeilen seit --MEHR-- */
#ifdef MAC
extern char **texte;
#else
extern char *texte[];           /* Fehlertexte */
#endif
extern char no_linefeed;        /* Flag : Ausgabezeile noch nicht fertig */
extern int sym_debugging;       /* Flag: symbolisches Debuggen */
int fehler_zahl = 1;            /* Anzahl der Aufrufe von 'fehler()'
                                   (zum Vergleich mit 'yynerrs') */

message VARPARM
{ yywhere(0);
  fprintf(yyerfp, VARARG);
  putc('\n',yyerfp);
}

sem_message VARPARM
{ yywhere(1);
  fprintf(yyerfp, VARARG);
  putc('\n',yyerfp);
}

run_message VARPARM
{ fprintf(yyerfp, VARARG);
  if (pc >= 0 && im_programm && !sym_debugging)
  { fprintf(yyerfp,texte[244]);
    more_count = 2;
    list_stat(programm + pc, "", yyerfp);
    if (akt_line)
    { register int i, j;

      fprintf(yyerfp, texte[234], i = akt_line->source_line);
      if (j = akt_line->stat_in_line) fprintf(yyerfp, texte[298], j);
      putc('\n', yyerfp); ifmore(yyerfp);
      if (!quitted) source_out(i, yyerfp);
    }
    if (!quitted && vec_bef && pec < pe_anz)
    {  fprintf(yyerfp, texte[245], pec + 1); }
  }
  else
  { putc('\n', yyerfp); }
  more_count = 0;
}

kom_message VARPARM
{ fprintf(yyerfp, VARARG);
  if (!quitted && vec_bef && pec < pe_anz)
  { fprintf(yyerfp, texte[245], pec + 1); ifmore(yyerfp); }
  else
  { putc('\n', yyerfp); ifmore(yyerfp); }
}

error VARPARM
{ if (anz_meldungen == fehlermax)
  { fputs(texte[116], yyerfp);
    anz_meldungen++; anz_fehler++;
  }
  else if (anz_fehler++, anz_meldungen++ < fehlermax)
  { fprintf(yyerfp, (parse_start == -1) ? texte[243] : texte[242], ++yynerrs);
    message(VARARG);
  }
}

sem_error VARPARM
{ if (anz_meldungen == fehlermax)
  { fputs(texte[116], yyerfp);
    anz_meldungen++; anz_fehler++;
  }
  else if (anz_fehler++, anz_meldungen++ < fehlermax)
  { fprintf(yyerfp, (parse_start == -1) ? texte[243] : texte[242], ++yynerrs);
    sem_message(VARARG);
  }
}

runerr VARPARM
{ if (no_linefeed && runout == stdout)
  { putc('\n', runout); no_linefeed = FALSE; }
  fputs((pc >= 0 && im_programm && !sym_debugging) ? texte[246] : texte[247], yyerfp);
  run_message(VARARG);
  err = TRUE;
  if (sym_debugging)
  { anz_fehler++; anz_meldungen++; }
}

komerr VARPARM
{ fputs(texte[247], kommandout);
  fprintf(kommandout, VARARG);
  putc('\n', kommandout);
  anz_fehler++; anz_meldungen++;
}

warning VARPARM
{ if (anz_meldungen == fehlermax)
  { fputs(texte[116], yyerfp);
    anz_meldungen++;
  }
  else if (anz_meldungen++ < fehlermax)
  { fputs(texte[248],yyerfp);
    message(VARARG);
  }
}

sem_warning VARPARM
{ if (anz_meldungen == fehlermax)
  { fputs(texte[116], yyerfp);
    anz_meldungen++;
  }
  else if (anz_meldungen++ < fehlermax)
  { fputs(texte[248],yyerfp);
    sem_message(VARARG);
  }
}

runwarn VARPARM
{ if (warnings_on)
  { if (no_linefeed && runout == stdout)
    { putc('\n', runout); no_linefeed = FALSE; }
    if (anz_runwarnings == fehlermax)
    { fputs(texte[185], yyerfp);
      anz_runwarnings++;
    }
    else if (anz_runwarnings++ < fehlermax)
    { fputs(texte[249],yyerfp);
      run_message(VARARG);
    }
  }
}

komwarn VARPARM
{ if (warnings_on)
  { if (anz_runwarnings == fehlermax)
    { fputs(texte[185], yyerfp); more_count++; ifmore(yyerfp);
      anz_runwarnings++;
    }
    else if (anz_runwarnings++ < fehlermax)
    { fputs(texte[248],yyerfp);
      kom_message(VARARG);
    }
  }
}

fatal VARPARM
{ fputs(texte[250],yyerfp);
  message(VARARG);
  yynerrs++; fehler_zahl++; abbruch = TRUE;
}

bug VARPARM
{ fputs(texte[251],yyerfp);
  message(VARARG);
  parzexit(1);
}

fehler VARPARM
{ if (fehler_zahl <= yynerrs)
  { fputs("   ",yyerfp);
    fprintf(yyerfp,VARARG);
    fputs("\n",yyerfp);
    fehler_zahl++;
  }
}
