
# line 2 "parz.y"
/******* Datei parz.y ******
 *
 *      Parser fuer PARZ V2.x
 *      Frank Sembach
 */

#include "parzdefs.h"
#include "komdefs.h"


# line 13 "parz.y"
typedef union 
 { long int_val;
   float real_val;
   unsigned char char_val;
   char *string_val;
   char *bitstring_val;
   char *comment;
   DECLIST decl_def;
   UNION_LIST union_def;
   TYP typ_def;
   ARG arg_def;
   CONLIST *conlist_ptr;
   RANGE range_val;
   MEMDECLIST memdeclist_val;
   RANGELIST *memlist_val;
   OPTPROC optproc_val;
   SCOPETAB *procidlist_val;
   long ident_key;
   ZEILE zeil_list;
   EXPRLIST exprlist_info;
   EXPR expr_info;
   SEXPR sexpr_info;
   SELECT select_info;
   EXPR_RANGE set_range;
 } YYSTYPE;
# define PLUS 257
# define MINUS 258
# define UMINUS 259
# define MAL 260
# define DURCH 261
# define MOD 262
# define SQRT 263
# define EXP 264
# define LN 265
# define SIN 266
# define COS 267
# define TAN 268
# define ARCSIN 269
# define ARCCOS 270
# define ARCTAN 271
# define ARCTANT 272
# define ABS 273
# define AND 274
# define OR 275
# define FIRST 276
# define LAST 277
# define SUM 278
# define PRODUCT 279
# define MAX 280
# define MIN 281
# define PROGRAMMSTART 282
# define KOMMANDOSTART 283
# define INTNUM 284
# define INTKLAM 285
# define REALNUM 286
# define CHAR 287
# define STRING 288
# define BITSTRING 289
# define EQ 290
# define NE 291
# define LT 292
# define LE 293
# define GT 294
# define GE 295
# define AOP 296
# define NIL 297
# define MYTRUE 298
# define MYFALSE 299
# define TERMS 300
# define EOL 301
# define MAXTRANS 302
# define ACTTRANS 303
# define DONE 304
# define TERMCH 305
# define SRESULT 306
# define ID 307
# define VRESULT 308
# define START 309
# define PE 310
# define PORTS 311
# define STOP 312
# define TO 313
# define SCALAR 314
# define VECTOR 315
# define RETURN 316
# define HALT 317
# define END 318
# define ADDR 319
# define NEW 320
# define NOT 321
# define STATUS 322
# define RANDOM 323
# define MOVE 324
# define EQUAL 325
# define AS 326
# define CONNECT 327
# define BICONNECT 328
# define AT 329
# define DISCONNECT 330
# define STRCMP 331
# define SIZE 332
# define IF 333
# define WHILE 334
# define CALL 335
# define GOTO 336
# define READ 337
# define WRITE 338
# define DRAW 339
# define WRITELN 340
# define LOAD 341
# define WITH 342
# define STORE 343
# define REDUCE 344
# define OF 345
# define PUSHS 346
# define PUSHV 347
# define POPS 348
# define POPV 349
# define PROC 350
# define PARALLEL 351
# define PROPAGATE 352
# define OUT 353
# define IN 354
# define SEND 355
# define RECEIVE 356
# define FROM 357
# define CONNECTED 358
# define NOP 359
# define B 360
# define C 361
# define I 362
# define R 363
# define U 364
# define S 365
# define V 366
# define OPENINPUT 367
# define OPENOUTPUT 368
# define CLOSEINPUT 369
# define CLOSEOUTPUT 370
# define GETPIXEL 371
# define OPENW 372
# define OPENABSW 373
# define MOVETO 374
# define LINETO 375
# define SETPIXEL 376
# define WSIZE 377
# define SETCOLOR 378
# define SELECTW 379
# define CLOSEW 380
# define ERROR 381
# define DEBUG 382
# define TRACE 383
# define NOTRACE 384
# define INITSET 385
# define ZEILEND 386
# define PP 387
# define LIST 388
# define CONNECTIONS 389
# define PATTERN 390
# define STRINGMATCH 391
# define GO 392
# define STEP 393
# define SET 394
# define OVER 395
# define ALL 396
# define COMPILER 397
# define INTERPRETER 398
# define FILENAME 399
# define ASSIGN 400
# define BREAKPOINT 401
# define EXAMINE 402
# define EIN 403
# define AUS 404
# define RECORD 405
# define KURZ 406
# define LANG 407
# define SHOW 408
# define MEMORY 409
# define HEAP 410
# define PARSTACK 411
# define CALLSTACK 412
# define CHAIN 413
# define ACTIVITY 414
# define VARIABLE 415
# define SPECIALS 416
# define DEPTH 417
# define WARN 418
# define CALLS 419
# define MODE 420
# define WIDTH 421
# define QUIT 422
# define HELP 423
# define IDENT 424
# define DIV 425
# define POWER 426

# line 133 "parz.y"
/*********************************************/
#include "externs.h"
#include "rundefs.h"
#include "runexts.h"
#include "komexts.h"
#include "debexts.h"
#include "funcs.h"

/* externs aus parz.l :  */
extern char *lies_comm(), *lies_zend();

extern char ausgeben;       /* Flag : Naechste Fehlermeldung ausgeben */
extern char bef_lesen;      /* Flag : Befehlstoken erwartet (Kommandointerp. ) */

extern FILE *yyin;          /* Eingabefile */
extern FILE *yyerfp;        /* File fuer Fehlermeldungen */
extern int yylineno;        /* Zeilenzaehler */
extern int anz_runwarnings; /* Zahl der ausgegebenen Warnungen zu einem SET-Kommando */

/*********************************************/

extern int yynerrs;         /* Zaehler fuer Fehlermeldungen */
#ifdef YYDEBUG
extern int yydebug;
#endif

extern char lesend, nospez;        /* Art des naechsten Zugriffs auf eine Variable */

extern char do_step;           /* parser hat "#\n" zurueckgegeben */
extern char scanner_fehler;    /* scanner hat in Zeile Fehler gemeldet */

extern int flags;                      /* Information ueber gelesene Schluesselworte */
extern int nach_end;                   /* Zaehlt Befehle nach dem letzten END-Befehl */
extern int last_label;                 /* letztes gelesenes Label */
extern int akt_max;                    /* maximale verfuegbare Programmadresse */

#define HEAP_ADRS 1
#define VEC_ADRS 2
extern char adrsort;                   /* Art der Adressen fuer memel */

extern STAT *stat_ptr;                 /* Zeiger auf momentan erzeugten Befehl */

extern struct func_ptrs
{ int (* do_f[2][REAL + 1])();
  int (* print_f)();
} op_funcs[OR - PLUS + 1];

extern struct
{ int (* do_rf[2])(), (* print_rf)();
} rel_op_funcs[GE - EQ + 1];

extern int (* assign_do_funcs[2][REAL + 1][STR + 1])();

extern int (* random_do_funcs[2][STR + 1])();

extern int (* strcmp_do_funcs[2][STR + 1][STR + 1])();

extern int (* red_do_funcs[STR + 1][MIN - AND + 1])();

extern int (* read_do_funcs[2][REAL + 1])();

extern int (* write2_do_funcs[2][STR + 1])();

extern int (* draw2_do_funcs[STR + 1])();

extern int (* writeln2_do_funcs[2][STR + 1])();

extern int red_typs[MIN - AND + 1];

extern AKTBLOCK *temp_a_block;         /* Zeiger auf Aktivierungsblock,
                                   der bei symbolischem Debuggen erzeugt wird 
                                   und von PROC vervollstaendigt werden muss */

extern char *ssstr[];           /* Texte fuer Singlestep-/Breakpointmodus */
extern char *protstr[];         /* Texte fuer Protokollmodus */

extern char *promptstr[2];

extern int graph_bef_exist;

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
extern YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 4085 "parz.y"

extern char * yydisplay();

extern DECL *neu_decl();
extern DECLIST *dlptr();
extern yytabelem yyexca[];

# define YYNPROD 504
# define YYLAST 1043
extern yytabelem yyact[];

extern yytabelem yypact[];

extern yytabelem yypgo[];

extern yytabelem yyr1[];

extern yytabelem yyr2[];

extern yytabelem yychk[];

extern yytabelem yydef[];

typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

extern yytoktype yytoks[];


extern char * yyreds[];

#endif /* YYDEBUG */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1,9021 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
extern int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
extern YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
extern int yys[ YYMAXDEPTH ];		/* state stack */

extern YYSTYPE *yypv;			/* top of value stack */
extern YYSTYPE *yypvt;			/* top of value stack for $vars */
extern int *yyps;			/* top of state stack */

extern int yystate;			/* current state */
extern int yytmp;			/* extra var (lasts between blocks) */

extern int yynerrs;			/* number of errors */
extern int yyerrflag;			/* error recovery flag */
extern int yychar;			/* current input token number */


extern int yyparse3();
/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse2(yytmp,yypvt)

int yytmp;
YYSTYPE *yypvt;
{

		switch(yytmp){

case 140:
# line 1038 "parz.y"
{ STAT_dscal(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                            } /*NOTREACHED*/ break;
case 141:
# line 1041 "parz.y"
{ STAT_dscal(*stat_ptr) = dlptr(NULL);
                            } /*NOTREACHED*/ break;
case 142:
# line 1045 "parz.y"
{ STAT_dvec(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                            } /*NOTREACHED*/ break;
case 143:
# line 1048 "parz.y"
{ STAT_dvec(*stat_ptr) = dlptr(NULL);
                            } /*NOTREACHED*/ break;
case 144:
# line 1052 "parz.y"
{ funcs(do_pushs, print_pushs);
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { sem_error(texte[46]);
                        fehler(texte[47]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 145:
# line 1061 "parz.y"
{ funcs((ARG_argsort(yypvt[-0].arg_def) & VEC) ? do_v_pushv : do_s_pushv,
                            print_pushv);
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 146:
# line 1067 "parz.y"
{ funcs((ARG_argsort(yypvt[-0].arg_def) & VEC) ? do_v_pops : do_s_pops,
                        print_pops);
                  STAT_verg(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 147:
# line 1072 "parz.y"
{ funcs(do_popv, print_popv);
                  if (!(ARG_argsort(yypvt[-0].arg_def) & VEC))
                  { ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                    sem_error(texte[48]);
                    fehler(texte[49]);
                  }
                  STAT_verg(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 148:
# line 1082 "parz.y"
{ funcs(do_parbit, print_parbit);
                      STAT_parbits(*stat_ptr) = yypvt[-0].bitstring_val;
                      if (strlen(yypvt[-0].bitstring_val) != pe_anz)
                      { error(texte[54]);
                        fehler(texte[55]);
                      }
                    } /*NOTREACHED*/ break;
case 149:
# line 1090 "parz.y"
{ if (ARG_argsort(yypvt[-0].arg_def) & (VEC | ADS | ADV | CON | SPEZ))
                      { error(texte[54]);
                        fehler(texte[56]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      funcs(do_parvar, print_parvar);
                      typ1_test(&yypvt[-0].arg_def,(1<<BOOL));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 150:
# line 1101 "parz.y"
{ funcs(do_inconnected, print_inconnected);
                      port_nr_test(&yypvt[-0].arg_def);
                      STAT_cin_port(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 151:
# line 1106 "parz.y"
{ funcs(do_line_inconnected, print_line_inconnected);
                      port_nr_test(&yypvt[-2].arg_def);
                      STAT_cin_port(*stat_ptr) = yypvt[-2].arg_def;
                      port_nr_test(&yypvt[-0].arg_def);
                      STAT_out_port(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 152:
# line 1113 "parz.y"
{ funcs(do_outconnected, print_outconnected);
                      port_nr_test(&yypvt[-0].arg_def);
                      STAT_out_port(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 153:
# line 1118 "parz.y"
{ funcs(do_line_outconnected, print_line_outconnected);
                      port_nr_test(&yypvt[-2].arg_def);
                      STAT_out_port(*stat_ptr) = yypvt[-2].arg_def;
                      port_nr_test(&yypvt[-0].arg_def);
                      STAT_cin_port(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 154:
# line 1126 "parz.y"
{ funcs(do_propagate, print_propagate);
                      if ( ( ARG_argsort(yypvt[-2].arg_def) & (ADS | ADV | CON | SPEZ) ) ||
                           !(ARG_argsort(yypvt[-2].arg_def) & VEC) )
                      { sem_error(texte[57]);
                        fehler(texte[58]);
                        ARG_argsort(yypvt[-2].arg_def) |= FALSCH;
                      }
                      STAT_vc1(*stat_ptr) = yypvt[-2].arg_def;
                      port_nr_test(&yypvt[-0].arg_def);
                      STAT_out_port(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 155:
# line 1138 "parz.y"
{ port_nr_test(&yypvt[-0].arg_def);
                      STAT_in_port(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 156:
# line 1142 "parz.y"
{ if (!(ARG_argsort(yypvt[-1].arg_def) & VEC))
                      { sem_error(texte[57]);
                        fehler(texte[82]);
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      typ2_test(&yypvt[-1].arg_def, &yypvt[-4].arg_def, yypvt[-0].int_val > 0 ? red_typs[(int)yypvt[-0].int_val - AND]
                                                 : (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                      STAT_vc1(*stat_ptr) = yypvt[-4].arg_def;
                      STAT_verg(*stat_ptr) = yypvt[-1].arg_def;
                      switch ((int)lsign(yypvt[-0].int_val))
                      { case -1 :
                          { register int z;

                            STAT_red_fct(*stat_ptr) = z = ziel((int)yypvt[-0].int_val);
                            funcs(do_redproc_propagate, print_redproc_propagate);
                            if (z >= 0)
                            { if (STAT_print_func(programm[z]) != print_proc)
                              { sem_error(texte[31]);
                                fehler(texte[42]);
                              }
                            }
                          }
                          break;
                        case 0  : STAT_red_fct(*stat_ptr) = AND - 1;
                                  funcs(do_to_propagate, print_to_propagate);
                                  break;
                        case 1  : STAT_red_fct(*stat_ptr) = (int)yypvt[-0].int_val;
                                  funcs(do_to_propagate, print_to_propagate);
                                  break;
                      }
                    } /*NOTREACHED*/ break;
case 157:
# line 1175 "parz.y"
{ if (!(ARG_argsort(yypvt[-1].arg_def) & VEC))
                  { sem_error(texte[271]);
                    fehler(texte[82]);
                    ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                  }
                  typ2_test(&yypvt[-1].arg_def, &yypvt[-4].arg_def, yypvt[-0].int_val > 0 ? red_typs[(int)yypvt[-0].int_val - AND]
                                             : (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = yypvt[-4].arg_def;
                  STAT_verg(*stat_ptr) = yypvt[-1].arg_def;
                  switch ((int)lsign(yypvt[-0].int_val))
                  { case -1 :
                      { register int z;

                        STAT_red_fct(*stat_ptr) = z = ziel((int)yypvt[-0].int_val);
                        funcs(do_redproc_send, print_redproc_send);
                        if (z >= 0)
                        { if (STAT_print_func(programm[z]) != print_proc)
                          { sem_error(texte[31]);
                            fehler(texte[42]);
                          }
                        }
                      }
                      break;
                    case 0  : STAT_red_fct(*stat_ptr) = AND - 1;
                              funcs(do_send, print_send);
                              break;
                    case 1  : STAT_red_fct(*stat_ptr) = (int)yypvt[-0].int_val;
                              funcs(do_send, print_send);
                              break;
                  }
                } /*NOTREACHED*/ break;
case 158:
# line 1208 "parz.y"
{ if (!(ARG_argsort(yypvt[-4].arg_def) & VEC))
                  { sem_error(texte[272]);
                    fehler(texte[82]);
                    ARG_argsort(yypvt[-4].arg_def) |= FALSCH;
                  }
                  typ2_test(&yypvt[-4].arg_def, &yypvt[-1].arg_def, yypvt[-0].int_val > 0 ? red_typs[(int)yypvt[-0].int_val - AND]
                                             : (1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                  STAT_verg(*stat_ptr) = yypvt[-4].arg_def;
                  switch ((int)lsign(yypvt[-0].int_val))
                  { case -1 :
                      { register int z;

                        STAT_red_fct(*stat_ptr) = z = ziel((int)yypvt[-0].int_val);
                        funcs(do_redproc_receive, print_redproc_receive);
                        if (z >= 0)
                        { if (STAT_print_func(programm[z]) != print_proc)
                          { sem_error(texte[31]);
                            fehler(texte[42]);
                          }
                        }
                      }
                      break;
                    case 0  : STAT_red_fct(*stat_ptr) = AND - 1;
                              funcs(do_receive, print_receive);
                              break;
                    case 1  : STAT_red_fct(*stat_ptr) = (int)yypvt[-0].int_val;
                              funcs(do_receive, print_receive);
                              break;
                  }
                } /*NOTREACHED*/ break;
case 159:
# line 1241 "parz.y"
{ yyval.int_val = yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 160:
# line 1243 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 161:
# line 1246 "parz.y"
{ if ( ( ARG_argsort(yypvt[-0].arg_def) & (ADS | ADV | CON) ) ||
                       !(ARG_argsort(yypvt[-0].arg_def) & VEC) )
                  { error(texte[85]);
                    fehler(texte[86]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 162:
# line 1254 "parz.y"
{ if (ARG_argsort(yypvt[-0].arg_def) & (VEC | ADS | ADV | CON))
                  { error(texte[85]);
                    fehler(texte[87]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 163:
# line 1261 "parz.y"
{ (int)yypvt[-0].int_val ? funcs(do_blockload, print_blockload)
                          : funcs(do_load, print_load);
                  typ2_test(&yypvt[-6].arg_def,&yypvt[-2].arg_def,(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = yypvt[-2].arg_def;
                  STAT_verg(*stat_ptr) = yypvt[-6].arg_def;
                } /*NOTREACHED*/ break;
case 164:
# line 1269 "parz.y"
{ if ( ( ARG_argsort(yypvt[-0].arg_def) & (ADS | ADV | CON) ) ||
                       !(ARG_argsort(yypvt[-0].arg_def) & VEC) )
                  { error(texte[88]);
                    fehler(texte[86]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 165:
# line 1277 "parz.y"
{ if (ARG_argsort(yypvt[-0].arg_def) & (VEC | ADS | ADV | CON))
                  { error(texte[88]);
                    fehler(texte[87]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 166:
# line 1284 "parz.y"
{ (int)yypvt[-0].int_val ? funcs(do_blockstore, print_blockstore)
                          : funcs(do_store, print_store);
                  typ2_test(&yypvt[-2].arg_def,&yypvt[-6].arg_def,(1<<BOOL | 1<<CHA | 1<<INT | 1<<REAL));
                  STAT_vc1(*stat_ptr) = yypvt[-6].arg_def;
                  STAT_verg(*stat_ptr) = yypvt[-2].arg_def;
                } /*NOTREACHED*/ break;
case 167:
# line 1292 "parz.y"
{ yyval.int_val = 0l;
                      if (yypvt[-0].int_val < 1l || yypvt[-0].int_val > (long)pe_anz)
                      { sem_error(texte[63], (int)yypvt[-0].int_val); fehler_zahl++;
                        STAT_pe_nr(*stat_ptr) = yypvt[-0].int_val ? -(int)yypvt[-0].int_val : pe_anz + 1;
                      }
                      else
                      { STAT_pe_nr(*stat_ptr) = (int)yypvt[-0].int_val;
                      }
                    } /*NOTREACHED*/ break;
case 168:
# line 1302 "parz.y"
{ yyval.int_val = 1l;
                      STAT_dload(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                    } /*NOTREACHED*/ break;
case 169:
# line 1306 "parz.y"
{ yyval.int_val = 0l;
                      STAT_pe_nr(*stat_ptr) = 0;
                    } /*NOTREACHED*/ break;
case 170:
# line 1311 "parz.y"
{ if ( ( ARG_argsort(yypvt[-0].arg_def) & (ADS | ADV | CON) ) ||
                       !(ARG_argsort(yypvt[-0].arg_def) & VEC) )
                  { error(texte[31]);
                    fehler(texte[89]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                  if ((int)yypvt[-2].int_val > 0)
                  { STAT_red_fct(*stat_ptr) = (int)yypvt[-2].int_val;
                    funcs(red_do_funcs[ARG_typ(yypvt[-0].arg_def)][(int)yypvt[-2].int_val - AND], print_op_reduce);
                  }
                  else
                  { register int z;

                    STAT_red_fct(*stat_ptr) = z = ziel((int)yypvt[-2].int_val);
                    funcs(do_proc_reduce, print_proc_reduce);
                    if (z >= 0)
                    { if (STAT_print_func(programm[z]) != print_proc)
                      { sem_error(texte[31]);
                        fehler(texte[42]);
                      }
                    }
                  }
                } /*NOTREACHED*/ break;
case 171:
# line 1336 "parz.y"
{ yyval.int_val = (long)AND; } /*NOTREACHED*/ break;
case 172:
# line 1337 "parz.y"
{ yyval.int_val = (long)OR; } /*NOTREACHED*/ break;
case 173:
# line 1338 "parz.y"
{ yyval.int_val = (long)FIRST; } /*NOTREACHED*/ break;
case 174:
# line 1339 "parz.y"
{ yyval.int_val = (long)LAST; } /*NOTREACHED*/ break;
case 175:
# line 1340 "parz.y"
{ yyval.int_val = (long)SUM; } /*NOTREACHED*/ break;
case 176:
# line 1341 "parz.y"
{ yyval.int_val = (long)PRODUCT; } /*NOTREACHED*/ break;
case 177:
# line 1342 "parz.y"
{ yyval.int_val = (long)MAX; } /*NOTREACHED*/ break;
case 178:
# line 1343 "parz.y"
{ yyval.int_val = (long)MIN; } /*NOTREACHED*/ break;
case 179:
# line 1344 "parz.y"
{ yyval.int_val = -yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 180:
# line 1347 "parz.y"
{ funcs(read_do_funcs[sign(ARG_argsort(yypvt[-0].arg_def) & VEC)][ARG_typ(yypvt[-0].arg_def)],
                        print_read);
                  STAT_verg(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 181:
# line 1352 "parz.y"
{ funcs(ARG_argsort(yypvt[-2].arg_def) & VEC ? do_vread_string
                                              : do_sread_string,
                        print_read_string);
                  typ1_test(&yypvt[-2].arg_def,(1<<CHA));
                  if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[130]);
                    fehler(texte[132]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-0].arg_def,(1<<INT));
                  STAT_verg(*stat_ptr) = yypvt[-2].arg_def;
                  STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 182:
# line 1367 "parz.y"
{ funcs(ARG_argsort(yypvt[-0].arg_def) & VEC ? do_v1_write : do_s1_write,
                        print_1_write);
                  STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 183:
# line 1372 "parz.y"
{ funcs(write2_do_funcs[sign(ARG_argsort(yypvt[-1].arg_def) & VEC)]
                                       [ARG_typ(yypvt[-1].arg_def)],
                        print_2_write);
                  typ1_test(&yypvt[-1].arg_def,(1<<CHA | 1<<INT | 1<<REAL));
                  if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[133]);
                    fehler(texte[135]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-0].arg_def,(1<<INT));
                  STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                  STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 184:
# line 1386 "parz.y"
{ funcs(ARG_argsort(yypvt[-2].arg_def) & VEC ? do_vr3_write : do_sr3_write,
                        print_3_write);
                  typ1_test(&yypvt[-2].arg_def,(1<<REAL));
                  if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                  { sem_error(texte[133]);
                    fehler(texte[135]);
                    ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-1].arg_def,(1<<INT));
                  if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[133]);
                    fehler(texte[136]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-0].arg_def,(1<<INT));
                  STAT_vc1(*stat_ptr) = yypvt[-2].arg_def;
                  STAT_vc2(*stat_ptr) = yypvt[-1].arg_def;
                  STAT_vc3(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 185:
# line 1406 "parz.y"
{ funcs(ARG_argsort(yypvt[-0].arg_def) & VEC ? do_v1_writeln : do_s1_writeln,
                        print_1_writeln);
                  STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 186:
# line 1411 "parz.y"
{ funcs(writeln2_do_funcs[sign(ARG_argsort(yypvt[-1].arg_def) & VEC)]
                                         [ARG_typ(yypvt[-1].arg_def)],
                        print_2_writeln);
                  typ1_test(&yypvt[-1].arg_def,(1<<CHA | 1<<INT | 1<<REAL));
                  if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[137]);
                    fehler(texte[135]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-0].arg_def,(1<<INT));
                  STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                  STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 187:
# line 1425 "parz.y"
{ funcs(ARG_argsort(yypvt[-2].arg_def) & VEC ? do_vr3_write : do_sr3_writeln,
                        print_3_writeln);
                  typ1_test(&yypvt[-2].arg_def,(1<<REAL));
                  if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                  { sem_error(texte[137]);
                    fehler(texte[135]);
                    ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-1].arg_def,(1<<INT));
                  if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[137]);
                    fehler(texte[136]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-0].arg_def,(1<<INT));
                  STAT_vc1(*stat_ptr) = yypvt[-2].arg_def;
                  STAT_vc2(*stat_ptr) = yypvt[-1].arg_def;
                  STAT_vc3(*stat_ptr) = yypvt[-0].arg_def;
                } /*NOTREACHED*/ break;
case 188:
# line 1446 "parz.y"
{ if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[134]);
		    fehler(texte[131]);
		    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
		  }
		  funcs(do_s1_draw, print_1_draw);
                  STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                  graph_bef_exist = TRUE;
                } /*NOTREACHED*/ break;
case 189:
# line 1456 "parz.y"
{ if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                  { sem_error(texte[134]);
		    fehler(texte[131]);
		    ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
		  }
		  funcs(draw2_do_funcs[ARG_typ(yypvt[-1].arg_def)], print_2_draw);
                  typ1_test(&yypvt[-1].arg_def, (1<<CHA | 1<<INT | 1<<REAL));
                  if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[134]);
                    fehler(texte[135]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-0].arg_def,(1<<INT));
                  STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                  STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                  graph_bef_exist = TRUE;
                } /*NOTREACHED*/ break;
case 190:
# line 1474 "parz.y"
{ if (ARG_argsort(yypvt[-2].arg_def) & VEC)
                  { sem_error(texte[134]);
		    fehler(texte[131]);
		    ARG_argsort(yypvt[-2].arg_def) |= FALSCH;
		  }
		  funcs(do_sr3_draw, print_3_draw);
                  typ1_test(&yypvt[-2].arg_def,(1<<REAL));
                  if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                  { sem_error(texte[134]);
                    fehler(texte[135]);
                    ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-1].arg_def,(1<<INT));
                  if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                  { sem_error(texte[134]);
                    fehler(texte[136]);
                    ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                  }
                  typ1_test(&yypvt[-0].arg_def,(1<<INT));
                  STAT_vc1(*stat_ptr) = yypvt[-2].arg_def;
                  STAT_vc2(*stat_ptr) = yypvt[-1].arg_def;
                  STAT_vc3(*stat_ptr) = yypvt[-0].arg_def;
                  graph_bef_exist = TRUE;
                } /*NOTREACHED*/ break;
case 191:
# line 1500 "parz.y"
{ funcs(do_errorcall,print_errorcall);
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 192:
# line 1505 "parz.y"
{ funcs(do_openinput, print_openinput);
                      if ( ( ARG_argsort(yypvt[-0].arg_def) & VEC ) ||
                           ( ARG_typ(yypvt[-0].arg_def) == CHA && (ARG_argsort(yypvt[-0].arg_def) & CON) ) )
                      { sem_error(texte[143]);
                        fehler(texte[144]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      typ1_test(&yypvt[-0].arg_def,(1<<CHA | 1<<STR));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 193:
# line 1517 "parz.y"
{ funcs(do_openoutput, print_openoutput);
                      if ( ( ARG_argsort(yypvt[-0].arg_def) & VEC ) ||
                           ( ARG_typ(yypvt[-0].arg_def) == CHA && (ARG_argsort(yypvt[-0].arg_def) & CON) ) )
                      { sem_error(texte[145]);
                        fehler(texte[144]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      typ1_test(&yypvt[-0].arg_def,(1<<CHA | 1<<STR));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 194:
# line 1529 "parz.y"
{ register int flag = FALSE;

                      funcs(do_getpixel, print_getpixel);
                      if (ARG_argsort(yypvt[-5].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-5].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[273]);
                        fehler(texte[282]);
                      }
                      typ3_test(&yypvt[-5].arg_def, &yypvt[-1].arg_def, &yypvt[-0].arg_def, (1<<INT));
                      STAT_verg(*stat_ptr) = yypvt[-5].arg_def;
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 195:
# line 1555 "parz.y"
{ register int flag = FALSE;

                      funcs(do_openw, print_openw);
                      if (ARG_argsort(yypvt[-5].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-5].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[274]);
                        fehler(texte[282]);
                      }
                      typ1_test(&yypvt[-5].arg_def, (1<<INT));
                      typ2_test(&yypvt[-1].arg_def, &yypvt[-0].arg_def, (1<<REAL));
                      STAT_verg(*stat_ptr) = yypvt[-5].arg_def;
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 196:
# line 1582 "parz.y"
{ register int flag = FALSE;

                      funcs(do_openabsw, print_openabsw);
                      if (ARG_argsort(yypvt[-5].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-5].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[352]);
                        fehler(texte[282]);
                      }
                      typ1_test(&yypvt[-5].arg_def, (1<<INT));
                      typ2_test(&yypvt[-1].arg_def, &yypvt[-0].arg_def, (1<<INT));
                      STAT_verg(*stat_ptr) = yypvt[-5].arg_def;
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 197:
# line 1610 "parz.y"
{ register int flag = FALSE;

                      funcs(do_moveto, print_moveto);
                      if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[275]);
                        fehler(texte[282]);
                      }
                      typ2_test(&yypvt[-1].arg_def, &yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 198:
# line 1631 "parz.y"
{ register int flag = FALSE;

                      funcs(do_lineto, print_lineto);
                      if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[276]);
                        fehler(texte[282]);
                      }
                      typ2_test(&yypvt[-1].arg_def, &yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 199:
# line 1652 "parz.y"
{ register int flag = FALSE;

                      funcs((ARG_argsort(yypvt[-1].arg_def) & VEC) ||
			    (ARG_argsort(yypvt[-0].arg_def) & VEC)   ? do_v_setpixel
			                              : do_s_setpixel,
			    print_setpixel);
                      typ2_test(&yypvt[-1].arg_def, &yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 200:
# line 1664 "parz.y"
{ register int flag = FALSE;

                      funcs(do_wsize, print_wsize);
                      if (ARG_argsort(yypvt[-1].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-1].arg_def) |= FALSCH;
                      }
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { flag = TRUE;
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      if (flag)
                      { sem_error(texte[278]);
                        fehler(texte[282]);
                      }
                      typ2_test(&yypvt[-1].arg_def, &yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-1].arg_def;
                      STAT_vc2(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 201:
# line 1685 "parz.y"
{ funcs(ARG_argsort(yypvt[-0].arg_def) & VEC ? do_v_setcolor : do_s_setcolor,
			    print_setcolor);
                      typ1_test(&yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 202:
# line 1692 "parz.y"
{ funcs(do_selectw, print_selectw);
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { sem_error(texte[280]);
                        fehler(texte[282]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      typ1_test(&yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 203:
# line 1703 "parz.y"
{ funcs(do_closew, print_closew);
                      if (ARG_argsort(yypvt[-0].arg_def) & VEC)
                      { sem_error(texte[279]);
                        fehler(texte[282]);
                        ARG_argsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      typ1_test(&yypvt[-0].arg_def, (1<<INT));
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                      graph_bef_exist = TRUE;
                    } /*NOTREACHED*/ break;
case 204:
# line 1715 "parz.y"
{ funcs(do_debug, print_debug);
                      STAT_dblock(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                      STAT_vc2(*stat_ptr) = yypvt[-3].arg_def;
                      STAT_vc3(*stat_ptr) = yypvt[-2].arg_def;
                    } /*NOTREACHED*/ break;
case 205:
# line 1722 "parz.y"
{ funcs(do_trace, print_trace);
                      if ((ARG_argsort(yypvt[-3].arg_def) & (IND | INDL)) &&
                          (ARG_indsort(yypvt[-3].arg_def) & VEC)) 
                      { sem_error(texte[117]);
                        fehler(texte[118]);
                        ARG_indsort(yypvt[-3].arg_def) |= FALSCH;
                      }
                      STAT_dblock(*stat_ptr) = dlptr(&yypvt[-0].decl_def);
                      STAT_vc2(*stat_ptr) = yypvt[-3].arg_def;
                      STAT_vc3(*stat_ptr) = yypvt[-2].arg_def;
                    } /*NOTREACHED*/ break;
case 206:
# line 1735 "parz.y"
{ funcs(do_notrace, print_notrace);
                      ARG_argsort(STAT_vc1(*stat_ptr)) = KEINER;
                    } /*NOTREACHED*/ break;
case 207:
# line 1739 "parz.y"
{ funcs(do_notrace, print_notrace);
                      if ((ARG_argsort(yypvt[-0].arg_def) & (IND | INDL)) &&
                          (ARG_indsort(yypvt[-0].arg_def) & VEC)) 
                      { sem_error(texte[120]);
                        fehler(texte[118]);
                        ARG_indsort(yypvt[-0].arg_def) |= FALSCH;
                      }
                      STAT_vc1(*stat_ptr) = yypvt[-0].arg_def;
                    } /*NOTREACHED*/ break;
case 208:
# line 1750 "parz.y"
{ funcs(ARG_argsort(yypvt[-3].arg_def) & VEC ? do_v_initset : do_s_initset,
                        print_initset);
                  if (ARG_typ(yypvt[-3].arg_def) != BOOL)
                  { error(texte[316]);
                    fehler(texte[317]);
                    ARG_argsort(yypvt[-3].arg_def) |= FALSCH;
                  }
                  STAT_verg(*stat_ptr) = yypvt[-3].arg_def;
                  STAT_setbits(*stat_ptr) = yypvt[-0].bitstring_val;
                } /*NOTREACHED*/ break;
case 209:
# line 1762 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def; } /*NOTREACHED*/ break;
case 210:
# line 1764 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def; } /*NOTREACHED*/ break;
case 211:
# line 1766 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def;
                      ARG_argsort(yyval.arg_def) = (ARG_argsort(yypvt[-0].arg_def) & ~VEC) |
                                        ((ARG_argsort(yypvt[-0].arg_def) & VEC) ? ADV : ADS);
                      nospez = FALSE;
                    } /*NOTREACHED*/ break;
case 212:
# line 1773 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def; } /*NOTREACHED*/ break;
case 213:
# line 1775 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def; } /*NOTREACHED*/ break;
case 214:
# line 1778 "parz.y"
{ yyval.arg_def = yypvt[-1].arg_def;
                      ARG_indsort(yyval.arg_def) = ARG_argsort(yyval.arg_def);
                      ARG_argsort(yyval.arg_def) = yypvt[-4].typ_def | IND | (ARG_indsort(yyval.arg_def) & SPEZ);
                      if (ARG_indsort(yyval.arg_def) & VEC)
                      { error(texte[34]);
                        fehler(texte[35]);
                        ARG_indsort(yyval.arg_def) |= FALSCH;
                      }
                      if (ARG_indtyp(yyval.arg_def) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort(yyval.arg_def) |= FALSCH;
                      }
                      nospez = FALSE;
                    } /*NOTREACHED*/ break;
case 215:
# line 1794 "parz.y"
{ yyval.arg_def = yypvt[-1].arg_def;
                      ARG_indsort(yyval.arg_def) = ARG_argsort(yyval.arg_def);
                      ARG_argsort(yyval.arg_def) = yypvt[-4].typ_def | VEC | IND | (ARG_indsort(yyval.arg_def) & SPEZ);
                      if (ARG_indtyp(yyval.arg_def) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort(yyval.arg_def) |= FALSCH;
                      }
                      nospez =  FALSE;
                    } /*NOTREACHED*/ break;
case 216:
# line 1805 "parz.y"
{ yyval.arg_def = yypvt[-1].arg_def;
                      ARG_indsort(yyval.arg_def) = ARG_argsort(yyval.arg_def);
                      ARG_vartiefe(yyval.arg_def) = (int)yypvt[-5].int_val;
                      ARG_argsort(yyval.arg_def) = yypvt[-6].typ_def | INDL | (ARG_indsort(yyval.arg_def) & SPEZ);
                      if (ARG_indsort(yyval.arg_def) & VEC)
                      { error(texte[34]);
                        fehler(texte[35]);
                        ARG_indsort(yyval.arg_def) |= FALSCH;
                      }
                      if (ARG_indtyp(yyval.arg_def) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort(yyval.arg_def) |= FALSCH;
                      }
                      nospez = FALSE;
                    } /*NOTREACHED*/ break;
case 217:
# line 1822 "parz.y"
{ yyval.arg_def = yypvt[-1].arg_def;
                      ARG_indsort(yyval.arg_def) = ARG_argsort(yyval.arg_def);
                      ARG_vartiefe(yyval.arg_def) = (int)yypvt[-5].int_val;
                      ARG_argsort(yyval.arg_def) = yypvt[-6].typ_def | VEC | INDL | (ARG_indsort(yyval.arg_def) & SPEZ);
                      if (ARG_indtyp(yyval.arg_def) != INT)
                      { error(texte[28]);
                        fehler(texte[33]);
                        ARG_indsort(yyval.arg_def) |= FALSCH;
                      }
                      nospez =  FALSE;
                    } /*NOTREACHED*/ break;
case 218:
# line 1835 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def; } /*NOTREACHED*/ break;
case 219:
# line 1837 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def; } /*NOTREACHED*/ break;
case 220:
# line 1840 "parz.y"
{ ARG_argsort(yyval.arg_def) = yypvt[-3].typ_def;
                  ARG_tiefe(yyval.arg_def) = (int)yypvt[-2].int_val;
                  ARG_num(yyval.arg_def) = (int)yypvt[-0].int_val;
                  ARG_gut_proc(yyval.arg_def) = -2;
                  if ((int)yypvt[-2].int_val == 0)
                  { if (!set_absoffs(yypvt[-3].typ_def, (int)yypvt[-0].int_val, &yyval.arg_def, &glob_s_decl, -1))
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort(yyval.arg_def) |= FALSCH;
                    }
                  }
                  else
                  { if ((int)yypvt[-0].int_val == 0)
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort(yyval.arg_def) |= FALSCH;
                    }
                  }
                } /*NOTREACHED*/ break;
case 221:
# line 1860 "parz.y"
{ ARG_argsort(yyval.arg_def) = SPEZ | INT;
                  ARG_vartok(yyval.arg_def) = MAXTRANS;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                  else if (lesend)
                  { error(texte[34]);
                    fehler(texte[37]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 222:
# line 1874 "parz.y"
{ ARG_argsort(yyval.arg_def) = SPEZ | INT;
                  ARG_vartok(yyval.arg_def) = ACTTRANS;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 223:
# line 1888 "parz.y"
{ ARG_argsort(yyval.arg_def) = SPEZ | BOOL;
                  ARG_vartok(yyval.arg_def) = DONE;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 224:
# line 1902 "parz.y"
{ ARG_argsort(yyval.arg_def) = SPEZ | CHA;
                  ARG_vartok(yyval.arg_def) = TERMCH;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 225:
# line 1916 "parz.y"
{ ARG_argsort(yyval.arg_def) = SPEZ | BOOL;
                  ARG_vartok(yyval.arg_def) = SRESULT;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 226:
# line 1931 "parz.y"
{ ARG_argsort(yyval.arg_def) = yypvt[-3].typ_def | VEC;
                  ARG_tiefe(yyval.arg_def) = (int)yypvt[-2].int_val;
                  ARG_num(yyval.arg_def) = (int)yypvt[-0].int_val;
                  ARG_gut_proc(yyval.arg_def) = -2;
                  if ((int)yypvt[-2].int_val == 0)
                  { if (!set_absoffs(yypvt[-3].typ_def, (int)yypvt[-0].int_val, &yyval.arg_def, &glob_v_decl, -1))
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort(yyval.arg_def) |= FALSCH;
                    }
                  }
                  else
                  { if ((int)yypvt[-0].int_val == 0)
                    { error(texte[34]);
                      fehler(texte[36]);
                      ARG_argsort(yyval.arg_def) |= FALSCH;
                    }
                  }
                } /*NOTREACHED*/ break;
case 227:
# line 1951 "parz.y"
{ ARG_argsort(yyval.arg_def) = SPEZ | VEC | INT;
                  ARG_vartok(yyval.arg_def) = ID;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 228:
# line 1965 "parz.y"
{ ARG_argsort(yyval.arg_def) = SPEZ | VEC | BOOL;
                  ARG_vartok(yyval.arg_def) = VRESULT;
                  if (nospez)
                  { error(texte[34]);
                    fehler(texte[44]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                  else if (!lesend)
                  { error(texte[34]);
                    fehler(texte[38]);
                    ARG_argsort(yyval.arg_def) |= FALSCH;
                  }
                } /*NOTREACHED*/ break;
case 229:
# line 1980 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | BOOL;
                      ARG_con_wert(yyval.arg_def).datentyp = BOOL | BOOL_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.b_val = TRUE;
                    } /*NOTREACHED*/ break;
case 230:
# line 1985 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | BOOL;
                      ARG_con_wert(yyval.arg_def).datentyp = BOOL | BOOL_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.b_val = FALSE;
                    } /*NOTREACHED*/ break;
case 231:
# line 1990 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | INT | SPEZ;
                      ARG_con_wert(yyval.arg_def).datentyp = INT | INT_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.i_val = 0;
                    } /*NOTREACHED*/ break;
case 232:
# line 1995 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | CHA | SPEZ;
                      ARG_con_wert(yyval.arg_def).datentyp = CHA | CHA_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.c_val = TERMS_CHAR;
                    } /*NOTREACHED*/ break;
case 233:
# line 2000 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | CHA | SPEZ;
                      ARG_con_wert(yyval.arg_def).datentyp = CHA | CHA_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.c_val = EOL_CHAR;
                    } /*NOTREACHED*/ break;
case 234:
# line 2005 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | CHA;
                      ARG_con_wert(yyval.arg_def).datentyp = CHA | CHA_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.c_val = yypvt[-0].char_val;
                    } /*NOTREACHED*/ break;
case 235:
# line 2010 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | INT;
                      ARG_con_wert(yyval.arg_def).datentyp = INT | INT_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.i_val = yypvt[-0].int_val;
                    } /*NOTREACHED*/ break;
case 236:
# line 2015 "parz.y"
{ ARG_argsort(yyval.arg_def) = CON | REAL;
                      if (fperror)
                      { fperror = FALSE;
                        error(texte[40]);
                        fehler_zahl++;
                        ARG_argsort(yyval.arg_def) |= FALSCH;
                      }
                      ARG_con_wert(yyval.arg_def).datentyp = REAL | REAL_ERLAUBT;
                      ARG_con_wert(yyval.arg_def).inhalt.r_val = yypvt[-0].real_val;
                    } /*NOTREACHED*/ break;
case 237:
# line 2026 "parz.y"
{ ARG_argsort(yyval.arg_def) = INT | CON | SIZ;
                      ARG_sizedec(yyval.arg_def) = dlptr(&yypvt[-1].decl_def);
                    } /*NOTREACHED*/ break;
case 238:
# line 2030 "parz.y"
{ yyval.arg_def = yypvt[-0].arg_def; } /*NOTREACHED*/ break;
case 239:
# line 2033 "parz.y"
{ ARG_argsort(yyval.arg_def) = STR | CON;
                  ARG_con_wert(yyval.arg_def).datentyp = STR ;
                  ARG_con_wert(yyval.arg_def).inhalt.s_val = yypvt[-0].string_val;
                } /*NOTREACHED*/ break;
case 240:
# line 2038 "parz.y"
{ lesend = TRUE; } /*NOTREACHED*/ break;
case 241:
# line 2040 "parz.y"
{ lesend = FALSE; } /*NOTREACHED*/ break;
case 242:
# line 2042 "parz.y"
{ nospez = TRUE; } /*NOTREACHED*/ break;
case 243:
# line 2047 "parz.y"
{ yyerrok;
                          show_prompt();
                        } /*NOTREACHED*/ break;
case 244:
# line 2051 "parz.y"
{ ups();
                          ueberlies_zeile();
                          yyerrok; yyclearin;
                          show_prompt();
                        } /*NOTREACHED*/ break;
case 246:
# line 2058 "parz.y"
{ if ((forced_break || stepping_to) && !scanner_fehler)
                          { unputc('\n'); unputc('#');
                            do_step = TRUE;
                            yyclearin; yyerrok;
                          }
                          else
                          { show_prompt(); }
                        } /*NOTREACHED*/ break;
case 252:
# line 2073 "parz.y"
{ fprintf(kommandout, deb_mod ? texte[170] : texte[171]);
                      if (default_pelist)
                      { more_on();
                        show_pes(default_pelist, texte[182], kommandout);
                        more_off();
                        putc('\n', kommandout);
                      }
                    } /*NOTREACHED*/ break;
case 258:
# line 2087 "parz.y"
{ fprintf(kommandout, texte[169], ssstr[ss_modus]); } /*NOTREACHED*/ break;
case 261:
# line 2091 "parz.y"
{ fprintf(kommandout, texte[168], protstr[prot]); } /*NOTREACHED*/ break;
case 267:
# line 2098 "parz.y"
{ fprintf(kommandout, warnings_on ? texte[186] : texte[187]); } /*NOTREACHED*/ break;
case 268:
# line 2100 "parz.y"
{ fprintf(kommandout, texte[252], pe_width); } /*NOTREACHED*/ break;
case 269:
# line 2104 "parz.y"
{ int dummy;

                      init_debcode(akt_tiefe + 1, -1, &dummy);
                    } /*NOTREACHED*/ break;
case 270:
# line 2109 "parz.y"
{ if (sym_debugging && yypvt[-4].sexpr_info.sexpr_art &&
                          yypvt[-3].sexpr_info.sexpr_art && yypvt[-1].expr_info.expr_art == EXPR_VAR)
                      { register ARG *exptr = yypvt[-1].expr_info.typerg ? &yypvt[-1].expr_info.erg : &yypvt[-1].expr_info.lastval;
                        register int extyp = yypvt[-1].expr_info.typerg ? yypvt[-1].expr_info.typerg : yypvt[-1].expr_info.typlast;

                        if (zuw_ok(yypvt[-3].sexpr_info.typserg, extyp))
                        { if (yypvt[-4].sexpr_info.sexpr_art == EXPR_VAR)
                          { register int goto_l2;

                                  /*      if selection call l1; */
                            funcs(do_v_ifcall, print_ifcall);
                            STAT_vc1(*stat_ptr) = yypvt[-4].sexpr_info.serg;
                            STAT_spr_ziel(*stat_ptr) = stat_ptr - programm + 2;
                            nextstat();
                                  /*      goto l2; */
                            funcs(do_goto, print_goto);
                            goto_l2 = stat_ptr - programm;
                            nextstat();
                                  /* l1 : proc debug_lev + 1; */
                            STAT_label(*stat_ptr) = ++max_label;
                            funcs(do_proc, print_proc);
                            STAT_proclev(*stat_ptr) = debug_lev + 1;
                            STAT_dscal(*stat_ptr) = dlptr(NULL);
                            STAT_dvec(*stat_ptr) = dlptr(NULL);
                            nextstat();
                                  /*      desig := expr; */
                            para_zuw(&yypvt[-3].sexpr_info, exptr, extyp);
                                  /*      return; */
                            funcs(do_return, print_return);
                            nextstat();
                                  /* l2 : ... */
                            STAT_label(*stat_ptr) = ++max_label;
                            STAT_spr_ziel(programm[goto_l2]) = stat_ptr - programm;
                          }
                          else
                          {       /* desig := expr; */
                            para_zuw(&yypvt[-3].sexpr_info, exptr, extyp);
                          }
                          end_debcode();
#ifdef DEBDEBUG
                          debcode_out();
                          parz_typs_out(stdout);
#endif
                          if (!anz_fehler)
                          { char *dummyst;
                            int dummy;

                            temp_a_block = new_aktblock(pc + 1, NULL, TRUE);
                            called = TRUE;
                            warnings_on = FALSE;
                            ended = FALSE;
                            err = FALSE;
                            start(debcode_start);
                            do
                            { akt_return(&dummyst, &dummy);
                              if (dummyst)
                              { free(aktive_pes);
                                aktive_pes = dummyst;
                                last_akt_pe = last(aktive_pes,&anz_akt_pes);
                              }
                            } while (akt_tiefe >= debug_lev);
                          }
                          kill_debcode();
                        }
                        else
                        { komerr(texte[313]); }
                      }
                      else
                      { if (yypvt[-1].expr_info.expr_art && yypvt[-1].expr_info.expr_art != EXPR_VAR)
                        { komerr(texte[310]); }
                      }
                      if (yypvt[-3].sexpr_info.sexpr_str) free(yypvt[-3].sexpr_info.sexpr_str);
                      if (yypvt[-1].expr_info.expr_str) free(yypvt[-1].expr_info.expr_str);
                    } /*NOTREACHED*/ break;
case 271:
# line 2186 "parz.y"
{ if (!file_gelesen)
                          { komerr(texte[3]); }
                          else if (yypvt[-2].zeil_list.list_flag >= 0)
                          { if ((int)yypvt[-1].int_val &&
                                ((ss_modus & STEP_COMP) || yypvt[-2].zeil_list.list_flag))
                            { komerr(texte[238]); }
                            else
                            { more_on();
                              if (yypvt[-2].zeil_list.list_flag)
                              { set_breakpoints((yypvt[-3].int_val ? (int)yypvt[-3].int_val : 1),
                                                yypvt[-2].zeil_list.zval.zlist.zcount,
                                                yypvt[-2].zeil_list.zval.zlist.zl,
                                                0, USER_BREAK);
                                free(yypvt[-2].zeil_list.zval.zlist.zl);
                              }
                              else
                              { set_breakpoints((yypvt[-3].int_val ? (int)yypvt[-3].int_val : 1), 1,
                                                &yypvt[-2].zeil_list.zval.znr,
                                                (int)yypvt[-1].int_val, USER_BREAK);
                              }
                              more_off();
                            }
                          }
                        } /*NOTREACHED*/ break;
case 272:
# line 2211 "parz.y"
{ more_on();
                          list_breakpoints(kommandout);
                          more_off();
                        } /*NOTREACHED*/ break;
case 273:
# line 2216 "parz.y"
{ yyval.int_val = yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 274:
# line 2217 "parz.y"
{ yyval.int_val = - yypvt[-0].int_val; } /*NOTREACHED*/ break;
case 275:
# line 2218 "parz.y"
{ yyval.int_val = 0l; } /*NOTREACHED*/ break;
case 276:
# line 2221 "parz.y"
{ yyval.zeil_list.list_flag = 0;
                  if ((int)yypvt[-0].int_val == 0)
                  { yyval.zeil_list.zval.znr = yyval.zeil_list.list_flag = -1;
                    { komerr(texte[173], 0); }
                  }
                  else if (ss_modus & STEP_INTER)
                  { yyval.zeil_list.zval.znr = ziel(-(int)yypvt[-0].int_val);
                    if (yyval.zeil_list.zval.znr < 0)
                    { komerr(texte[173], (int)yypvt[-0].int_val);
                      yyval.zeil_list.list_flag = -1;
                    }
                  }
                  else
                  { yyval.zeil_list.zval.znr = source_ziel((int)yypvt[-0].int_val);
                    if (yyval.zeil_list.zval.znr < 0)
                    { komerr(texte[237], (int)yypvt[-0].int_val);
                      yyval.zeil_list.list_flag = -1;
                    }
                  }
                } /*NOTREACHED*/ break;
case 277:
# line 2242 "parz.y"
{ proc_lines(yypvt[-0].ident_key, &yyval.zeil_list);
                } /*NOTREACHED*/ break;
case 278:
# line 2247 "parz.y"
{ more_on();
                      show_aktstack(kommandout, CHAIN_OPT, -2, -2, 0);
                      more_off();
                    } /*NOTREACHED*/ break;
case 279:
# line 2252 "parz.y"
{ more_on();
                      show_aktstack(kommandout, CHAIN_OPT | ACTIVITY_OPT, -2, -2, 0);
                      more_off();
                    } /*NOTREACHED*/ break;
case 280:
# line 2259 "parz.y"
{ more_on();
                      list_connections(kommandout, yypvt[-1].conlist_ptr);
                      more_off();
                      loesch_conlist(yypvt[-1].conlist_ptr);
                    } /*NOTREACHED*/ break;
case 281:
# line 2265 "parz.y"
{ more_on();
                      list_connections(kommandout, NULL);
                      more_off();
                    } /*NOTREACHED*/ break;
case 282:
# line 2271 "parz.y"
{ if (yypvt[-0].conlist_ptr)
                      { yyval.conlist_ptr = yypvt[-0].conlist_ptr;
                        yyval.conlist_ptr->conlist_tail = yypvt[-2].conlist_ptr;
                      }
                      else
                      { yyval.conlist_ptr = NULL;
                        loesch_conlist(yypvt[-2].conlist_ptr);
                      }
                    } /*NOTREACHED*/ break;
case 283:
# line 2281 "parz.y"
{ yyval.conlist_ptr = yypvt[-0].conlist_ptr;
                      if (yyval.conlist_ptr) yyval.conlist_ptr->conlist_tail = NULL;
                    } /*NOTREACHED*/ break;
case 284:
# line 2286 "parz.y"
{ parse_start = -3; } /*NOTREACHED*/ break;
case 285:
# line 2288 "parz.y"
{ parse_start = -2; } /*NOTREACHED*/ break;
case 286:
# line 2290 "parz.y"
{ if (anz_fehler)
                      { yyval.conlist_ptr = NULL; }
                      else if (!(yyval.conlist_ptr = (CONLIST *)calloc((size_t)1,
                                                        (size_t)sizeof(CONLIST))))
                      { komerr(texte[80]); }
                      else
                      { yyval.conlist_ptr->v_pe = yypvt[-6].range_val;
                        yyval.conlist_ptr->v_po = yypvt[-4].range_val;
                        yyval.conlist_ptr->n_pe = yypvt[-1].range_val;
                        yyval.conlist_ptr->n_po = yypvt[-0].range_val;
                      }
                    } /*NOTREACHED*/ break;
case 287:
# line 2304 "parz.y"
{ if (yypvt[-0].int_val < 1l || yypvt[-0].int_val > (long)pe_anz)
                      { komerr(texte[63], (int)yypvt[-0].int_val); }
                      else
                      { yyval.range_val.von_n = yyval.range_val.bis_n = (int)yypvt[-0].int_val; }
                    } /*NOTREACHED*/ break;
case 288:
# line 2310 "parz.y"
{ if (yypvt[-2].int_val < 1l || yypvt[-2].int_val > (long)pe_anz)
                      { komerr(texte[63], (int)yypvt[-2].int_val); }
                      if (yypvt[-0].int_val < 1l || yypvt[-0].int_val > (long)pe_anz)
                      { komerr(texte[63], (int)yypvt[-0].int_val); }
                      if (!anz_fehler)
                      { if (yypvt[-2].int_val > yypvt[-0].int_val)
                        { komerr(texte[167], (int)yypvt[-2].int_val, (int)yypvt[-0].int_val); }
                        else
                        { yyval.range_val.von_n = (int)yypvt[-2].int_val; yyval.range_val.bis_n = (int)yypvt[-0].int_val; }
                      }
                    } /*NOTREACHED*/ break;
default : yyparse3(yytmp,yypvt);
}



}
