
# line 2 "parz.y"
/******* Datei parz.y ******
 *
 *      Parser fuer PARZ V2.x
 *      Frank Sembach
 */

#include "parzdefs.h"
#include "komdefs.h"


# line 13 "parz.y"
typedef union 
 { long int_val;
   float real_val;
   unsigned char char_val;
   char *string_val;
   char *bitstring_val;
   char *comment;
   DECLIST decl_def;
   UNION_LIST union_def;
   TYP typ_def;
   ARG arg_def;
   CONLIST *conlist_ptr;
   RANGE range_val;
   MEMDECLIST memdeclist_val;
   RANGELIST *memlist_val;
   OPTPROC optproc_val;
   SCOPETAB *procidlist_val;
   long ident_key;
   ZEILE zeil_list;
   EXPRLIST exprlist_info;
   EXPR expr_info;
   SEXPR sexpr_info;
   SELECT select_info;
   EXPR_RANGE set_range;
 } YYSTYPE;
# define PLUS 257
# define MINUS 258
# define UMINUS 259
# define MAL 260
# define DURCH 261
# define MOD 262
# define SQRT 263
# define EXP 264
# define LN 265
# define SIN 266
# define COS 267
# define TAN 268
# define ARCSIN 269
# define ARCCOS 270
# define ARCTAN 271
# define ARCTANT 272
# define ABS 273
# define AND 274
# define OR 275
# define FIRST 276
# define LAST 277
# define SUM 278
# define PRODUCT 279
# define MAX 280
# define MIN 281
# define PROGRAMMSTART 282
# define KOMMANDOSTART 283
# define INTNUM 284
# define INTKLAM 285
# define REALNUM 286
# define CHAR 287
# define STRING 288
# define BITSTRING 289
# define EQ 290
# define NE 291
# define LT 292
# define LE 293
# define GT 294
# define GE 295
# define AOP 296
# define NIL 297
# define MYTRUE 298
# define MYFALSE 299
# define TERMS 300
# define EOL 301
# define MAXTRANS 302
# define ACTTRANS 303
# define DONE 304
# define TERMCH 305
# define SRESULT 306
# define ID 307
# define VRESULT 308
# define START 309
# define PE 310
# define PORTS 311
# define STOP 312
# define TO 313
# define SCALAR 314
# define VECTOR 315
# define RETURN 316
# define HALT 317
# define END 318
# define ADDR 319
# define NEW 320
# define NOT 321
# define STATUS 322
# define RANDOM 323
# define MOVE 324
# define EQUAL 325
# define AS 326
# define CONNECT 327
# define BICONNECT 328
# define AT 329
# define DISCONNECT 330
# define STRCMP 331
# define SIZE 332
# define IF 333
# define WHILE 334
# define CALL 335
# define GOTO 336
# define READ 337
# define WRITE 338
# define DRAW 339
# define WRITELN 340
# define LOAD 341
# define WITH 342
# define STORE 343
# define REDUCE 344
# define OF 345
# define PUSHS 346
# define PUSHV 347
# define POPS 348
# define POPV 349
# define PROC 350
# define PARALLEL 351
# define PROPAGATE 352
# define OUT 353
# define IN 354
# define SEND 355
# define RECEIVE 356
# define FROM 357
# define CONNECTED 358
# define NOP 359
# define B 360
# define C 361
# define I 362
# define R 363
# define U 364
# define S 365
# define V 366
# define OPENINPUT 367
# define OPENOUTPUT 368
# define CLOSEINPUT 369
# define CLOSEOUTPUT 370
# define GETPIXEL 371
# define OPENW 372
# define OPENABSW 373
# define MOVETO 374
# define LINETO 375
# define SETPIXEL 376
# define WSIZE 377
# define SETCOLOR 378
# define SELECTW 379
# define CLOSEW 380
# define ERROR 381
# define DEBUG 382
# define TRACE 383
# define NOTRACE 384
# define INITSET 385
# define ZEILEND 386
# define PP 387
# define LIST 388
# define CONNECTIONS 389
# define PATTERN 390
# define STRINGMATCH 391
# define GO 392
# define STEP 393
# define SET 394
# define OVER 395
# define ALL 396
# define COMPILER 397
# define INTERPRETER 398
# define FILENAME 399
# define ASSIGN 400
# define BREAKPOINT 401
# define EXAMINE 402
# define EIN 403
# define AUS 404
# define RECORD 405
# define KURZ 406
# define LANG 407
# define SHOW 408
# define MEMORY 409
# define HEAP 410
# define PARSTACK 411
# define CALLSTACK 412
# define CHAIN 413
# define ACTIVITY 414
# define VARIABLE 415
# define SPECIALS 416
# define DEPTH 417
# define WARN 418
# define CALLS 419
# define MODE 420
# define WIDTH 421
# define QUIT 422
# define HELP 423
# define IDENT 424
# define DIV 425
# define POWER 426

# line 133 "parz.y"
/*********************************************/
#include "externs.h"
#include "rundefs.h"
#include "runexts.h"
#include "komexts.h"
#include "debexts.h"
#include "funcs.h"

/* externs aus parz.l :  */
extern char *lies_comm(), *lies_zend();

extern char ausgeben;       /* Flag : Naechste Fehlermeldung ausgeben */
extern char bef_lesen;      /* Flag : Befehlstoken erwartet (Kommandointerp. ) */

extern FILE *yyin;          /* Eingabefile */
extern FILE *yyerfp;        /* File fuer Fehlermeldungen */
extern int yylineno;        /* Zeilenzaehler */
extern int anz_runwarnings; /* Zahl der ausgegebenen Warnungen zu einem SET-Kommando */

/*********************************************/

extern int yynerrs;         /* Zaehler fuer Fehlermeldungen */
#ifdef YYDEBUG
extern int yydebug;
#endif

extern char lesend, nospez;        /* Art des naechsten Zugriffs auf eine Variable */

extern char do_step;           /* parser hat "#\n" zurueckgegeben */
extern char scanner_fehler;    /* scanner hat in Zeile Fehler gemeldet */

extern int flags;                      /* Information ueber gelesene Schluesselworte */
extern int nach_end;                   /* Zaehlt Befehle nach dem letzten END-Befehl */
extern int last_label;                 /* letztes gelesenes Label */
extern int akt_max;                    /* maximale verfuegbare Programmadresse */

#define HEAP_ADRS 1
#define VEC_ADRS 2
extern char adrsort;                   /* Art der Adressen fuer memel */

extern STAT *stat_ptr;                 /* Zeiger auf momentan erzeugten Befehl */

extern struct func_ptrs
{ int (* do_f[2][REAL + 1])();
  int (* print_f)();
} op_funcs[OR - PLUS + 1];

extern struct
{ int (* do_rf[2])(), (* print_rf)();
} rel_op_funcs[GE - EQ + 1];

extern int (* assign_do_funcs[2][REAL + 1][STR + 1])();

extern int (* random_do_funcs[2][STR + 1])();

extern int (* strcmp_do_funcs[2][STR + 1][STR + 1])();

extern int (* red_do_funcs[STR + 1][MIN - AND + 1])();

extern int (* read_do_funcs[2][REAL + 1])();

extern int (* write2_do_funcs[2][STR + 1])();

extern int (* draw2_do_funcs[STR + 1])();

extern int (* writeln2_do_funcs[2][STR + 1])();

extern int red_typs[MIN - AND + 1];

extern AKTBLOCK *temp_a_block;         /* Zeiger auf Aktivierungsblock,
                                   der bei symbolischem Debuggen erzeugt wird 
                                   und von PROC vervollstaendigt werden muss */

extern char *ssstr[];           /* Texte fuer Singlestep-/Breakpointmodus */
extern char *protstr[];         /* Texte fuer Protokollmodus */

extern char *promptstr[2];

extern int graph_bef_exist;

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
extern YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 4085 "parz.y"

extern char * yydisplay();

extern DECL *neu_decl();
extern DECLIST *dlptr();
extern yytabelem yyexca[];

# define YYNPROD 504
# define YYLAST 1043
extern yytabelem yyact[];

extern yytabelem yypact[];

extern yytabelem yypgo[];

extern yytabelem yyr1[];

extern yytabelem yyr2[];

extern yytabelem yychk[];

extern yytabelem yydef[];

typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

extern yytoktype yytoks[];


extern char * yyreds[];

#endif /* YYDEBUG */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1,9021 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
extern int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
extern YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
extern int yys[ YYMAXDEPTH ];		/* state stack */

extern YYSTYPE *yypv;			/* top of value stack */
extern YYSTYPE *yypvt;			/* top of value stack for $vars */
extern int *yyps;			/* top of state stack */

extern int yystate;			/* current state */
extern int yytmp;			/* extra var (lasts between blocks) */

extern int yynerrs;			/* number of errors */
extern int yyerrflag;			/* error recovery flag */
extern int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse4(yytmp,yypvt)

int yytmp;
register YYSTYPE *yypvt;
{

		switch(yytmp){

case 441:
# line 3232 "parz.y"
{ yyval.int_val = EQ; } /*NOTREACHED*/ break;
case 442:
# line 3233 "parz.y"
{ yyval.int_val = NE; } /*NOTREACHED*/ break;
case 443:
# line 3234 "parz.y"
{ yyval.int_val = LT; } /*NOTREACHED*/ break;
case 444:
# line 3235 "parz.y"
{ yyval.int_val = LE; } /*NOTREACHED*/ break;
case 445:
# line 3236 "parz.y"
{ yyval.int_val = GT; } /*NOTREACHED*/ break;
case 446:
# line 3237 "parz.y"
{ yyval.int_val = GE; } /*NOTREACHED*/ break;
case 447:
# line 3238 "parz.y"
{ yyval.int_val = IN; } /*NOTREACHED*/ break;
case 448:
# line 3242 "parz.y"
{ register char *yyd = yydisplay((int)yypvt[-1].int_val);

                      if (yyval.sexpr_info.sexpr_art = yypvt[-2].sexpr_info.sexpr_art == EXPR_VAR && yypvt[-0].sexpr_info.sexpr_art == EXPR_VAR)
                      { if (yyval.sexpr_info.sexpr_art = add_ok(yypvt[-2].sexpr_info.typserg, (int)yypvt[-1].int_val, yypvt[-0].sexpr_info.typserg))
                        { if (yyval.sexpr_info.sexpr_str =
                                malloc((size_t)(strlen(yypvt[-2].sexpr_info.sexpr_str) +
                                                  strlen(yyd) +
                                                  strlen(yypvt[-0].sexpr_info.sexpr_str) + 3)))
                          { sprintf(yyval.sexpr_info.sexpr_str, "%s %s %s",
                                    yypvt[-2].sexpr_info.sexpr_str, yyd, yypvt[-0].sexpr_info.sexpr_str);
                            yyval.sexpr_info.sexpr_art = EXPR_VAR;
                            yyval.sexpr_info.typserg = obertyp(yypvt[-2].sexpr_info.typserg);
                            para_addop(&yyval.sexpr_info.serg, &yypvt[-2].sexpr_info.serg, (int)yypvt[-1].int_val, &yypvt[-0].sexpr_info.serg, yyval.sexpr_info.typserg);
                          }
                          else
                          { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                            komerr(texte[80]);
                          }
                        }
                        else
                        { komerr(texte[314], yyd); }
                      }
                      else
                      { if (yypvt[-2].sexpr_info.sexpr_art && yypvt[-2].sexpr_info.sexpr_art != EXPR_VAR)
                        { komerr(texte[306], yyd); }
                        if (yypvt[-0].sexpr_info.sexpr_art && yypvt[-0].sexpr_info.sexpr_art != EXPR_VAR)
                        { komerr(texte[307], yyd); }
                      }
                      akt_index_typ = index_typ1;
                      if (yypvt[-2].sexpr_info.sexpr_str) free(yypvt[-2].sexpr_info.sexpr_str);
                      if (yypvt[-0].sexpr_info.sexpr_str) free(yypvt[-0].sexpr_info.sexpr_str);
                    } /*NOTREACHED*/ break;
case 449:
# line 3275 "parz.y"
{ if (yypvt[-1].int_val)
                      { register char *tok = yydisplay(yypvt[-1].int_val < 0 ? UMINUS : PLUS);

                        if (yyval.sexpr_info.sexpr_art = yypvt[-0].sexpr_info.sexpr_art == EXPR_VAR)
                        { if (yyval.sexpr_info.sexpr_art = sign_ok(yypvt[-0].sexpr_info.typserg))
                          { if (yyval.sexpr_info.sexpr_str =
                                  malloc((size_t)(strlen(tok) +
                                                    strlen(yypvt[-0].sexpr_info.sexpr_str) + 2)))
                            { sprintf(yyval.sexpr_info.sexpr_str, "%s %s",
                                      tok, yypvt[-0].sexpr_info.sexpr_str);
                              yyval.sexpr_info.typserg = obertyp(yypvt[-0].sexpr_info.typserg);
                              yyval.sexpr_info.sexpr_art = EXPR_VAR;
                              if (yypvt[-1].int_val < 0l)
                              { para_minus(&yyval.sexpr_info.serg, &yypvt[-0].sexpr_info.serg, yyval.sexpr_info.typserg); }
                            }
                            else
                            { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                              komerr(texte[80]);
                            }
                          }
                          else
                          { komerr(texte[314], tok); }
                        }
                        else if (yypvt[-0].sexpr_info.sexpr_art)
                        { komerr(texte[305], tok); }
                        if (yypvt[-0].sexpr_info.sexpr_str) free(yypvt[-0].sexpr_info.sexpr_str);
                      }
                      else
                      { yyval.sexpr_info = yypvt[-0].sexpr_info; }
                    } /*NOTREACHED*/ break;
case 450:
# line 3307 "parz.y"
{ yyval.int_val = PLUS; } /*NOTREACHED*/ break;
case 451:
# line 3308 "parz.y"
{ yyval.int_val = MINUS; } /*NOTREACHED*/ break;
case 452:
# line 3309 "parz.y"
{ yyval.int_val = OR; } /*NOTREACHED*/ break;
case 453:
# line 3313 "parz.y"
{ register char *yyd = yydisplay((int)yypvt[-1].int_val);

                  if (yyval.sexpr_info.sexpr_art = yypvt[-2].sexpr_info.sexpr_art == EXPR_VAR && yypvt[-0].sexpr_info.sexpr_art == EXPR_VAR)
                  { if (yyval.sexpr_info.sexpr_art = mul_ok(yypvt[-2].sexpr_info.typserg, (int)yypvt[-1].int_val, yypvt[-0].sexpr_info.typserg))
                    { if (yyval.sexpr_info.sexpr_str =
                            malloc((size_t)(strlen(yypvt[-2].sexpr_info.sexpr_str) +
                                              strlen(yyd) +
                                              strlen(yypvt[-0].sexpr_info.sexpr_str) + 3)))
                      { sprintf(yyval.sexpr_info.sexpr_str, "%s %s %s",
                                yypvt[-2].sexpr_info.sexpr_str, yyd, yypvt[-0].sexpr_info.sexpr_str);
                        yyval.sexpr_info.typserg = obertyp(yypvt[-2].sexpr_info.typserg);
                        yyval.sexpr_info.sexpr_art = EXPR_VAR;
                        para_mulop(&yyval.sexpr_info.serg, &yypvt[-2].sexpr_info.serg, (int)yypvt[-1].int_val, &yypvt[-0].sexpr_info.serg, yyval.sexpr_info.typserg);
                      }
                      else
                      { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], yyd); }
                  }
                  else
                  { if (yypvt[-2].sexpr_info.sexpr_art && yypvt[-2].sexpr_info.sexpr_art != EXPR_VAR)
                    { komerr(texte[306], yyd); }
                    if (yypvt[-0].sexpr_info.sexpr_art && yypvt[-0].sexpr_info.sexpr_art != EXPR_VAR)
                    { komerr(texte[307], yyd); }
                  }
                  akt_index_typ = index_typ1;
                  if (yypvt[-2].sexpr_info.sexpr_str) free(yypvt[-2].sexpr_info.sexpr_str);
                  if (yypvt[-0].sexpr_info.sexpr_str) free(yypvt[-0].sexpr_info.sexpr_str);
                } /*NOTREACHED*/ break;
case 454:
# line 3346 "parz.y"
{ yyval.sexpr_info = yypvt[-0].sexpr_info; } /*NOTREACHED*/ break;
case 455:
# line 3349 "parz.y"
{ yyval.int_val = MAL; } /*NOTREACHED*/ break;
case 456:
# line 3350 "parz.y"
{ yyval.int_val = DURCH; } /*NOTREACHED*/ break;
case 457:
# line 3351 "parz.y"
{ yyval.int_val = DIV; } /*NOTREACHED*/ break;
case 458:
# line 3352 "parz.y"
{ yyval.int_val = MOD; } /*NOTREACHED*/ break;
case 459:
# line 3353 "parz.y"
{ yyval.int_val = AND; } /*NOTREACHED*/ break;
case 460:
# line 3357 "parz.y"
{ if (yyval.sexpr_info.sexpr_art = yypvt[-2].sexpr_info.sexpr_art == EXPR_VAR && yypvt[-0].sexpr_info.sexpr_art == EXPR_VAR)
                  { if (yyval.sexpr_info.sexpr_art = pow_ok(yypvt[-2].sexpr_info.typserg, yypvt[-0].sexpr_info.typserg))
                    { if (yyval.sexpr_info.sexpr_str =
                            malloc((size_t)(strlen(yypvt[-2].sexpr_info.sexpr_str) +
                                              strlen(yypvt[-0].sexpr_info.sexpr_str) + 5)))
                      { sprintf(yyval.sexpr_info.sexpr_str, "%s ** %s",
                                yypvt[-2].sexpr_info.sexpr_str, yypvt[-0].sexpr_info.sexpr_str);
                        yyval.sexpr_info.sexpr_art = EXPR_VAR;
                        yyval.sexpr_info.typserg = obertyp(yypvt[-2].sexpr_info.typserg);
                        para_pow(&yyval.sexpr_info.serg,
                                 &yypvt[-2].sexpr_info.serg, obertyp(yypvt[-2].sexpr_info.typserg),
                                 &yypvt[-0].sexpr_info.serg, obertyp(yypvt[-0].sexpr_info.typserg));
                      }
                      else
                      { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], "**"); }
                  }
                  else
                  { if (yypvt[-2].sexpr_info.sexpr_art && yypvt[-2].sexpr_info.sexpr_art != EXPR_VAR)
                    { komerr(texte[306], "**"); }
                    if (yypvt[-0].sexpr_info.sexpr_art && yypvt[-0].sexpr_info.sexpr_art != EXPR_VAR)
                    { komerr(texte[307], "**"); }
                  }
                  akt_index_typ = index_typ1;
                  if (yypvt[-2].sexpr_info.sexpr_str) free(yypvt[-2].sexpr_info.sexpr_str);
                  if (yypvt[-0].sexpr_info.sexpr_str) free(yypvt[-0].sexpr_info.sexpr_str);
                } /*NOTREACHED*/ break;
case 461:
# line 3389 "parz.y"
{ yyval.sexpr_info = yypvt[-0].sexpr_info; } /*NOTREACHED*/ break;
case 462:
# line 3393 "parz.y"
{ EXPRLIST dummy_el;

                  dummy_el.expr_array = NULL;
                  dummy_el.expr_count = 0;
                  para_stdfkt(&yyval.sexpr_info, yypvt[-2].ident_key, &dummy_el);
                } /*NOTREACHED*/ break;
case 463:
# line 3400 "parz.y"
{ para_stdfkt(&yyval.sexpr_info, yypvt[-3].ident_key, &yypvt[-1].exprlist_info); } /*NOTREACHED*/ break;
case 464:
# line 3402 "parz.y"
{ if (yyval.sexpr_info.sexpr_str = malloc((size_t)20))
                  { sprintf(yyval.sexpr_info.sexpr_str, "%ld", yypvt[-0].int_val);
                    yyval.sexpr_info.sexpr_art = EXPR_VAR;
                    yyval.sexpr_info.typserg = para_typ[INT];
                    ARG_argsort(yyval.sexpr_info.serg) = CON | INT;
                    ARG_con_wert(yyval.sexpr_info.serg).datentyp = INT | INT_ERLAUBT;
                    ARG_con_wert(yyval.sexpr_info.serg).inhalt.i_val = yypvt[-0].int_val;
                  }
                  else
                  { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                } /*NOTREACHED*/ break;
case 465:
# line 3416 "parz.y"
{ if (yyval.sexpr_info.sexpr_str = malloc((size_t)4))
                  { sprintf(yyval.sexpr_info.sexpr_str, "'%c'", yypvt[-0].char_val);
                    yyval.sexpr_info.sexpr_art = EXPR_VAR;
                    yyval.sexpr_info.typserg = para_typ[CHA];
                    ARG_argsort(yyval.sexpr_info.serg) = CON | CHA;
                    ARG_con_wert(yyval.sexpr_info.serg).datentyp = CHA | CHA_ERLAUBT;
                    ARG_con_wert(yyval.sexpr_info.serg).inhalt.c_val = yypvt[-0].char_val;
                  }
                  else
                  { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                } /*NOTREACHED*/ break;
case 466:
# line 3430 "parz.y"
{ if (yyval.sexpr_info.sexpr_str = malloc((size_t)20))
                  {
#  ifdef SUN
                    sprintf(yyval.sexpr_info.sexpr_str, yypvt[-0].real_val ? "%#g" : "%#f", yypvt[-0].real_val);
#  else
                    sprintf(yyval.sexpr_info.sexpr_str, "%#g", yypvt[-0].real_val);
#  endif
                    yyval.sexpr_info.sexpr_art = EXPR_VAR;
                    yyval.sexpr_info.typserg = para_typ[REAL];
                    ARG_argsort(yyval.sexpr_info.serg) = CON | REAL;
                    if (fperror)
                    { fperror = FALSE;
                      komerr(texte[40]);
                      yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                    }
                    ARG_con_wert(yyval.sexpr_info.serg).datentyp = REAL | REAL_ERLAUBT;
                    ARG_con_wert(yyval.sexpr_info.serg).inhalt.r_val = yypvt[-0].real_val;
                  }
                  else
                  { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                } /*NOTREACHED*/ break;
case 467:
# line 3454 "parz.y"
{ if (yyval.sexpr_info.sexpr_str = malloc((size_t)(strlen(yypvt[-0].string_val) + 3)))
                  { register TYPTAB *ityp = types_table + akt_index_typ - 1;
                    register DECLIST *dl;

                    sprintf(yyval.sexpr_info.sexpr_str, "\"%s\"", yypvt[-0].string_val);
                    yyval.sexpr_info.sexpr_art = EXPR_VAR;
                    if (akt_index_typ > index_typ2) bug("parz.y/factor : Strings nicht verbraucht");
                    yyval.sexpr_info.typserg = akt_index_typ + 1;
                    if ((dl = &ityp[1].parz_decl)->darray) free(dl->darray);
                    dl->darray = NULL; dl->dcount = 0;
                    ityp->typ_arg3 = strlen(yypvt[-0].string_val);
                    akt_index_typ += 2;
                    parz_typ(yyval.sexpr_info.typserg);
                    ARG_argsort(yyval.sexpr_info.serg) = STR | CON;
                    ARG_con_wert(yyval.sexpr_info.serg).datentyp = STR ;
                    ARG_con_wert(yyval.sexpr_info.serg).inhalt.s_val = yypvt[-0].string_val;
                  }
                  else
                  { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                } /*NOTREACHED*/ break;
case 468:
# line 3477 "parz.y"
{ yyval.sexpr_info = yypvt[-0].sexpr_info; } /*NOTREACHED*/ break;
case 469:
# line 3479 "parz.y"
{ yyval.sexpr_info = yypvt[-0].sexpr_info; } /*NOTREACHED*/ break;
case 470:
# line 3481 "parz.y"
{ if (yyval.sexpr_info.sexpr_art = yypvt[-1].expr_info.expr_art)
                  { if (yyval.sexpr_info.sexpr_str = malloc((size_t)(strlen(yypvt[-1].expr_info.expr_str) + 3)))
                    { sprintf(yyval.sexpr_info.sexpr_str, "(%s)", yypvt[-1].expr_info.expr_str);
                      if (yypvt[-1].expr_info.typerg)
                      { yyval.sexpr_info.serg = yypvt[-1].expr_info.erg;
                        yyval.sexpr_info.typserg = yypvt[-1].expr_info.typerg;
                      }
                      else
                      { yyval.sexpr_info.serg = yypvt[-1].expr_info.lastval;
                        yyval.sexpr_info.typserg = yypvt[-1].expr_info.typlast;
                      }
                    }
                    else
                    { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                      komerr(texte[80]);
                    }
                  }
                  if (yypvt[-1].expr_info.expr_str) free(yypvt[-1].expr_info.expr_str);
                } /*NOTREACHED*/ break;
case 471:
# line 3501 "parz.y"
{ if (yyval.sexpr_info.sexpr_art = yypvt[-0].sexpr_info.sexpr_art == EXPR_VAR)
                  { if (yyval.sexpr_info.sexpr_art = not_ok(yypvt[-0].sexpr_info.typserg))
                    { if (yyval.sexpr_info.sexpr_str = malloc((size_t)(strlen(yypvt[-0].sexpr_info.sexpr_str) + 5)))
                      { sprintf(yyval.sexpr_info.sexpr_str, "NOT %s", yypvt[-0].sexpr_info.sexpr_str);
                        yyval.sexpr_info.typserg = para_typ[BOOL];
                        yyval.sexpr_info.sexpr_art = EXPR_VAR;
                        para_not(&yyval.sexpr_info.serg, &yypvt[-0].sexpr_info.serg);
                      }
                      else
                      { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], "NOT");
                    }
                  }
                  else if (yypvt[-0].sexpr_info.sexpr_art)
                  { komerr(texte[305], "NOT");
                  }
                  if (yypvt[-0].sexpr_info.sexpr_str) free(yypvt[-0].sexpr_info.sexpr_str);
                } /*NOTREACHED*/ break;
case 472:
# line 3524 "parz.y"
{ if (yyval.sexpr_info.sexpr_art = yypvt[-1].expr_info.expr_art == EXPR_VAR && yypvt[-3].int_val)
                  { register int etyp = yypvt[-1].expr_info.typerg ? yypvt[-1].expr_info.typerg : yypvt[-1].expr_info.typlast;
                    register char *yyd = yydisplay((int)yypvt[-3].int_val);

                    if (yyval.sexpr_info.sexpr_art = red_ok((int)yypvt[-3].int_val, etyp))
                    { if (yyval.sexpr_info.sexpr_str =
                            malloc((size_t)(strlen(yyd) +
                                              strlen(yypvt[-1].expr_info.expr_str) + 10)))
                      { sprintf(yyval.sexpr_info.sexpr_str, "REDUCE.%s(%s)",
                                yyd, yypvt[-1].expr_info.expr_str);
                        yyval.sexpr_info.typserg = obertyp(etyp);
                        yyval.sexpr_info.sexpr_art = EXPR_VAR;
                        para_reduce(&yyval.sexpr_info.serg, (int)yypvt[-3].int_val,
                                    yypvt[-1].expr_info.typerg ? &yypvt[-1].expr_info.erg : &yypvt[-1].expr_info.lastval, yyval.sexpr_info.typserg);
                      }
                      else
                      { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { komerr(texte[314], yyd); }
                  }
                  else if (yypvt[-1].expr_info.expr_art && yypvt[-1].expr_info.expr_art != EXPR_VAR)
                  { komerr(texte[304]); }
                  akt_index_typ = index_typ1;
                  if (yypvt[-1].expr_info.expr_str) free(yypvt[-1].expr_info.expr_str);
                } /*NOTREACHED*/ break;
case 473:
# line 3555 "parz.y"
{ register SYMTAB *st;

                          yyval.int_val = 0;
                          if (disp &&
                              (st = look_sym(yypvt[-0].ident_key, disp[akt_tiefe]->top_scope)))
                          { if (st->sym_art == SY_REDOPER || st->sym_art == SY_RED_STDF)
                            { yyval.int_val = st->sym_type_scope; }
                          }
                          if (!yyval.int_val)
                          { komerr(texte[303], key_to_name(yypvt[-0].ident_key)); }
                        } /*NOTREACHED*/ break;
case 474:
# line 3566 "parz.y"
{ yyval.int_val = AND; } /*NOTREACHED*/ break;
case 475:
# line 3567 "parz.y"
{ yyval.int_val = OR; } /*NOTREACHED*/ break;
case 476:
# line 3571 "parz.y"
{ register SYMTAB *st;
                  register int t;

                  if (st = look_sym(yypvt[-1].ident_key, akt_scope))
                  { yyval.int_val = st->sym_type_scope;
                    if (!(st->sym_art == SY_TYPENAME &&
                          types_table[yyval.int_val - 1].typ_art == TYP_SET))
                    { yyval.int_val = -337; }
                  }
                  else
                  { yyval.int_val = -301; }
                } /*NOTREACHED*/ break;
case 477:
# line 3584 "parz.y"
{ register char *tnam = key_to_name(yypvt[-4].ident_key);

                  if (yypvt[-2].int_val < 0)
                  { komerr(texte[-yypvt[-2].int_val], tnam);
                    yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                    yyval.sexpr_info.sexpr_str = NULL;
                  }
                  else
                  { yyval.sexpr_info = yypvt[-1].sexpr_info;
                    if (yyval.sexpr_info.sexpr_art)
                    { if (yyval.sexpr_info.sexpr_str =
                            malloc((size_t)(strlen(tnam) +
                                              strlen(yypvt[-1].sexpr_info.sexpr_str) + 3)))
                      { sprintf(yyval.sexpr_info.sexpr_str, "%s{%s}", tnam, yypvt[-1].sexpr_info.sexpr_str);
                        yyval.sexpr_info.sexpr_art = EXPR_VAR;
                      }
                      else
                      { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                  }
                  if (yypvt[-1].sexpr_info.sexpr_str) free(yypvt[-1].sexpr_info.sexpr_str);
                } /*NOTREACHED*/ break;
case 478:
# line 3609 "parz.y"
{ yyval.int_val = bitset_typ; } /*NOTREACHED*/ break;
case 479:
# line 3611 "parz.y"
{ yyval.sexpr_info = yypvt[-1].sexpr_info;
                  if (yyval.sexpr_info.sexpr_art)
                  { if (yyval.sexpr_info.sexpr_str = malloc((size_t)(strlen(yypvt[-1].sexpr_info.sexpr_str) + 3)))
                    { sprintf(yyval.sexpr_info.sexpr_str, "{%s}", yypvt[-1].sexpr_info.sexpr_str);
                    }
                    else
                    { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                      komerr(texte[80]);
                    }
                    if (yypvt[-1].sexpr_info.sexpr_str) free(yypvt[-1].sexpr_info.sexpr_str);
                  }
                } /*NOTREACHED*/ break;
case 480:
# line 3624 "parz.y"
{ register char *tnam = key_to_name(yypvt[-2].ident_key);
                  register SYMTAB *st;
                  register int t;

                  if (yyval.sexpr_info.sexpr_art = ((st = look_sym(yypvt[-2].ident_key, akt_scope)) != NULL))
                  { t = st->sym_type_scope;
                    if (st->sym_art == SY_TYPENAME &&
                        types_table[t - 1].typ_art == TYP_SET)
                    { if (yyval.sexpr_info.sexpr_str = malloc((size_t)(strlen(tnam) + 3)))
                      { sprintf(yyval.sexpr_info.sexpr_str, "%s{}", tnam);
                        if (para_set_clear(&yyval.sexpr_info.serg, yyval.sexpr_info.typserg = t))
                        { yyval.sexpr_info.sexpr_art = EXPR_VAR; }
                        else
                        { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                          free(yyval.sexpr_info.sexpr_str); yyval.sexpr_info.sexpr_str = NULL;
                          komerr(texte[80]);
                        }
                      }
                      else
                      { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        komerr(texte[80]);
                      }
                    }
                    else
                    { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                      yyval.sexpr_info.sexpr_str = NULL;
                      komerr(texte[337], tnam); } 
                  }
                  else
                  { yyval.sexpr_info.sexpr_str = NULL;
                    komerr(texte[301], tnam);
                  }
                } /*NOTREACHED*/ break;
case 481:
# line 3658 "parz.y"
{ if (yyval.sexpr_info.sexpr_str = malloc((size_t)3))
                  { strcpy(yyval.sexpr_info.sexpr_str, "{}");
                    new_var(&yyval.sexpr_info.serg, yyval.sexpr_info.typserg = bitset_typ, 0);
                    para_const_set(&yyval.sexpr_info.serg, "00000000000000000000000000000000");
                    yyval.sexpr_info.sexpr_art = EXPR_VAR;
                    strcpy(yyval.sexpr_info.sexpr_str, "{}");
                  }
                  else
                  { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                    komerr(texte[80]);
                  }
                } /*NOTREACHED*/ break;
case 482:
# line 3673 "parz.y"
{ register int ok1 = yypvt[-0].set_range.ex1.sexpr_art;
                          register int ok2 = yypvt[-0].set_range.ex2.sexpr_art;

                          yyval.sexpr_info = yypvt[-2].sexpr_info;
                          if (ok1 && yypvt[-2].sexpr_info.sexpr_art)
                          { if (rel_ok(yypvt[-0].set_range.ex1.typserg, IN, yyval.sexpr_info.typserg) &&
                                (!ok2 || rel_ok(yypvt[-0].set_range.ex2.typserg, IN, yyval.sexpr_info.typserg)))
                            { if (yyval.sexpr_info.sexpr_str =
                                    malloc((size_t)(strlen(yypvt[-2].sexpr_info.sexpr_str) +
                                                    strlen(yypvt[-0].set_range.ex1.sexpr_str) +
                                                    (ok2 ? (strlen(yypvt[-0].set_range.ex2.sexpr_str) + 4)
                                                         : 2))))
                              { sprintf(yyval.sexpr_info.sexpr_str, "%s,%s%s%s",
                                        yypvt[-2].sexpr_info.sexpr_str,
                                        yypvt[-0].set_range.ex1.sexpr_str,
                                        ok2 ? ".." : "",
                                        ok2 ? yypvt[-0].set_range.ex2.sexpr_str : "");
                                if (ok2)
                                { para_add_range(&yyval.sexpr_info, &yypvt[-0].set_range.ex1.serg, &yypvt[-0].set_range.ex2.serg); }
                                else
                                { para_incl_set(&yyval.sexpr_info, &yypvt[-0].set_range.ex1.serg); }
                                yyval.sexpr_info.sexpr_art = EXPR_VAR;
                              }
                              else
                              { komerr(texte[80]);
                                yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                              }
                            }
                            else
                            { komerr(texte[339]);
                              yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                              yyval.sexpr_info.sexpr_str = NULL;
                            }
                          }
                          else 
                          { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                            yyval.sexpr_info.sexpr_str = NULL;
                          }
                          if (yypvt[-2].sexpr_info.sexpr_str) free(yypvt[-2].sexpr_info.sexpr_str);
                          if (yypvt[-0].set_range.ex1.sexpr_str) free(yypvt[-0].set_range.ex1.sexpr_str);
                          if (yypvt[-0].set_range.ex2.sexpr_str) free(yypvt[-0].set_range.ex2.sexpr_str);
                        } /*NOTREACHED*/ break;
case 483:
# line 3716 "parz.y"
{ register int ok1 = yypvt[-0].set_range.ex1.sexpr_art;
                          register int ok2 = yypvt[-0].set_range.ex2.sexpr_art;

                          if (ok1 &&
                              para_set_clear(&yyval.sexpr_info.serg, yyval.sexpr_info.typserg = (int)yypvt[-1].int_val))
                          { if (rel_ok(yypvt[-0].set_range.ex1.typserg, IN, yyval.sexpr_info.typserg) &&
                                (!ok2 || rel_ok(yypvt[-0].set_range.ex2.typserg, IN, yyval.sexpr_info.typserg)))
                            { if (yyval.sexpr_info.sexpr_str =
                                    malloc((size_t)(strlen(yypvt[-0].set_range.ex1.sexpr_str) +
                                                    (ok2 ? (strlen(yypvt[-0].set_range.ex2.sexpr_str) + 3)
                                                         : 1))))
                              { sprintf(yyval.sexpr_info.sexpr_str, "%s%s%s",
                                        yypvt[-0].set_range.ex1.sexpr_str,
                                        ok2 ? ".." : "",
                                        ok2 ? yypvt[-0].set_range.ex2.sexpr_str : "");
                                if (ok2)
                                { para_add_range(&yyval.sexpr_info, &yypvt[-0].set_range.ex1.serg, &yypvt[-0].set_range.ex2.serg); }
                                else
                                { para_incl_set(&yyval.sexpr_info, &yypvt[-0].set_range.ex1.serg); }
                                yyval.sexpr_info.sexpr_art = EXPR_VAR;
                              }
                              else
                              { komerr(texte[80]);
                                yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                              }
                            }
                            else
                            { komerr(texte[339]);
                              yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                              yyval.sexpr_info.sexpr_str = NULL;
                            }
                          }
                          else 
                          { yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                            yyval.sexpr_info.sexpr_str = NULL;
                          }
                          if (yypvt[-0].set_range.ex1.sexpr_str) free(yypvt[-0].set_range.ex1.sexpr_str);
                          if (yypvt[-0].set_range.ex2.sexpr_str) free(yypvt[-0].set_range.ex2.sexpr_str);
                        } /*NOTREACHED*/ break;
case 484:
# line 3758 "parz.y"
{ if (yypvt[-0].expr_info.expr_art == EXPR_VAR)
                          { yyval.set_range.ex1.sexpr_art = yypvt[-0].expr_info.expr_art;
                            yyval.set_range.ex1.sexpr_str = yypvt[-0].expr_info.expr_str;
                            yyval.set_range.ex1.serg = yypvt[-0].expr_info.typerg ? yypvt[-0].expr_info.erg : yypvt[-0].expr_info.lastval;
                            yyval.set_range.ex1.typserg = yypvt[-0].expr_info.typerg ? yypvt[-0].expr_info.typerg : yypvt[-0].expr_info.typlast;
                          }
                          else
                          { yyval.set_range.ex1.sexpr_art = EXPR_FALSCH;
                            yyval.set_range.ex1.sexpr_str = NULL;
                            if (yypvt[-0].expr_info.expr_art)
                            { komerr(texte[338], yypvt[-0].expr_info.expr_str);
                              free(yypvt[-0].expr_info.expr_str);
                            }
                          }
                          yyval.set_range.ex2.sexpr_art = EXPR_FALSCH;
                          yyval.set_range.ex2.sexpr_str = NULL;
                        } /*NOTREACHED*/ break;
case 485:
# line 3776 "parz.y"
{ if (yypvt[-2].expr_info.expr_art == EXPR_VAR)
                          { yyval.set_range.ex1.sexpr_art = yypvt[-2].expr_info.expr_art;
                            yyval.set_range.ex1.sexpr_str = yypvt[-2].expr_info.expr_str;
                            yyval.set_range.ex1.serg = yypvt[-2].expr_info.typerg ? yypvt[-2].expr_info.erg : yypvt[-2].expr_info.lastval;
                            yyval.set_range.ex1.typserg = yypvt[-2].expr_info.typerg ? yypvt[-2].expr_info.typerg : yypvt[-2].expr_info.typlast;
                          }
                          else
                          { yyval.set_range.ex1.sexpr_art = EXPR_FALSCH;
                            yyval.set_range.ex1.sexpr_str = NULL;
                            if (yypvt[-2].expr_info.expr_art)
                            { komerr(texte[338], yypvt[-2].expr_info.expr_str);
                              free(yypvt[-2].expr_info.expr_str);
                            }
                          }
                          if (yypvt[-0].expr_info.expr_art == EXPR_VAR)
                          { yyval.set_range.ex2.sexpr_art = yypvt[-0].expr_info.expr_art;
                            yyval.set_range.ex2.sexpr_str = yypvt[-0].expr_info.expr_str;
                            yyval.set_range.ex2.serg = yypvt[-0].expr_info.typerg ? yypvt[-0].expr_info.erg : yypvt[-0].expr_info.lastval;
                            yyval.set_range.ex2.typserg = yypvt[-0].expr_info.typerg ? yypvt[-0].expr_info.typerg : yypvt[-0].expr_info.typlast;
                          }
                          else
                          { yyval.set_range.ex2.sexpr_art = yyval.set_range.ex1.sexpr_art = EXPR_FALSCH;
                            yyval.set_range.ex2.sexpr_str = NULL;
                            if (yypvt[-0].expr_info.expr_art)
                            { komerr(texte[338], yypvt[-0].expr_info.expr_str);
                              free(yypvt[-0].expr_info.expr_str);
                              if (yyval.set_range.ex1.sexpr_str)
                              { free(yyval.set_range.ex1.sexpr_str);
                                yyval.set_range.ex1.sexpr_str = NULL;
                              }
                            }
                          }
                        } /*NOTREACHED*/ break;
case 486:
# line 3812 "parz.y"
{ if (yyval.sexpr_info.sexpr_art = (yypvt[-3].sexpr_info.sexpr_art == EXPR_VAR))
                      { if (yyval.sexpr_info.sexpr_art = 
                              (types_table[yypvt[-3].sexpr_info.typserg - 1].typ_art == TYP_ARRAY))
                        { register char *elstr = exprlist_string(&yypvt[-1].exprlist_info);

                          if (elstr && (yyval.sexpr_info.sexpr_str =
                                          malloc((size_t)(strlen(yypvt[-3].sexpr_info.sexpr_str) +
                                                            strlen(elstr) + 3))))
                          { yyval.sexpr_info.sexpr_art = EXPR_VAR;
                            sprintf(yyval.sexpr_info.sexpr_str, "%s[%s]", yypvt[-3].sexpr_info.sexpr_str, elstr);
                            free(elstr);
                            para_arraykomp(&yyval.sexpr_info, &yypvt[-3].sexpr_info.serg, &yypvt[-1].exprlist_info, yypvt[-3].sexpr_info.typserg);
                            if (!yyval.sexpr_info.sexpr_art)
                            { free(yyval.sexpr_info.sexpr_str); yyval.sexpr_info.sexpr_str = NULL; }
                          }
                          else
                          { if (elstr)
                            { komerr(texte[80]);
                              free(elstr);
                            }
                            yyval.sexpr_info.sexpr_str = NULL;
                            yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                          }
                        }
                        else
                        { komerr(texte[324], yypvt[-3].sexpr_info.sexpr_str); }
                      }
                      else if (yypvt[-3].sexpr_info.sexpr_art)
                      { komerr(texte[305], "[]"); }
                      if (yypvt[-3].sexpr_info.sexpr_str) free(yypvt[-3].sexpr_info.sexpr_str);
                      exprlist_free(&yypvt[-1].exprlist_info);
                    } /*NOTREACHED*/ break;
case 487:
# line 3845 "parz.y"
{ if (yyval.sexpr_info.sexpr_art = (yypvt[-2].sexpr_info.sexpr_art == EXPR_VAR))
                      { if (yyval.sexpr_info.sexpr_art = 
                              (types_table[yypvt[-2].sexpr_info.typserg - 1].typ_art == TYP_RECORD))
                        { register char *memstr = key_to_name(yypvt[-0].ident_key);

                          if (yyval.sexpr_info.sexpr_str =
                                malloc((size_t)(strlen(yypvt[-2].sexpr_info.sexpr_str) +
                                                  strlen(memstr) + 2)))
                          { sprintf(yyval.sexpr_info.sexpr_str, "%s.%s", yypvt[-2].sexpr_info.sexpr_str, memstr);
                            para_recmem(&yyval.sexpr_info, &yypvt[-2].sexpr_info.serg, yypvt[-0].ident_key, yypvt[-2].sexpr_info.typserg);
                            if (!yyval.sexpr_info.sexpr_art)
                            { komerr(texte[323], memstr);
                              free(yyval.sexpr_info.sexpr_str); yyval.sexpr_info.sexpr_str = NULL;
                            }
                          }
                          else
                          { komerr(texte[80]); yyval.sexpr_info.sexpr_str = NULL;
                            yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                          }
                        }
                        else
                        { komerr(texte[322], yypvt[-2].sexpr_info.sexpr_str); }
                      }
                      else if (yypvt[-2].sexpr_info.sexpr_art)
                      { komerr(texte[305], "."); }
                      if (yypvt[-2].sexpr_info.sexpr_str) free(yypvt[-2].sexpr_info.sexpr_str);
                    } /*NOTREACHED*/ break;
case 488:
# line 3873 "parz.y"
{ if (yyval.sexpr_info.sexpr_art = (yypvt[-1].sexpr_info.sexpr_art == EXPR_VAR))
                      { if (yyval.sexpr_info.sexpr_art =
                              (yypvt[-1].sexpr_info.typserg != nil_typ &&
                               !(ARG_argsort(yypvt[-1].sexpr_info.serg) & CON) &&
                               types_table[yypvt[-1].sexpr_info.typserg - 1].typ_art == TYP_POINTER))
                        { if (yyval.sexpr_info.sexpr_str = malloc((size_t)(strlen(yypvt[-1].sexpr_info.sexpr_str) + 2)))
                          { sprintf(yyval.sexpr_info.sexpr_str, "%s^", yypvt[-1].sexpr_info.sexpr_str);
                            yyval.sexpr_info.sexpr_art = EXPR_VAR;
                            para_pointer(&yyval.sexpr_info, &yypvt[-1].sexpr_info.serg, yypvt[-1].sexpr_info.typserg);
                          }
                          else
                          { komerr(texte[80]); yyval.sexpr_info.sexpr_str = NULL;
                            yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                          }
                        }
                        else
                        { komerr(texte[321], yypvt[-1].sexpr_info.sexpr_str); }
                      }
                      else if (yypvt[-1].sexpr_info.sexpr_art)
                      { komerr(texte[305], "^"); }
                      if (yypvt[-1].sexpr_info.sexpr_str) free(yypvt[-1].sexpr_info.sexpr_str);
                    } /*NOTREACHED*/ break;
case 489:
# line 3896 "parz.y"
{ para_desig_ident(&yyval.sexpr_info, yypvt[-0].ident_key);
                    } /*NOTREACHED*/ break;
case 490:
# line 3901 "parz.y"
{ yyval.sexpr_info = yypvt[-0].select_info.exp; } /*NOTREACHED*/ break;
case 491:
# line 3903 "parz.y"
{ yyval.sexpr_info.sexpr_art = EXPR_SEL_LEER;
                      yyval.sexpr_info.sexpr_str = NULL;
                    } /*NOTREACHED*/ break;
case 492:
# line 3909 "parz.y"
{ char dimnam[20];
                      int dummytok;
                      register long key;

                      sprintf(dimnam, "DIM%d", yypvt[-2].select_info.dimnum + 1);
                      if (!(key = name_to_key(dimnam, &dummytok)) ||
                          !look_sym(key, disp[akt_tiefe]->top_scope))
                      { komerr(texte[329]);
                        yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        yyval.sexpr_info.sexpr_str = NULL;
                      }
                      else
                      { para_desig_ident(&yyval.sexpr_info, key); }
                    } /*NOTREACHED*/ break;
case 493:
# line 3924 "parz.y"
{ yyval.select_info = yypvt[-5].select_info;
                      yyval.select_info.dimnum++;
                      if (yypvt[-5].select_info.exp.sexpr_art == EXPR_VAR)
                      { if (yypvt[-1].sexpr_info.sexpr_art == EXPR_VAR &&
                            yypvt[-2].sexpr_info.sexpr_art == EXPR_VAR)
                        { para_mulop(&yyval.select_info.exp.serg,
                                     &yypvt[-5].select_info.exp.serg, AND, &yypvt[-1].sexpr_info.serg, para_typ[BOOL]); }
                        else
                        { yyval.select_info.exp.sexpr_art = EXPR_FALSCH; }
                      }
                      if (yypvt[-2].sexpr_info.sexpr_str) free(yypvt[-2].sexpr_info.sexpr_str);
                      yyval.select_info.exp.sexpr_str = NULL;
                    } /*NOTREACHED*/ break;
case 494:
# line 3938 "parz.y"
{ yyval.select_info = yypvt[-4].select_info;
                      yyval.select_info.dimnum++;
                      if (yyval.select_info.exp.sexpr_art == EXPR_VAR)
                      { char dimnam[20];
                        int dummytok;
                        register long key;

                        sprintf(dimnam, "DIM%d", yyval.select_info.dimnum);
                        if (!(key = name_to_key(dimnam, &dummytok)) ||
                            !look_sym(key, disp[akt_tiefe]->top_scope))
                        { komerr(texte[329]);
                          yyval.select_info.exp.sexpr_art = EXPR_FALSCH;
                        }
                      }
                      yyval.select_info.exp.sexpr_str = NULL;
                    } /*NOTREACHED*/ break;
case 495:
# line 3955 "parz.y"
{ int dummytok;
                      register long key;

                      if (!(key = name_to_key("DIM1", &dummytok)) ||
                          !look_sym(key, disp[akt_tiefe]->top_scope))
                      { komerr(texte[330]);
                        yyval.sexpr_info.sexpr_art = EXPR_FALSCH;
                        yyval.sexpr_info.sexpr_str = NULL;
                      }
                      else
                      { para_desig_ident(&yyval.sexpr_info, key); }
                    } /*NOTREACHED*/ break;
case 496:
# line 3968 "parz.y"
{ yyval.select_info.dimnum = 1;
                      yyval.select_info.exp = yypvt[-1].sexpr_info;
                      if (yypvt[-2].sexpr_info.sexpr_str) free(yypvt[-2].sexpr_info.sexpr_str);
                    } /*NOTREACHED*/ break;
case 497:
# line 3973 "parz.y"
{ int dummytok;
                      register long key;

                      if (!(key = name_to_key("DIM1", &dummytok)) ||
                          !look_sym(key, disp[akt_tiefe]->top_scope))
                      { komerr(texte[330]);
                        yyval.select_info.exp.sexpr_art = EXPR_FALSCH;
                      }
                      else
                      { yyval.select_info.dimnum = 1;
                        new_var(&yyval.select_info.exp.serg, yyval.select_info.exp.typserg = para_typ[BOOL], VEC);
                                /* $$ := TRUE; */
                        funcs(do_vbb_zuw, print_zuw);
                        STAT_verg(*stat_ptr) = yyval.select_info.exp.serg;
                        ARG_argsort(STAT_vc1(*stat_ptr)) = BOOL | CON;
                        ARG_con_wert(STAT_vc1(*stat_ptr)).datentyp = BOOL | BOOL_ERLAUBT;
                        ARG_con_wert(STAT_vc1(*stat_ptr)).inhalt.b_val = TRUE;
                        nextstat();
                        yyval.select_info.exp.sexpr_art = EXPR_VAR;
                      }
                      yyval.select_info.exp.sexpr_str = NULL;
                    } /*NOTREACHED*/ break;
case 498:
# line 3998 "parz.y"
{ yyval.sexpr_info = yypvt[-2].sexpr_info; } /*NOTREACHED*/ break;
case 499:
# line 4000 "parz.y"
{ yyval.sexpr_info = yypvt[-3].sexpr_info;
                              if (yypvt[-3].sexpr_info.sexpr_art == EXPR_VAR &&
                                  yypvt[-0].sexpr_info.sexpr_art == EXPR_VAR)
                              { para_addop(&yyval.sexpr_info.serg,
                                           &yypvt[-3].sexpr_info.serg, OR, &yypvt[-0].sexpr_info.serg, para_typ[BOOL]);
                              }
                            } /*NOTREACHED*/ break;
case 500:
# line 4008 "parz.y"
{ yyval.sexpr_info = yypvt[-0].sexpr_info; } /*NOTREACHED*/ break;
case 501:
# line 4012 "parz.y"
{ register int etyp =
                                  yypvt[-0].expr_info.typerg ? yypvt[-0].expr_info.typerg : yypvt[-0].expr_info.typlast;
                              register ARG *exp =
                                  yypvt[-0].expr_info.typerg ? &yypvt[-0].expr_info.erg : &yypvt[-0].expr_info.lastval;
                              register int dimtyp = yypvt[-1].sexpr_info.typserg;
                              register ARG *dimvar = &yypvt[-1].sexpr_info.serg;

                              if (yyval.sexpr_info.sexpr_art = (yypvt[-0].expr_info.expr_art == EXPR_VAR &&
                                                  yypvt[-1].sexpr_info.sexpr_art == EXPR_VAR))
                              { if (yyval.sexpr_info.sexpr_art = zuw_ok(etyp, para_typ[BOOL]))
                                { yyval.sexpr_info.serg = *exp;
                                  yyval.sexpr_info.typserg = etyp;
                                  yyval.sexpr_info.sexpr_art = EXPR_VAR;
                                }
                                else if (yyval.sexpr_info.sexpr_art =
                                           (zuw_ok(etyp, para_typ[INT]) &&
                                            rel_ok(etyp, EQ, dimtyp)))
                                { para_relop(&yyval.sexpr_info.serg, dimvar, dimtyp, EQ,
                                                       exp, etyp);
                                  yyval.sexpr_info.sexpr_art = EXPR_VAR;
                                }
                              }
                              else if (yypvt[-0].expr_info.expr_art && yypvt[-0].expr_info.expr_art != EXPR_VAR)
                              { komerr(texte[331], yypvt[-0].expr_info.expr_str); }
                              if (yypvt[-0].expr_info.expr_str) free(yypvt[-0].expr_info.expr_str);
                              yyval.sexpr_info.sexpr_str = NULL;
                            } /*NOTREACHED*/ break;
case 502:
# line 4040 "parz.y"
{ register int etyp1 =
                                  yypvt[-2].expr_info.typerg ? yypvt[-2].expr_info.typerg : yypvt[-2].expr_info.typlast;
                              register ARG *exp1 =
                                  yypvt[-2].expr_info.typerg ? &yypvt[-2].expr_info.erg : &yypvt[-2].expr_info.lastval;
                              register int etyp2 =
                                  yypvt[-0].expr_info.typerg ? yypvt[-0].expr_info.typerg : yypvt[-0].expr_info.typlast;
                              register ARG *exp2 =
                                  yypvt[-0].expr_info.typerg ? &yypvt[-0].expr_info.erg : &yypvt[-0].expr_info.lastval;
                              register int dimtyp = yypvt[-3].sexpr_info.typserg;
                              register ARG *dimvar = &yypvt[-3].sexpr_info.serg;
                              ARG hilf;

                              if (yyval.sexpr_info.sexpr_art = (yypvt[-2].expr_info.expr_art == EXPR_VAR &&
                                                  yypvt[-0].expr_info.expr_art == EXPR_VAR &&
                                                  yypvt[-3].sexpr_info.sexpr_art == EXPR_VAR))
                              { if (yyval.sexpr_info.sexpr_art =
                                      (zuw_ok(etyp1, para_typ[INT]) &&
                                       zuw_ok(etyp2, para_typ[INT]) &&
                                       rel_ok(etyp1, LE, dimtyp) &&
                                       rel_ok(dimtyp, LE, etyp2)))
                                { para_relop(&yyval.sexpr_info.serg, exp1, etyp1, LE,
                                                       dimvar, dimtyp);
                                  para_relop(&hilf, dimvar, dimtyp, LE,
                                                    exp2, etyp2);
                                  para_mulop(&yyval.sexpr_info.serg,
                                             &yyval.sexpr_info.serg, AND, &hilf, para_typ[BOOL]);
                                  yyval.sexpr_info.sexpr_art = EXPR_VAR;
                                }
                              }
                              else
                              { if (yypvt[-2].expr_info.expr_art && yypvt[-2].expr_info.expr_art != EXPR_VAR)
                                { komerr(texte[331], yypvt[-2].expr_info.expr_str); }
                                if (yypvt[-0].expr_info.expr_art && yypvt[-0].expr_info.expr_art != EXPR_VAR)
                                { komerr(texte[331], yypvt[-0].expr_info.expr_str); }
                              }
                              if (yypvt[-2].expr_info.expr_str) free(yypvt[-2].expr_info.expr_str);
                              if (yypvt[-0].expr_info.expr_str) free(yypvt[-0].expr_info.expr_str);
                              yyval.sexpr_info.sexpr_str = NULL;
                            } /*NOTREACHED*/ break;
case 503:
# line 4082 "parz.y"
{ unputc('|'); } /*NOTREACHED*/ break;

}


}
