%{
/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Scanner
  Filename     : parz.l       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.parz.l
  Version      : 1.3 
  Last changed : 9/27/93 at 14:05:09        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : lexikalische Analyse fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)parz.l	1.3  9/27/93 PARZ - Scanner (Frank Sembach)";

# define SB -1
# define SC -1
# define SI -1
# define SR -1
# define VB -2
# define VC -2
# define VI -2
# define VR -2
    /******************************************************/
#ifdef DEB

    main()
    { char *p;

      while (p = (char *)yylex())
        printf("%-10.10s is \"%s\"\n",p,yytext);
    }
#   define token(x) (int)"x"

#else

#   define token(x) x

#endif
    /******************************************************/
#define SCAN 1
#include "parzdefs.h"
#include "komdefs.h"
#include "y_tab.h"
#include "rundefs.h"
#include "komexts.h"
#include "toup.h"
#ifdef MAC
extern double myatof();
#endif
extern char quitted;
extern int yychar;              /* Tokenpuffer des Parsers */
extern int flags;               /* Zeigt an, was bereits gelesen wurde :
                                   START, PE, PORTS, SCALAR, VECTOR, STOP */
extern
#ifdef RS6000
       signed
#endif
              char parse_start; /* Benutzungsart des Parsers :
                                    1 : Programm (anfangs),
                                    2 : Kommandos (anfangs)
                                   -1 : im Programm
                                   -2 : im Kommando
                                   -3 : Kommandoeingabe von Programmteilen */
extern char do_step;            /* parser hat "#\n" zurueckgegeben */
extern char scanner_fehler;     /* scanner hat in Zeile Fehler gemeldet */

extern FILE *kommandin;         /* Dateizeiger fuer Kommandoeingabe */
extern FILE *kommandout;        /* Dateizeiger fuer Kommandoausgabe */

# ifdef YYDEBUG
extern int yydebug;             /* Flag : Parser-Debugmodus */
#endif

# ifdef LEXDEBUG
int lexdebug = 0;               /* Flag : Scanner-Debugmodus */
#endif

char *bit_pack();

char *stringtext;               /* Eingelesener String */

int tzaehl = 0;                 /* Zaehler fuer Tokens seit Zeilenanfang */

char ausgeben;                  /* Flag : Naechste Fehlermeldung ausgeben */

char bef_lesen;                 /* Flag : Befehlstoken erwartet (Kommandointerp. ) */
int bef_tok = 0;                /* zuletzt eingelesener Befehl */
int para_mode = FALSE;          /* Flag einlesen von Parallaxis Ausdruecken */

#ifdef MAC
extern char **texte;
#else
extern char *texte[];           /* Fehlertexte */
#endif
extern char fperror;            /* Flag : Fliesskommafehler */
extern char loadfilename[];     /* Name der zu ladenden bzw. compilierenden Datei */

%}

%Start PAR PARFORT FNAM PARALLAXIS

D [0-9]+
L [a-zA-Z]
PL [a-zA-Z_]
LD [a-zA-Z0-9_]

%%
[ \t] ;
<FNAM>[^ \t\n]+   { /* Dateiname */
                    strcpy(loadfilename, yytext);
                    BEGIN 0;
                    return token(FILENAME);
                  }
";".*      { /* Kommentar */
             if (yyleng == 1)
             { yylval.comment = NULL; }
             else
             { if (yylval.comment = calloc((size_t)yyleng,(size_t)sizeof(char)))
                 strcpy(yylval.comment, yytext + 1);
               else
                 fatal(texte[60]);
             }
             BEGIN 0;
             tzaehl++;
             if (parse_start == -3) parse_start = -2;
             return token(';') ;
           }
[-+:!\[\]()*/\^,\\{}\.] { /* Einzelzeichen */
                          if (!para_mode) BEGIN 0;
                          tzaehl++;
                          return token(yytext[0]);
                        }
".."    { if (!para_mode) BEGIN 0;
          tzaehl++; return token(PP);
        }
":="    { if (!para_mode) BEGIN 0; tzaehl++; return token(AOP); }
"="     { if (!para_mode) BEGIN 0; tzaehl++; return token(EQ); }
"<>"    { if (!para_mode) BEGIN 0; tzaehl++; return token(NE); }
"<"     { if (!para_mode) BEGIN 0; tzaehl++; return token(LT); }
"<="    { if (!para_mode) BEGIN 0; tzaehl++; return token(LE); }
">"     { if (!para_mode) BEGIN 0; tzaehl++; return token(GT); }
">="    { if (!para_mode) BEGIN 0; tzaehl++; return token(GE); }
<PARALLAXIS>"~"  { tzaehl++; return token(NOT); }
<PARALLAXIS>"**" { tzaehl++; return token(POWER); }

<PARALLAXIS>\"[^\"\n]*\" |
<PARALLAXIS>\'[^\'\n]*\' { /* Parallaxis-String  */
                           tzaehl++;
                           if (yyleng == 3)
                           { yylval.char_val = (unsigned char)yytext[1];
                             return token(CHAR);
                           }
                           else
                           { if (stringtext = calloc((size_t)(yyleng-1),
                                                     (size_t)sizeof(char)))
                             { strncpy(stringtext, yytext + 1, (size_t)(yyleng - 2)); }
                             else
                             { fatal(texte[60]); }
                             yylval.string_val = stringtext;
                             return token(STRING);
                           }
                         }

\'(.|\'\')\' { /* CHAR-Konstante '...' */
               yylval.char_val = (unsigned char)yytext[1];
               if (!para_mode) BEGIN 0;
               tzaehl++;
               return token(CHAR);
             }
[cC][hH][rR]\({D}\) { /* CHAR-Konstante chr(...) */
                      int i;
                      if (para_mode)
                      { REJECT; }
                      else
                      { sscanf(yytext + 4, "%d", &i);
                        yylval.char_val = (unsigned char)i;
                        BEGIN 0;
                        tzaehl++;
                        return token(CHAR);
                      }
                    }
\"([^\"\n]|\"\")*\" { /* STRING-Konstante "..." */
                      register char *sp, *tp;
                      register int i;

                      if (stringtext = calloc((size_t)(yyleng-1),(size_t)sizeof(char)))
                      { for (sp = stringtext, tp = yytext + 1, i = 0;
                             i < yyleng - 2;
                             sp++, tp++, i++)
                        { *sp = *tp;
                          if (*sp == '"') { i++, tp++; }
                        }
                        *sp = '\0';
                      }
                      else
                        fatal(texte[60]);
                      yylval.string_val = stringtext;
                      if (!para_mode) BEGIN 0;
                      tzaehl++;
                      return token(STRING);
                    }
<PAR>[01][01 \t]*/(.|\n[^01 \t\n]) { /* Bitstring auf einer Zeile */
                   tzaehl++;
                   yylval.bitstring_val = bit_pack(yytext);
                   if (!para_mode) BEGIN 0;
                   return token(BITSTRING);
                 }
<PAR>[01][01 \t]*/(\n[01 \t\n]) { /* Anfang mehrzeiliger Bitstring */
                   if (stringtext = calloc((size_t)(yyleng+1),(size_t)sizeof(char)))
                     strcpy(stringtext,yytext);
                   else
                     fatal(texte[60]);
                   BEGIN PARFORT;
                 }
<PARFORT>[01 \t]+/(.|\n[^01 \t\n]) { /* Ende mehrzeiliger Bitstring */
                   tzaehl++;
                   bit_append();
                   yylval.bitstring_val = bit_pack(stringtext);
                   free(stringtext);
                   if (!para_mode) BEGIN 0;
                   return token(BITSTRING);
                 }
<PARFORT>[01 \t]+/(\n[01 \t\n]) { /* Fortsetzung mehrzeiliger Bitstring */
                   bit_append();
                 }
<PARFORT>\n/((\n)?[^01 \t\n]) { /* Ende (mit \n ) mehrzeiliger Bitstring */
             tzaehl++;
             yylval.bitstring_val = bit_pack(stringtext);
             free(stringtext);
             if (!para_mode) BEGIN 0;
             return token(BITSTRING);
           }
<PARFORT>\n/\n[01 \t\n] { /* Fortsetzung (mit \n) mehrzeiliger Bitstring */
           }
{D}/[ \t]*\(  { /* INTEGER-Konstante gefolgt von Klammer auf */
                yylval.int_val = atol(yytext);
                if (!para_mode) BEGIN 0;
                tzaehl++;
                return token(INTKLAM);
              }
{D}       |
{D}/".."  { /* INTEGER-Konstante */
            yylval.int_val = atol(yytext);
            if (!para_mode) BEGIN 0;
            tzaehl++;
            return token(INTNUM);
          }
{D}(\.{D}?)?([eE][-+]?{D})?    |
(\.{D})([eE][-+]?{D})?         { /* REAL-Konstante */
                                 yylval.real_val =
#ifdef MAC
                                                   myatof(yytext);
#else
                                                   atof(yytext);
#endif
                                 if (fperror)
                                 { yylval.real_val = HUGE; }
                                 else if (fabs(yylval.real_val) == HUGE)
                                 { fperror = TRUE; }
                                 if (!para_mode) BEGIN 0;
                                 tzaehl++;
                                 return token(REALNUM);
                               }
<PARALLAXIS>{PL}{LD}*   { /* Parallaxis Identifier */
                          int tok;

                          if (!(yylval.ident_key = name_to_key(yytext, &tok)))
                          { komerr(texte[301], yytext);
                            scanner_fehler = TRUE; tok = 0;
                          }
                          return tok;
                        }
{L}+        { /* Buchstabenfolge */
              int tok = lookup();

              switch (tok)
              { case PARALLEL :
                case INITSET  : BEGIN PAR;
                                tzaehl++;
                                return tok;
                case -1 : unput(yytext[yyleng-1]);
                          BEGIN 0;
                          tzaehl++;
                          return token(S);
                case -2 : unput(yytext[yyleng-1]);
                          BEGIN 0;
                          tzaehl++;
                          return token(V);
                case 0  : error(texte[6]);
                          fehler_zahl++; tzaehl++;
                          if (flags == VECTOR_DA)
                          { ups();
                            unput(';');
                            ausgeben = FALSE;
                          }
                          else if (parse_start == -2 || parse_start == -3)
                          { ausgeben = FALSE;
                            scanner_fehler = TRUE;
                            return 1;
                          }
                          break;
                default : BEGIN 0;
                          tzaehl++;
                          return tok;
              }
            }
\n  { /* newline */
      tzaehl = 0;
      if (parse_start == -2 || parse_start == -3)
      { bef_lesen = TRUE;
        BEGIN 0; para_mode = FALSE;
        return token(ZEILEND);
      }
    }
!!0!!   { /* Parser-Debug aus */
#         ifdef YYDEBUG
            yydebug = 0;
#         else
            REJECT;
#         endif
        }
!!1!!   { /* Parser-Debug ein */
#         ifdef YYDEBUG
            yydebug = 1;
#         else
            REJECT;
#         endif
        }
!!0l!!  { /* Scanner-Debug aus */
#         ifdef LEXDEBUG
            lexdebug = 0;
#         else
            REJECT;
#         endif
        }
!!1l!!  { /* Scanner-Debug ein */
#         ifdef LEXDEBUG
            lexdebug = 1;
#         else
            REJECT;
#         endif
        }
"$" { /* Dollar-Zeichen : nur erlaubt als Umschalter Programm/Kommando */
      switch (parse_start)
      { case -1 : error(texte[7], yytext[0]);
                  fehler_zahl++; tzaehl++;
                  break;
        case -2 :
        case -3 : komerr(texte[7], yytext[0]);
                  scanner_fehler = TRUE;
                  break;
        case  1 : parse_start = -1;
                  return token(PROGRAMMSTART);
        case  2 : parse_start = -2;
                  bef_lesen = TRUE;
                  return token(KOMMANDOSTART);
        default : bug("parz.l : Falscher Wert parse_start : %d", parse_start);
      }
    }
"?" { /* Fragezeichen : Als Kommando Ersatz fuer HELP */
      if (parse_start == -2 || parse_start == -3) return (bef_tok = token(HELP));
      else
      { error(texte[7], yytext[0]); fehler_zahl++; tzaehl++; }
    }
<PARALLAXIS>"&" { tzaehl++; return token(AND); }
"&" { /* &-Zeichen : nur erlaubt zum Umschalten auf Einlesen von Filenamen */
      if (parse_start == -2 || parse_start == -3)
      { if (!bef_lesen && bef_tok == LOAD)
        { BEGIN FNAM; }
        else
        { komerr(texte[7], yytext[0]);
          scanner_fehler = TRUE;
        }
      }
      else
      { error(texte[7], yytext[0]); fehler_zahl++; tzaehl++; }
    }
<PARALLAXIS>"#" { tzaehl++; return token(NE); }
"#" { /* #-Zeichen : nur erlaubt als Pseudoeingabe fuer STEP nach Abbruch, STEP TO/ALL*/
      if (parse_start == -2 || parse_start == -3)
      { if (do_step)
        { do_step = FALSE;
          return '#';
        }
        else
        { komerr(texte[7], yytext[0]);
          scanner_fehler = TRUE;
        }
      }
      else
      { error(texte[7], yytext[0]); fehler_zahl++; tzaehl++; }
    }
"|" { /* |-Zeichen : nur erlaubt zum Umschalten auf Parallaxis-Modus */
      if (parse_start == -2 || parse_start == -3)
      { BEGIN PARALLAXIS;
        para_mode = TRUE;
      }
      else
      { error(texte[7], yytext[0]); fehler_zahl++; tzaehl++; }
    }
.   { /* Unerlaubtes Zeichen */
      if (parse_start == -2 || parse_start == -3)
      { komerr(texte[7], yytext[0]);
        scanner_fehler = TRUE;
      }
      else
      { error(texte[7], yytext[0]); fehler_zahl++; tzaehl++; }
    }

%%

        /* Tabelle der Schluesselworte im Programmtext :
           so geordnet, dass gilt: tabelle[2*n] < tabelle[n] < tabelle[2*n+1]
         */
static struct key_tab
       { char *name;    /* Schluesselwort in Grossbuchstaben */
         int tokn;      /* zugehoeriges Token */
       } tabelle[] =
# include "key.tab"

        /* Tabellen fuer Kommandointerpreter
              static struct kom_tab ktabelle[];
              static struct opt_tab otabelle[];
         */
# include "kom.tab"

char namebuf[MAX_LENG]; /* Speicher fuer eingelesenen Namen in Grossbuchstaben */


/**************************************************************************
 ***                  Funktion lookup
 ***
 *** ermittelt das Token zu 'yytext'
 *** sucht abhaengig von 'parse_start' und 'bef_lesen' in
 *** tabelle, ktabelle oder otabelle.
 ***
 **************************************************************************/

int lookup()
{ register int n;

#ifdef LEXDEBUG
  if (lexdebug)
  { printf("yytext = %s\nparse_start = %d, bef_tok = %d, bef_lesen = %d\n",
           yytext, parse_start, bef_tok, bef_lesen);
  }
#endif
                /* 'yytext' in Grossbuchstaben nach 'namebuf' kopieren
                   (max. MAX_LENG Buchstaben )
                 */
  for (n = 0; (n < yyleng) && (n < MAX_LENG - 1); namebuf[n] = mytoupper(yytext[n]), n++);
  namebuf[n] =  '\0';
  switch (parse_start)
  { case -1 :
    case -3 :
                /* suche Text in tabelle */
      for (n = 1; n <= MAX_KEYWORDS; )
      { switch (sign(strcmp(namebuf,tabelle[n].name)))
        { case  0 : return tabelle[n].tokn;
          case  1 : n = (n << 1) + 1;
                    break;
          case -1 : n <<= 1;
                    break;
        }
      }
      if (parse_start == -3 && yyleng > 1 && bef_tok != VARIABLE)
                /* nicht gefunden : zusammenhaengende Optionen aufbrechen */
      { for (n = yyleng - 1; n > 0; n--)
        { unput(' '); unput(yytext[n]); }
        yytext[1] = '\0';
        yyleng = 1;
        return lookup();
      }
      return 0;
    case -2 :
      if (bef_lesen)
                /* suche Text in ktabelle */
      { struct kom_tab *kompt;

        for (kompt = ktabelle; kompt->knam; kompt++)
        { if (kompt->minvergl <= n)        /* Eingabe lang genug */
          { if (strncmp(kompt->knam, namebuf, (size_t)n) == 0)  /* gefunden */
            { if (bef_tok == HELP)
              { return kompt->ktok;     /* Argument zu HELP gelesen */
              }
              else
              { switch (bef_tok = kompt->ktok)
                { case HELP       : break;      /* evtl. noch einen Befehl lesen */
                  case TRACE      :
                  case NOTRACE    :
                  case SET        : parse_start = -3;
                                    break;      /* Programmteile lesen */
                  case LOAD       : unput('&');
                                    bef_lesen = FALSE;
                                    break;      /* Dateiname lesen */
                  case BREAKPOINT :
                  case EXAMINE    : BEGIN PARALLAXIS;
                                    break;
                  default         : bef_lesen = FALSE;
                                    break;      /* Optionen lesen */
                }
                return bef_tok;
              }
            }
          }
        }
        komerr(texte[0], yytext);       /* unbekannter Befehl */
        ueberlies_zeile(); unput('\n');
        return HELP;
      }
      else
                /* suche Text in otabelle */
      { register struct opt_tab *optpt;
        register int verg, tok;

        for (optpt = otabelle; optpt->ktok && optpt->ktok < bef_tok; optpt++);
        for (; optpt->onam &&
               optpt->ktok == bef_tok &&
               (verg = strncmp(optpt->onam, namebuf, (size_t)n)) <= 0; optpt++)
        { if (verg == 0)
          { switch (tok = optpt->otok)
            { case MEMORY   :
              case HEAP     :
              case PARSTACK :
              case SPECIALS : parse_start = -3;
                              break;    /* Programmteile lesen */
              case CALLSTACK: bef_tok = CALLSTACK;
                              break;    /* Optionen lesen */
              case VARIABLE : parse_start = -3;
                              bef_tok = VARIABLE;
                              break;    /* Programmteile lesen */
            }
            return tok;
          }
        }
        if (yyleng > 1 && bef_tok != VARIABLE)
                /* nicht gefunden : zusammenhaengende Optionen aufbrechen */
        { for (n = yyleng - 1; n > 0; n--)
          { unput(' '); unput(yytext[n]); }
          yytext[1] = '\0';
          yyleng = 1;
          return lookup();
        }
        return 1;
      }
    default : bug("parz.l/lookup : Falscher wert von parse_start : %d", parse_start);
  }
}

/**************************************************************************
 ***                       Funktion bit_append
 ***
 *** haengt 'yytext' an den bisher in 'stringtext' aufgesammelten Bitstring
 ***
 **************************************************************************/

bit_append()
{ register size_t l = strlen(stringtext) + (size_t)(yyleng + 1);

  if (stringtext = realloc(stringtext, l))
    strcat(stringtext,yytext);
  else
    fatal(texte[60]);
}

/**************************************************************************
 ***                       Funktion bit_pack
 ***
 *** liefert Kopie von 'str', in der alles ausser '0' und '1' fehlt.
 ***
 **************************************************************************/

char *bit_pack(str)
char *str;
{ register char *bp;
  register char c;
  register char *bits = calloc((size_t)(strlen(str) + 1), (size_t)sizeof(char));
  register size_t l;

  if (bits)
  { for (bp = bits; c = *str; str++)
    { if (c == '0' || c == '1')
      { *(bp++) = c;}
    }
    *bp = '\0';
  }
  else
    fatal(texte[60]);
  l = (size_t)(bp - bits + 1);
  return realloc(bits, l);
}

/**************************************************************************
 ***                        Funktion lies_comm
 ***
 *** liefert NULL, wenn in Zeile bisher maximal ein Token gelesen
 *** sonst : ueberliest Eingabezeile bis zum ';' und liefere die Restzeile
 ***         kein ';' in Zeile : liefere "\0"
 ***
 **************************************************************************/

char *lies_comm()
{ char c;

  if (tzaehl <= 1)
  { return NULL; }
  else
  { ups();
    while ((c = input()) != ';' && c != '\n');
                /* mindestens ein Zeichen im Kommentar */
    unput(' '); unput(c);
    if (c == ';')
    { yylex();
      return yylval.comment;
    }
    else
    { return "\0"; }
  }
}

/**************************************************************************
 ***                     Funktion lies_zend
 ***
 *** liefert NULL, wenn in Zeile bisher maximal ein Token gelesen
 *** sonst : setze ';' in Eingabestream ein, liefere Ergebnis von 'lies_comm'
 ***
 **************************************************************************/

char *lies_zend()
{ if (tzaehl <= 1)
  { return NULL; }
  else
  { ups();
    unput(';');
    yyleng = 0;       /* verhindert, dass lies_comm yytext nochmal zurueckgibt */
    return lies_comm();
  }
}

/**************************************************************************
 ***                  Funktion ueberlies_zeile
 ***
 *** ueberliest im Kommandointerpreter Rest der Eingabezeile,
 *** setzt Kommandointerpreter in Zustrand "Befehlswort lesen"
 ***
 **************************************************************************/

ueberlies_zeile()
{ while (input() != '\n');
  bef_tok = 0; bef_lesen = TRUE;
}

/**************************************************************************
 ***                  Funktion ups
 ***
 *** gibt 'yytext' an die Leseroutine zurueck
 ***
 **************************************************************************/

ups()
{ register char *p;

  for (p = yytext + yyleng - 1; p >= yytext;)
  { unput(*p--);
  }
}

/**************************************************************************
 ***                        Funktion unputc
 ***
 *** identisch zu unput, aber auch von ausserhalb lex_yy.c ansprechbar
 ***
 **************************************************************************/

unputc(c)
char c;
{ unput(c); }

/**************************************************************************
 ***                        Funktion para_off
 ***
 *** schaltet den Source-Scan-Modus aus
 ***
 **************************************************************************/

para_off()
{ para_mode = FALSE; BEGIN 0; }

/**************************************************************************
 ***                  Funktion yywrap
 ***
 *** verlaesst PARZ, wenn bei Kommandoeingabe EOF auftritt
 ***
 **************************************************************************/

yywrap()
{ if (parse_start <= -2)
  { putc('\n', kommandout);
    parzexit(0);
  }
  else return(1);
}
