/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : parzdefs.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.parzdefs.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:15        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Globale Definitionen fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


#ifndef SCAN
#  include <stdio.h>
#endif
#ifdef PC
#  include <stdlib.h>
#  ifdef SCAN
#    undef YYLMAX
#    define YYLMAX 300
#    undef NLSTATE
#  endif
#else
#  define size_t unsigned
#endif

#include <ctype.h>
#include <math.h>
#include <signal.h>
#include <errno.h>
#ifdef MAC
extern int errno;
# define HUGE HUGE_VAL
#endif

#ifdef PC
#  define random() rand()
#  define srandom(x) srand((unsigned int) x)
#endif

#ifdef HP_UX
#  undef HUGE
#  define HUGE MAXFLOAT

extern double drand48();
#  define random() (int)(drand48() * ((1<<(sizeof(int) * 8 - 1)) - 1))
#  define srandom(x) srand48((long) x)
#endif

#define FEHLERMAX 15
#define MORELEN 23

#define STACKPARTLEN 5

#ifdef PC
#define STARTPROGLEN 50
#else
#define STARTPROGLEN 1000
#endif

#define MIN_PRINTING_CHAR ' '
#define MAX_PRINTING_CHAR '\176'

#ifndef TRUE
#  define TRUE 1
#  define FALSE 0
#endif

#define EOL_CHAR '\n'
#define TERMS_CHAR '\0'

#define BOOL 0
#define CHA 1
#define INT 2
#define REAL 3
#define SUMM 4
#define STR 4
#define KEINER 5
#define UNDEF_ERG 8
#define MARKE 16
#define ERLAUBT_SHIFT 5
#define BOOL_ERLAUBT (1<<(BOOL+ERLAUBT_SHIFT))
#define CHA_ERLAUBT (1<<(CHA+ERLAUBT_SHIFT))
#define INT_ERLAUBT (1<<(INT+ERLAUBT_SHIFT))
#define REAL_ERLAUBT (1<<(REAL+ERLAUBT_SHIFT))
typedef int TYP;  /* fuer WERTE BOOL .. KEINER | MARKE | BOOL_ERLAUBT | CHA_ERLAUBT | INT_ERLAUBT | REAL_ERLAUBT */

#define ALLTYPS (BOOL | CHA | INT | REAL | STR | KEINER)
#define ALL_ERLAUBT (BOOL_ERLAUBT | CHA_ERLAUBT | INT_ERLAUBT | REAL_ERLAUBT)
#define TYP_erlaubt(t) (t & ALL_ERLAUBT)
#define ERLAUBT(t) ((1<<ERLAUBT_SHIFT)<<(t))
#define CH_TYP(t,x) (((t) & ~ALLTYPS) | (x))
#define UNDEF_CPY(t,x) (((t) & ~UNDEF_ERG) | ((x) & UNDEF_ERG))
#define UNDEF_PUT(t,x) (t |= ((x) & UNDEF_ERG))

#define VEC 8
#define IND 16
#define INDL 32
#define ADS 64
#define ADV 128
#define CON 256
#define SPEZ 512
#define SIZ 1024
#define FALSCH 2048
typedef int ARGART; /* fuer Werte BOOL .. KEINER | VEC | IND | INDL | ADS | ADV | CON | SPEZ | SIZ | FALSCH
                       Bit 3 = 0 : Scalare Variable
                             = 1 : Vektorvariable
                     Bit 4,5 = 0 : direkte Variable
                       Bit 4 = 1 : indirekte Variable
                       Bit 5 = 1 : lokal indirekte Variable
                     Bit 6,7 = 0 : normal
                       Bit 6 = 1 : skalare Adressierung
                       Bit 7 = 1 : vektorielle Adressierung
                       Bit 8 = 0 : Variable
                             = 1 : Konstante
                       Bit 9 = 0 : normale Variable
                             = 1 : vordefinierte Variable
                      Bit 10 = 1 : Groesse einer Deklaration
                      Bit 11 = 1 : Fehler im Programm  */

#define AA_typ(a) (a & ALLTYPS)

/* Werte fuer Parserzustand */
#define START_DA 1
#define PE_DA 2
#define PORTS_DA 3
#define SCALAR_DA 4
#define VECTOR_DA 5
#define STOP_DA 6

typedef struct          /* Simulator-Speicherstelle */
{ TYP datentyp;
  union
  { int   b_val;
    unsigned char  c_val;
    long  i_val;
    float r_val;
    char  *s_val;
  } inhalt;
} ITEM;

#define ITEM_typ(i) (((i).datentyp) & ALLTYPS)

typedef struct port
{ ITEM inbuf;            /* Puffer fuer ankommende Daten */
  int out_count;         /* Zahl der Zeiger in '*zielarr' */
  struct port **zielarr; /* Ziel-PORT-Zeiger fuer abgehende Daten */
} PORT;

/* Adressierung von Port 'po' in Prozessor 'pe' */
#define PNR(pe,po) portarray[port_anz * ((pe) - 1) + (po) - 1]

typedef struct stacktyp         /* verkettete Liste von Parameterstacksegmenten */
{ ITEM speicher[STACKPARTLEN];  /* Stacksegment */
  int top;                      /* speicher[top] ist erste freie Speicherstelle */
  struct stacktyp *n_stack_part;/* Verkettungszeiger auf Block weiter unten im Stack */
} STACK;

typedef enum {FELD, KLAM, UNION} DECL_ART;

typedef struct declist
{ struct decl *darray;          /* Feld von Deklarationen */
  int dcount;                   /* Zahl der Elemente in 'darray' */
  int typ_zahl[SUMM + 1];       /* Variablenzahlen in Deklaration */
} DECLIST;

typedef struct union_list
{ DECLIST *uarray;          /* Liste der Varianten */
  int ucount;               /* Zahl der Varianten in 'uarray' */
  int utyp_anz[SUMM + 1];   /* Zahl der Typnummern (BOOL .. REAL)
                               bzw. tatsaechliche Zahl der Speicherplaetze (SUMM) */
} UNION_LIST;

typedef struct decl             /* Struktur fuer Variablendeklarationen */
{ DECL_ART art;                 /* Unterscheidet Var.Dekl. von (geklammerter) Unterdekl. */
  union
  { /* fuer art == FELD : 't zahl' */
    struct
    { TYP t;                    /* Variablentyp */
      int zahl;                 /* Anzahl */
    } feld;
    /* fuer art == KLAM : 'wiederh( klamdecl )'*/
    struct
    { int wiederh;              /* Zahl der Wiederholungen der Unterdekl. */
      DECLIST klamdecl;         /* geschachtelte Deklaration*/
    } klam;
    /* fuer art == UNION : 'U( unionlist )' */
    UNION_LIST ul;              /* Varianten */
  } was;
} DECL;
#define DECL_art(dec) ((dec).art)
#define DECL_t(dec) ((dec).was.feld.t)
#define DECL_zahl(dec) ((dec).was.feld.zahl)
#define DECL_wiederh(dec) ((dec).was.klam.wiederh)
#define DECL_typ_anz(dec) ((dec).was.klam.klamdecl.typ_zahl)
#define DECL_klamdecl(dec) ((dec).was.klam.klamdecl)
#define DECL_ul(dec) ((dec).was.ul)

typedef struct arg   /* PARZ-Befehlsarguments */
{ ARGART argsort;    /* Typ des Arguments */
  union
  { ITEM con_wert;   /* arg ist Konstante */
    DECLIST *sizedec;/* arg ist SIZE-Konstante */
    int vartok;      /* arg ist vordefinierte Variable */
    struct           /* arg ist normale Variable
                        (direkt oder indiziert) */
    { int tiefe;     /*   abs. Ebene */
      int num;       /*   Offset rel. zu Ebene und Typ */
      int absoffs;   /*   Offset rel. zu Ebene */
      int gut_proc;  /*   absoffs stimmt, wenn
                          programm[gut_proc] = PROC-Befehl der
                             aktuellen Prozedur auf Ebene 'tiefe' */
    } var;
  } asort;
  ARGART indsort;    /* Art der Indexvariable */
  int vartiefe;      /* Tiefe der Gesamtvariable bei INDL-Variable */
} ARG;
#define ARG_argsort(a) ((a).argsort)
#define ARG_con_wert(a) ((a).asort.con_wert)
#define ARG_sizedec(a) ((a).asort.sizedec)
#define ARG_vartok(a) ((a).asort.vartok)
#define ARG_tiefe(a) ((a).asort.var.tiefe)
#define ARG_num(a) ((a).asort.var.num)
#define ARG_absoffs(a) ((a).asort.var.absoffs)
#define ARG_gut_proc(a) ((a).asort.var.gut_proc)
#define ARG_indsort(a) ((a).indsort)
#define ARG_vartiefe(a) ((a).vartiefe)
#define ARG_typ(a) AA_typ(ARG_argsort(a))
#define ARG_valtyp(a) (ARG_argsort(a) & (ADS | ADV) ? INT : ARG_typ(a))
#define ARG_indtyp(a) AA_typ(ARG_indsort(a))

typedef struct Stat     /* PARZ-Befehl */
{ int label;            /* Zeilennummer */
  int para_zeile;       /* Zeilennummer im Parallaxis-Programm */
  int (*do_func)();     /* Funktion, die den Befehl ausfuehrt */
  int (*print_func)();  /* Funktion, die den Befehl ausgibt */
  struct                /* max. drei Argumente */
  { union               /* erstes Argument */
    { ARG vc1;          /*   Variable oder Konstante */
      DECLIST *dnew;    /*   Deklaration fuer NEW */
      DECLIST *dblock;  /*   Deklaration fuer MOVE, EQUAL */
      DECLIST *dscal;   /*   SCALAR Declaration fuer PROC */
      char *parbits;    /*   Bitstring fuer PARALLEL */
      char *setbits;    /*   Bitstring fuer INITSET */
      ARG cin_port;     /*   Eingangsport fuer CONNECTED */
    } arg1;
    union               /* zweites Argument */
    { ARG vc2;          /*   Variable oder Konstante */
      DECLIST *dvec;    /*   VECTOR Deklaration fuer PROC */
      DECLIST *dload;   /*   Deklaration fuer LOAD / STORE */
      int pe_nr;        /*   Pe-Nr fuer LOAD, STORE */
      int red_fct;      /*   Funktion fuer REDUCE: Token oder Sprungziel */
      ARG out_port;     /*   Ausgangsport fuer PROPAGATE, CONNECTED */
    } arg2;
    union               /* drittes Argument */
    { ARG verg;         /*   Ergebnisvariable */
      ARG vc3;          /*   Vergleichsvar. fuer EQUAL */
      int proclev;      /*   Schachtelungsebene fuer PROC */
      struct            /*   Beschreibung von Sprung */
      { int spr_ziel;   /*     Sprungziel
                                  negativ : label
                                  positiv : Befehlsnummer */
        int rel_tok;    /*     Token von evtl. Vergleichsoperation bei IF, WHILE */
      } spr_beschr;
      ARG in_port;      /*   Eingangsport fuer PROPAGATE */
    } arg3;
    int falsch;         /* Befehl ist falsch */
  } sargs;
  char *comm_text;      /* Kommentartext */
  char bpoint;          /* Breakpointflags */
  struct zeiltab **src_ln;/* Beginnende Quell-Statements */
  int src_ln_count;     /* Zahl der Elemente in 'src_ln' */
  int src_next;         /* Flag : Ende eines Quell-Statements */
  struct scopetab **scopes;/* Beginnende Quell-Geltungsbereiche */
  int scopes_count;     /* Zahl der Elemente in 'scopes' */
} STAT;
#define STAT_label(s) ((s).label)
#define STAT_para_zeile(s) ((s).para_zeile)
#define STAT_do_func(s) ((s).do_func)
#define STAT_print_func(s) ((s).print_func)
#define STAT_vc1(s) ((s).sargs.arg1.vc1)
#define STAT_dnew(s) ((s).sargs.arg1.dnew)
#define STAT_dblock(s) ((s).sargs.arg1.dblock)
#define STAT_dscal(s) ((s).sargs.arg1.dscal)
#define STAT_parbits(s) ((s).sargs.arg1.parbits)
#define STAT_setbits(s) ((s).sargs.arg1.setbits)
#define STAT_cin_port(s) ((s).sargs.arg1.cin_port)
#define STAT_vc2(s) ((s).sargs.arg2.vc2)
#define STAT_dvec(s) ((s).sargs.arg2.dvec)
#define STAT_dload(s) ((s).sargs.arg2.dload)
#define STAT_pe_nr(s) ((s).sargs.arg2.pe_nr)
#define STAT_red_fct(s) ((s).sargs.arg2.red_fct)
#define STAT_out_port(s) ((s).sargs.arg2.out_port)
#define STAT_verg(s) ((s).sargs.arg3.verg)
#define STAT_vc3(s) ((s).sargs.arg3.vc3)
#define STAT_proclev(s) ((s).sargs.arg3.proclev)
#define STAT_spr_ziel(s) ((s).sargs.arg3.spr_beschr.spr_ziel)
#define STAT_rel_tok(s) ((s).sargs.arg3.spr_beschr.rel_tok)
#define STAT_in_port(s) ((s).sargs.arg3.in_port)
#define STAT_falsch(s) ((s).sargs.falsch)
#define STAT_comm_text(s) ((s).comm_text)
#define STAT_bpoint(s) ((s).bpoint)
#define STAT_src_ln(s) ((s).src_ln)
#define STAT_src_ln_count(s) ((s).src_ln_count)
#define STAT_src_next(s) ((s).src_next)
#define STAT_scopes(s) ((s).scopes)
#define STAT_scopes_count(s) ((s).scopes_count)

/* Bits fuer Breakpoints und Protokoll-an */
#define COMP_BREAK 1
#define USER_BREAK 2
#define TO_BREAK 4
#define PROT_ON 8

#include "debdefs.h"

extern int fehler_zahl;         /* Zahl der tatsaechlich ausgegebenen Fehler */

#ifdef YYDEBUG
#  define calloc my_calloc
#  define realloc my_realloc
#  define free my_free
#  define malloc my_malloc
extern char *calloc(), *realloc(), *malloc();
extern void free();
#else
#  ifdef PC
extern void *calloc();
#  else
#    if !defined(RS6000) || defined(MIPS)
extern char *calloc(), *realloc(), *malloc();
extern void free();
#    else
extern void *pscalloc(), *psmalloc();
#      define calloc pscalloc
#      define malloc psmalloc
#    endif
#  endif
#endif

# ifndef SCAN
extern int my_getc(), my_getchar(), my_fgetc(), my_ungetc();
extern char *my_gets(), *my_fgets();

#undef getc
#define getc my_getc
#undef getchar
#define getchar my_getchar
#define fgetc my_fgetc
#define ungetc my_ungetc
#define gets my_gets
#define fgets my_fgets
# endif

#ifdef SUN
#ifdef labs
#undef labs
#endif
#define labs(x) ((long)abs((int)x))
#endif
#ifdef APOLLO
#define labs(x) ((long)abs((int)x))
#endif

#ifndef PC
extern char *mktemp();
#endif

#ifdef MAC
extern char **texte;
#else
extern char *texte[];           /* Fehlertexte */
#endif

#define Max(a,b) ((a) < (b) ? (b) : (a))
#define Min(a,b) ((a) > (b) ? (b) : (a))
