/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Simulation
  Filename     : rundefs.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.rundefs.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:36        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : globale Definitionen fuer Simulationsteil von PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


/* Einheit fuer Tracezaehler in ITEMs */
#define TRACED (REAL_ERLAUBT * 2)

typedef struct vblocks          /* Speichert Bloecke eines Arguments fuer alle PEs */
{ int inc;                      /* 0 : alle Bloecke gleich, 1 : ein Block fuer jedes PE */
  struct varblock *blocks[1];   /* Bloecke : laenger, falls inc = 1 */
} VBLOCKS;

typedef struct itptrs           /* Speichert ITEM-Zeiger eines Arguments fuer alle PEs */
{ ITEM *(* n_it_func)();        /* Funktion die naechsten Zeiger berechnet */
  int ip_count;                 /* bisherige PE-Nummer */
  ITEM *itps[1];                /* ITEM-Zeiger : mehr, falls n_it_func = n_item_ptr */
} ITPTRS;

typedef struct tracevar
{ ITPTRS varpts;            /* Variablenbeschreibung */
  VBLOCKS varbls;           /* bei einschalten von TRACE */
  DECLIST *tdec;            /* Deklaration der auszugebenden Var. */
  char *t_string;           /* Auszugebender String */
  struct tracevar *t_naechst;/*Verkettung */
} TRACEVAR;

typedef struct varblock
{ ITEM *vars;               /* Variablen */
  int von, bis;             /* erste u. letzte Absolutadresse */
  TRACEVAR *t_info;         /* Informationen fuer TRACE */
  char *max_pes;            /* PEs auf denen der Block existiert */
  struct varblock *nblock;  /* Allozierungsverkettung */
} VARBLOCK;

typedef struct aktblock
{ int rueck;                /* Ruecksprungadresse */
  ZEILTAB *para_call_zeile; /* Aufrufende Zeile im Sourcecode */
  struct aktblock *dispalt; /* alter disp[tiefe] */
  struct aktblock *alt_step_block; /* alter Block fuer step over */
  int procadr;              /* Adresse PROC-Befehl */
  VARBLOCK *s_vars, *v_vars;/* Lokale Variablen */
  int aufr_tiefe;           /* Tiefe des Aufrufers */
  char *vorh_aktiv;         /* Parallel-Info bei IF, WHILE */
  char *start_aktiv;        /* Parallel-Info zum Zeitpunkt der PROC-Ausfuehrung */
  SCOPETAB *top_scope;      /* oberster Geltungsbereich auf dieser Ebene */
  SCOPETAB *new_scope;      /* auf dieser Ebene zuletzt eingehaengter GB */
  int entered_scopes;       /* Zaehlt die in diesem Block betretenen GBs */
} AKTBLOCK;

typedef AKTBLOCK * DISPLAY;

extern ITEM *gl_item();
extern ITEM *n_item();
extern ITEM *n_item_ptr();

/* Variablennummern in s/v_spez_vars */
#define MAXTRANS_VAR 0
#define ACTTRANS_VAR 1
#define DONE_VAR 2
#define TERMCH_VAR 3
#define SRESULT_VAR 4
#define ID_VAR 0
#define VRESULT_VAR 1
