SYSTEM Linienerkennung1 ;

(*   Version der Hough-Transformation, bei der jeder Akkumulator-Zelle ein PE           *)
(*   zugeordnet wird.                                                                   *)




CONST    N   =  30 ;
         G   =   N  ;
	 D   = N ;
         Wurzel = SQRT(2.0) ;
         HN  =  G DIV 2  ;
	 HHN = 2 * HN ;
	 HHN1 = HHN  ;
         HN1  = HN - 2;
         BN  = N DIV 2 ;
         DW  =  N ;
	 C1  = 180.0  ;
         PI  = 3.14159 ;
	 Obergrenze_CI        =    100    ;  (*  Obere Feldgrenze der Stringdefinition  *)
	 S   =   10;

TYPE    STRING      = ARRAY[1..Obergrenze_CI] OF CHAR ;		(*  String-Definition   *)
        Matrix      = ARRAY[-BN..BN],[-BN..BN] of INTEGER ;
        Liste       = ARRAY[1..DW] OF INTEGER ;
        Matrix2     = ARRAY[1..DW],[-512..512] OF INTEGER ;
        Matrix3     = ARRAY[-BN..BN],[-BN..BN] OF REAL ;
	BILD_MATRIX = ARRAY[-BN..BN],[-BN..BN] OF INTEGER ;
	Matrix5     = ARRAY[-HHN..HHN1],[-HN..HN1] OF INTEGER ;


 (* CONFIGURATION PARAMETERRAUM [-HN..HN],[-HN..HN] ;*)



SCALAR   B_Name_S          :   STRING     ;   (* Variable fuer die Eingabedatei         *)
         Hoehe, Breite     : INTEGER ;
         MaxFarbe          : INTEGER ;
         B_Matrix          : MATRIX  ;
	 Counter_File      : STRING ;
	 C_Matrix          : Matrix3 ;
	 Schranke          : INTEGER  ;
	 P_Bild            : STRING ;
	 Handle1           : INTEGER ;
	 Farbe             : COLOR  ;
	 CH                : CHAR ;

VECTOR   Counter           : INTEGER ;
	 P                 : REAL    ;
         W                 : REAL    ;
         X,Y               : INTEGER ;
	 Help2		   : REAL    ;
	 DP                : REAl ;
 




PROCEDURE INIT_STRING ( SCALAR VAR B_Name_S : STRING ) ;
(*   Initialisiert die uebergebene STRING_Variable mit Blanks			        *)
	

     SCALAR       I_SI   :   INTEGER   ;	 (*   Schleifenzaehler	                *)
 

     BEGIN
        WRITESTRING('INIT_STRING') ;
        WRITELN ;
        FOR   I_SI := 1    TO     Obergrenze_CI    DO       
             B_Name_S[I_SI]   :=   ' '   ;
        END ;
     END INIT_STRING ;



PROCEDURE OPENABSWINDOW ( SCALAR X,Y : INTEGER ) : SCALAR  INTEGER ;

	SCALAR AX, AY    : INTEGER ;

	BEGIN
	    WRITESTRING('OPENABSWINDOW') ;
	    WRITELN ;
	    SELECTWINDOW(0);
	    WINDOWSIZE( AX, AY ) ;
	    RETURN OPENWINDOW( FLOAT(X) / FLOAT(AX) , FLOAT(Y) / FLOAT(AY) ) ;
	END OPENABSWINDOW ;




PROCEDURE SETZE_EINGABE_FENSTER ;

     SCALAR      DX, DY    : INTEGER   ;
                 Str1      : STRING     ; 
		 Str2      : STRING   ;
	  	 X1, Y1    : INTEGER   ;
		 I         : INTEGER  ;


     BEGIN
	WRITESTRING('SETZE_EINGABE_FENSTER') ;
        WRITELN ;
        Handle1      :=  OPENABSWINDOW( 1100, 800 ) ;
        Farbe.red    :=  180 ;
        Farbe.green  :=    1 ;
        Farbe.blue   :=  200 ;
        SETCOLOR ( FARBE ) ;
        WINDOWSIZE( DX, DY ) ;
        X1 := 1 ;
        Y1 := 1 ;
        FOR   I := 1   TO   DX  DO
              LINE( X1, Y1, X1, DY ) ;
              X1 := X1 + 1 ;
        END ;
        Farbe.red    := 200 ;
        Farbe.green  := 180  ;
        Farbe.blue   := 255  ;
	SETCOLOR( Farbe ) ;
        Str1 := " MASSIV PARALLELE HOUGH-TRANSFORMATION " ;
        MOVETO(400, 100 ) ;
        DRAWSTRING( Str1 ) ;
        Str1 := " Bitte geben Sie den Namen der zu untersuchenden Bilddatei ein " ;
        MOVETO( 400, 190 ) ;
        DRAWSTRING( Str1 ) ;
	Str2 := " VORSICHT : Die Bilddatei muss im PGM-Format vorliegen " ;
	MOVETO (400, 230 ) ;
        DRAWSTRING ( Str2 ) ;
     END SETZE_EINGABE_FENSTER ;



PROCEDURE Get_Dname( SCALAR VAR B_Name_S : STRING ) : SCALAR BOOLEAN ;

SCALAR   K , I        : INTEGER ;
         File         : STRING  ;
	 Str1, Str2   : STRING  ;
	 CH           : CHAR  ;
	 X, Y         : INTEGER ; 

   BEGIN
      WRITESTRING('GET_DNAME' ) ;
      WRITELN ;
      K := 0 ;
      REPEAT
         Str1 :=' Bitte geben Sie den Namen der zu untersuchenden '  ;
         Str2 :=' Bilddatei ein : '  ;
         MOVETO ( 300, 300 ) ;
         DRAWSTRING( Str1 ) ;
         MOVETO ( 300, 320 ) ;
         DRAWSTRING( Str2 ) ;
	 I := 1 ;
	 X := 400 ;
         Y := 350 ;
         REPEAT
	    READ( CH ) ;
	    B_Name_S[I] := CH ;
	    MOVETO( X, Y ) ;
	    DRAW(CH) ;
	    (*X := X + 5 ; 
	    MOVETO ( X, Y ) ;
            DRAWINT( ORD(CH), 6) ;*)
	    I := I + 1 ;
	    X := X + 5 ; 
	 UNTIL CH = chr(10);
	 B_Name_S[I-1] := CHR(0) ;
         WRITESTRING( B_NAME_S) ;
	 I := 0 ;
         REPEAT
	      I := I + 1 ;
         UNTIL ( B_Name_S[I] = '.' ) OR  ( I = 98 ) ;
         IF   I = 98    THEN  WRITESTRING ( ' Die angegebene Datei hat die falsche Extension' ) ;
			      WRITELN ;
			      WRITESTRING ( 'Die erwartete Extension lautet : PGM ' ) ;
			      WRITELN ;
			      RETURN ( FALSE ) ;
                        ELSIF  ( B_Name_S[ I + 1 ] = 'p' ) OR ( B_Name_S[ I + 1 ] = 'P' )
			      THEN  IF ( B_Name_S[ I + 2 ] = 'g' ) OR ( B_Name_S[I+2]= 'G' )
				        THEN IF ( B_NAME_S[ I+3 ] = 'm' )
						      OR ( B_Name_S[I+3] = 'M' )
					         THEN  ;
						 ELSE RETURN( FALSE ) ;
					     END ;
					ELSE  RETURN ( FALSE ) ;
				    END ;
			      ELSE RETURN ( FALSE ) ;
	END ;
	OPENINPUT( B_Name_S )  ;
         If DONE = TRUE     THEN   CLOSEINPUT ;
                                   Return( TRUE ) ;
                            ELSE   WRITESTRING(' File konnte nicht geoeffnet werden ') ;
                                   K := K + 1 ;
         END ;
         IF K < 3  THEN WRITELN ;
                        WRITESTRING(' Bitte wiederholen Sie die Eingabe ') ;
                        WRITELN ;
         END ;
      Until ( K = 3 )  ;
      RETURN( False )  ;
   END Get_Dname ;



PROCEDURE LINIE ( SCALAR File : STRING ) ;


CONFIGURATION PARAMETERRAUM [-HHN..HHN1],[-HN..HN1] ;


    
    CONNECTION  RRIGHT : PARAMETERRAUM[I,J] -> PARAMETERRAUM[ I   , J + 1 ].LLEFT;
	        LLEFT  : PARAMETERRAUM[I,J] -> PARAMETERRAUM[ I   , J - 1 ].RRIGHT ;
	        UUP    : PARAMETERRAUM[I,J] -> PARAMETERRAUM[I + 1, J     ].DDOWN;
	        DDOWN  : PARAMETERRAUM[I,J] -> PARAMETERRAUM[I - 1, J     ].UUP;

SCALAR     I, J  : INTEGER ;


PROCEDURE INIT_MATRIX ( SCALAR  VAR  File_Matrix : Matrix ) ;

  SCALAR   I, J   : INTEGER  ;

  BEGIN
     WRiteSTRING('INIT_MATRIX ' ) ;
     WRITELN ;
     FOR   I := -BN   TO   BN    DO
          FOR J := -BN   TO   BN   DO
              File_Matrix[I,J] := 0 ;
          END ;
     END ;
  END INIT_MATRIX ;





PROCEDURE FEHLERMELDUNG ;


    BEGIN
      WRITESTRING ( 'FEHLERMELDUNG ' ) ;
      WRITELN ;
      CLOSEINPUT ;
      WRITESTRING ( ' Datei besitzt nicht korrektes PGM-Format') ;
    END FEHLERMELDUNG ;





PROCEDURE SEND_FILE_TO_ARRAY( SCALAR File : String ; SCALAR VAR B_Matrix : Matrix ): SCALAR  BOOLEAN ;

SCALAR   A, I, J, I1, J1   : INTEGER ;
         Magic             : STRING  ;
         Fertig            : Boolean ;
         Ch                : CHAR    ;


    BEGIN
       WRITESTRING ( 'SEND_FILE_TO_ARRAY ') ;
       WRITELN ;
       OPENINPUT( File ) ;
       Fertig  := False ;
       REPEAT
          READSTRING ( Magic ) ;
          IF  STRCMP ( Magic, 'P2' ) = 0
		  THEN Fertig := TRUE ;
	          ELSIF  Magic[1] = '#'
			 THEN  
			    REPEAT
			       READ ( Ch ) ;
			    UNTIL Ch = EOL ;
                  ELSE FEHLERMELDUNG ;
                       RETURN ( FALSE ) ;
          END ;
       UNTIL Fertig ;
       Fertig := FALSE ;
       REPEAT
          READINT( A ) ;
          IF NOT DONE  
              THEN READ ( Ch ) ;
                   IF Ch = '#' THEN
				 REPEAT
                                    READ ( Ch ) ;
			         UNTIL Ch = EOL ;
			       ELSE FEHLERMELDUNG ;
				    RETURN ( FALSE ) ;
                   END ;
               ELSE
                  Breite := A ;
		  FERTIG := TRUE ;
           END ;
       UNTIL  Fertig ;
       Fertig := FALSE ;
       REPEAT
          READINT( A ) ;
          IF  NOT  DONE  
               THEN READ ( Ch) ;
                    IF Ch = '#' THEN
                                  REPEAT
                                      READ ( Ch ) ;
                                  UNTIL Ch = EOL ;
                                ELSE  FEHLERMELDUNG ;
                                      RETURN ( FALSE ) ;
                    END ;
                ELSE
                    Hoehe := A ;
                    Fertig := TRUE ;
          END ;
       UNTIL Fertig = TRUE ;
       Fertig := FALSE ;
       REPEAT
          READINT ( A ) ;
          IF NOT DONE  
              THEN  READ ( Ch ) ;
                    IF Ch = '#' THEN
                                    REPEAT
                                        READ (Ch) ;
                                    UNTIL Ch = EOL ;
                                 ELSE FEHLERMELDUNG ;
                                      RETURN ( FALSE ) ;
                    END ;
              ELSE
                   MaxFarbe := A ;
                   Fertig := TRUE ;
         END ;
      UNTIL Fertig = True ;
      INIT_MATRIX( B_Matrix ) ;
      IF ODD( Hoehe ) THEN  I1 :=   Hoehe DIV 2 ;
		      ELSE  I1 := ( Hoehe DIV 2 ) - 1 ;
      END ;
      IF ODD( Breite )   THEN   J1 := - ( Breite DIV  2 ) ;
			 ELSE   J1 := - ( Breite DIV 2 ) + 1 ;
      END ;
      FOR  I := I1   TO   -( Hoehe DIV  2 )   BY   -1   DO
           FOR J := J1   TO   ( Breite DIV 2 )  DO
               READINT ( A ) ;
               IF NOT DONE
		    THEN  READ (Ch);
		          IF  Ch = '#' THEN
					  REPEAT
					      READ(Ch) ;
					  UNTIL  Ch = EOL ;
				       ELSE FEHLERMELDUNG ;
					    RETURN ( FALSE ) ;
			  END ;
		    ELSE
               	       B_Matrix[I,J] :=  A ;
		       A := 0 ;	
		END ;
           END ;
      END ;
      CLOSEINPUT ;
     
      RETURN ( TRUE ) ;
   END SEND_FILE_TO_ARRAY ;



PROCEDURE  COUNTER_TO_FILE (  SCALAR VAR COUNTER_FILE : STRING );

    SCALAR     I , J : INTEGER ;
               C_Matrix   : Matrix5 ;
	       Help_Matrix : Matrix3 ;
	       HELP : REAL ;

    BEGIN
        WRITESTRING('COUNTER_TO_FILE');
        WRITELN ;
        STORE  [ -HHN..HHN1 ], [-HN..HN1 ] ( Counter, C_Matrix ) ;
	STORE [ -HHN..HHN1],[-HN..HN1] ( W, Help_Matrix ) ;
        OPENOUTPUT ( 'Akku2.tmp' ) ;
        FOR  I := HHN1 TO -HHN  BY -1 DO
             FOR  J := -HN   TO  HN1   DO
                 WRITEFIXPT (Help_Matrix[I,J], 7,5 ) ;
             END ;
	     WRITELN
        END ;
        WRITELN ;
	WRITELN ;
	CLOSEOUTPUT ;
	OPENOUTPUT(COUNTER_FILE ) ;
        WRITESTRING('P2') ;
        WRITELN ;
        WRITEINT(Breite,4) ;
        WRITELN;
        WRITEINT(Hoehe,4) ;
        WRITELN ;
        WRITEINT(MaxFarbe,4 ) ;
        WRITELN ;
        FOR  I := HHN1 TO - HHN   BY -1   DO
             FOR J := -HN   TO  HN1      DO
                 WRITEINT( C_Matrix[I,J] ,4  ) ;
             END ;
             WRITELN ;
        END ;
        CLOSEOUTPUT ;
    END COUNTER_TO_FILE ;



PROCEDURE INITIALISIERE_AKKU_PE  ;

    VECTOR     Help   :  REAL ;
	       

    BEGIN
        WRITESTRING('INITIALISIERE_AKKU_PE') ;
        WRITELN ;
        PARALLEL 
           Help2 :=   PI / FLOAT(G) ;
	   W     :=   FLOAT(DIM2) * Help2   ;
           Help  :=   SQRT(  ( FLOAT ( N DIV 2 )  ** 2.0   ) * 2.0 ) ;
	   Help2 :=   Help / FLOAT(HHN) ;
	   DP    :=   Help2;
	   P     :=   FLOAT ( DIM1 ) * Help2 ;
           Counter := 0 ;
	   X     :=   0 ;
           Y     :=   0 ;
       ENDPARALLEL;
    END INITIALISIERE_AKKU_PE ;





PROCEDURE NEW_BPUNKT ( SCALAR  B_MAtrix : Matrix ;  SCALAR  VAR  I, J : INTEGER )
		     : SCALAR BOOLEAN ;

      SCALAR  Gefunden : BOOLEAN  ;
              K, L     : INTEGER   ;


     BEGIN 
          WRITESTRING('NEW_PUNKT') ;
          WRITELN ;
	    IF ( I = HHN1 ) AND  ( J = HN1 ) THEN RETURN ( FALSE ) ;
	    END ;
	    WRITEINT(I,4) ;
	    WRITEINT(J,4) ;
	    FOR L := J   TO BN DO
		  IF   B_Matrix[I,L] = 1 THEN  J := L ;
					       RETURN( TRUE ) ;
		  END ;
	    END ;
	    I := I + 1 ;
            FOR K := I  TO BN   DO
               FOR L := -BN  TO   BN  DO
                     IF B_Matrix[K,L] = 1 THEN  I := K ;
						J := L ;
					        WRITEINT(K,4);
					        WRITEINT(L,4) ;
						WRITELN ;
						RETURN (TRUE ) ;
                     END ;
               END ;
            END ;
           RETURN ( FALSE ) ;
     END NEW_BPUNKT ;




PROCEDURE FUELLE_AKKU ( SCALAR B_Matrix : Matrix ) ;

   SCALAR   I, J      :    INTEGER ;

   VECTOR   H1, H2      :  REAL  ;
            W1 , W2     :  REAL ;

   BEGIN 
       WRITESTRING ('FUELLE_AKKU') ;
       WRITELN ;
       I := -HHN ;
       J := -HN ;
       IF   NEW_BPUNKT( B_Matrix , I, J  )
	    THEN
               REPEAT
		    WRITEINT( I, 4);
		    WRITEINT(J, 4 ) ;
                    PARALLEL
                        X  := J ;
			Y  := I ;
                        W1 := PI / FLOAT( G ) ;
                       W2 := W1 / 2.0 ;
                        H1 := FLOAT(X) * cos ( W )   + FLOAT( Y) * sin ( W ) ;
                        H2 := FLOAT(X) * COS ( W +  W1 ) +FLOAT( Y)  * SIN ( W + W1 ) ;
                        IF ( ( H1 >= P ) AND  ( H1 <= P + DP ) ) OR
				(  ( H2 >= P ) AND  ( H2 <= P + DP ) )
                             THEN
                                 Counter  := Counter + 1 ;
                        END ;
                    ENDPARALLEL ;
		    WRITEINT(I,4) ;
		    WRITEINT( J , 4 ) ;
		    IF J = BN THEN  IF I < BN THEN I := I + 1 ;				                                                      J := -BN ;
				     END ;	       
			       ELSE  J := J + 1 ;
                    END ;
		    WRITEINT(I,4);
		    WRITEINT(J,4);
		    WRITELN ;
               UNTIL NEW_BPUNKT( B_Matrix , I, J ) = FALSE  ;
       END ;

   END FUELLE_AKKU ;




PROCEDURE DEF_OUTPUT_FILE ( SCALAR VAR H_Bild : STRING ) ;

     SCALAR     Help_Datei   : STRING  ;
	        I            : INTEGER ;


     BEGIN
	 WRITESTRING('DEF_OUTPUT_FILE') ;
         WRITELN ;
         INIT_STRING(Help_Datei ) ;
         Help_Datei[1] := 'p' ;
         I := 1 ;
         WRITESTRING('   FOR REPEAT ' ) ;
         WRITELN ;
         REPEAT
	    Help_Datei[I+1] := H_Bild[I] ;
            I := I + 1 ;
         UNTIL ( H_Bild[I] = ' ') OR ( I = 100 )  ;   (* ??????????????????????????*)
         WRITESTRING('     NACH REPEAT ' ) ;
         WRITELN ;
         H_Bild := Help_Datei ;
     END DEF_OUTPUT_FILE ;



PROCEDURE OEFFNE_FILE( SCALAR VAR H_Bild : STRING ) ;

    BEGIN
      WRITESTRING('OEFFNE_FILE') ;
      WRITELN ;
      OPENOUTPUT(H_Bild ) ;
      (* WRITESTRING('P2') ;
      WRITELN ;
      WRITEINT(Breite,4) ;
      WRITELN;
      WRITEINT(Hoehe,4);
      WRITELN ;
      WRITEINT(MaxFarbe,4 ) ;
      WRITELN ; *)
    END OEFFNE_FILE ;


PROCEDURE SCHREIBE_IN_FILE ( SCALAR  HP, HW : REAL ; SCALAR  HC : INTEGER ) ;
 
      BEGIN
         WRITEFIXPT(HP, 10,5);
         WRITEFIXPT(HW, 10,5) ;
         WRITEINT( HC, 5 ) ;
         WRITELN ;
      END SCHREIBE_IN_FILE ;



PROCEDURE MAX_WERT_ANALYSE ( SCALAR Max_Wert : INTEGER ) ;

    VECTOR  HCount1, HCount2  : INTEGER ;
            HelpW , HelpP     : REAL ;

    BEGIN
       (* PARALLEL
	    HelpW  := W ;
	    HCount1 := Counter ;
	    Hcount2 := Counter ;
	    PROPAGATE.RRIGHT(HCount1) ;
            PROPAGATE.LLEFT(HCount2 ) ;
	    IF Counter = Max_Wert 
		THEN  IF (Counter = HCount1)  
			    THEN
				 PROPAGATE.LLEFT(HelpW) ;
			    ELSIF ( Counter = HCount2 ) 
				THEN
				   PROPAGATE.RRIGHT(HelpW) ;	 
		      END ;
		      IF W <> HelpW THEN   HelpW := ( HelpW + W ) / 2.0   END ;
            END ; 
	  
	    HelpP := P ;
	    HCount1 := Counter ;
	    HCount2 := Counter ;
	    PROPAGATE.DDOWN(HCount1);
	    PROPAGATE.UUP(HCount2) ;
	    IF COUNTER = Max_Wert 
	          THEN IF ( COUNTER = HCount1)
			   THEN
			       PROPAGATE.UUP(HelpP) ;
			   ELSIF ( Counter = HCount2 ) 
				THEN
				    PROPAGATE.DDOWN(HelpP) ;
		       END ;
	               IF  P <> HelpP  THEN HelpP :=  ( HelpP + P ) / 2 ; END ;
	    END ; 
        ENDPARALLEL ;  *) 


    END MAX_WERT_ANALYSE ;

PROCEDURE MAX_SUCHE_IM_AKKU ;

    SCALAR   H_Bild        : STRING   ;
	     MaxWert       : INTEGER ;
	     HDIM1, HDIM2  : INTEGER ;
	     HP, HW        : REAL ;
             HC            : INTEGER ;
             B             : INTEGER ;

    VECTOR   Help1, Help2 : INTEGER ;
	     PHelp, WHelp  : REAL ;


    BEGIN
       WRITESTRING('MAX_SUCHE_IM_AKKU' ) ;
       WRITELN ;
       B := 0 ;
       H_Bild := B_Name_S ;
       DEF_OUTPUT_FILE(H_Bild) ;
       P_Bild := H_Bild ;
       OEFFNE_FILE(H_Bild) ;
       PARALLEL
          PHelp := P ;
          WHelp := W ;
          MaxWert := REDUCE.MAX(Counter) ;
       ENDPARALLEL ;
       MAX_WERT_ANALYSE(MaxWert );
       IF MaxWert >= Schranke THEN
           REPEAT
              PARALLEL
                 Help1 := Counter ;
		 
	         IF Counter = MaxWert 
                     THEN
			HDIM1 := REDUCE.MIN(DIM1) ;
		        IF  DIM1 = HDIM1
                              THEN 
				HDIM2 := REDUCE.MIN(DIM2);
	                END ;
		 END ;		  
              ENDPARALLEL ;
	      PARALLEL;
	           IF (DIM1=hdim1) AND (DIM2=hdim2) THEN
                      STORE (PHelp,HP) ;
                      STORE (WHelp, HW );
	              Counter := 0 ;
                   END;
              ENDPARALLEL;
              HC := MaxWert ;
 	      SCHREIBE_IN_FILE(HP, HW, HC ) ;
	      PARALLEL
		   MaxWert := REDUCE.MAX (Counter );
              ENDPARALLEL ;
           UNTIL ( MaxWert  < Schranke ) ; 
       END ;
       CLOSEOUTPUT ;
    END MAX_SUCHE_IM_AKKU ;




    BEGIN
        WRITESTRING('LINIE') ;
        WRITELN ;
        IF SEND_FILE_TO_ARRAY( File, B_MATRIX )  THEN  ;
		   OPENOUTPUT('Farbarray');
      		   For I := BN  TO -BN   BY -1  DO
                       FOR  J := -BN  TO BN  DO
	                            WRITEINT(B_Matrix[I,J],2) ;
	               END ;
                       WRITELN ;
                   END ;
                   CLOSEOUTPUT ;
                  INITIALISIERE_AKKU_PE  ;
		  FUELLE_AKKU ( B_Matrix) ;
		  COUNTER_FILE := 'Akku.m' ;
		  Counter_TO_FILE(  COUNTER_FILE );
		  MAX_SUCHE_IM_AKKU ;
		
        END ;


END Linie ;




PROCEDURE PARAMETER_TO_BILD ;

    CONFIGURATION BILDRAUM [-BN..BN],[-BN..BN] ;

    
    CONNECTION  RIGHT : BILDRAUM[I,J] -> BILDRAUM[ I   , J + 1 ].LEFT;
	        LEFT  : BILDRAUM[I,J] -> BILDRAUM[ I   , J - 1 ].RIGHT ;
	        UP    : BILDRAUM[I,J] -> BILDRAUM[I + 1, J     ].DOWN;
	        DOWN  : BILDRAUM[I,J] -> BILDRAUM[I - 1, J     ].UP;



    SCALAR   PNormale , Winkel : REAL ;
	     HCounter	       : INTEGER ;
             F_Matrix          : Bild_Matrix ;
             H_Bild            : STRING  ;
	     Help1, Help2      : REAL ;
	     Z_Matrix	       : Matrix3 ;
	     I,J               : INTEGER ;

     
    VECTOR   X, Y, FARBE    : INTEGER ;
	     BP, BW         : REAL ;
	 


    PROCEDURE INIT_PE ;

    BEGIN
	WRITESTRING('INIT_PE') ;
	WRITELN;
	PARALLEL
            X := DIM2 ;
	    Y := DIM1 ;
	    FARBE := 0 ;
	    BP  := 0.0 ;
	    BW  := 0.0 ;
        ENDPARALLEL ;
    END INIT_PE ;


    PROCEDURE BERECHNE_GERADE ( SCALAR Winkel, PNormale : REAL ) ;

	VECTOR  Help, DP  : REAL ;
		Hilfe1, Help3 : REAL ;	        

        BEGIN
	    WRITESTRING('BERECHNE_GERADE') ;
	    WRITELN ;
	    WRITEREAL(WINKEL,4);
	    WRITEREAL(PNormale,4) ;
	    WRITELN ;
	    PARALLEL
	 	Hilfe1 := 0.0 ;
		Help3 := 0.0 ;
		BW   := Winkel ;
                BP   := PNormale ;
                DP   := ( SQRT( FLOAT(HHN) ** 2.0  ) * 2.0 ) / FLOAT(HHN) ;
		DP   := DP / 2.0 ;
                HELP := FLOAT(X) * COS(BW) + FLOAT(Y) * SIN(BW) ;
		Hilfe1 := Help ;
		WRITESTRING('DOWN');
		WRITELN ;
		PROPAGATE.DOWN(Hilfe1) ;
		Help3 := Help ;
	        WRITESTRING('UP') ;
		WRITELN ;
		PROPAGATE.UP(Help3) ;	
	        WRITESTRING('Nach UP ') ;
		WRITELN ;
	        IF  PNormale >= 0.0
		   THEN
		       IF (PNormale >= Help ) AND ( PNormale < Help3)
				 THEN 
				    IF ABS( PNormale - Help ) < ABS( Help3 - PNormale )
				       THEN
					Farbe := 1 ;
				    END ;
			   ELSIF ( PNormale < Help ) AND ( PNormale > Help1 )
				THEN  IF ABS( Help - PNormale ) < ABS( PNormale - Hilfe1 )
					  THEN 
					     Farbe := 1 ;
				      END ;
		       END ;
		    ELSIF ( PNormale <= Help ) AND ( PNormale > Hilfe1 )
			   THEN  IF ABS( PNormale - Help ) < ABS( PNormale - Hilfe1 )
				     THEN
					Farbe := 1 ;
				 END ;
			   ELSIF ( PNormale >  Help ) AND ( PNormale < Help3 )
			        THEN IF  ABS( Help - PNormale ) < ABS( PNormale -Help3 ) 
				             THEN
						 Farbe := 1 
				     END ;
		END ;
            ENDPARALLEL ;
	    STORE [-BN..BN],[-BN..BN] ( Help, Z_Matrix ) ;
	END BERECHNE_GERADE ;



    PROCEDURE DEF_OUTPUT_FILE ( SCALAR VAR H_Bild : STRING ) ;

        SCALAR     Help_Datei   : STRING  ;
	        I            : INTEGER ;


        BEGIN
	   WRITESTRING('DEF_OUTPUT_FILE') ;
           WRITELN ;
           INIT_STRING(Help_Datei ) ;
           Help_Datei[1] := 'h' ;
           I := 1 ;
           WRITESTRING('   FOR REPEAT ' ) ;
           WRITELN ;
           REPEAT
	      Help_Datei[I+1] := H_Bild[I] ;
              I := I + 1 ;
           UNTIL ( H_Bild[I] = ' ') OR ( I = 100 )  ;   (* ??????????????????????????*)
           WRITESTRING('     NACH REPEAT ' ) ;
           WRITELN ;
           H_Bild := Help_Datei ;
       END DEF_OUTPUT_FILE ;



    PROCEDURE ARRAY_TO_FILE ( SCALAR F_Matrix : Bild_Matrix ) ;

	SCALAR   I, J, I1, J1   : INTEGER ;


	BEGIN
           WRITESTRING('ARRAY_TO_FILE') ;
           WRITELN ;
           H_BILD := B_NAME_S ;
	   DEF_OUTPUT_FILE( H_Bild ) ;
           OPENOUTPUT(H_BILD) ;
   	   WRITESTRING('P2') ;
           WRITELN ;
           WRITEINT(Breite,4) ;
           WRITELN;
           WRITEINT(Hoehe,4);
           WRITELN ;
           WRITEINT(MaxFarbe,4 ) ;
           WRITELN ;
	   IF ODD( Hoehe ) THEN  I1 :=   Hoehe DIV 2 ;
		           ELSE  I1 := ( Hoehe DIV 2 ) - 1 ;
           END ;
           IF ODD( Breite )   THEN   J1 := - ( Breite DIV  2 ) ;
			      ELSE   J1 := - ( Breite DIV 2 ) +1 ;
           END ; 
           FOR   I := I1 TO  -(Hoehe DIV 2 ) BY -1  DO   (* I1, -(Hoehe DIV 2 ) *)
               FOR  J :=  J1   TO   ( Breite DIV 2 )   DO    (* J1 , Breite DIV 2 *)
		   WRITEINT(F_Matrix[I,J] ,2) ;
	       END ;
	   WRITELN;
           END ; 
      	   (* FOR   I := BN TO  -BN BY -1  DO   (* I1, -(Hoehe DIV 2 )*)
               FOR  J :=  -BN   TO   BN   DO    (* J1 , Breite DIV 2 *)
		   WRITEINT(F_Matrix[I,J] ,2) ;
	       END ;
	   WRITELN;
           END ; *)
	   CLOSEOUTPUT ;


        END ARRAY_TO_FILE ;




    PROCEDURE ARRAY_TO_FILE2 ( SCALAR F_Matrix : Matrix3 ) ;

	SCALAR   I, J, I1, J1   : INTEGER ;


	BEGIN
           WRITESTRING('ARRAY_TO_FILE2') ;
           WRITELN ;
           H_BILD := B_NAME_S ;
           OPENOUTPUT('Bild_Normale') ;
   	   WRITESTRING('P2') ;
           WRITELN ;
           WRITEREAL(Winkel,4) ;
           WRITELN;
           WRITEREAL(PNormale,4);
	   IF PNormale >= 0.0 THEN WRITELN END ;
           WRITELN ;
           FOR   I := BN TO -BN    BY -1  DO
               FOR  J := -BN   TO   BN   DO
		   WRITEFIXPT(Z_Matrix[I,J] ,7,5) ;
	       END ;
	   WRITELN;
           END ; 
	   CLOSEOUTPUT ;


        END ARRAY_TO_FILE2 ;






    BEGIN
        INIT_PE ;
        WRITESTRING(P_Bild) ;
	WRITELN ;
	OPENINPUT(P_Bild);
	WRITESTRING('NACH OPENINPUT ') ;
	WRITELN ;
        PNormale := 2.0 ;
	Help1 := -1000000.0 ;
	Help2 := -1000000.0 ;
	Winkel := 1.0 ;
	READREAL( PNormale ) ;
	IF PNormale <> Help1 
	    THEN
	       REPEAT
		 Help1 := Pnormale ;
		 Help2 := Winkel ;
	         READREAL( Winkel ) ; 
	         READINT( HCounter ) ;
	         BERECHNE_GERADE (Winkel,PNormale );            
	         READREAL(PNormale );  
	       UNTIL ( Help1 = PNormale) AND ( Help2 = Winkel ) ;      (* !!!!!!!*)
	END ;
	CLOSEINPUT ;
	For I := -BN  TO BN   DO
            FOR J := -BN    TO BN   DO
		F_Matrix[I,J] := 0 ;
            END ;
        END ;
        STORE[-BN..BN],[-BN..BN](Farbe, F_Matrix) ;        
	ARRAY_TO_FILE( F_Matrix) ;
	ARRAY_TO_FILE2( Z_Matrix );


    END PARAMETER_TO_BILD ;



BEGIN
  Schranke := S ;
  INIT_String( B_Name_S ) ;
  SETZE_EINGABE_FENSTER ;
  If Get_Dname(B_Name_S)  THEN  Linie( B_Name_S ) ;
		              PARAMETER_TO_BILD ;
  END ;
  
  READ(CH) ;
  CLOSEWINDOW ( Handle1 ) ;
END Linienerkennung1 .
