SYSTEM FindMax;
CONST   size=3;

CONFIGURATION  field[size],[size];
CONNECTION right: field[i,j] -> field[i, j+1].left;
           left : field[i,j] -> field[i, j-1].right;
           up   : field[i,j] -> field[i+1, j].down;
           down : field[i,j] -> field[i-1, j].up;

SCALAR  i   :  integer;
VECTOR  value,
        buffer : integer;
BEGIN 
  PARALLEL
    value := id_no
  ENDPARALLEL;

  FOR i := 1 TO size-1  DO
    PARALLEL
       buffer := value;
       PROPAGATE.left(buffer);
       IF buffer > value THEN value := buffer END;
    ENDPARALLEL
  END ; (* FOR *)

  FOR i := 1 TO size-1  DO
    PARALLEL
       buffer := value;
       PROPAGATE.down(buffer);
       IF buffer > value THEN value := buffer END;
    ENDPARALLEL
  END ; (* FOR *)

  STORE [0],[0] (value, i);
  WriteInt(i,10);
END FindMax.

