system life;
const n = 40;
configuration feld[1..n],[1..n];
connection lo : feld[i,j] -> feld[i-1, j-1].ru;
            o : feld[i,j] -> feld[i-1, j  ].u;
           ro : feld[i,j] -> feld[i-1, j+1].lu;
            r : feld[i,j] -> feld[i  , j+1].l;
           ru : feld[i,j] -> feld[i+1, j+1].lo;
            u : feld[i,j] -> feld[i+1, j  ].o;
           lu : feld[i,j] -> feld[i+1, j-1].ro;
            l : feld[i,j] -> feld[i  , j-1].r;
scalar a : array[1..n],[1..n] of boolean;
       c : char;
       last : boolean;
vector val, buf : boolean;
       vorh : array boolean of boolean;
       anz : integer;

PROCEDURE out;
SCALAR z,s: integer;
BEGIN
  store(val,a);
  for z := 1 to n do
    FOR s:=1 TO n DO
      IF a[z,s] THEN write("X") ELSE write(" ") END;
    END;
    writeln;
  end;
  WriteLn
END out;

procedure setze;       (* besetzt feld zufaellig *)
begin
  parallel
    val := false;
  endparallel;
  parallel[2..n-1],[2..n-1]
    val := vbrandom();
  endparallel;
end setze;

begin
  setze;
  last := false;
  parallel
    vorh[true] := val;
    vorh[false] := val;
  endparallel;
  loop
    out;
    parallel
      anz := 0;
      propagate.lo(val,buf);
      anz := anz + ord(buf);
      propagate.o (val,buf);
      anz := anz + ord(buf);
      propagate.ro(val,buf);
      anz := anz + ord(buf);
      propagate.r (val,buf);
      anz := anz + ord(buf);
      propagate.ru(val,buf);
      anz := anz + ord(buf);
      propagate.u (val,buf);
      anz := anz + ord(buf);
      propagate.lu(val,buf);
      anz := anz + ord(buf);
      propagate.l (val,buf);
      anz := anz + ord(buf);
    endparallel;
    parallel [2..n-1],[2..n-1]
      if val
      then if (anz < 2) or (anz > 3)
           then val := false
           end
      else if (anz = 3)
           then val := TRUE
           end
      end;
    endparallel;
    if reduce.and(val = vorh[true]) or
       reduce.and(val = vorh[false])
    then
      out;
      exit
    end;
    last := not last;
    parallel
      vorh[last] := val;
    endparallel
  end;
end life.
