SYSTEM N_KOERPER_PROBLEM;

CONST n        = 3;
      iter     = 100;
      G        = 2.47239E-10;                (* AE**3 / (me * d**2) *)
      zschritt = .01 / 24.0;                 (* d *)
      zq_2     = zschritt * zschritt / 2.0;  (* d**2 *)

TYPE daten = ARRAY [1..n] OF REAL;

CONST minit  = daten(3.34E5, 1.0, 1.231E-2);
             (* Massen : Erdmassen em *)
      xinit  = daten(0.0, 1.0, 0.997);
             (* X-Koordinaten : AE *)
      yinit  = daten(0.0, 0.0, 0.0);
             (* Y-Koordinaten : km *)
      zinit  = daten(0.0, 0.0, 0.0);
             (* Z-Koordinaten : km *)
      vxinit = daten(0.0, 0.0, 0.0);
             (* X-Geschwindigkeiten : AE/d *)
      vyinit = daten(0.0, 1.721E-2, 1.666E-2);
             (* Y-Geschwindigkeiten : AE/d *)
      vzinit = daten(0.0, 0.0, 4.768E-5);
             (* Z-Geschwindigkeiten : AE/d *)

SCALAR dvar : daten;
       zeit : REAL;      (* d *)

CONFIGURATION koerper[1..n];

VECTOR masse      : REAL;     (* Masse : Erdmassen *)
       x,  y,  z  : REAL;     (* Koordinaten : AE *)
       vx, vy, vz : REAL;     (* Geschwindigkeiten : AE/d *)
       ax, ay, az : REAL;     (* Beschleunigungen : AE/d**2 *)

CONFIGURATION wechselwirkung[1..n],[1..n-1];
CONNECTION koerper1 : wechselwirkung[i,j] <-> koerper[i].ww1;
           koerper2 : wechselwirkung[i,j] <-> {j <  i} koerper[j]  .ww2,
                                              {j >= i} koerper[j+1].ww2;

VECTOR m1, m2     : REAL;     (* Massen : Erdmassen *)
       gm         : REAL;     (* G * m2 : AE**3 / d**2 *)
       
SCALAR i : INTEGER;

PROCEDURE init;
BEGIN
  PARALLEL koerper
    dvar := minit;
    LOAD(masse, dvar);
    dvar := xinit;
    LOAD(x    , dvar);
    dvar := yinit;
    LOAD(y    , dvar);
    dvar := zinit;
    LOAD(z    , dvar);
    dvar := vxinit;
    LOAD(vx   , dvar);
    dvar := vyinit;
    LOAD(vy   , dvar);
    dvar := vzinit;
    LOAD(vz   , dvar);
    SEND koerper.ww1 (masse) TO wechselwirkung.koerper1 (m1);	
    SEND koerper.ww2 (masse) TO wechselwirkung.koerper2 (m2);	
  ENDPARALLEL;

  PARALLEL wechselwirkung
    gm := G * m2;
  ENDPARALLEL;
  zeit := 0.0;
END init;

PROCEDURE schritt;

VECTOR x1, y1, z1 : REAL;     (* Koordinaten Koerper1 : AE *)
       x2, y2, z2 : REAL;     (* Koordinaten Koerper2 : AE *)
       dx, dy, dz : REAL;     (* Distanzkomponenten : AE *)
       dq         : REAL;     (* Quadrat der Distanz : AE**2 *)
       k          : REAL;     (* gemeinsame Konstante : 1/d**2 *)

BEGIN
  PARALLEL wechselwirkung
    RECEIVE wechselwirkung.koerper1 (x1) FROM koerper.ww1 (x);
    RECEIVE wechselwirkung.koerper2 (x2) FROM koerper.ww2 (x);
    RECEIVE wechselwirkung.koerper1 (y1) FROM koerper.ww1 (y);
    RECEIVE wechselwirkung.koerper2 (y2) FROM koerper.ww2 (y);
    RECEIVE wechselwirkung.koerper1 (z1) FROM koerper.ww1 (z);
    RECEIVE wechselwirkung.koerper2 (z2) FROM koerper.ww2 (z);
    dx := x2 - x1;
    dy := y2 - y1;
    dz := z2 - z1;
    dq := dx*dx + dy*dy + dz*dz;
    k := gm / (dq * Sqrt(dq));
    SEND wechselwirkung.koerper1 (k * dx) TO koerper.ww1 (ax) REDUCE.SUM;
    SEND wechselwirkung.koerper1 (k * dy) TO koerper.ww1 (ay) REDUCE.SUM;
    SEND wechselwirkung.koerper1 (k * dz) TO koerper.ww1 (az) REDUCE.SUM;
  ENDPARALLEL;

  PARALLEL koerper
    x := x + vx * zschritt + ax * zq_2;
    y := y + vy * zschritt + ay * zq_2;
    z := z + vz * zschritt + az * zq_2;
    vx := vx + ax * zschritt;
    vy := vy + ay * zschritt;
    vz := vz + az * zschritt;
  ENDPARALLEL
END schritt;

PROCEDURE ausgabe;

TYPE name = ARRAY [1..8] OF CHAR;

SCALAR dfeld : daten;
       i : INTEGER;

  PROCEDURE auszeile(SCALAR s : name);
  BEGIN
    WriteString(s);
    FOR i := 1 TO n DO
      WriteString("   ");
      WriteReal(dfeld[i],15);
    END; (* FOR *)
    WriteLn;
  END auszeile;
  
BEGIN
  WriteFixPt(zeit, 7,3);
  FOR i := 1 TO n DO
    WriteString("   Koerper"); WriteInt(i,3); WriteString("     ");
  END; (* FOR *)
  WriteLn;
  PARALLEL koerper
    STORE(masse, dfeld); auszeile("m   :  ");
    STORE(x    , dfeld); auszeile("x   :  ");
    STORE(y    , dfeld); auszeile("y   :  ");
    STORE(z    , dfeld); auszeile("z   :  ");
    STORE(vx   , dfeld); auszeile("vx  :  ");
    STORE(vy   , dfeld); auszeile("vy  :  ");
    STORE(vz   , dfeld); auszeile("vz  :  ");
  ENDPARALLEL
END ausgabe;

BEGIN
  init;
  LOOP
    FOR i := 1 TO iter DO
      schritt;
    END; (* FOR *) 
    zeit := zeit + FLOAT(iter) * zschritt;
    ausgabe;
  END; (* LOOP *)
END N_KOERPER_PROBLEM.
