SYSTEM PDM_2;(*PDMRAB ist topologischer Teil von PDM-2*) 
(*PDM-2 ist ein Paralleles Digitales Modell des dynamischen Netzobjektes
  mit konzentrierten Parametern*) 
(*PDM-2 wird in PARALLAXIS-Umgebung programmiert*)
(*PDM-2-Algorithmusstruktur wird am Abb.6 des PDM-BERICHTES dargestellt*)

CONST m=8;n=5;D=4;G=4;hd=0.1;h1=0.15;h2=0.05;IT=1000;



(*TYPE matrix1 =ARRAY[1..G],[1..m] of integer;
     matrix2 =ARRAY[1..D],[1..m] of integer;
     matrix3 =ARRAY[1..G],[1..D] of integer;
     matrix4 =ARRAY[1..G],[1..G] of integer;
     matrix5 =ARRAY[1..D],[1..D] of integer;
     matrix6 =ARRAY[1..D],[1..G] of integer;
 
     matrix7 =ARRAY[1..D],[1..D] of real;
     matrix8 =ARRAY[1..G],[1..G] of real;
     matrix9 =ARRAY[1..m],[1..m] of real;
     matrix10=ARRAY[1..G],[1..D] of real;
     matrix11=ARRAY[1..G],[1..m] of real;
     
     column1 =ARRAY[1..D] of real;
     column2 =ARRAY[1..G] of real;
     column3 =ARRAY[1..m] of real;*)
 
CONFIGURATION  grid [m],[m]; 


CONNECTION       leftG: grid[i,j] -> grid[i,(j-1) MOD G].leftG;
                   upD: grid[i,j] -> grid[(i-1) MOD D,j].upD;
               shiftGL: grid[i,j] -> grid[i,(j-i) MOD G].shiftGL;
               shiftDU: grid[i,j] -> grid[(i-j) MOD D,j].shiftDU;
              
                 leftD: grid[i,j] -> grid[i,(j-1) MOD D].leftD;
                   upG: grid[i,j] -> grid[(i-1) MOD G,j].upG;
               shiftDL: grid[i,j] -> grid[i,(j-i) MOD D].shiftDL;
               shiftGU: grid[i,j] -> grid[(i-j) MOD G,j].shiftGU;

                 leftm: grid[i,j] -> grid[i,(j-1) MOD m].leftm;
               shiftmL: grid[i,j] -> grid[i,(j-i) MOD m].shiftmL; 
                   upm: grid[i,j] -> grid[(i-1) MOD m,j].upm;
               shiftmU: grid[i,j] -> grid[(i-j) MOD m,j].shiftmU;


SCALAR          i,j,l    :integer;
(*                        S:matrix1; 
                       SX:matrix3; 
                       SY:matrix4;  
                        A:matrix2;   
                   AXI,AX:matrix5;  
                     W,AY:matrix6;  
                       KX:matrix7;  
           W5,W4,W3,W2,KY:matrix8;    
                  aw,bw,R:matrix9;
                       W1:matrix10;
                    RU,TP:matrix11; 
 
                     ZX,X:column1;
                     ZY,Y:column2;
 V,V1,awz,bwq,HU,Q,HN,H,Z:column3; *)

VECTOR VX,VY,VQ,VH,VHN,VHU,VZX,VZY,VZ,VR,VRU,VTP,VW1,VKX,VKY,VW2  :real;
       Vawz,Vbwq,Vaw,Vbw,VW3,VW4,VW5,VV1,VV                       :real;
       VS,VSX,VSY,VA,VAX,VAY,VW,VAXI                              :integer; 

procedure dummy();
scalar i,j : integer;
begin
end dummy;

BEGIN
i := 1;
 PARALLEL 

(*Matrizen einlesen*)

   OpenInput ("MATR-PDM-2");

   ReadInt (VS);
   ReadInt (VSX);
   ReadInt (VSY);
   ReadInt (VA);
   ReadInt (VAX);
   ReadInt (VAY);
   ReadInt (VAXI);

   ReadReal (VR);
   ReadReal (VKX);
   ReadReal (VKY);
   ReadReal (Vaw);
   ReadReal (Vbw);
   ReadReal (VW5);

   ReadReal (VY);
   ReadReal (VHN);

   CloseInput;

(*Matrix mult W:=AXI*AY,BLOK P0*)
ENDPARALLEL;
PARALLEL [G],[G]
     PROPAGATE.shiftGL(VAXI);
     PROPAGATE.shiftDU(VAY);
     VW := VAXI * VAY;
     FOR l := 2 TO G DO
       PROPAGATE.leftG(VAXI);
       PROPAGATE.upD(VAY);
       VW := VW + VAXI*VAY;
     END;
ENDPARALLEL;
PARALLEL

(*Matrix mult W1:=SX*KX,Blok P0*)

     PROPAGATE.shiftDL(VSX);
     PROPAGATE.shiftGU(VKX);
     VW1 := FLOAT(VSX) * VKX;
     FOR l := 2 TO D DO
       PROPAGATE.leftD(VSX);
       PROPAGATE.upG(VKX);
       VW1 := VW1 + FLOAT(VSX)*VKX; 
     END;

(*Matrix mult W2:=W1*W,Blok P0*)       

     PROPAGATE.shiftGL(VW1);
     PROPAGATE.shiftGU(VW);
     VW2 := VW1 * FLOAT(VW);
     FOR l := 2 TO G DO
       PROPAGATE.leftG(VW1);
       PROPAGATE.upG(VW);
       VW2 := VW2 + VW1*FLOAT(VW);
     END;

(*Matrix mult W3:=SY*KY,Blok P0*)

     PROPAGATE.shiftGL(VSY);
     PROPAGATE.shiftGU(VKY);
     VW3 := FLOAT(VSY) * VKY;
     FOR l := 2 TO G DO
       PROPAGATE.leftG(VSY);
       PROPAGATE.upG(VKY);
       VW3 := VW3 + FLOAT(VSY)*VKY;
     END;

(*Matrix substrag W4:=W3-W2,Blok P0*)

       VW4 := VW3 - VW2;

(*Matrix W5=INVERS(W4) wird fuer PDM-2-TEST vorgegeben*)

(*Matrix mult TP:=W5*S,Blok P0*)

     PROPAGATE.shiftmL(VW5);
     PROPAGATE.shiftGU(VS);
     VTP := VW5 * FLOAT(VS);
     FOR l:= 2 TO m DO
       PROPAGATE.leftm(VW5);
       PROPAGATE.upG(VS);
       VTP := VTP + VW5*FLOAT(VS);
     END;

(*Matrix mult RU:=TP*R,Blok P0*)

     PROPAGATE.shiftmL(VTP);
     PROPAGATE.shiftGU(VR);
     VRU := VTP * VR;
     FOR l := 2 TO m DO
       PROPAGATE.leftm(VTP);
       PROPAGATE.upG(VR);
       VRU := VRU + VTP*VR;
     END; 

(*Ende des topologischen Teils,Blok P0*)
  ENDPARALLEL; 
 
(*   STORE(VW,W);
   STORE(VW1,W1);
   STORE(VW2,W2);
   STORE(VW3,W3);
   STORE(VW4,W4);
   STORE(VW5,W5);
   STORE(VTP,TP); 
   STORE(VRU,RU);*)

END PDM_2.



