/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : General
  Filename     : texte.c       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.texte.c
  Version      : 1.4 
  Last changed : 11/16/93 at 15:31:10        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Fehlermeldungen fuer PARZ

******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/

static char sccs_id[] = "@(#)texte.c	1.4  11/16/93 PARZ - General (Frank Sembach)";


#include "parzdefs.h"
#include "komdefs.h"
#include "y_tab.h"

extern FILE *yyerfp;
extern int bef_tok;

char *ssstr[] = { "aus",
                  "Parallaxis",
                  "PARZ"
                };
char *protstr[] = {"aus", "kurz", "lang"};

char *texte[] =
{
/*  0 */ "Unbekannter Befehl %s",
/*  1 */ "Unbekannter Protokollmodus %d\n",
/*  2 */ "\b \b",
/*  3 */ "Programm kann nicht ausgefuehrt werden\n",
/*  4 */ "Nicht genuegend Platz zum Programmablauf",
/*  5 */ "Nicht genuegend Platz fuer Variablen",
/*  6 */ "Unbekannter Name",
/*  7 */ "Unzulaessiges Zeichen %c",
/*  8 */ "Das Programm muss mit STOP aufhoeren",
/*  9 */ "Alles hinter STOP wird ignoriert\n",
/* 10 */ "Das Programm muss mit START beginnen",
/* 11 */ "Zahl der Prozessoreinheiten fehlt",
/* 12 */ "Zahl der Prozessoreinheiten unklar",
/* 13 */ "Zahl der Verbindungen fehlt",
/* 14 */ "Zahl der Verbindungen unklar",
/* 15 */ "Fehlerhafte Verbindungsliste",
/* 16 */ "Fehlerhafte SCALAR-Deklaration",
/* 17 */ "SCALAR-Deklaration fehlt",
/* 18 */ "Fehlerhafte VECTOR-Deklaration",
/* 19 */ "VECTOR-Deklaration fehlt",
/* 20 */ "Fehlerhafte Programmzeile",
/* 21 */ " ( Label : %d )",
/* 22 */ "Labels sind nicht in aufsteigender Reihenfolge\n",
/* 23 */ "Label darf nicht 0 sein\n",
/* 24 */ "Fehler bei IF - GOTO",
/* 25 */ "Sprung auf PROC-Befehl ist verboten",
/* 26 */ "Fehler bei END",
/* 27 */ "Nur ein! END-Befehl am Programmende erlaubt",
/* 28 */ "Typfehler",
/* 29 */ "Adressierung liefert INTEGER-Wert",
/* 30 */ "Zuweisung von String nur an CHAR-Array moeglich",
/* 31 */ "Fehler bei REDUCE",
/* 32 */ "Zielvariable muss SCALAR sein",
/* 33 */ "Indexvariable muss vom Typ Integer sein",
/* 34 */ "Variablenfehler",
/* 35 */ "VECTOR-Variable als Index fuer SCALAR-Variable",
/* 36 */ "Variable ausserhalb des deklarierten Bereichs",
/* 37 */ "Lesezugriff auf Nur-Schreib-Variable",
/* 38 */ "Schreibzugriff auf Nur-Lese-Variable",
/* 39 */ "Fehler bei GOTO",
/* 40 */ "Ueberlauf bei einlesen von REAL-Konstante\n",
/* 41 */ "Fehler bei IF - CALL",
/* 42 */ "Sprungziel muss PROC_Befehl sein",
/* 43 */ "Bei IF...GOTO sind keine VECTOR-Variablen erlaubt",
/* 44 */ "Hier ist keine vordefinierte Variable erlaubt",
/* 45 */ "Falscher PORT-Bereich %d .. %d",
/* 46 */ "Fehler bei PUSHS",
/* 47 */ "Variable muss SCALAR sein",
/* 48 */ "Fehler bei POPV",
/* 49 */ "Argument muss vom Typ VECTOR sein",
/* 50 */ "Fehler bei CALL",
/* 51 */ "Fehler bei PROC",
/* 52 */ "Prozedurschachtelungstiefe muss >= 1 sein",
/* 53 */ "Indirekter Zugriff [%ld] auf unbekannte Variable",
/* 54 */ "Fehler bei PARALLEL",
/* 55 */ "Bitfeld hat falsche Laenge",
/* 56 */ "Argument muss Anfangsvariable eines skalaren Feldes sein",
/* 57 */ "Fehler bei PROPAGATE",
/* 58 */ "Uebertragungsvariable muss Vektorvariable sein",
/* 59 */ "TRACE war fuer die Variable nicht eingeschaltet",
/* 60 */ "Nicht genuegend Platz fuer Programmzeilen!\n",
/* 61 */ "Nicht genuegend Platz fuer Stacks!\n",
/* 62 */ "Nicht genuegend Platz fuer Ports!\n",
/* 63 */ "Falsche PE-Nr %d",
/* 64 */ "Falsche PORT-Nr %d",
/* 65 */ "Mehrere abgehende Verbindungen von %d %d\n",
/* 66 */ "Nicht genuegend Platz fuer Deklarationen!\n",
/* 67 */ "Zuweisung von VECTOR-Wert an SCALAR-Variable unmoeglich",
/* 68 */ "Unzulaessiger Typ",
/* 69 */ "Unvertraegliche Typen",
/* 70 */ "Portnummer muss vom Typ INTEGER sein",
/* 71 */ "Portnummer darf nur Konstante oder Skalarvariable sein",
/* 72 */ "am Programmende erkannt",
/* 73 */ "Unerlaubter Sprung nach Label %d in Befehl %d :",
/* 74 */ "END_Befehl fehlt!\n",
/* 75 */ "Nach dem END-Befehl duerfen keine Befehle mehr stehen",
/* 76 */ "Unbekanntes Label %d in Befehl %d :",
/* 77 */ "Unerlaubter CALL-Aufruf von Label %d in Befehl %d :",
/* 78 */ "Unerlaubter REDUCE-Aufruf von Label %d in Befehl %d :",
/* 79 */ "Syntax-Fehler",
/* 80 */ "Nicht genuegend Platz fuer diese Funktion\n",
/* 81 */ "                        ",
/* 82 */ "Zielvariable muss VECTOR sein",
/* 83 */ "Filename endet nicht mit 'termS'",
/* 84 */ "Unterschiedliche skalare und vektorielle Typen",
/* 85 */ "Fehler bei LOAD",
/* 86 */ "Erstes Argument muss vom Typ VECTOR sein",
/* 87 */ "Zweites Argument muss vom Typ SCALAR sein",
/* 88 */ "Fehler bei STORE",
/* 89 */ "Argument muss Vektorvariable sein",
/* 90 */ "Indexvariable hat keinen INTEGER-Wert",
/* 91 */ "Zugriff auf uninitialisierte Variable",
/* 92 */ "Zugriff auf unbekannte Variable",
/* 93 */ "RETURN aus Hauptprogramm ist unmoeglich",
/* 94 */ "Programmende innerhalb einer Prozedur",
/* 95 */ "Nicht genuegend Variablen am Stueck im Quellbereich von MOVE",
/* 96 */ "Aufruf einer Prozedur auf Ebene %d von Ebene %d aus",
/* 97 */ "Nicht genuegend Variablen am Stueck im Zielbereich von MOVE",
/* 98 */ "Zeile %d",
/* 99 */ "Zuweisung von CHAR-Wert an BOOLEAN-Variable",
/*100 */ "Zuweisung von REAL-Wert an CHAR-Variable",
/*101 */ "Erstes Argument ist uninitialisiert",
/*102 */ "Zweites Argument ist uninitialisiert",
/*103 */ "Zuweisung von CHAR-Wert an REAL-Variable",
/*104 */ "Unvertraegliche Typen bei Blockoperation",
/*105 */ "Nicht genuegend Variablen am Stueck im ersten Bereich von EQUAL",
/*106 */ "Nicht genuegend Variablen am Stueck im zweiten Bereich von EQUAL",
/*107 */ "Prozessoren, die bei der Ausfuehrung von PROC inaktiv waren,\n          koennen vor RETURN nicht aktiviert werden",
/*108 */ "Nicht genuegend Variablen am Stueck fuer Stringeingabe",
/*109 */ "Nicht genuegend CHAR-Variablen am Stueck fuer Stringeingabe",
/*110 */ "Nicht genuegend skalare Variablen am Stueck fuer LOAD",
/*111 */ "Ueberlauf bei Gleitkommaoperation",
/*112 */ "Nicht genuegend skalare Variablen am Stueck fuer STORE",
/*113 */ "Keine aktiven Prozessoren bei REDUCE",
/*114 */ "Illegaler Befehl waehrend REDUCE",
/*115 */ "Mehrere ankommende Werte auf einem Port",
/*116 */ "Weitere Fehlermeldungen und Warnungen werden unterdrueckt\n\n",
/*117 */ "Fehler bei TRACE",
/*118 */ "Indirekte Vektoradresse ist nicht erlaubt",
/*119 */ "PROC-Befehl ohne CALL erreicht",
/*120 */ "Fehler bei NOTRACE",
/*121 */ "Nicht genuegend Platz fuer Prozeduraufruf",
/*122 */ "", /* "\n**** Funktion abgebrochen ! ****\n", */
/*123 */ "Unterlauf bei Stack",
/*124 */ "Verschiedene Typen bei POP-Operation",
/*125 */ "Nicht genuegend Platz fuer Trace-Informationen",
/*126 */ "Nicht genuegend Variablen am Stueck fuer PARALLEL",
/*127 */ "Nicht genuegend BOOLEAN-Variablen am Stueck fuer PARALLEL",
/*128 */ "Nicht genuegend Variablen am Stueck fuer String-Zuweisung",
/*129 */ "Nicht genuegend CHAR-Variablen am Stueck fuer String-Zuweisung",
/*130 */ "Fehler bei READ",
/*131 */ "Erstes Argument muss vom Typ SCALAR sein",
/*132 */ "Maximallaenge muss ein skalarer INTEGER-Wert sein",
/*133 */ "Fehler bei WRITE",
/*134 */ "Fehler bei DRAW",
/*135 */ "Ausgabelaenge muss ein skalarer INTEGER-Wert sein",
/*136 */ "Nachkommastellenzahl muss ein skalarer INTEGER-Wert sein",
/*137 */ "Fehler bei WRITELN",
/*138 */ "Mehrfaches TRACE auf gleichem Variablenbereich",
/*139 */ "Nicht genuegend Variablen am Stueck",
/*140 */ "Nicht genuegend Variablen am Stueck fuer TRACE",
/*141 */ "Deklaration passt nicht zur Speicherstruktur",
/*142 */ "STATUS-Zuweisung ist nur an skalares BOOLEAN-Feld moeglich",
/*143 */ "Fehler bei OPENINPUT",
/*144 */ "Dateiname muss String oder skalares CHAR-Array sein",
/*145 */ "Fehler bei OPENOUTPUT",
/*146 */ "String endet nicht mit termS",
/*147 */ "Negativer Exponent bei INTEGER-Potenz",
/*148 */ "Potenz 0 ^ 0",
/*149 */ "Negative Basis bei REAL-Potenz",
/*150 */ "Potenz 0 ^ negative Zahl",
/*151 */ "Division durch 0",
/*152 */ "Unbekannter Debugmodus %d\n",
/*153 */ "Mehrere ankommende Verbindungen bei %d %d\n",
/*154 */ "Verbindung %d %d TO %d %d ist mehrfach angegeben",
/*155 */ "Unbekannte Uebersetzungskennung %d\n",
/*156 */ "Unbekannter Singlestepmodus %d\n",
/*157 */ "Datei %s nicht gefunden\n",
/*158 */ "Nicht genuegend Variablen am Stueck fuer String-Ausgabe",
/*159 */ "Nicht genuegend CHAR-Variablen am Stueck fuer String-Ausgabe",
/*160 */ "Nicht genuegend Variablen am Stueck fuer STATUS-Zuweisung",
/*161 */ "Nicht genuegend BOOLEAN-Variablen am Stueck fuer STATUS-Zuweisung",
/*162 */ "Indirekte Adresse [%ld] zeigt auf falschen Typ",
/*163 */ "Protokolldatei : %s\n",
/*164 */ "Kann keine Protokolldatei eroeffnen\n",
/*165 */ "\nEingabedatei : %s\n",
/*166 */ "Compilieren klappt nicht",
/*167 */ "Falscher PE-Bereich %d .. %d",
/*168 */ "Protokollmodus : %s\n",
/*169 */ "Einzelschritt-/Breakpointmodus : %s\n",
/*170 */ "Debugmodus : ein\n",
/*171 */ "Debugmodus : aus\n",
/*172 */ "Unverstaendliches Kommando",
/*173 */ "Unbekanntes Label : %d",
/*174 */ "Falscher Offset : %d",
/*175 */ "\nProgrammunterbrechung bei Zeile :",
/*176 */ "\nZeile erreicht :",
/*177 */ "\nGewaltsame Programmunterbrechung vor Zeile :",
/*178 */ "\nProgrammschritt auf Zeile :",
/*179 */ "Aktive Prozessoren : ",
/*180 */ "Programm war nicht unterbrochen\n",
/*181 */ "\nPARZ Parallel Simulator, Version 2.08, Univ. Stuttgart, Germany Nov. 1993\n",
/*182 */ "Default-PEs : ",
/*183 */ "Kein Aufrufstack vorhanden",
/*184 */ "Verwendung einer Variablen auf Ebene %d von Ebene %d aus",
/*185 */ "Weitere Warnungen zu diesem Befehl werden unterdrueckt\n\n",
/*186 */ "Warnungen : ein\n",
/*187 */ "Warnungen : aus\n",
/*188 */ "Unbekannter Warnungsmodus %d\n",
/*189 */ "-- MEHR (Hilfe mit h) --",
/*190 */ "\r                        \r",
/*191 */ "       ( Hilfe mit >h< )\n",
/*192 */ "\n\nFalsche Option\n",
/*193 */ "\n\nIm Filtermodus f kein Filename erlaubt\n",
/*194 */ "Temporaere Datei laesst sich nicht oeffnen",
/*195 */ "Falscher TEXT-Bereich %d .. %d",
/*196 */ "Kein Programm geladen\n",
/*197 */ "Falscher Adressbereich %d .. %d",
/*198 */ "Adressbereich %d .. %d existiert nicht",
/*199 */ "Adressbereich %d .. %d ist nicht auf dem HEAP",
/*200 */ "Fehler bei CONNECTED",
/*201 */ "Ziel muss vom Typ VECTOR INTEGER sein",
/*202 */ "Modus : %d\n\n",
/*203 */ "Programm : %s\n\n",
/*204 */ " Keine",
/*205 */ "Prozedur %s (%d z), aufgerufen von Zeile %s (%d z)",
/*206 */ "   Lokale Variablen fuer Steuerrechner :",
/*207 */ "   Lokale Variablen fuer PE-Array :",
/*208 */ "   Fruehere Prozessorzustaende : ",
/*209 */ "Aktivierungsblock fehlt !\n\n",
/*210 */ "Hauptprogramm %s : ",
/*211 */ "   Globale Variablen fuer Steuerrechner :",
/*212 */ "   Globale Variablen fuer PE-Array :",
/*213 */ "Aktivierungsblock fuer Hauptprogramm fehlt !\n\n",
/*214 */ "Heap fuer Steuerrechner :",
/*215 */ " Keiner",
/*216 */ "Heap fuer PE-Array :",
/*217 */ "Speicher des Steuerrechners :",
/*218 */ "Speicher des PE-Arrays :",
/*219 */ "* ToS *",
/*220 */ "* BoS *",
/*221 */ "Parameterstack fuer Steuerrechner :",
/*222 */ "Parameterstacks fuer PE-Array :",
/*223 */ "Abstand von Spitze des Aufrufstack : %d\n",
/*224 */ "Adresse %d existiert nicht",
/*225 */ "  ...  ",
/*226 */ "Adresse %d ist nicht auf dem HEAP",
/*227 */ "bei \"%.*s\"",
/*228 */ "Falsches Vorzeichen '-'",
/*229 */ "Falsches Vorzeichen NOT",
/*230 */ "Kein Vorzeichen erlaubt",
/*231 */ "Ausgewaehlte PE ist nicht aktiv",
/*232 */ "Nicht genuegend Platz fuer REDUCE",
/*233 */ "Die Variable existiert nicht auf den ausgewaehlten PEs",
/*234 */ "    in Quellcode-Zeile %d",
/*235 */ "Nicht genuegend Variablen am Stueck im Zielbereich von LOAD",
/*236 */ "Nicht genuegend Variablen am Stueck im Quellbereich von STORE",
/*237 */ "Unbekannte Quellzeile %d",
/*238 */ "Im Compilermodus ist kein Offset erlaubt",
/*239 */ "Breakpoint gesetzt auf Zeile :\n",
/*240 */ "Breakpoint geloescht aus Zeile :\n",
/*241 */ "%*d : %s",
/*242 */ "[Fehler] ",
/*243 */ "[Fehler %d] ",
/*244 */ "\n   im Befehl :",
/*245 */ "      bei Prozessor Nr %d\n",
/*246 */ "\n[Laufzeitfehler] ",
/*247 */ "\n[Fehler] ",
/*248 */ "[Warnung] ",
/*249 */ "\n[Achtung] ",
/*250 */ "[Abbruch] ",
/*251 */ "[Systemfehler] ",
/*252 */ "Ausgabebreite fuer PE-Listen : %d\n",
/*253 */ "Ausgabebreite 0 ist nicht erlaubt",
/*254 */ "pa2 -pxme%d%s <%s",
/*255 */ "",
/*256 */ "erwartet wird: ",
/*257 */ "Funktion '%s' ist nicht definiert fuer Argument %#g",
/*258 */ "Funktion 'arctan' ist nicht definiert fuer Argument %#g / %#g",
/*259 */ "sqrt",
/*260 */ "exp",
/*261 */ "ln",
/*262 */ "sin",
/*263 */ "cos",
/*264 */ "tan",
/*265 */ "arcsin",
/*266 */ "arccos",
/*267 */ "arctan",
/*268 */ "abs",
/*269 */ "Diese Funktion ist nicht implementiert\n",
/*270 */ "Nicht genuegend Platz fuer Parser",
/*271 */ "Fehler bei SEND",
/*272 */ "Fehler bei RECEIVE",
/*273 */ "Fehler bei GETPIXEL",
/*274 */ "Fehler bei OPENW",
/*275 */ "Fehler bei MOVETO",
/*276 */ "Fehler bei LINETO",
/*277 */ "Fehler bei SETPIXEL",
/*278 */ "Fehler bei WSIZE",
/*279 */ "Fehler bei SETCOLOR",
/*280 */ "Fehler bei SELECTW",
/*281 */ "Fehler bei CLOSEW",
/*282 */ "Grafikroutinen arbeiten nur mit skalaran Daten",
/*283 */ "Zugriff auf inaktive Variante",
/*284 */ "Zugriff auf inaktive Variante beim ersten Argument",
/*285 */ "Zugriff auf inaktive Variante beim zweiten Argument",
/*286 */ "Nicht genuegend Variablen am Stueck fuer Graphik Befehl",
/*287 */ "Nicht genuegend INTEGER-Variablen am Stueck fuer Graphik Befehl",
/*288 */ "Keine Verbindungen vorhanden\n",
/*289 */ "Falsche MAGIC-Nummer in xrf-Datei\n",
/*290 */ "Woerterbuch falsch in xrf-Datei\n",
/*291 */ "Symboltabelle falsch in xrf-Datei\n",
/*292 */ "Geltungsbereichstabelle falsch in xrf-Datei\n",
/*293 */ "Zeilennummerntabelle falsch in xrf-Datei\n",
/*294 */ "Typtabelle falsch in xrf-Datei\n",
/*295 */ "Mitgliedertabelle falsch in xrf-Datei\n",
/*296 */ "Endekennung fehlt in xrf-Datei\n",
/*297 */ "Nicht genuegend Platz fuer xrf-Daten\n",
/*298 */ "+%d",
/*299 */ "Nicht genuegend Platz fuer Quelltext\n",
/*300 */ "Quelldatei laesst sich nicht oeffnen\n",
/*301 */ "Unbekannter Bezeichner %s",
/*302 */ "Unbekannter Prozedur- oder Systemname %s",
/*303 */ "%s nicht als REDUCE-Operator erlaubt",
/*304 */ "Falscher Ausdruck als Argument von REDUCE",
/*305 */ "Falsches Argument bei '%s'",
/*306 */ "Falsches erstes Argument bei '%s'",
/*307 */ "Falsches zweites Argument bei '%s'",
/*308 */ "Unerlaubter Bezeichner %s",
/*309 */ "Prozedur ist nicht auf dem Aufrufstack",
/*310 */ "Ausdruck ist nicht zuweisbar",
/*311 */ "Keine aktive Konfiguration",
/*312 */ "Keine PEs selektiert\n",
/*313 */ "Typen sind nicht zuweisungskompatibel",
/*314 */ "Falsche Typkombination fuer Operator '%s'",
/*315 */ "Zuweisung an Konstante ist unmoeglich",
/*316 */ "Fehler bei INITSET",
/*317 */ "Zielvariable muss vom Typ BOOLEAN sein",
/*318 */ "Nicht genuegend Variablen am Stueck fuer INITSET",
/*319 */ "Nicht genuegend BOOLEAN-Variablen am Stueck fuer INITSET",
/*320 */ "Falsche POINTER-Konstante",
/*321 */ "Falsche Dereferenzierung '%s'",
/*322 */ "'%s' ist kein RECORD",
/*323 */ "Unbekannte RECORD-Komponente '%s'",
/*324 */ "'%s' ist kein ARRAY",
/*325 */ "Bereichsueberschreitung bei ARRAY-Index",
/*326 */ "Index '%s' hat falschen Typ",
/*327 */ "VECTOR-Index fuer SCALAR-Feld",
/*328 */ "Dereferenzierung von NIL",
/*329 */ "Selektion hat zu viele Dimensionen",
/*330 */ "Keine Selektion erlaubt",
/*331 */ "Falscher Ausdruck '%s' in Selektion",
/*332 */ "Keine .xrf-Datei\n",
/*333 */ ".xrf-Datei aelter als .z-Datei\n",
/*334 */ ".xrf-Datei laesst sich nicht oeffnen\n",
/*335 */ "Keine Quelldatei\n",
/*336 */ "Quelldatei juenger als .z-Datei\n",
/*337 */ "'%s' ist kein SET-Typ",
/*338 */ "Falscher Ausdruck '%s' in Set",
/*339 */ "Falscher Typ in SET-Konstante",
/*340 */ "Wert ausserhalb des SET-Bereichs",
/*341 */ "%s ist keine Standardfunktion und kein Typname",
/*342 */ "Falscher Typ fuer konstante Struktur",
/*343 */ "Konstante ARRAYs noch nicht implementiert\n",
/*344 */ "Konstante RECORDs noch nicht implementiert\n",
/*345 */ "Falsche Parameterzahl fuer Funktion '%s'",
/*346 */ "Falscher Typ fuer Funktion '%s'",
/*347 */ "Parametrisierter Port '%s' braucht einen Parameter",
/*348 */ "Port '%s' braucht keinen Parameter",
/*349 */ "Falsche Parameterzahl fuer Port '%s'",
/*350 */ "Falscher Parametertyp fuer Port '%s'",
/*351 */ "Funktion '%s' noch nicht implementiert\n",
/*352 */ "Fehler in OPENABSW",
/* */ ""
};

extern int morelen;
extern char more_mod, quitted;

printhelp(s)
char *s;
{ fputs(s, stderr); putc('\n', stderr);
  fputs("Verwendung : parz { Option | file }\n", stderr);
  fputs("Optionen und files werden von links nach rechts abgearbeitet\n", stderr);
  fputs("Optionen schalten div. Modi um, files sind Programmtexte\n", stderr);
  fputs("   Optionen :\n", stderr);
#ifndef PC
  fputs("   -c[0|1]         : Compilieren (default aus)\n", stderr);
#endif
  fputs("   -d[0|1]         : Ausgabe von DEBUG und TRACE (default ein)\n", stderr);
  fputs("   -e[0-9]+        : max. Anzahl von Meldungen (default 15)\n", stderr);
  fputs("   -f              : Filter : starte Programm von stdin\n", stderr);
#ifndef CRAY
  fputs("   -l              : Datei laden (falls vorhanden), Kommandointerpreter\n", stderr);
  fputs("   -m[0-9]*        : 'MEHR'-Bildschirmlaenge (0 : aus)\n", stderr);
#endif
  fputs("   -r[0|1|2][file] : Protokollmodus (default aus), Protokolldatei\n", stderr);
  fputs("                     (bei Dateiangabe nicht mit anderen Optionen mischen)\n", stderr);
  fputs("   -s[0|1|2]       : Singlestep (1 : Parallaxis, 2 : PARZ)\n", stderr);
  fputs("   -w[0|1]         : Laufzeitwarnungen (default ein)\n", stderr);
  parzexit(1);
}

print_more_help(f)
FILE *f;
{ fputs("------------------- Hilfe -------------------\n", f);
  fputs("Space     : Ein Bildschirm weiter\n", f);
  fputs("numSpace  : weiter mit neuer Bildschirmlaenge\n", f);
  fputs("Return    : Eine Zeile weiter\n", f);
  fputs("numReturn : num Zeilen weiter\n", f);
  fputs("q         : Funktion abbrechen\n", f);
  fputs("h,?       : Hilfsanzeige\n", f);
  fputs("---------------------------------------------\n", f);
}

char *help_texte[] =
{
#define LNULL 24
#define SNULL 0
/*  1 */ "          Simulator Kommandos :\n",
/*  2 */ "A(SSIGN)        : Wert an Quellvariable zuweisen\n",
/*  3 */ "B(REAKPOINT)    : Breakpoint setzen / loeschen\n",
/*  4 */ "C(ALLS)         : Aufrufkette ausgeben\n",
/*  5 */ "CO(NNECTIONS)   : Portverbindungen anzeigen\n",
/*  6 */ "D(EBUG)         : Debugmodus einstellen / anzeigen\n",
/*  7 */ "E(XAMINE)       : Quellvariable anzeigen\n",
/*  8 */ "G(O)            : Programm starten bzw. fortsetzen\n",
/*  9 */ "H(ELP) bzw. ?   : Dieser Hilfstext\n",
/* 10 */ "H(ELP) Kommando : Hilfe zu Kommando\n",
/* 11 */ "L(OAD)          : Programm laden\n",
/* 12 */ "LI(ST)          : Programmlisting ausgeben\n",
/* 13 */ "M(ODE)          : Einzelschritt- und Breakpointmodus einstellen / anzeigen\n",
/* 14 */ "N(OTRACE)       : PARZ NOTRACE-Befehl\n",
/* 15 */ "Q(UIT)          : Interpreter verlassen\n",
/* 16 */ "R(ECORD)        : Protokollmodus einstellen / anzeigen\n",
/* 17 */ "S(HOW)          : Speicher- oder Stackinhalt ansehen\n",
/* 18 */ "SE(T)           : Variablenwert aendern\n",
/* 19 */ "ST(EP)          : Einzelschritt ausfuehren\n",
/* 20 */ "STO(P)          : Unterbrochenes Programm abbrechen\n",
/* 21 */ "T(RACE)         : PARZ TRACE-Befehl\n",
/* 22 */ "W(ARN)          : Laufzeitwarnungen ein / ausschalten\n",
/* 23 */ "WI(DTH)         : Ausgabebreite fuer PE-Listen einstellen / anzeigen\n",
/* 24 */ "<RETURN>        : Nach Abbruch oder ST(EP) T(O)/A(LL) : ein Schritt weiter\n",

#ifndef PC
#define LLIST 8
#else 
#define LLIST 3
#endif
#define SLIST (SNULL + LNULL)
/*  1 */ "LI(ST) [ ( label [ '..' ] ) | ( [ label ] '..' label ) ]\n",
/*  2 */ "   Ausgabe der ausgewaehlten Zeilen\n",
/*  3 */ "   keine Zeilenangabe: ganzes Programm ausgeben\n",
#ifndef PC
/*  4 */ "\n",
/*  5 */ "LI(ST) S(TRINGMATCH) \"string\"\n",
/*  6 */ "   Ausgabe von Programmzeilen, die string enthalten\n",
/*  7 */ "LI(ST) P(ATTERN) \"Reg.Ausdr.\"\n",
/*  8 */ "   Ausgabe von Programmzeilen, die Reg.Ausdr. enthalten (im Sinne von GREP)\n",
#endif

#define LGO 5
#define SGO (SLIST + LLIST)
/*  1 */ "G(O) [ S(TEP) [ O(VER) ] ] [ T(O) ( label | proc_ident ) ]\n",
/*  2 */ "   Programm starten / fortsetzen\n",
/*  3 */ "   S(TEP) : Ausgabe jeds Schritts, O(VER) : Prozeduraufruf ist ein Schritt\n",
/*  4 */ "   T(O)   : bis Befehl bzw. Quellzeile 'label'\n",
/*  5 */ "                oder Prozedur 'proc_ident' erreicht\n",

#define LSTEP 9
#define SSTEP (SGO + LGO)
/*  1 */ "ST(EP) [ O(VER) ]\n",
/*  2 */ "   Einzelschritt ausfuehren\n",
/*  3 */ "ST(EP) [ O(VER) ] T(O) ( label | proc_ident )\n",
/*  4 */ "   Einzelschritte ausfuehren bis Befehl bzw. Quellzeile 'label'\n",
/*  5 */ "                                 oder Prozedur 'proc_ident' erreicht\n",
/*  6 */ "ST(EP) [ O(VER) ] A(LL)\n",
/*  7 */ "   Einzelschritte ausfuehren bis Programmende\n",
/*  8 */ "      O(VER)      : ueberspringe Funktionen\n",
/*  9 */ "      T(O), A(LL) : mit <RETURN> einen Schritt weiter\n",

#define LMODE 5
#define SMODE (SSTEP + LSTEP)
/*  1 */ "M(ODE)        : Einzelschritt-/Breakpointmodus anzeigen\n",
/*  2 */ "M(ODE) Option : Einzelschritt-/Breakpointmodus einstellen\n",
/*  3 */ "   Option :\n",
/*  4 */ "      C(OMPILER)    : Parallaxis-Schritte\n",
/*  5 */ "      I(NTERPRETER) : PARZ-Schritte\n",

#define LSTOP 1
#define SSTOP (SMODE + LMODE)
/*  1 */ "STO(P) : beendet unterbrochenes Programm, setzt Befehlszaehler auf Anfang\n",

#ifndef PC
#define LLOAD 2
#else 
#define LLOAD 1
#endif
#define SLOAD (SSTOP + LSTOP)
/*  1 */ "L(OAD) file             : lade neues Programm aus Datei file\n",
#ifndef PC
/*  2 */ "L(OAD) file -C(OMPILER) : compiliere neues Program aus Datei file\n",
#endif

#define LBREAKPOINT 6
#define SBREAKPOINT (SLOAD + LLOAD)
/*  1 */ "B(REAKPOINT) [ [sign] ( label | proc_ident ) [(+|-)offset] ]\n",
/*  2 */ "   setze (falls sign = '+' oder fehlt) bzw.\n",
/*  3 */ "   loesche (falls sign = '-')\n",
/*  4 */ "   Breakpoint in Zeile 'label +/- offset' bzw. in Quellzeile 'label'\n",
/*  5 */ "              oder bei Eintritt in Prozedur 'proc_ident'\n",
/*  6 */ "   ohne Argumente : Liste aller Breakpoints\n",

#define LDEBUG 3
#define SDEBUG (SBREAKPOINT + LBREAKPOINT)
/*  1 */ "D(EBUG) [ Y(ES) | N(O) | 0 | 1 ] [ P(E) ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/*  2 */ "   DEBUG/TRACE-Modus setzen / anzeigen\n",
/*  3 */ "   P(E) setzt Default-Prozessorliste\n",

#define LTRACE 2
#define STRACE (SDEBUG + LDEBUG)
/*  1 */ "T(RACE) vardesc string AS declaration\n",
/*  2 */ "   schaltet TRACE fuer einen Variablenbereich ein\n",

#define LNOTRACE 2
#define SNOTRACE (STRACE + LTRACE)
/*  1 */ "N(OTRACE)         : schaltet TRACE fuer alle Variablen aus\n",
/*  2 */ "N(OTRACE) vardesc : schaltet TRACE fuer eine Variable aus\n",

#define LRECORD 4
#define SRECORD (SNOTRACE + LNOTRACE)
/*  1 */ "R(ECORD) ( O(FF) | N(O) | 0 ) : schaltet Protokollausgabe aus\n",
/*  2 */ "R(ECORD) ( S(HORT) | 1 )      : Ausgabe von PE-Anzahlen im Protokoll\n",
/*  3 */ "R(ECORD) ( L(ONG) | 2 )       : Ausgabe von PE-Aktivierungen im Protokoll\n",
/*  4 */ "R(ECORD)                      : Protokollmodus anzeigen\n",

#define LWARN 2
#define SWARN (SRECORD + LRECORD)
/*  1 */ "W(ARN) ( Y(ES) | N(O) | 0 | 1 ) : schaltet Warnungen ein/aus\n",
/*  2 */ "W(ARN)                          : Warnungsmodus anzeigen\n",

#define LSET 2
#define SSET (SWARN + LWARN)
/*  1 */ "SE(T) vardesc [ PE ( ( num [ '..' num ] ),+ | '*' ) ] [ - | NOT ] VarConst\n",
/*  2 */ "   besetzt vardesc auf den bezeichneten PEs mit [ - | NOT ] VarConst\n",

#define LSHOW 40
#define SSHOW (SSET + LSET)
/*  1 */ "S(HOW) M(EMORY) [ S ( ( adr [ '..' ] ) | ( [ adr ] '..' adr ) ),* ]\n",
/*  2 */ "                [ V ( ( adr [ '..' ] ) | ( [ adr ] '..' adr ) ),* ]\n",
/*  3 */ "                [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/*  4 */ "   Ausgabe des angegebenen Speicherbereichs :\n",
/*  5 */ "   adr : ganze Zahl entspr. Absolutadresse\n",
/*  6 */ "   PE  : Liste der zu betrachtenden Prozessoren\n",
/*  7 */ "   num : Prozessornummer, '*' : alle Prozessoren\n",
/*  8 */ "\n",
/*  9 */ "S(HOW) H(EAP) ...\n",
/* 10 */ "   Wie S(HOW) M(EMORY), aber nur negative Adressen\n",
/* 11 */ "\n",
/* 12 */ "S(HOW) P(ARSTACK) [ S [ tiefe ] ]  [ V [ tiefe ] ]\n",
/* 13 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/* 14 */ "   Ausgabe von Parameterstacks :\n",
/* 15 */ "   tiefe : Zahl der auszugebenden Werte ab Top Of Stack\n",
/* 16 */ "   PE    : Liste der zu betrachtenden Prozessoren\n",
/* 17 */ "\n",
/* 18 */ "S(HOW) C(ALLSTACK) [ C(HAIN) [ A(CTIVITY) ] ]\n",
/* 19 */ "                   [ S [ tiefe ] ]  [ V [ tiefe ] ]\n",
/* 20 */ "                   [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/* 21 */ "   Ausgabe des Prozeduraktivierungsstacks :\n",
/* 22 */ "   C(HAIN)    : Ausgabe der ganzen Aufrufkette\n",
/* 23 */ "   A(CTIVITY) : Ausgabe der PE-Zustaende auf dem Stapel\n",
/* 24 */ "   tiefe      : Zahl der Aufrufstufen mit Variablenausgabe\n",
/* 25 */ "   PE         : Liste der zu betrachtenden Prozessoren\n",
/* 26 */ "\n",
/* 27 */ "S(HOW) V(ARIABLE) vardesc [ P(ROC) label [ D(EPTH) tiefe ] ]\n",
/* 28 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ] [ AS declaration ]\n",
/* 29 */ "   Ausgabe von Variablenwerten :\n",
/* 30 */ "   vardesc     : Startvariable des Speicherbereichs\n",
/* 31 */ "   label       : Prozedur, aus deren Sicht Variable betrachtet wird\n",
/* 32 */ "   tiefe       : Zahl der zu betrachtenden rekursiven Aufrufe der Prozedur\n",
/* 33 */ "   PE ...      : Liste der zu betrachtenden Prozessoren\n",
/* 34 */ "   declaration : Beschreibung des Speicherbereichs\n",
/* 35 */ "\n",
/* 36 */ "S(HOW) S(PECIALS) ( MAXTRANS | ACTTRANS | DONE | TERMCH | SRESULT | VRESULT ),*\n",
/* 37 */ "                  [ PE ( ( num [ '..' num ] ),+ | '*' ) ]\n",
/* 38 */ "   Ausgabe der Variablenwerte der angegebenen Spezialvariablen\n",
/* 39 */ "   ( sind keine Variablen angegeben, werden alle ausgegeben. )\n",
/* 40 */ "   PE ... : Liste der zu betrachtenden Prozessoren\n",

#define LCALLS 2
#define SCALLS (SSHOW + LSHOW)
/*  1 */ "C(ALLS)            : Ausgabe der Aufrufkette\n",
/*  2 */ "C(ALLS) A(CTIVITY) : Ausgabe der Aufrufkette mit Angabe der aktiven PEs\n",

#define LQUIT 1
#define SQUIT (SCALLS + LCALLS)
/*  1 */ "Q(UIT) : Interpreter verlassen\n",

#define LHELP 16
#define SHELP (SQUIT + LQUIT)
/*  1 */ "H(ELP) oder ?   : Kommandouebersicht\n",
/*  2 */ "H(ELP) kommando : Kommandobeschreibung\n",
/*  3 */ "\n",
/*  4 */ "Syntax der Hilfstexte:\n",
/*  5 */ "   Wort in Grossbuchstaben         : Text ohne gross/klein Unterscheidung\n",
/*  6 */ "   Wort in Kleinbuchstaben         : wird im Hilfstext erklaert\n",
/*  7 */ "   X(Y) mit X,Y in Grossbuchstaben : Praefix von XY (mindetens X)\n",
/*  8 */ "                                     ohne gross/klein Unterscheidung\n",
/*  9 */ "   Ziffer  : diese Ziffer\n",
/* 10 */ "   'c'     : das Zeichen c\n",
/* 11 */ "   ( x )   : x\n",
/* 12 */ "   [ x ]   : x oder nichts\n",
/* 13 */ "   x | y   : x oder y\n",
/* 14 */ "   x y     : x gefolgt von y\n",
/* 15 */ "   ( x ),* : beliebig viele x durch ',' getrennt\n",
/* 16 */ "   ( x ),+ : mindestens ein x durch ',' getrennt\n",

#define LWIDTH 1
#define SWIDTH (SHELP + LHELP)
/*  1 */ "WI(DTH) [ num ] : Ausgabebreite fuer PE-Listen einstellen / ausgeben\n",

#define LCONNECTIONS 4
#define SCONNECTIONS (SWIDTH + LWIDTH)
/*  1 */ "C(ONNECTIONS) ( enum enum TO enum enum ),*\n",
/*  2 */ "   enum : ( num [ '..' num ] | '*' )\n",
/*  3 */ "      Ausgabe der ausgewaehlten Portverbindungen :\n",
/*  4 */ "      keine Auswahl: alle Verbindungen ausgeben\n",

#define LEXAMINE 6
#define SEXAMINE (SCONNECTIONS + LCONNECTIONS)
/*  1 */ "E(XAMINE) [ ( '!' proc_ident )+ [ '!' tiefe ] ] [ selection ] expr_list\n",
/*  2 */ "   Ausgabe der Werte der Parallaxis-Ausdruecke in 'expr_list'\n",
/*  3 */ "     ..proc_ident.. : Prozedurpfad aus dessen Sicht 'expr_list' ausgewertet wird\n",
/*  4 */ "     tiefe          : Zahl der rekursiven Aufrufe von 'proc_ident'\n",
/*  5 */ "     selection      : Auswahl von PEs in Parallaxis-Notation\n",
/*  6 */ "                      ohne Configuration-Name, nur innerhalb Parallel-Block\n",

#define LASSIGN 4
#define SASSIGN (SEXAMINE + LEXAMINE)
/*  1 */ "A(SSIGN) [ selection ] designator ':=' expr\n",
/*  2 */ "   Weist dem Parallaxis-Bezeichner 'designator' den Wert 'expr' zu\n",
/*  3 */ "     selection : Auswahl von PEs, auf denen die Zuweisung stattfindet\n",
/*  4 */ "                 ohne Configuration-Name, nur innerhalb Parallel-Block\n"

};

help_out(von, len)
int von, len;
{ register int moreflag;
  register int bis;

  if (moreflag = (more_mod && morelen < len))
  { more_on(); }
  for (bis = von + len; von < bis; von++)
  { fputs(help_texte[von], yyerfp);
    if (moreflag && von < bis - 1) ifmore(yyerfp);
    if (quitted) break;
  }
  if (moreflag) more_off();
  if (quitted) putc('\n', yyerfp);
}

help(komm_tok)
int komm_tok;
{ switch (komm_tok)
  { case 0          : help_out(SNULL,LNULL);
                      break;
    case LIST       : help_out(SLIST,LLIST);
                      break;
    case GO         : help_out(SGO,LGO);
                      break;
    case STEP       : help_out(SSTEP,LSTEP);
                      break;
    case MODE       : help_out(SMODE,LMODE);
                      break;
    case STOP       : help_out(SSTOP,LSTOP);
                      break;
    case LOAD       : help_out(SLOAD,LLOAD);
                      break;
    case BREAKPOINT : help_out(SBREAKPOINT,LBREAKPOINT);
                      break;
    case DEBUG      : help_out(SDEBUG,LDEBUG);
                      break;
    case TRACE      : help_out(STRACE,LTRACE);
                      break;
    case NOTRACE    : help_out(SNOTRACE,LNOTRACE);
                      break;
    case RECORD     : help_out(SRECORD,LRECORD);
                      break;
    case WARN       : help_out(SWARN,LWARN);
                      break;
    case SET        : help_out(SSET,LSET);
                      break;
    case SHOW       : help_out(SSHOW,LSHOW);
                      break;
    case CALLS      : help_out(SCALLS,LCALLS);
                      break;
    case QUIT       : help_out(SQUIT,LQUIT);
                      break;
    case HELP       : help_out(SHELP,LHELP);
                      break;
    case WIDTH      : help_out(SWIDTH,LWIDTH);
                      break;
    case CONNECTIONS: help_out(SCONNECTIONS,LCONNECTIONS);
                      break;
    case EXAMINE    : help_out(SEXAMINE,LEXAMINE);
                      break;
    case ASSIGN     : help_out(SASSIGN,LASSIGN);
                      break;
  }
  bef_tok = 0;
}
