SYSTEM beuys;
CONST maxnode = 100;
      length  = maxnode * 3;
      part    = length div 2;

TYPE  field   = ARRAY [0..8] OF INTEGER;

SCALAR   ch : CHAR;
       	 win : CARDINAL;
      	 xa,ya : field;

CONFIGURATION line [maxnode];
CONNECTION    left  : line[i]  -> line[i-1].right;

VECTOR   x1,x2,x3,x4,y1,y2,y3,y4 : INTEGER;

PROCEDURE plot(VECTOR x, y : integer; SCALAR c: COLOR);
VECTOR xnext, dx, px, ynext, dy, py, m, t, i: integer;

   PROCEDURE VSIGN(VECTOR i : integer) : VECTOR integer;
   VECTOR erg : integer;
   BEGIN
         IF i = 0 THEN erg := 0 ELSE erg := i div ABS(i) END;
         RETURN (erg);
   END VSIGN;

BEGIN
   Setcolor(c);
   PROPAGATE.left(x,xnext); dx := xnext - x;
   PROPAGATE.left(y,ynext); dy := ynext - y;
   IF DIM1 # REDUCE.max(DIM1) THEN
      IF ABS(dx) < ABS(dy) THEN
      	 IF dy < 0 THEN
      	    dec(xnext,dx); inc(x,dx); dx := -dx;
      	    dec(ynext,dy); inc(y,dy); dy := -dy;
      	 END;
      	 px := x; m := 0; i := VSIGN(dx); dx := ABS(dx); t := dy div 2;
      	 FOR py := y TO ynext DO
      	    SetPixel(px,py);
      	    inc(m,dx);
      	    IF m > t THEN inc(t,dy); inc(px,i); END;
      	 END;
      ELSE
      	 IF dx < 0 THEN
      	    dec(xnext,dx); inc(x,dx); dx := -dx;
      	    dec(ynext,dy); inc(y,dy); dy := -dy;
      	 END;
      	 py := y; m := 0; i := VSIGN(dy); dy := ABS(dy); t := dx div 2;
      	 FOR px := x TO xnext DO
      	    SetPixel(px,py);
      	    inc(m,dy);
      	    IF m > t THEN inc(t,dx); inc(py,i); END;
      	 END;
      END;
   END;
END plot;


BEGIN (* main *)
   win := OpenAbsWindow(length,length);

   PARALLEL
      IF EVEN(DIM1) THEN
      	 x1 := VIRandom() MOD part;
      	 y1 := VIRandom() MOD part;
      	 x2 := VIRandom() MOD part;
      	 y2 := length - VIRandom() MOD part;
      	 x3 := VIRandom() MOD part;
      	 y3 := part div 2 + VIRandom() MOD part;
      	 x4 := part div 2 + VIRandom() MOD part;
      	 y4 := VIRandom() MOD part;
      ELSE
      	 x1 := length - VIRandom() MOD part;
      	 y1 := length - VIRandom() MOD part;
      	 x2 := length - VIRandom() MOD part;
      	 y2 := VIRandom() MOD part;
      	 x3 := length - VIRandom() MOD part;
      	 y3 := part div 2 + VIRandom() MOD part;
      	 x4 := part div 2 + VIRandom() MOD part;
      	 y4 := length - VIRandom() MOD part;
      END;
      plot(x1, y1, COLOR(0,0,0));
      plot(x2, y2, COLOR(200,200,200));
      plot(x3, y3, COLOR(120,120,120));
      plot(x4, y4, COLOR(170,170,170));
   ENDPARALLEL;
   WriteString("Press RETURN for termination"); WriteLn;
   Read(ch);
   CloseWindow(win);
END beuys.
