SYSTEM fractal;
CONST  maxlevel  = 10;
       low_val   = 0.0;
       high_val  = 1.0;
       maxnode   = 2**maxlevel - 1;
       leaf_end  = maxnode;
       leaf_start= (leaf_end+1) DIV 2;
       leaf_num  = leaf_start;
       scale     = 2;
       height    = scale * leaf_num DIV 3;

CONFIGURATION tree [1 .. maxnode];
CONNECTION    son_l : tree[i] <-> tree[2*i].father;
              son_r : tree[i] <-> tree[2*i+1].father;
      	      left  : tree[i]  -> tree[i-1].right;

SCALAR  i,j         : INTEGER;
        delta       : REAL;
        field       : ARRAY [1..2**maxlevel-1] OF REAL;
        win         : CARDINAL;
        xmax,xmin   : REAL;
        ch          : CHAR;

VECTOR  x, low, high: REAL;
        pos         : CARDINAL;

PROCEDURE Gauss(): VECTOR REAL;
(* random number with Gaussian distribution *)
CONST N = 4;
      A = MAX(INTEGER);
      GA= (3.0*FLOAT(N))**0.5;
      GF= 2.0*GA / (FLOAT(N)*FLOAT(A));
SCALAR i  : INTEGER; 
VECTOR sum: REAL;
BEGIN
  sum:=0.0;
  FOR i:=1 TO N DO sum:= sum + FLOAT(VIRandom()) END;
  RETURN (GF*sum - GA)
END Gauss;

PROCEDURE MidPointRec(SCALAR delta: REAL; SCALAR level: INTEGER);
SCALAR  min, max, max2 : INTEGER;
BEGIN
  (* select tree-level: 2^(level-1) <= id_no <= 2^level - 1 *)
  min := 2**(level-1);
  max := 2 * min - 1;
  max2:= 2 * max + 1;

  PARALLEL [min..max]
    x := 0.5 * (low + high) + delta*Gauss();
  ENDPARALLEL;

  IF level < maxlevel THEN (* new low/high values for left/right son *) 
    PARALLEL [min..max2]
      PROPAGATE.son_l(low);
      PROPAGATE.son_r(high);
      PROPAGATE.son_l(x);
      PROPAGATE.son_r(x);
      IF even(id_no) THEN high:=x ELSE low:=x END;
    ENDPARALLEL
  END
END MidPointRec;

PROCEDURE VLine(VECTOR x0, y0, x1, y1 : integer);
VECTOR dx, dy,
       plauf, pabh, sw,
       i, m, t, kl : INTEGER;
       koord : ARRAY [0..1] OF INTEGER;

   PROCEDURE VSIGN(VECTOR i : integer) : VECTOR integer;
   VECTOR erg : integer;
   BEGIN
         IF i = 0 THEN erg := 0 ELSE erg := i div ABS(i) END;
         RETURN (erg);
   END VSIGN;

   PROCEDURE VSwap(VECTOR VAR a, b : INTEGER);
   VECTOR sw : INTEGER;
   BEGIN
      sw := a; a := b; b := sw;
   END VSwap;

BEGIN
   dx := x1 - x0;
   dy := y1 - y0;
   IF ABS(dx) < ABS(dy) THEN
      VSwap(x0,y0);
      x1 := y1;
      VSwap(dx,dy);
      plauf := 1; pabh := 0;
   ELSE
      plauf := 0; pabh := 1;
   END;
   IF dx < 0 THEN
      inc(y0,dy); dy := -dy;
      VSwap(x0, x1); dx := -dx;
   END;
   koord[pabh] := y0; i := VSIGN(dy); dy := ABS(dy);
   m := 0; t := dx div 2;

   FOR kl := x0 TO x1 DO
      koord[plauf] := kl;
      SetPixel(koord[0],koord[1]);
      inc(m,dy);
      IF m > t THEN inc(t,dx); inc(koord[pabh],i); END;
   END;

END VLine;

PROCEDURE plot(VECTOR x, y : integer; SCALAR c: COLOR);
VECTOR xnext, ynext : INTEGER;
BEGIN
   Setcolor(c);
   PROPAGATE.left(x,xnext);
   PROPAGATE.left(y,ynext);
   IF DIM1 # REDUCE.max(DIM1) THEN
      VLine(x, y, xnext, ynext);
   END;
END plot;

BEGIN (* main *)
  PARALLEL
    low  := low_val;   (* starting values *)
    high := high_val;
    x    := 0.0;
  ENDPARALLEL;

  FOR i:=1 TO maxlevel DO
    delta := 0.5 ** (FLOAT(i)/2.0);
    MidPointRec(delta,i);
  END;

  win  := OpenAbswindow(leaf_num * scale, height);
 IF NOT Done THEN
   WriteString("scale too large"); WriteLn;
 ELSE
  xmin := REDUCE.min(x);
  xmax := REDUCE.max(x);
  PARALLEL [leaf_start..leaf_end]
    pos := height - TRUNC( FLOAT(height-1)* (x-xmin)/(xmax-xmin) );
    plot((DIM1-leaf_start+1)*scale, pos, COLOR(0,0,0));
  ENDPARALLEL;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
 END
END fractal.
