SYSTEM fractal;
CONST  maxlevel  = 10;
       low_val   = 0.0;
       high_val  = 1.0;
       maxnode   = 2**maxlevel - 1;
       leaf_end  = maxnode;
       leaf_start= (leaf_end+1) DIV 2;
       leaf_num  = leaf_start;
       scale     = 2;
       height    = scale * leaf_num DIV 3;

CONFIGURATION tree [1 .. maxnode];
CONNECTION    son_l : tree[i] <-> tree[2*i].father;
              son_r : tree[i] <-> tree[2*i+1].father;
      	      left  : tree[i]  -> tree[i-1].right;

SCALAR  i,j         : INTEGER;
        delta       : REAL;
        field       : ARRAY [1..2**maxlevel-1] OF REAL;
        win         : CARDINAL;
        xmax,xmin   : REAL;
        ch          : CHAR;

VECTOR  x, low, high: REAL;
        pos         : CARDINAL;

PROCEDURE Gauss(): VECTOR REAL;
(* random number with Gaussian distribution *)
CONST N = 4;
      A = MAX(INTEGER);
      GA= (3.0*FLOAT(N))**0.5;
      GF= 2.0*GA / (FLOAT(N)*FLOAT(A));
SCALAR i  : INTEGER; 
VECTOR sum: REAL;
BEGIN
  sum:=0.0;
  FOR i:=1 TO N DO sum:= sum + FLOAT(VIRandom()) END;
  RETURN (GF*sum - GA)
END Gauss;

PROCEDURE MidPointRec(SCALAR delta: REAL; SCALAR level: INTEGER);
SCALAR  min, max, max2 : INTEGER;
BEGIN
  (* select tree-level: 2^(level-1) <= id_no <= 2^level - 1 *)
  min := 2**(level-1);
  max := 2 * min - 1;
  max2:= 2 * max + 1;

  PARALLEL [min..max]
    x := 0.5 * (low + high) + delta*Gauss();
  ENDPARALLEL;

  IF level < maxlevel THEN (* new low/high values for left/right son *) 
    PARALLEL [min..max2]
      PROPAGATE.son_l(low);
      PROPAGATE.son_r(high);
      PROPAGATE.son_l(x);
      PROPAGATE.son_r(x);
      IF even(id_no) THEN high:=x ELSE low:=x END;
    ENDPARALLEL
  END
END MidPointRec;

PROCEDURE plot(VECTOR x, y : integer; SCALAR c: COLOR);
VECTOR xnext, dx, px, ynext, dy, py, m, t, i: integer;

   PROCEDURE VSIGN(VECTOR i : integer) : VECTOR integer;
   VECTOR erg : integer;
   BEGIN
         IF i = 0 THEN erg := 0 ELSE erg := i div ABS(i) END;
         RETURN (erg);
   END VSIGN;

BEGIN
   Setcolor(c);
   PROPAGATE.left(x,xnext); dx := xnext - x;
   PROPAGATE.left(y,ynext); dy := ynext - y;
   IF DIM1 # REDUCE.max(DIM1) THEN
      IF ABS(dx) < ABS(dy) THEN
      	 IF dy < 0 THEN
      	    dec(xnext,dx); inc(x,dx); dx := -dx;
      	    dec(ynext,dy); inc(y,dy); dy := -dy;
      	 END;
      	 px := x; m := 0; i := VSIGN(dx); dx := ABS(dx); t := dy div 2;
      	 FOR py := y TO ynext DO
      	    SetPixel(px,py);
      	    inc(m,dx);
      	    IF m > t THEN inc(t,dy); inc(px,i); END;
      	 END;
      ELSE
      	 IF dx < 0 THEN
      	    dec(xnext,dx); inc(x,dx); dx := -dx;
      	    dec(ynext,dy); inc(y,dy); dy := -dy;
      	 END;
      	 py := y; m := 0; i := VSIGN(dy); dy := ABS(dy); t := dx div 2;
      	 FOR px := x TO xnext DO
      	    SetPixel(px,py);
      	    inc(m,dy);
      	    IF m > t THEN inc(t,dx); inc(py,i); END;
      	 END;
      END;
   END;
END plot;

BEGIN (* main *)
  PARALLEL
    low  := low_val;   (* starting values *)
    high := high_val;
    x    := 0.0;
  ENDPARALLEL;

  FOR i:=1 TO maxlevel DO
    delta := 0.5 ** (FLOAT(i)/2.0);
    MidPointRec(delta,i);
  END;

  win  := OpenAbswindow(leaf_num * scale, height);
 IF NOT Done THEN
   WriteString("scale too large"); WriteLn;
 ELSE
  xmin := REDUCE.min(x);
  xmax := REDUCE.max(x);
  PARALLEL [leaf_start..leaf_end]
    pos := height - TRUNC( FLOAT(height-1)* (x-xmin)/(xmax-xmin) );
    plot((DIM1-leaf_start+1)*scale, pos, COLOR(0,0,0));
  ENDPARALLEL;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win);
 END
END fractal.


