SYSTEM GraphicTest;

CONFIGURATION Grid [256], [256];

SCALAR
	win1    : INTEGER;
	w1, h1  : INTEGER;
	i : INTEGER;
	x, y : INTEGER;
	c : CHAR;
	rgb : COLOR;

VECTOR vrgb : COLOR;


(*PROCEDURE OpenAbsWindow (SCALAR x, y : INTEGER) : SCALAR INTEGER;

  SCALAR ax, ay : INTEGER;

BEGIN
  SelectWindow (0);
  WindowSize (ax, ay); (* get maximum window size *)
  RETURN OpenWindow (FLOAT (x) / FLOAT (ax), FLOAT (y) / FLOAT (ay));
END OpenAbsWindow;
*)

BEGIN

   win1 := OpenAbsWindow (256, 256);

   WindowSize (w1, h1);
   Read (c);

   FOR i := 0 TO w1 DO
     rgb.BLUE  := 1;
     rgb.RED   := (i + 1) MOD 256;
     rgb.GREEN := 1;
     SetColor (rgb);
     Line (i, 0, i, h1 - 1);
   END;

   Read (c);

   CloseWindow (win1);

   win1 := OpenAbsWindow (256, 256);

   WindowSize (w1, h1);
   Read (c);

   FOR i := 0 TO h1 DO
     rgb.BLUE  := 1;
     rgb.RED   := 1;
     rgb.GREEN := (i + 1) MOD 256;
     SetColor (rgb);
     Line (0, i, w1 - 1, i);
   END;

   Read (c);

   CloseWindow (win1);

   win1 := OpenAbsWindow (256, 256);

   WindowSize (w1, h1);
   Read (c);

   FOR i := 0 TO w1 DO
     rgb.BLUE  := (i + 1) MOD 256;
     rgb.RED   := 1;
     rgb.GREEN := 1;
     SetColor (rgb);
     Line (i, 0, i, h1 - 1);
   END;

   Read (c);

   CloseWindow (win1);

(*   win1 := OpenAbsWindow (256, 256);

   WindowSize (w1, h1);
   Read (c);

   PARALLEL
     vrgb.BLUE  := DIM2;
     vrgb.RED   := DIM1;
     vrgb.GREEN := (DIM1 + DIM2) MOD 256;
     SetColor (vrgb);
     SetPixel (DIM1, DIM2);
   ENDPARALLEL;

   Read (c);

   CloseWindow (win1);
*)
   win1 := OpenAbsWindow (256, 256);

   WindowSize (w1, h1);
   Read (c);

   FOR x := 0 TO w1 DO
     FOR y := 0 TO h1 DO
       rgb.BLUE  := x MOD 256;
       rgb.RED   := y MOD 256;
       rgb.GREEN := (x + y) MOD 256;
       SetColor (rgb);
       SetPixel (x, y);
     END;
   END;

   Read (c);

   CloseWindow (win1);

END GraphicTest.

