SYSTEM line_bench;
CONST qlen    = 10;
      length  = qlen * qlen * 2;
      part    = length div 2;

SCALAR   ch : CHAR;
       	 win : CARDINAL;
      	 col : integer;

CONFIGURATION grid [qlen],[qlen];

VECTOR   x0, y0, x1, y1 : INTEGER;

PROCEDURE VLine(VECTOR x0, y0, x1, y1 : integer);
VECTOR dx, px, dy, py, m, t, i: integer;

   PROCEDURE VSIGN(VECTOR i : integer) : VECTOR integer;
   VECTOR erg : integer;
   BEGIN
         IF i = 0 THEN erg := 0 ELSE erg := i div ABS(i) END;
         RETURN (erg);
   END VSIGN;

BEGIN
   dx := x1 - x0;
   dy := y1 - y0;
   IF ABS(dx) < ABS(dy) THEN
      IF dy < 0 THEN
      	 inc(x0,dx); dx := -dx;
      	 dec(y1,dy); inc(y0,dy); dy := -dy;
      END;
      px := x0; m := 0; i := VSIGN(dx); dx := ABS(dx); t := dy div 2;
      FOR py := y0 TO y1 DO
      	 SetPixel(px,py);
      	 inc(m,dx);
      	 IF m > t THEN inc(t,dy); inc(px,i); END;
      END;
   ELSE
      IF dx < 0 THEN
      	 dec(x1,dx); inc(x0,dx); dx := -dx;
      	 inc(y0,dy); dy := -dy;
      END;
      py := y0; m := 0; i := VSIGN(dy); dy := ABS(dy); t := dx div 2;
      FOR px := x0 TO x1 DO
      	 SetPixel(px,py);
      	 inc(m,dy);
      	 IF m > t THEN inc(t,dx); inc(py,i); END;
      END;
   END;
END VLine;


BEGIN (* main *)
   win := OpenAbsWindow(length,length);

   PARALLEL grid
      x0 := DIM1 * qlen;
      y0 := DIM2 * qlen;
      x1 := length - x0;
      y1 := length - y0;
      FOR col := 200 TO 0 BY -50 DO
      	 SETCOLOR(COLOR(col,col,col));
      	 VLine(x0, y0, x1, y1);
      	 y0 := length - y0; y1 := length - y1
      END;
   ENDPARALLEL;

   WriteString("Press RETURN for termination"); WriteLn;
   Read(ch);
   CloseWindow(win);
END line_bench.
