SYSTEM mandelbrot;
(* Iterative Computation of Mandelbrot Set    *)
(* With X Window Visualization | Braunl, 1992 *)
CONST n        =   128;
      max_iter =   30;
      col_start=   100;
      col_dec  =   - (150 DIV max_iter);
      limit    =   5.0;
      north    =   1.3;  south = -1.3;
      west     =  -2.0;  east  =  0.6;

TYPE  complex  = RECORD re,im: REAL
                 END;

CONFIGURATION list [0..n-1],[0..n-1];
CONNECTION (* none *);

SCALAR iter, win_num: INTEGER;
       ch           : CHAR;
       col : INTEGER;
  
VECTOR c, z  : complex;
       out : BOOLEAN;

PROCEDURE C_Mand (VECTOR z,c: complex): VECTOR complex; (* z^2+c *)
VECTOR res: complex;
BEGIN
  res.re := z.re*z.re - z.im*z.im + c.re;
  res.im := 2.0 * z.re*z.im + c.im;
  RETURN(res);
END C_Mand;

PROCEDURE C_Col (VECTOR a: complex) : VECTOR BOOLEAN;
BEGIN
  RETURN (a.re*a.re + a.im*a.im > limit);
END C_Col;

BEGIN
  win_num := OpenAbswindow(n,n);
  PARALLEL
    WITH c DO
      re := west  + FLOAT(DIM2) * ((east -west )/FLOAT(n-1)); (* real *)
      im := south + FLOAT(DIM1) * ((north-south)/FLOAT(n-1)); (* imaginery *)
    END;
    z:=c;
    iter := 1; col := col_start; out := FALSE;

    REPEAT
      WriteInt(iter,5); WriteLn;
      z   := C_Mand(z,c);
      out := C_Col(z);
      SetColor(COLOR(col, col, col)); (* grayscale *)
      SetPixel(DIM2,DIM1);            (* fill remaining region *)
      dec(col,col_dec);
      inc(iter);
    UNTIL (iter > max_iter) OR out
  ENDPARALLEL;

  WriteString("Press RETURN for termination"); WriteLn;
  Read(ch);
  CloseWindow(win_num);
END mandelbrot.
