/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : X - Interface
  Filename     : xgraph.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.xgraph.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:42        
  Author       : ?????????? Modified by Frank Sembach
  Creation date: 91
  ----------------------------------------------------------------------------
  Description  : PARZ-Library
                 (c) by University Stuttgart, 1991
                 Don't edit this file !!!
******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


/**********************************************************************
 ***                                                                ***
 ***    PARZ-Library                                                ***
 ***                                                                ***
 ***    (c) by University Stuttgart, 1991                           ***
 ***                                                                ***
 ***    Don't edit this file !!!                                    ***
 ***                                                                ***
 *********************************************************************/

#ifndef PZ2CH
#define PZ2CH

#if 0
===========================================================================
#include <stdio.h>
#include <math.h>
#ifndef VAX
#include <sys/types.h>
#else
#include <types.h>
#endif
#ifndef VAX
#include <sys/time.h>
#else
#include <time.h>
#endif
#ifndef SGI
#ifndef VAX
#include <sys/timeb.h>
#else
#include <timeb.h>
#endif
#endif

#ifdef SGI
#define VAX
#endif


/********************* DEFINES **************************************/

#define SINGLE 0
#define DOUBLE 1

#if 0
  PRECISION is set by the compiler at run-time
#define PRECISION      DOUBLE  
#endif

#define isActive()    (((int) *act) & 1)

#define EvalBoolExpr(a) callIt|=(*act=(*act&126)|(isActive()?(a):0))&1

#define ForAllPE       for(i=0,act=activePE;i<PENUM;i++,act++) 
#define ForAllActivePE for(i=0,act=activePE;i<PENUM;i++,act++) \
			 if(isActive()) 

#define    NO_REDUCE 0
#define   MIN_REDUCE 1
#define   MAX_REDUCE 2
#define   SUM_REDUCE 3
#define   MUL_REDUCE 4
#define   AND_REDUCE 5
#define    OR_REDUCE 6
#define FIRST_REDUCE 7
#define  LAST_REDUCE 8
#define   OWN_REDUCE 9

/********************* TYPES *****************************************/

typedef long           INT;
typedef unsigned char  CHAR;
typedef long BOOL;

#if PRECISION == DOUBLE
typedef double         REAL;
#else
typedef float          REAL;
#endif
===========================================================================
#endif

typedef union {
        long  i;
        int   b;
        unsigned char  c;
        float  r;
        } MemItem;

#if 0
===========================================================================
typedef struct {
        MemItem          *scalar;
        MemItem          *vector;
        MemItem          *scaLocal;
        int               vecSize;
        int               indIndex;
        struct timeval    startTime;
#ifndef SGI
        struct timeb      startClock;
#endif
        } ACTRECORD;


/************************** VARIABLES *******************************/

/*** predeclared variables ***/

extern int       _MAXTRANS;
extern int       _ACTTRANS;
extern int       _SRESULT;
extern MemItem  *_VRESULT;
extern int       _DONE;
extern int       _TERMCH;
extern MemItem  *_ID;

/*** input / output ***/

extern FILE *in, *out;

/*** maintenance ***/

extern char           *activePE, *act;
extern int             i, callIt;
extern INT             outPortTmp, inPortTmp;
extern MemItem        *SDisp [];
extern MemItem        *VDisp [];
extern int             SizeDisp [];
extern MemItem       **SIndDisp;
extern MemItem       **VIndDisp;
extern int            *IndSizeDisp;
extern int             IndIndex;
extern MemItem        *vTmp, *vTmp1;
extern struct timezone timeZone;

/*************************** FUNCTIONS ******************************/

/*** maintenance ***/

extern int InitDisplay (), ResetDisplay ();

extern int PrintTime ();

extern int SetAct ();
extern int SetSet ();
extern int SetPos ();

extern INT      NewMem ();
extern MemItem *Ref ();

extern int INIT (), EXIT ();

extern int STATUS ();

/*** stack ***/

extern int PUSHSi (), PUSHSb (), PUSHSr (), PUSHSc ();
extern int PUSHVi (), PUSHVr (), PUSHVb (), PUSHVc ();
extern int POPSi  (), POPSr  (), POPSb  (), POPSc  ();
extern int POPVi  (), POPVr  (), POPVb  (), POPVc  ();

/*** control statements ***/

extern int PushActSet (), PopActSet ();

/*** math ***/

extern INT   RandomI ();
extern CHAR  RandomC ();
extern INT   RandomB ();
extern REAL  RandomR ();

extern INT  _MOD ();
extern INT  _IPOWER ();
extern REAL _RIPOWER (), _RRPOWER ();

/*** input / output ***/

extern int OpenInput (),  OpenInputChars (),  CloseInput ();
extern int OpenOutput (), OpenOutputChars (), CloseOutput ();

extern int InBool (), InChars (), OutChars ();
extern int VOutChars ();

/*** strings ***/

extern int _StrCopy ();
extern INT _StrCmpCon ();
extern INT _StrCmp ();

/*** reduction ***/

/*** reduce variable ***/

extern int   PropOutInI (), PropOutInR ();
extern int   PropOutInC (), PropOutInB ();

extern int   PropToI (),  PropToR ();
extern int   PropToC (),  PropToB ();

extern int   SendToI (),  SendToR ();
extern int   SendToC (),  SendToB ();

extern int   ReceiveFromI (), ReceiveFromR ();
extern int   ReceiveFromC (), ReceiveFromB ();

extern INT   RedSumI (), RedMulI ();
extern REAL  RedSumR (), RedMulR ();

extern INT   RedMaxI (), RedMinI ();
extern REAL  RedMaxR (), RedMinR ();
extern CHAR  RedMaxC (), RedMinC ();
extern BOOL  RedMaxB (), RedMinB ();

extern BOOL  RedAndB (),  RedOrB ();

extern INT   RedFirstI (), RedLastI ();
extern REAL  RedFirstR (), RedLastR ();
extern CHAR  RedFirstC (), RedLastC ();
extern BOOL  RedFirstB (), RedLastB ();

extern int   OwnReduceI (), OwnReduceR ();
extern int   OwnReduceC (), OwnReduceB ();

/*** propagate reduce ***/

extern int  PRedSumI (), PRedMulI ();
extern int  PRedSumR (), PRedMulR ();

extern int  PRedMaxI (), PRedMinI ();
extern int  PRedMaxR (), PRedMinR ();
extern int  PRedMaxC (), PRedMinC ();
extern int  PRedMaxB (), PRedMinB ();

extern int  PRedAndB (),  PRedOrB ();

extern int  PRedFirstI (), PRedLastI ();
extern int  PRedFirstR (), PRedLastR ();
extern int  PRedFirstC (), PRedLastC ();
extern int  PRedFirstB (), PRedLastB ();

/*** data transfer ***/

extern int Connect (), Biconnect (), Disconnect (), DisconnectAll ();

extern short ConnectedIn (), ConnectedInOut (), ConnectedOut (), ConnectedOutIn ();

extern int  PropRedOwnI (), PropRedOwnR ();
extern int  PropRedOwnC (), PropRedOwnB ();

extern int _LOAD (), _STORE ();

extern int _MOVE_VS (), _MOVE_VV ();

/*** recording ***/

extern void EmitRecording ();
extern void IncStatCounter ();

===========================================================================
# endif
/** graphics **/

typedef struct colrec { MemItem r, g, b; } COLREC;

extern int init_x (), OpenW (), OpenAbsW ();
extern int CloseW (), SelectW ();
extern int WSize (), SetColor (), VSetColor ();
extern int SetPixel (), VSetPixel ();
extern int GetPixel (), MoveTo (), LineTo ();
extern int DrawString (), DrawInt (), DrawBool ();
extern int DrawReal (), DrawFixPt (), DrawImage ();
extern int DrawStr (), DrawChar ();

#endif

/*** End of pz2c.h ***/


