/*****************************************************************************
  Project: PARZ - Parallel Intermediate Code Debugger/Interpreter
  ----------------------------------------------------------------------------
  Release      : 1
  Project Part : Scanner
  Filename     : yydispl.h       
  SCCS-Path    : /tmp_mnt/user/sembach/parz/v2/SCCS/s.yydispl.h
  Version      : 1.2 
  Last changed : 6/2/93 at 20:39:45        
  Author       : Frank Sembach
  Creation date: Aug. 92
  ----------------------------------------------------------------------------
  Description  : Ausgabe von Strings fuer Tokens in Fehlermeldungen fuer PARZ
                 (Quelle : Schreiner, Friedman : Compiler bauen mit UNIX)
******************************************************************************
***      (C) COPYRIGHT University of Stuttgart - All Right Reserved        ***
*****************************************************************************/


#include <ctype.h>
#define DIM(x) (sizeof x /sizeof x[0])

char * yydisplay(ch)
  int ch;
{
  static char buf[20];
  static char * token[] = {
#include "y_tok.h"
                            0 };

  switch (ch) 
   {
    case 0:         return "[end of file]";
    case YYERRCODE: return "[error]";
    case '\b' :     return "backspace";
    case '\f' :     return "form feed";
    case '\n' :     return "newline";
    case '\r' :     return "carriage return";
    case '\t' :     return "tab";
   }
  if (ch > 256 && ch < 256 + DIM(token))
   return token[ch -257];
  if (isprint(ch))
    sprintf(buf, "'%c'",ch);
   else if (ch < 256)
    sprintf(buf, "char %04.3o",ch);
   else
    sprintf(buf,"symbol %d",ch);
  return buf;
}
