// Ping-Pong radio communication program
// T. Braunl, May 2017
#include "eyebot.h"

int main ()
{ int l, i;
  int id[256];
  int myid, partnerid;
  BYTE buf[10];

  LCDMenu("", "", "", "END");
  LCDPrintf("init\n");
  RADIOInit();

  myid = RADIOGetID();
  LCDPrintf("my id %d\n", myid);

  LCDPrintf("scanning (takes time ...)\n");
  l = RADIOStatus(id); 

  if (l== 0)
  { LCDPrintf("No other robots found -- exiting\n");
    KEYWait(KEY4);
    return 0;
  }

  partnerid = id[0];
  LCDPrintf("partner is %d\n", partnerid);

  if (myid < partnerid)
  { LCDPrintf("I will start\n");
    buf[0] = 1;
    RADIOSend(partnerid, buf, 1);
  }
  else LCDPrintf("I am waiting for partner\n");

  for (i=0; i<10; i++)
  { RADIOReceive(&partnerid, buf, 1);
    LCDPrintf("received %d from %d\n", buf[0], partnerid);

    buf[0]++;
    RADIOSend(partnerid, buf, 1);
  }

  KEYWait(KEY4);
}

