// Ping-Pong radio communication program
// T. Braunl, May 2017
#include <stdio.h>
#include "radio.h"
#define MAX 10

int main ()
{ int l, i, num;
  int id[256];
  int myid, partnerid;
  BYTE buf[MAX] = "00000";

  printf("init radio station program\n");
  RADIOInit();

  myid = RADIOGetID();
  printf("my id %d\n", myid);

  printf("scanning (may take time ...)\n");
  l = RADIOStatus(id); 
  if (l==0)
  { printf("No robots found -- exiting\n");
    return 0;
  }

  partnerid = 47;  // fixed address
  printf("partner is %d\n", partnerid);

  printf("I will start\n");
  RADIOSend(partnerid, buf);
   
  for (i=0; i<10; i++)
  { RADIOReceive(&partnerid, buf, MAX);
    printf("received from %d text %s\n", partnerid, buf);

    sscanf (buf, "%d", &num);
    num++;
    sprintf(buf, "%05d", num);
    RADIOSend(partnerid, buf);
  }
}

