package sim;

import java.awt.*;
import java.applet.*;

import sim.engine.*;

public class GridBackground extends WrapperPainted
{
	private int dotSize;
	private boolean hide;
	
/* ==================================================================
	Creation Part
	================================================================= */
	public Image getIcon()
	{
		return null;
	}
	
	public Wrapper createWrapper()
	{
		return null;
	}
	
	public Wrapper createWrapper(Point gridPosition)
	{
		return null;
	}
	
	public String getBubbleHelp()
	{
		return null;
	}
		
	
/* ==================================================================
	GUI part
	================================================================= */
	public GridBackground()
	{
		super();
		
		this.dotSize = 2;
		this.hide = false;
	}
	
	public void setHide(boolean value)
	{
		this.hide = value;
	}
	
	public boolean isHidden()
	{
		return this.hide;
	}
	
	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			int gridGap = CentralPanel.ACTIVE_GRID.getCurrentGridGap();
			
			Rectangle clip = g.getClipBounds();
			
			g.clearRect(clip.x, clip.y, clip.width, clip.height);
	
			if(!this.hide)
			{
				g.setColor(this.brush);
				
				int xEnd = clip.x + clip.width;
				int yEnd = clip.y + clip.height;
				
				int xStart = clip.x - clip.x % gridGap;
				int yStart = clip.y - clip.y % gridGap;
				
				if(xStart <= 0)
					xStart = gridGap;
				else if(xStart != clip.x)
					xStart = xStart + gridGap;
				
				if(yStart <= 0)
					yStart = gridGap;
				else if(yStart != clip.y)
					yStart = yStart + gridGap;
				
				int x, y;
				
				for(y = yStart; y < yEnd; y = y + gridGap)
					for(x = xStart; x < xEnd; x = x + gridGap)
						g.fillRect(x, y, this.dotSize, this.dotSize);
			}
		}
	}
	
	public void scale()
	{
		if(CentralPanel.ACTIVE_GRID.getZoom() < 100)
			this.dotSize = 1;
		else
			this.dotSize = 2;
	}
	
	
	public void initializeGridSize()
	{
		this.setGridSize(CentralPanel.ACTIVE_GRID.getGridSize());
	}
	
	public void addNotify()
	{
		super.addNotify();
		
		this.changeColor(CentralPanel.ACTIVE_GRID.getBackground().darker());
	}
	
/* ==================================================================
	Maintanance Part
	================================================================= */
	public boolean canDrop()
	{
		return true;
	}
	
	public void droped()
	{
	}
	
	public void selected()
	{
	}
	
	public void checkAfterSelected()
	{
	}
	
/* ==================================================================
	Storage Part
	================================================================= */
	public String getSpecificParameters()
	{
		return null;
	}
	
	public void loadWrapper(String[] specificParameters) throws SimException
	{
		
	}
	
	public int getNumberOfSpecificParameters()
	{
		return 0;
	}
}