package sim.util;

import java.awt.event.*;

abstract public class SimButtonListener extends MouseAdapter implements MouseMotionListener, ActionListener
{
	public void mouseMoved(MouseEvent event)
	{
	}
	
	public void mouseDragged(MouseEvent event)
	{
	}
	
	public void mouseEntered(MouseEvent event)
	{
		((SimButton)event.getSource()).paintEntered();
	}

	public void mouseExited(MouseEvent event)
	{
		((SimButton)event.getSource()).paintExited();
	}
	
	abstract public void activate(SimButton button);
	abstract public void arm(SimButton button);
	abstract public void disarm(SimButton button);
}