package sim.engine;

import java.util.Vector;

public class NodeList extends Vector
{
	public NodeList(int size)
	{
		super(size);
		
		this.setSize(size);
	}
	
	public NodeList()
	{
		super();
	}
		
	public int getSize()
	{
		return super.size();
	}
	
	public Node getItemAt(int index)
	{		
		return (Node)super.elementAt(index);
	}
	
	public void removeItemAt(int index)
	{
		super.removeElementAt(index);
	}
	
	public void removeItem(Node oldValue)
	{
		super.removeElement(oldValue);
	}
	
	public void removeAll()
	{
		super.removeAllElements();
	}
	
	public void changeItem(int index, Node newValue)
	{
		super.setElementAt(newValue, index);
	}
	
	public void resetItem(int index)
	{
		super.setElementAt(null, index);
	}
	
	public void insertItem(Node newValue)
	{
		super.addElement(newValue);
	}
	
	public void insertItemAt(int index, Node newValue)
	{
		super.insertElementAt(newValue, index);
	}
	
	public boolean contains(Node value)
	{
		return super.contains(value);
	}
}
