package sim;

import java.awt.*;
import java.awt.event.*;

import sim.util.BubbleListener;
import sim.util.SimButton;
import sim.util.SimButtonListener;

public class GridShortcut extends Panel
{
	private GridShortcutListener listener;
	
	public GridShortcut()
	{
		super();
		this.setLayout(new FlowLayout(FlowLayout.LEFT, 8, 0));
	}
	
	public void addNotify()
	{
		super.addNotify();
		this.listener = new GridShortcutListener(this);
	}
	
/* ==================================================================
	Services provided to Menu
	================================================================ */
	public void setGridVisibility(boolean visible)
	{
		this.listener.setGridVisibility(visible);
	}
	
	public void setZoom(String zoomString)
	{
		this.listener.setZoom(zoomString);
	}
	
/* ==================================================================
	Listener to handle mouse events
	================================================================= */
	private class GridShortcutListener extends SimButtonListener implements ItemListener
	{
		private boolean buttonUpOnLastMouseDown = true;
		private Choice zoomControl;
		private SimButton gridSwitch;
		
		public GridShortcutListener(GridShortcut parent)
		{
			// initialize zoomControl
			this.zoomControl = new Choice();
			
			this.zoomControl.add("200%");
			this.zoomControl.add("150%");
			this.zoomControl.add("100%");
			this.zoomControl.add("75%");
			this.zoomControl.add("50%");
			this.zoomControl.select("100%");
			this.zoomControl.addMouseListener(new BubbleListener(this.zoomControl, "Zoom control", NorthPanel.BUBBLE_WAIT));
			this.zoomControl.addItemListener(this);
			parent.add(this.zoomControl);
			
			// initialize gridSwitch
			this.gridSwitch = new SimButton("sim/images/GridIcon.gif", "Grid control", NorthPanel.BUBBLE_WAIT);
			this.gridSwitch.setListener(this);
			this.gridSwitch.setInset(false);
			parent.add(this.gridSwitch);
		}
		
		public void actionPerformed(ActionEvent e)
		{
			SimMenuBar.VIEW_GRID.setState(this.gridSwitch.isInset());
			CentralPanel.ACTIVE_GRID.changeGridVisibility(this.gridSwitch.isRaised());
		}
		
		public void activate(SimButton ib)
		{
			ib.processActionEvent();
			ib.setArmed(false);
		}
		
		public void arm(SimButton ib)
		{
			ib.setArmed(true);
		}
		
		public void disarm(SimButton ib)
		{
			ib.setArmed(false);
		}
		
		public void mousePressed(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			if(ib.isEnabled())
			{
				if(ib.isRaised())
				{
					ib.paintInset();
					this.buttonUpOnLastMouseDown = false;
					this.arm(ib);
				}
				else
				{
					ib.paintRaised();
					this.buttonUpOnLastMouseDown = true;
					this.arm(ib);
				}
				
			}
		}
	
		public void mouseClicked(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			if(ib.isEnabled() && ib.isArmed())
				this.activate(ib);
		}
		
		public void mouseReleased(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			Point pt = event.getPoint();
			
			if(ib.contains(pt.x, pt.y))
				this.mouseClicked(event);
		}
		
		public void mouseDragged(MouseEvent event)
		{
			SimButton ib = (SimButton)event.getSource();
			if(ib.isEnabled() && ib.isArmed())
			{
				Point loc = event.getPoint();
				
				if(ib.contains(loc.x,loc.y))
				{
					if(this.buttonUpOnLastMouseDown)
					{
						if( ! ib.isRaised()) 
							ib.paintRaised();
					}
					else
						if(ib.isRaised())
							ib.paintInset();
				}
				else
				{
					if(this.buttonUpOnLastMouseDown)
						{
						if(ib.isRaised())
							ib.paintInset();
					}
					else
						if( ! ib.isRaised())
							ib.paintRaised();
				}
			}
		}
		
		public void itemStateChanged(ItemEvent e)
		{
			try
			{
				String selected = (String)e.getItem();
				
				if(selected.equals("200%"))
					CentralPanel.ACTIVE_GRID.changeZoom(200);
				else if(selected.equals("150%"))
					CentralPanel.ACTIVE_GRID.changeZoom(150);
				else if(selected.equals("100%"))
					CentralPanel.ACTIVE_GRID.changeZoom(100);
				else if(selected.equals("75%"))
					CentralPanel.ACTIVE_GRID.changeZoom(75);
				else if(selected.equals("50%"))
					CentralPanel.ACTIVE_GRID.changeZoom(50);
			}
			catch(SimException ex)
			{
				zoomControl.select(Integer.toString(CentralPanel.ACTIVE_GRID.getZoom()) + "%");
				
				MainWindow.OK_WINDOW.setDescription("Can not change zoom");
				MainWindow.OK_WINDOW.setMessage(ex.getMessage());
				MainWindow.OK_WINDOW.show();
			}
		}
		
		public void setGridVisibility(boolean visible)
		{
			CentralPanel.ACTIVE_GRID.changeGridVisibility(!visible);
			
			if(visible)
				this.gridSwitch.paintInset();
			else
				this.gridSwitch.paintRaised();
		}
		
		public void setZoom(String zoomString)
		{
			try
			{
				if(zoomString.equals("200%"))
					CentralPanel.ACTIVE_GRID.changeZoom(200);
				else if(zoomString.equals("150%"))
					CentralPanel.ACTIVE_GRID.changeZoom(150);
				else if(zoomString.equals("100%"))
					CentralPanel.ACTIVE_GRID.changeZoom(100);
				else if(zoomString.equals("75%"))
					CentralPanel.ACTIVE_GRID.changeZoom(75);
				else if(zoomString.equals("50%"))
					CentralPanel.ACTIVE_GRID.changeZoom(50);
				
				this.zoomControl.select(zoomString);
			}
			catch(SimException ex)
			{
				MainWindow.OK_WINDOW.setDescription("Can not change zoom");
				MainWindow.OK_WINDOW.setMessage(ex.getMessage());
				MainWindow.OK_WINDOW.show();
			}
		}
	}
}