package sim;

import java.awt.*;

import sim.util.SimSeparator;

public class NorthPanel extends Panel
{
	public static final long BUBBLE_WAIT = 500;
	public static SaveLoadShortcut STORE_SHORTCUT;
	public static GridShortcut GRID_SHORTCUT;
	public static RunShortcut RUN_SHORTCUT;
	public static EditShortcut EDIT_SHORTCUT;
	
	public NorthPanel()
	{
		super();
		
		this.setBackground(MainWindow.BACKGROUND);
		
		this.setLayout(new BorderLayout());
		
		this.add(BorderLayout.NORTH, new SimSeparator());
		
		Panel p = new Panel(new FlowLayout(FlowLayout.LEFT, 0, 2));
		this.add(BorderLayout.CENTER, p);
		
		NorthPanel.STORE_SHORTCUT = new SaveLoadShortcut();
		NorthPanel.GRID_SHORTCUT = new GridShortcut();
		NorthPanel.RUN_SHORTCUT = new RunShortcut();
		NorthPanel.EDIT_SHORTCUT = new EditShortcut();
		
		SimSeparator s;
		
		p.add(NorthPanel.STORE_SHORTCUT);
		s = new SimSeparator();
		s.setHeight(25);
		p.add(s);
		
		p.add(NorthPanel.EDIT_SHORTCUT);
		s = new SimSeparator();
		s.setHeight(25);
		p.add(s);
		
		p.add(NorthPanel.GRID_SHORTCUT);
		s = new SimSeparator();
		s.setHeight(25);
		p.add(s);
		
		p.add(NorthPanel.RUN_SHORTCUT);
	}
}
